/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.nio.channels.ReadableByteChannel;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.springframework.dao.ConcurrencyFailureException;

public class EmptyContentReader
extends AbstractContentReader {
    public EmptyContentReader(String contentUrl) {
        super(contentUrl);
    }

    @Override
    protected ContentReader createReader() throws ContentIOException {
        return new EmptyContentReader(this.getContentUrl());
    }

    @Override
    protected ReadableByteChannel getDirectReadableChannel() throws ContentIOException {
        throw new ConcurrencyFailureException(this.getContentUrl() + " no longer exists");
    }

    public boolean exists() {
        return false;
    }

    public long getLastModified() {
        return 0L;
    }

    public long getSize() {
        return 0L;
    }
}

