/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.metadataloaders;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.alfresco.repo.bulkimport.impl.FileUtils;
import org.alfresco.repo.bulkimport.metadataloaders.AbstractMapBasedMetadataLoader;
import org.alfresco.service.ServiceRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class XmlPropertiesFileMetadataLoader
extends AbstractMapBasedMetadataLoader {
    private static final Log log = LogFactory.getLog(XmlPropertiesFileMetadataLoader.class);
    private static final String METADATA_FILE_EXTENSION = "properties.xml";
    private final Set<String> protectedProperties = new HashSet<String>();

    public void setProtectedProperties(List<String> protectedProperties) {
        this.protectedProperties.clear();
        this.protectedProperties.addAll(protectedProperties);
    }

    public XmlPropertiesFileMetadataLoader(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, METADATA_FILE_EXTENSION);
    }

    public XmlPropertiesFileMetadataLoader(ServiceRegistry serviceRegistry, String multiValuedSeparator) {
        super(serviceRegistry, multiValuedSeparator, METADATA_FILE_EXTENSION);
    }

    @Override
    protected Map<String, Serializable> loadMetadataFromFile(Path metadataFile) {
        HashMap<Object, Object> result;
        block2: {
            result = null;
            try {
                Properties props = new Properties();
                props.loadFromXML(new BufferedInputStream(Files.newInputStream(metadataFile, new OpenOption[0])));
                result = new HashMap<Object, Object>(props);
                this.removeProtectedProperties(result);
            }
            catch (IOException ioe) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)("Metadata file '" + FileUtils.getFileName(metadataFile) + "' could not be read."), (Throwable)ioe);
            }
        }
        return result;
    }

    private void removeProtectedProperties(Map<String, Serializable> props) {
        props.keySet().removeAll(this.protectedProperties);
    }
}

