/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog.cannedqueries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.blog.cannedqueries.AbstractBlogPostsCannedQueryFactory;
import org.alfresco.repo.blog.cannedqueries.BlogEntity;
import org.alfresco.repo.blog.cannedqueries.GetBlogPostsCannedQueryParams;
import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetBlogPostsCannedQuery
extends AbstractCannedQueryPermissions<BlogEntity> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.query.blogs";
    private static final String QUERY_SELECT_GET_BLOGS = "select_GetBlogsCannedQuery";
    private final CannedQueryDAO cannedQueryDAO;

    public GetBlogPostsCannedQuery(CannedQueryDAO cannedQueryDAO, MethodSecurityBean<BlogEntity> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
    }

    protected List<BlogEntity> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Object paramBeanObj = parameters.getParameterBean();
        if (paramBeanObj == null) {
            throw new NullPointerException("Null GetBlogPosts query params");
        }
        GetBlogPostsCannedQueryParams paramBean = (GetBlogPostsCannedQueryParams)paramBeanObj;
        String requestedCreator = paramBean.getCmCreator();
        boolean isPublished = paramBean.getIsPublished();
        Date publishedFromDate = paramBean.getPublishedFromDate();
        Date publishedToDate = paramBean.getPublishedToDate();
        List results = this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_BLOGS, paramBean, 0, Integer.MAX_VALUE);
        ArrayList<BlogEntity> filtered = new ArrayList<BlogEntity>(results.size());
        for (BlogEntity result : results) {
            AuditablePropertiesEntity auditProps;
            boolean blogIsPublished;
            boolean nextNodeIsAcceptable = true;
            Date actualPublishedDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)result.getPublishedDate());
            boolean bl = blogIsPublished = actualPublishedDate != null;
            if (blogIsPublished != isPublished) {
                nextNodeIsAcceptable = false;
            }
            if (!(requestedCreator == null || (auditProps = result.getNode().getAuditableProperties()) != null && requestedCreator.equals(auditProps.getAuditCreator()))) {
                nextNodeIsAcceptable = false;
            }
            if (publishedFromDate != null || publishedToDate != null) {
                if (actualPublishedDate != null) {
                    if (publishedFromDate != null && actualPublishedDate.before(publishedFromDate)) {
                        nextNodeIsAcceptable = false;
                    }
                    if (publishedToDate != null && actualPublishedDate.after(publishedToDate)) {
                        nextNodeIsAcceptable = false;
                    }
                } else {
                    nextNodeIsAcceptable = false;
                }
            }
            if (!nextNodeIsAcceptable) continue;
            filtered.add(result);
        }
        List sortPairs = parameters.getSortDetails().getSortPairs();
        if (sortPairs != null && !sortPairs.isEmpty()) {
            Pair sortPair = (Pair)sortPairs.get(0);
            QName sortProperty = (QName)sortPair.getFirst();
            Comparator<BlogEntity> comparator = new AbstractBlogPostsCannedQueryFactory.BlogEntityComparator(sortProperty);
            if (sortPair.getSecond() == CannedQuerySortDetails.SortOrder.DESCENDING) {
                comparator = Collections.reverseOrder(comparator);
            }
            Collections.sort(filtered, comparator);
        }
        if (start != null) {
            this.logger.debug((Object)("Base query: " + filtered.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return filtered;
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }
}

