/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FixBpmPackagesPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.fixBpmPackages.result";
    private static final String ERR_MSG_INVALID_BOOTSTRAP_STORE = "patch.fixBpmPackages.invalidBootsrapStore";
    private static final String ERR_MSG_EMPTY_CONTAINER = "patch.fixBpmPackages.emptyContainer";
    private static final Log logger = LogFactory.getLog(FixBpmPackagesPatch.class);
    private static Log progress_logger = LogFactory.getLog(PatchExecuter.class);
    private int batchThreads = 4;
    private int batchSize = 1000;
    private ImporterBootstrap importerBootstrap;
    private BehaviourFilter policyFilter;

    public void setBatchThreads(int batchThreads) {
        this.batchThreads = batchThreads;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setPolicyFilter(BehaviourFilter policyFilter) {
        this.policyFilter = policyFilter;
    }

    @Override
    protected String applyInternal() throws Exception {
        FixBpmPackagesPatchHelper helper = new FixBpmPackagesPatchHelper();
        try {
            String sysWorkflowContainer;
            QName sysWorkflowQName;
            String sysContainer;
            QName sysContainerQName;
            List refs;
            this.policyFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
            StoreRef store = this.importerBootstrap.getStoreRef();
            if (store == null) {
                throw new PatchException(ERR_MSG_INVALID_BOOTSTRAP_STORE);
            }
            NodeRef rootRef = this.nodeService.getRootNode(store);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("StoreRef:" + String.valueOf(store) + " RootNodeRef: " + String.valueOf(rootRef)));
            }
            if ((refs = this.nodeService.getChildAssocs(rootRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)(sysContainerQName = QName.createQName((String)(sysContainer = this.importerBootstrap.getConfiguration().getProperty("system.system_container.childname")), (NamespacePrefixResolver)this.namespaceService)))) == null || refs.size() == 0) {
                throw new PatchException(ERR_MSG_EMPTY_CONTAINER, sysContainer);
            }
            NodeRef sysNodeRef = ((ChildAssociationRef)refs.get(0)).getChildRef();
            if ((refs = this.nodeService.getChildAssocs(sysNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)(sysWorkflowQName = QName.createQName((String)(sysWorkflowContainer = this.importerBootstrap.getConfiguration().getProperty("system.workflow_container.childname")), (NamespacePrefixResolver)this.namespaceService)))) == null || refs.size() == 0) {
                throw new PatchException(ERR_MSG_EMPTY_CONTAINER, sysWorkflowContainer);
            }
            NodeRef workflowContainerRef = ((ChildAssociationRef)refs.get(0)).getChildRef();
            if ((refs = this.nodeService.getChildAssocs(workflowContainerRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL)) == null || refs.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("There are no any packages in the container " + sysWorkflowContainer));
                }
                String string = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{0});
                return string;
            }
            NodeRef packagesContainerRef = ((ChildAssociationRef)refs.get(0)).getChildRef();
            refs = this.nodeService.getChildAssocs(packagesContainerRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + refs.size() + " packages to convert"));
            }
            String string = helper.fixBpmPackages(refs);
            return string;
        }
        finally {
            this.policyFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            helper.closeWriter();
        }
    }

    private class FixBpmPackagesPatchHelper {
        private File logFile;
        private FileChannel channel;
        private Integer assocCount;
        private int skipCount = 0;
        private List<ChildAssociationRef> refs;

        private FixBpmPackagesPatchHelper() throws IOException {
            File tempDir = TempFileProvider.getLongLifeTempDir((String)"patches");
            this.logFile = new File(tempDir, "FixBpmPackagesPatch.log");
            RandomAccessFile outputFile = new RandomAccessFile(this.logFile, "rw");
            this.channel = outputFile.getChannel();
            this.channel.position(this.channel.size());
            this.writeLine("").writeLine("");
            this.writeLine("FixBpmPackagesPatch executing on " + String.valueOf(new Date()));
        }

        private FixBpmPackagesPatchHelper write(Object obj) throws IOException {
            this.channel.write(ByteBuffer.wrap(obj.toString().getBytes("UTF-8")));
            return this;
        }

        private FixBpmPackagesPatchHelper writeLine(Object obj) throws IOException {
            this.write(obj);
            this.write("\n");
            return this;
        }

        private void closeWriter() {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {}
        }

        public String fixBpmPackages(List<ChildAssociationRef> references) throws Exception {
            this.refs = references;
            this.assocCount = references.size();
            BatchProcessWorkProvider<ChildAssociationRef> workProvider = new BatchProcessWorkProvider<ChildAssociationRef>(){

                @Override
                public synchronized int getTotalEstimatedWorkSize() {
                    return FixBpmPackagesPatchHelper.this.assocCount;
                }

                @Override
                public synchronized long getTotalEstimatedWorkSizeLong() {
                    return FixBpmPackagesPatchHelper.this.assocCount.intValue();
                }

                @Override
                public synchronized Collection<ChildAssociationRef> getNextWork() {
                    int nextMaxSize = FixBpmPackagesPatchHelper.this.skipCount + ((FixBpmPackagesPatchHelper)FixBpmPackagesPatchHelper.this).FixBpmPackagesPatch.this.batchSize;
                    List<ChildAssociationRef> result = FixBpmPackagesPatchHelper.this.assocCount < FixBpmPackagesPatchHelper.this.skipCount ? Collections.emptyList() : (FixBpmPackagesPatchHelper.this.assocCount >= nextMaxSize ? FixBpmPackagesPatchHelper.this.refs.subList(FixBpmPackagesPatchHelper.this.skipCount, nextMaxSize) : FixBpmPackagesPatchHelper.this.refs.subList(FixBpmPackagesPatchHelper.this.skipCount, FixBpmPackagesPatchHelper.this.assocCount));
                    FixBpmPackagesPatchHelper.this.skipCount += ((FixBpmPackagesPatchHelper)FixBpmPackagesPatchHelper.this).FixBpmPackagesPatch.this.batchSize;
                    return result;
                }
            };
            BatchProcessor<ChildAssociationRef> batchProcessor = new BatchProcessor<ChildAssociationRef>("FixBpmPackagesPatch", FixBpmPackagesPatch.this.transactionHelper, workProvider, FixBpmPackagesPatch.this.batchThreads, FixBpmPackagesPatch.this.batchSize, FixBpmPackagesPatch.this.applicationEventPublisher, progress_logger, 1000);
            BatchProcessor.BatchProcessWorker<ChildAssociationRef> worker = new BatchProcessor.BatchProcessWorker<ChildAssociationRef>(){

                @Override
                public String getIdentifier(ChildAssociationRef entry) {
                    return entry.toString();
                }

                @Override
                public void beforeProcess() throws Throwable {
                }

                @Override
                public void process(ChildAssociationRef assocRef) throws Throwable {
                    NodeRef packageRef = assocRef.getChildRef();
                    QName typeQname = FixBpmPackagesPatch.this.nodeService.getType(packageRef);
                    String name = (String)((Object)FixBpmPackagesPatch.this.nodeService.getProperty(packageRef, ContentModel.PROP_NAME));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Package " + name + " type " + String.valueOf(typeQname)));
                    }
                    if (!FixBpmPackagesPatch.this.nodeService.getType(packageRef).equals((Object)WorkflowModel.TYPE_PACKAGE)) {
                        FixBpmPackagesPatch.this.nodeService.setType(packageRef, WorkflowModel.TYPE_PACKAGE);
                    }
                    List packageItemsAssocs = FixBpmPackagesPatch.this.nodeService.getChildAssocs(packageRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                    for (ChildAssociationRef itemAssoc : packageItemsAssocs) {
                        NodeRef parentRef = itemAssoc.getParentRef();
                        NodeRef childRef = itemAssoc.getChildRef();
                        String itemName = (String)((Object)FixBpmPackagesPatch.this.nodeService.getProperty(childRef, ContentModel.PROP_NAME));
                        if (itemAssoc.isPrimary()) {
                            logger.error((Object)("Association between package: " + name + " and item: " + itemName + " is primary association, so removing this assiciation will result in child node deletion"));
                            continue;
                        }
                        if (itemAssoc.getTypeQName().equals((Object)WorkflowModel.ASSOC_PACKAGE_CONTAINS)) continue;
                        boolean assocRemoved = FixBpmPackagesPatch.this.nodeService.removeChildAssociation(itemAssoc);
                        if (assocRemoved) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Association between package: " + name + " and item: " + itemName + " was removed"));
                            }
                        } else {
                            if (!logger.isErrorEnabled()) continue;
                            logger.error((Object)("Association between package: " + name + " and item: " + itemName + " doesn't exist"));
                            continue;
                        }
                        FixBpmPackagesPatch.this.nodeService.addChild(parentRef, childRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)itemName)));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("New association has been created between package: " + name + " and item: " + itemName));
                    }
                }

                @Override
                public void afterProcess() throws Throwable {
                }
            };
            int updated = batchProcessor.process(worker, true);
            return I18NUtil.getMessage((String)FixBpmPackagesPatch.MSG_SUCCESS, (Object[])new Object[]{updated, this.logFile});
        }
    }
}

