/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.action.executer.TestModeable;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.DateCompareMethod;
import org.alfresco.repo.template.HasAspectMethod;
import org.alfresco.repo.template.I18NMessageMethod;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.Pair;
import org.alfresco.util.UrlUtil;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.EmailValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.mail.MailException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.util.StringUtils;

public class MailActionExecuter
extends ActionExecuterAbstractBase
implements InitializingBean,
TestModeable {
    private static Log logger = LogFactory.getLog(MailActionExecuter.class);
    public static final String NAME = "mail";
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_TO = "to";
    public static final String PARAM_CC = "cc";
    public static final String PARAM_BCC = "bcc";
    public static final String PARAM_TO_MANY = "to_many";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_SUBJECT_PARAMS = "subjectParams";
    public static final String PARAM_TEXT = "text";
    public static final String PARAM_HTML = "html";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_FROM_PERSONAL_NAME = "fromPersonalName";
    public static final String PARAM_TEMPLATE = "template";
    public static final String PARAM_TEMPLATE_MODEL = "template_model";
    public static final String PARAM_IGNORE_SEND_FAILURE = "ignore_send_failure";
    public static final String PARAM_SEND_AFTER_COMMIT = "send_after_commit";
    private static final String FROM_ADDRESS = "alfresco@alfresco.org";
    private JavaMailSender mailService;
    private TemplateService templateService;
    private PersonService personService;
    private AuthenticationService authService;
    private NodeService nodeService;
    private AuthorityService authorityService;
    private ServiceRegistry serviceRegistry;
    private SysAdminParams sysAdminParams;
    private PreferenceService preferenceService;
    private TenantService tenantService;
    private String headerEncoding = null;
    private String fromDefaultAddress = null;
    private boolean fromEnabled = true;
    private boolean sendTestMessage = false;
    private String testMessageTo = null;
    private String testMessageSubject = "Test message";
    private String testMessageText = "This is a test message.";
    private boolean validateAddresses = true;
    private boolean testMode = false;
    private MimeMessage lastTestMessage;
    private int testSentCount;
    private TemplateImageResolver imageResolver;
    private String testModeRecipient;
    static AtomicInteger numberSuccessfulSends = new AtomicInteger(0);
    static AtomicInteger numberFailedSends = new AtomicInteger(0);

    public void setMailService(JavaMailSender javaMailSender) {
        this.mailService = javaMailSender;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.authService = authService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setHeaderEncoding(String headerEncoding) {
        this.headerEncoding = headerEncoding;
    }

    public void setFromAddress(String fromAddress) {
        this.fromDefaultAddress = fromAddress;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setImageResolver(TemplateImageResolver imageResolver) {
        this.imageResolver = imageResolver;
    }

    public void setTestMessageTo(String testMessageTo) {
        this.testMessageTo = testMessageTo;
    }

    public String getTestMessageTo() {
        return this.testMessageTo;
    }

    public void setTestMessageSubject(String testMessageSubject) {
        this.testMessageSubject = testMessageSubject;
    }

    public void setTestMessageText(String testMessageText) {
        this.testMessageText = testMessageText;
    }

    public void setSendTestMessage(boolean sendTestMessage) {
        this.sendTestMessage = sendTestMessage;
    }

    /*
     * Unable to fully structure code
     */
    public boolean sendTestMessage() {
        block6: {
            if (this.testMessageTo == null || this.testMessageTo.length() == 0) {
                throw new AlfrescoRuntimeException("email.outbound.err.test.no.to");
            }
            if (this.testMessageSubject == null || this.testMessageSubject.length() == 0) {
                throw new AlfrescoRuntimeException("email.outbound.err.test.no.subject");
            }
            if (this.testMessageText == null || this.testMessageText.length() == 0) {
                throw new AlfrescoRuntimeException("email.outbound.err.test.no.text");
            }
            params = new HashMap<String, Serializable>();
            params.put("to", (Serializable)this.testMessageTo);
            params.put("subject", (Serializable)this.testMessageSubject);
            params.put("text", (Serializable)this.testMessageText);
            ruleAction = this.serviceRegistry.getActionService().createAction("mail", params);
            message = this.prepareEmail(ruleAction, null, (Pair<String, Locale>)new Pair((Object)this.testMessageTo, (Object)this.getLocaleForUser(this.testMessageTo)), this.getFrom(ruleAction));
            try {
                this.mailService.send(message.getMimeMessage());
                this.onSend();
                break block6;
            }
            catch (MailException me) {
                this.onFail();
                txt = new StringBuffer();
                txt.append(me.getClass().getName() + ", " + me.getMessage());
                cause = me.getCause();
                ** while (cause != null)
            }
lbl-1000:
            // 1 sources

            {
                txt.append(", ");
                txt.append(cause.getClass().getName() + ", " + cause.getMessage());
                cause = cause.getCause();
                continue;
            }
lbl33:
            // 1 sources

            args = new Object[]{this.testMessageTo, txt.toString()};
            throw new AlfrescoRuntimeException("email.outbound.err.send.failed", args, (Throwable)me);
        }
        return true;
    }

    public void setTestModeRecipient(String testModeRecipient) {
        this.testModeRecipient = testModeRecipient;
    }

    public void setValidateAddresses(boolean validateAddresses) {
        this.validateAddresses = validateAddresses;
    }

    @Override
    public void init() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Init called, testMessageTo=" + this.testMessageTo));
        }
        numberSuccessfulSends.set(0);
        numberFailedSends.set(0);
        super.init();
        if (this.sendTestMessage && this.testMessageTo != null) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                    params.put(MailActionExecuter.PARAM_TO, (Serializable)((Object)MailActionExecuter.this.testMessageTo));
                    params.put(MailActionExecuter.PARAM_SUBJECT, (Serializable)((Object)MailActionExecuter.this.testMessageSubject));
                    params.put(MailActionExecuter.PARAM_TEXT, (Serializable)((Object)MailActionExecuter.this.testMessageText));
                    Action ruleAction = MailActionExecuter.this.serviceRegistry.getActionService().createAction(MailActionExecuter.NAME, params);
                    MailActionExecuter.this.executeImpl(ruleAction, null);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.fromDefaultAddress == null || this.fromDefaultAddress.length() == 0) {
            this.fromDefaultAddress = FROM_ADDRESS;
        }
    }

    @Override
    protected void executeImpl(final Action ruleAction, NodeRef actionedUponNodeRef) {
        MimeMessageHelper[] finalMessages;
        MimeMessageHelper[] messages = null;
        if (this.validNodeRefIfPresent(actionedUponNodeRef)) {
            messages = this.prepareEmails(ruleAction, actionedUponNodeRef);
        }
        if ((finalMessages = messages) != null) {
            if (this.sendAfterCommit(ruleAction)) {
                AlfrescoTransactionSupport.bindListener((TransactionListener)new TransactionListenerAdapter(){

                    public void afterCommit() {
                        RetryingTransactionHelper helper = MailActionExecuter.this.serviceRegistry.getTransactionService().getRetryingTransactionHelper();
                        helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            @Override
                            public Void execute() throws Throwable {
                                MimeMessageHelper[] mimeMessageHelperArray = finalMessages;
                                int n = finalMessages.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MimeMessageHelper message = mimeMessageHelperArray[n2];
                                    MailActionExecuter.this.sendEmail(ruleAction, message);
                                    ++n2;
                                }
                                return null;
                            }
                        }, false, true);
                    }
                });
            } else {
                MimeMessageHelper[] mimeMessageHelperArray = finalMessages;
                int n = finalMessages.length;
                int n2 = 0;
                while (n2 < n) {
                    MimeMessageHelper message = mimeMessageHelperArray[n2];
                    if (message != null) {
                        this.sendEmail(ruleAction, message);
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean validNodeRefIfPresent(NodeRef actionedUponNodeRef) {
        if (actionedUponNodeRef == null) {
            return true;
        }
        return this.nodeService.exists(actionedUponNodeRef);
    }

    private boolean sendAfterCommit(Action action) {
        Boolean sendAfterCommit = (Boolean)action.getParameterValue(PARAM_SEND_AFTER_COMMIT);
        return sendAfterCommit == null ? false : sendAfterCommit;
    }

    private MimeMessageHelper[] prepareEmails(Action ruleAction, NodeRef actionedUponNodeRef) {
        String templateRef;
        Serializable ref = ruleAction.getParameterValue(PARAM_TEMPLATE);
        String string = templateRef = ref instanceof NodeRef ? ((NodeRef)ref).toString() : (String)((Object)ref);
        if (templateRef == null) {
            MimeMessageHelper[] messages = new MimeMessageHelper[]{this.prepareEmail(ruleAction, actionedUponNodeRef, null, null)};
            return messages;
        }
        Collection<Pair<String, Locale>> recipients = this.getRecipients(ruleAction);
        Pair<InternetAddress, Locale> from = this.getFrom(ruleAction);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("From: address=" + String.valueOf(from.getFirst()) + " ,locale=" + String.valueOf(from.getSecond())));
        }
        MimeMessageHelper[] messages = new MimeMessageHelper[recipients.size()];
        int recipientIndex = 0;
        for (Pair<String, Locale> recipient : recipients) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Recipient: address=" + (String)recipient.getFirst() + " ,locale=" + String.valueOf(recipient.getSecond())));
            }
            messages[recipientIndex] = this.prepareEmail(ruleAction, actionedUponNodeRef, recipient, from);
            ++recipientIndex;
        }
        return messages;
    }

    public MimeMessageHelper prepareEmail(final Action ruleAction, final NodeRef actionedUponNodeRef, final Pair<String, Locale> recipient, final Pair<InternetAddress, Locale> sender) {
        final MimeMessageHelper[] messageRef = new MimeMessageHelper[1];
        MimeMessagePreparator mailPreparer = new MimeMessagePreparator(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                String templateRef;
                if (logger.isDebugEnabled()) {
                    logger.debug(ruleAction.getParameterValues());
                }
                messageRef[0] = new MimeMessageHelper(mimeMessage);
                if (MailActionExecuter.this.headerEncoding != null && MailActionExecuter.this.headerEncoding.length() != 0) {
                    mimeMessage.setHeader("Content-Transfer-Encoding", MailActionExecuter.this.headerEncoding);
                }
                String to = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TO));
                String toRecipients = null;
                if (to != null && to.length() != 0) {
                    Serializable bccValue;
                    messageRef[0].setTo(to);
                    toRecipients = to;
                    Serializable ccValue = ruleAction.getParameterValue(MailActionExecuter.PARAM_CC);
                    if (ccValue != null) {
                        if (ccValue instanceof String) {
                            String cc = (String)((Object)ccValue);
                            if (cc.length() > 0) {
                                messageRef[0].setCc(cc);
                            }
                        } else if (ccValue instanceof List) {
                            List s = (List)((Object)ccValue);
                            messageRef[0].setCc(s.toArray(new String[s.size()]));
                        } else if (ccValue.getClass().isArray()) {
                            messageRef[0].setCc((String[])ccValue);
                        }
                    }
                    if ((bccValue = ruleAction.getParameterValue(MailActionExecuter.PARAM_BCC)) != null) {
                        if (bccValue instanceof String) {
                            String bcc = (String)((Object)bccValue);
                            if (bcc.length() > 0) {
                                messageRef[0].setBcc(bcc);
                            }
                        } else if (bccValue instanceof List) {
                            List s = (List)((Object)bccValue);
                            messageRef[0].setBcc(s.toArray(new String[s.size()]));
                        } else if (bccValue.getClass().isArray()) {
                            messageRef[0].setBcc((String[])bccValue);
                        }
                    }
                } else {
                    Serializable authoritiesValue = ruleAction.getParameterValue(MailActionExecuter.PARAM_TO_MANY);
                    ArrayList<String> authorities = null;
                    if (authoritiesValue != null) {
                        if (authoritiesValue instanceof String) {
                            authorities = new ArrayList<String>(1);
                            authorities.add((String)((Object)authoritiesValue));
                        } else {
                            authorities = (List)((Object)authoritiesValue);
                        }
                    }
                    if (authorities == null || authorities.size() == 0) throw new MailPreparationException("No recipient has been specified for the mail action");
                    ArrayList<String> recipients = new ArrayList<String>(authorities.size());
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(authorities.size() + " recipient(s) for mail"));
                    }
                    for (String authority : authorities) {
                        AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)(" authority type: " + String.valueOf(authType)));
                        }
                        if (authType.equals((Object)AuthorityType.USER)) {
                            if (MailActionExecuter.this.personService.personExists(authority)) {
                                NodeRef person = MailActionExecuter.this.personService.getPerson(authority);
                                if (!MailActionExecuter.this.personService.isEnabled(authority) && !MailActionExecuter.this.nodeService.hasAspect(person, ContentModel.ASPECT_ANULLABLE)) continue;
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address != null && address.length() != 0 && MailActionExecuter.this.validateAddress(address)) {
                                    if (logger.isTraceEnabled()) {
                                        logger.trace((Object)"Recipient (person) exists in Alfresco with known email.");
                                    }
                                    recipients.add(address);
                                    continue;
                                }
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)"Recipient (person) exists in Alfresco without known email.");
                                }
                                if (!MailActionExecuter.this.validateAddress(authority)) continue;
                                recipients.add(authority);
                                continue;
                            }
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)"Recipient does not exist in Alfresco.");
                            }
                            if (!MailActionExecuter.this.validateAddress(authority)) continue;
                            recipients.add(authority);
                            continue;
                        }
                        if (!authType.equals((Object)AuthorityType.GROUP) && !authType.equals((Object)AuthorityType.EVERYONE)) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Recipient is a group...");
                        }
                        Set<String> users = authType.equals((Object)AuthorityType.GROUP) ? MailActionExecuter.this.authorityService.getContainedAuthorities(AuthorityType.USER, authority, false) : MailActionExecuter.this.authorityService.getAllAuthorities(AuthorityType.USER);
                        for (String userAuth : users) {
                            if (MailActionExecuter.this.personService.personExists(userAuth)) {
                                if (!MailActionExecuter.this.personService.isEnabled(userAuth)) continue;
                                NodeRef person = MailActionExecuter.this.personService.getPerson(userAuth);
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address != null && address.length() != 0) {
                                    recipients.add(address);
                                    if (!logger.isTraceEnabled()) continue;
                                    logger.trace((Object)"   Group member email is known.");
                                    continue;
                                }
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)"   Group member email not known.");
                                }
                                if (!MailActionExecuter.this.validateAddress(authority)) continue;
                                recipients.add(userAuth);
                                continue;
                            }
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)"   Group member person not found");
                            }
                            if (!MailActionExecuter.this.validateAddress(authority)) continue;
                            recipients.add(userAuth);
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(recipients.size() + " valid recipient(s)."));
                    }
                    if (recipients.size() <= 0) throw new MailPreparationException("All recipients for the mail action were invalid");
                    messageRef[0].setTo(recipients.toArray(new String[recipients.size()]));
                    toRecipients = String.join((CharSequence)",", recipients);
                }
                NodeRef fromPerson = null;
                String currentUserName = MailActionExecuter.this.authService.getCurrentUserName();
                List<String> usersNotToBeUsedInFromField = Arrays.asList(AuthenticationUtil.getSystemUserName(), AuthenticationUtil.getGuestUserName());
                if (!usersNotToBeUsedInFromField.contains(currentUserName)) {
                    fromPerson = MailActionExecuter.this.personService.getPerson(currentUserName);
                }
                if (MailActionExecuter.this.isFromEnabled()) {
                    String from = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_FROM));
                    if (from != null && from.length() > 0) {
                        String fromPersonalName;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("from specified as a parameter, from:" + from));
                        }
                        if ((fromPersonalName = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_FROM_PERSONAL_NAME))) != null && fromPersonalName.length() > 0) {
                            try {
                                messageRef[0].setFrom(from, fromPersonalName);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                messageRef[0].setFrom(from);
                            }
                        } else {
                            messageRef[0].setFrom(from);
                        }
                    } else {
                        String fromActualUser = null;
                        if (fromPerson != null) {
                            fromActualUser = (String)((Object)MailActionExecuter.this.nodeService.getProperty(fromPerson, ContentModel.PROP_EMAIL));
                        }
                        if (fromActualUser != null && fromActualUser.length() != 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("looked up email address for :" + String.valueOf(fromPerson) + " email from " + fromActualUser));
                            }
                            messageRef[0].setFrom(fromActualUser);
                        } else {
                            messageRef[0].setFrom(MailActionExecuter.this.fromDefaultAddress);
                        }
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("from not enabled - sending from default address:" + MailActionExecuter.this.fromDefaultAddress));
                    }
                    messageRef[0].setFrom(MailActionExecuter.this.fromDefaultAddress);
                }
                messageRef[0].setSubject((String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_SUBJECT)));
                if (MailActionExecuter.this.testModeRecipient != null && MailActionExecuter.this.testModeRecipient.length() > 0 && !MailActionExecuter.this.testModeRecipient.equals("${dev.email.recipient.address}")) {
                    Serializable obj;
                    messageRef[0].setTo(MailActionExecuter.this.testModeRecipient);
                    String emailRecipient = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TO));
                    if (emailRecipient == null && (obj = ruleAction.getParameterValue(MailActionExecuter.PARAM_TO_MANY)) != null) {
                        emailRecipient = obj.toString();
                    }
                    String recipientPrefixedSubject = "(" + emailRecipient + ") " + (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_SUBJECT));
                    messageRef[0].setSubject(recipientPrefixedSubject);
                }
                String text = null;
                Serializable ref = ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE);
                String string = templateRef = ref instanceof NodeRef ? ((NodeRef)ref).toString() : (String)((Object)ref);
                if (templateRef != null) {
                    Map suppliedModel = null;
                    if (ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE_MODEL) != null) {
                        Serializable m = ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE_MODEL);
                        if (m instanceof Map) {
                            suppliedModel = (Map)((Object)m);
                        } else {
                            logger.warn((Object)("Skipping unsupported email template model parameters of type " + m.getClass().getName() + " : " + m.toString()));
                        }
                    }
                    Map<String, Object> model = MailActionExecuter.this.createEmailTemplateModel(actionedUponNodeRef, suppliedModel, fromPerson, toRecipients);
                    Locale locale = (Locale)recipient.getSecond();
                    if (locale == null) {
                        locale = (Locale)ruleAction.getParameterValue(MailActionExecuter.PARAM_LOCALE);
                    }
                    if (locale == null) {
                        locale = (Locale)sender.getSecond();
                    }
                    String subject = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_SUBJECT));
                    Serializable subjectParamsObject = ruleAction.getParameterValue(MailActionExecuter.PARAM_SUBJECT_PARAMS);
                    Object[] subjectParams = null;
                    if (subjectParamsObject instanceof List) {
                        subjectParams = ((List)((Object)subjectParamsObject)).toArray();
                    } else if (subjectParamsObject instanceof Object[]) {
                        subjectParams = (Object[])subjectParamsObject;
                    } else if (subjectParamsObject != null) {
                        subjectParams = new Object[]{subjectParamsObject.toString()};
                    }
                    String localizedSubject = MailActionExecuter.this.getLocalizedSubject(subject, subjectParams, locale);
                    text = locale == null ? MailActionExecuter.this.templateService.processTemplate("freemarker", templateRef, model) : MailActionExecuter.this.templateService.processTemplate("freemarker", templateRef, model, locale);
                    if (MailActionExecuter.this.testModeRecipient != null && MailActionExecuter.this.testModeRecipient.length() > 0 && !MailActionExecuter.this.testModeRecipient.equals("${dev.email.recipient.address}")) {
                        messageRef[0].setTo(MailActionExecuter.this.testModeRecipient);
                        String emailRecipient = (String)recipient.getFirst();
                        String recipientPrefixedSubject = "(" + emailRecipient + ") " + localizedSubject;
                        messageRef[0].setSubject(recipientPrefixedSubject);
                    } else {
                        messageRef[0].setTo((String)recipient.getFirst());
                        messageRef[0].setSubject(localizedSubject);
                    }
                }
                boolean isHTML = false;
                if (text == null) {
                    text = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TEXT));
                }
                if (text != null) {
                    if (MailActionExecuter.isHTML(text)) {
                        isHTML = true;
                    }
                } else {
                    text = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_HTML));
                    if (text != null) {
                        isHTML = true;
                    }
                }
                if (text == null) return;
                messageRef[0].setText(text, isHTML);
            }
        };
        MimeMessage mimeMessage = this.mailService.createMimeMessage();
        try {
            mailPreparer.prepare(mimeMessage);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Unable to prepare mail message. Skipping.", (Throwable)e);
            }
            return null;
        }
        return messageRef[0];
    }

    private void sendEmail(Action ruleAction, MimeMessageHelper preparedMessage) {
        block5: {
            try {
                if (!this.testMode) {
                    this.mailService.send(preparedMessage.getMimeMessage());
                    this.onSend();
                } else {
                    this.lastTestMessage = preparedMessage.getMimeMessage();
                    ++this.testSentCount;
                }
            }
            catch (NullPointerException | MailException e) {
                Serializable obj;
                this.onFail();
                String to = (String)((Object)ruleAction.getParameterValue(PARAM_TO));
                if (to == null && (obj = ruleAction.getParameterValue(PARAM_TO_MANY)) != null) {
                    to = obj.toString();
                }
                logger.error((Object)("Failed to send email to " + to + " : " + String.valueOf(e)));
                Boolean ignoreError = (Boolean)ruleAction.getParameterValue(PARAM_IGNORE_SEND_FAILURE);
                if (ignoreError != null && ignoreError.booleanValue()) break block5;
                throw new AlfrescoRuntimeException("Failed to send email to:" + to);
            }
        }
    }

    private String getLocalizedSubject(String subject, Object[] params, Locale locale) {
        String localizedSubject = null;
        localizedSubject = locale == null ? I18NUtil.getMessage((String)subject, (Object[])params) : I18NUtil.getMessage((String)subject, (Locale)locale, (Object[])params);
        if (localizedSubject == null) {
            return subject;
        }
        return localizedSubject;
    }

    private Pair<InternetAddress, Locale> getFrom(Action ruleAction) {
        try {
            InternetAddress address;
            String currentUserName;
            Locale locale = null;
            String fromPersonName = null;
            if (!this.authService.isCurrentUserTheSystemUser() && (currentUserName = this.authService.getCurrentUserName()) != null && this.personExists(currentUserName)) {
                fromPersonName = currentUserName;
                locale = this.getLocaleForUser(fromPersonName);
            }
            if (this.isFromEnabled()) {
                String from = (String)((Object)ruleAction.getParameterValue(PARAM_FROM));
                if (from != null && from.length() > 0) {
                    String fromPersonalName;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("from specified as a parameter, from:" + from));
                    }
                    if ((fromPersonalName = (String)((Object)ruleAction.getParameterValue(PARAM_FROM_PERSONAL_NAME))) != null && fromPersonalName.length() > 0) {
                        try {
                            address = new InternetAddress(from, fromPersonalName);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            address = new InternetAddress(from);
                        }
                    } else {
                        address = new InternetAddress(from);
                    }
                    if (locale == null && this.personExists(from)) {
                        locale = this.getLocaleForUser(from);
                    }
                } else {
                    String fromActualUser = fromPersonName;
                    if (fromPersonName != null) {
                        fromActualUser = this.getPersonEmail(fromPersonName);
                    }
                    if (fromActualUser != null && fromActualUser.length() != 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("looked up email address for :" + fromPersonName + " email from " + fromActualUser));
                        }
                        address = new InternetAddress(fromActualUser);
                    } else {
                        address = new InternetAddress(this.fromDefaultAddress);
                    }
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("from not enabled - sending from default address:" + this.fromDefaultAddress));
                }
                address = new InternetAddress(this.fromDefaultAddress);
            }
            return new Pair((Object)address, (Object)locale);
        }
        catch (MessagingException messagingException) {
            throw new AlfrescoRuntimeException("Failed to resolve sender mail address");
        }
    }

    private Collection<Pair<String, Locale>> getRecipients(Action ruleAction) {
        HashMap<String, Pair> recipients = new HashMap<String, Pair>();
        String to = (String)((Object)ruleAction.getParameterValue(PARAM_TO));
        if (to != null && to.length() != 0) {
            Locale locale = null;
            if (this.personExists(to)) {
                locale = this.getLocaleForUser(to);
            }
            recipients.put(to, new Pair((Object)to, (Object)locale));
        } else {
            Serializable authoritiesValue = ruleAction.getParameterValue(PARAM_TO_MANY);
            ArrayList<String> authorities = null;
            if (authoritiesValue != null) {
                if (authoritiesValue instanceof String) {
                    authorities = new ArrayList<String>(1);
                    authorities.add((String)((Object)authoritiesValue));
                } else {
                    authorities = (List)((Object)authoritiesValue);
                }
            }
            if (authorities != null && authorities.size() != 0) {
                for (String authority : authorities) {
                    AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
                    if (authType.equals((Object)AuthorityType.USER)) {
                        if (authority == null || authority.length() == 0 || recipients.containsKey(authority)) continue;
                        if (this.personExists(authority)) {
                            String address = this.getPersonEmail(authority);
                            if (address != null && address.length() != 0 && this.validateAddress(address)) {
                                Locale locale = this.getLocaleForUser(authority);
                                recipients.put(authority, new Pair((Object)address, (Object)locale));
                                continue;
                            }
                            EmailValidator emailValidator = EmailValidator.getInstance((boolean)true);
                            if (!this.validateAddresses || !emailValidator.isValid(authority)) continue;
                            Locale locale = this.getLocaleForUser(authority);
                            recipients.put(authority, new Pair((Object)authority, (Object)locale));
                            continue;
                        }
                        recipients.put(authority, new Pair((Object)authority, null));
                        continue;
                    }
                    if (!authType.equals((Object)AuthorityType.GROUP) && !authType.equals((Object)AuthorityType.EVERYONE)) continue;
                    Set<String> users = authType.equals((Object)AuthorityType.GROUP) ? this.authorityService.getContainedAuthorities(AuthorityType.USER, authority, false) : this.authorityService.getAllAuthorities(AuthorityType.USER);
                    for (String userAuth : users) {
                        if (recipients.containsKey(userAuth)) continue;
                        if (this.personExists(userAuth)) {
                            String address = this.getPersonEmail(userAuth);
                            if (address != null && address.length() != 0 && this.validateAddress(address)) {
                                Locale locale = this.getLocaleForUser(userAuth);
                                recipients.put(userAuth, new Pair((Object)address, (Object)locale));
                                continue;
                            }
                            EmailValidator emailValidator = EmailValidator.getInstance((boolean)true);
                            if (!this.validateAddresses || !emailValidator.isValid(userAuth) || userAuth == null || userAuth.length() == 0) continue;
                            Locale locale = this.getLocaleForUser(userAuth);
                            recipients.put(userAuth, new Pair((Object)userAuth, (Object)locale));
                            continue;
                        }
                        recipients.put(userAuth, new Pair((Object)authority, null));
                    }
                }
                if (recipients.size() <= 0) {
                    throw new MailPreparationException("All recipients for the mail action were invalid");
                }
            } else {
                throw new MailPreparationException("No recipient has been specified for the mail action");
            }
        }
        return recipients.values();
    }

    public boolean personExists(final String user) {
        boolean exists = false;
        String domain = this.tenantService.getPrimaryDomain(user);
        exists = domain != null ? ((Boolean)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return MailActionExecuter.this.personService.personExists(user);
            }
        }, (String)domain)).booleanValue() : this.personService.personExists(user);
        return exists;
    }

    public NodeRef getPerson(final String user) {
        NodeRef person = null;
        String domain = this.tenantService.getPrimaryDomain(user);
        person = domain != null ? (NodeRef)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return MailActionExecuter.this.personService.getPerson(user);
            }
        }, (String)domain) : this.personService.getPerson(user);
        return person;
    }

    public String getPersonEmail(String user) {
        final NodeRef person = this.getPerson(user);
        String email = null;
        String domain = this.tenantService.getPrimaryDomain(user);
        email = domain != null ? (String)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
            }
        }, (String)domain) : (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
        return email;
    }

    private Locale getLocaleForUser(final String user) {
        Locale locale = null;
        String localeString = null;
        String domain = this.tenantService.getPrimaryDomain(user);
        if (domain != null) {
            localeString = (String)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

                public String doWork() throws Exception {
                    return (String)((Object)MailActionExecuter.this.preferenceService.getPreference(user, MailActionExecuter.PARAM_LOCALE));
                }
            }, (String)domain);
        } else if (this.personExists(user)) {
            localeString = (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    return (String)((Object)MailActionExecuter.this.preferenceService.getPreference(user, MailActionExecuter.PARAM_LOCALE));
                }
            });
        }
        if (localeString != null) {
            locale = StringUtils.parseLocaleString(localeString);
        }
        return locale;
    }

    private boolean validateAddress(String address) {
        boolean result = false;
        EmailValidator emailValidator = EmailValidator.getInstance((boolean)true);
        if (!this.validateAddresses || emailValidator.isValid(address)) {
            result = true;
        } else {
            logger.error((Object)("Failed to send email to '" + address + "' as the address is incorrectly formatted"));
        }
        return result;
    }

    private Map<String, Object> createEmailTemplateModel(NodeRef ref, Map<String, Object> suppliedModel, NodeRef fromPerson, String toRecipents) {
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        if (fromPerson != null) {
            model.put("person", new TemplateNode(fromPerson, this.serviceRegistry, null));
        }
        if (toRecipents != null) {
            model.put(PARAM_TO, toRecipents);
        }
        if (ref != null) {
            model.put("document", new TemplateNode(ref, this.serviceRegistry, null));
            NodeRef parent = this.serviceRegistry.getNodeService().getPrimaryParent(ref).getParentRef();
            model.put("space", new TemplateNode(parent, this.serviceRegistry, null));
        }
        model.put("date", new Date());
        model.put("hasAspect", new HasAspectMethod());
        model.put("message", new I18NMessageMethod());
        model.put("dateCompare", new DateCompareMethod());
        model.put("url", new URLHelper(this.sysAdminParams));
        model.put("shareUrl", UrlUtil.getShareUrl(this.serviceRegistry.getSysAdminParams()));
        if (this.imageResolver != null) {
            model.put("imageresolver", this.imageResolver);
        }
        if (suppliedModel != null && suppliedModel.size() > 0) {
            for (String key : suppliedModel.keySet()) {
                if (model.containsKey(key)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Not allowing overwriting of built in model parameter " + key));
                    continue;
                }
                model.put(key, suppliedModel.get(key));
            }
        }
        return model;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TO, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TO)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CC, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_CC)));
        paramList.add(new ParameterDefinitionImpl(PARAM_BCC, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_BCC)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TO_MANY, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_TO_MANY), true));
        paramList.add(new ParameterDefinitionImpl(PARAM_SUBJECT, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_SUBJECT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEXT, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TEXT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_FROM, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_FROM)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEMPLATE, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_TEMPLATE), false, "ac-email-templates"));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEMPLATE_MODEL, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_TEMPLATE_MODEL), true));
        paramList.add(new ParameterDefinitionImpl(PARAM_IGNORE_SEND_FAILURE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_IGNORE_SEND_FAILURE)));
    }

    @Override
    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public boolean isTestMode() {
        return this.testMode;
    }

    public MimeMessage retrieveLastTestMessage() {
        return this.lastTestMessage;
    }

    public int getTestSentCount() {
        return this.testSentCount;
    }

    public int resetTestSentCount() {
        this.testSentCount = 0;
        return 0;
    }

    public void clearLastTestMessage() {
        this.lastTestMessage = null;
    }

    public void setFromEnabled(boolean fromEnabled) {
        this.fromEnabled = fromEnabled;
    }

    public boolean isFromEnabled() {
        return this.fromEnabled;
    }

    public static boolean isHTML(String value) {
        boolean result = false;
        String htmlPrefix = "<html";
        String dtPrefix = "<!DOCTYPE";
        String trimmedText = value.trim();
        if (trimmedText.length() >= htmlPrefix.length() && trimmedText.substring(0, htmlPrefix.length()).equalsIgnoreCase(htmlPrefix)) {
            result = true;
        } else if (trimmedText.length() >= dtPrefix.length() && trimmedText.substring(0, dtPrefix.length()).equalsIgnoreCase(dtPrefix)) {
            result = true;
        }
        return result;
    }

    protected void onSend() {
        numberSuccessfulSends.getAndIncrement();
    }

    protected void onFail() {
        numberFailedSends.getAndIncrement();
    }

    public int getNumberSuccessfulSends() {
        return numberSuccessfulSends.get();
    }

    public int getNumberFailedSends() {
        return numberFailedSends.get();
    }

    public static class URLHelper {
        private final SysAdminParams sysAdminParams;

        public URLHelper(SysAdminParams sysAdminParams) {
            this.sysAdminParams = sysAdminParams;
        }

        public String getContext() {
            return "/" + this.sysAdminParams.getAlfrescoContext();
        }

        public String getServerPath() {
            return this.sysAdminParams.getAlfrescoProtocol() + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort();
        }
    }
}

