/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.repo.action.ActionStatistics;
import org.alfresco.repo.action.RunningAction;
import org.alfresco.service.cmr.action.Action;

public class ActionServiceMonitor {
    private ConcurrentHashMap<UUID, RunningAction> runningActions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ActionStatistics> actionStatistics = new ConcurrentHashMap();

    public RunningAction actionStarted(Action action) {
        RunningAction runningAction = new RunningAction(action);
        this.runningActions.put(runningAction.getId(), runningAction);
        return runningAction;
    }

    public void actionCompleted(RunningAction action) {
        this.runningActions.remove(action.getId());
        this.updateActionStatisitcis(action);
    }

    private void updateActionStatisitcis(RunningAction action) {
        String actionName = action.getActionName();
        ActionStatistics actionStats = this.actionStatistics.get(actionName);
        if (actionStats == null) {
            this.actionStatistics.putIfAbsent(actionName, new ActionStatistics(actionName));
            actionStats = this.actionStatistics.get(actionName);
        }
        actionStats.addAction(action);
    }

    public List<RunningAction> getRunningActions() {
        return Collections.unmodifiableList(new ArrayList<RunningAction>(this.runningActions.values()));
    }

    public int getRunningActionCount() {
        return this.runningActions.size();
    }

    public List<ActionStatistics> getActionStatisitcs() {
        return Collections.unmodifiableList(new ArrayList<ActionStatistics>(this.actionStatistics.values()));
    }
}

