/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.search;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.search.CMISResultSet;
import org.alfresco.opencmis.search.CMISResultSetMetaData;
import org.alfresco.opencmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.results.ResultSetSPIWrapper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.namespace.QName;

public class CMISResultSetRow
implements ResultSetRow {
    private CMISResultSet resultSet;
    private int index;
    private Map<String, Float> scores;
    private NodeService nodeService;
    private Map<String, NodeRef> nodeRefs;
    private Map<NodeRef, CMISNodeInfo> nodeInfos;
    private Query query;
    private CMISDictionaryService cmisDictionaryService;

    public CMISResultSetRow(CMISResultSet resultSet, int index, Map<String, Float> scores, NodeService nodeService, Map<String, NodeRef> nodeRefs, Map<NodeRef, CMISNodeInfo> nodeInfos, Query query, CMISDictionaryService cmisDictionaryService) {
        this.resultSet = resultSet;
        this.index = index;
        this.scores = scores;
        this.nodeService = nodeService;
        this.nodeRefs = nodeRefs;
        this.query = query;
        this.cmisDictionaryService = cmisDictionaryService;
        this.nodeInfos = nodeInfos;
    }

    public int getIndex() {
        return this.index;
    }

    public ResultSet getResultSet() {
        return new ResultSetSPIWrapper<CMISResultSetRow, CMISResultSetMetaData>(this.resultSet);
    }

    public float getScore() {
        float count = 0.0f;
        float overall = 0.0f;
        for (Float score : this.scores.values()) {
            overall = overall * (count / (count + 1.0f)) + score.floatValue() / (count + 1.0f);
        }
        return overall;
    }

    public float getScore(String selectorName) {
        return this.scores.get(selectorName).floatValue();
    }

    public Map<String, Float> getScores() {
        return this.scores;
    }

    public NodeRef getNodeRef(String selectorName) {
        return this.nodeRefs.get(selectorName);
    }

    public Map<String, NodeRef> getNodeRefs() {
        return this.nodeRefs;
    }

    public Serializable getValue(String columnName) {
        CmisFunctionEvaluationContext context = new CmisFunctionEvaluationContext();
        context.setCmisDictionaryService(this.cmisDictionaryService);
        context.setNodeRefs(this.nodeRefs);
        context.setNodeInfos(this.nodeInfos);
        context.setNodeService(this.nodeService);
        context.setScores(this.scores);
        context.setScore(Float.valueOf(this.getScore()));
        for (Column column : this.query.getColumns()) {
            PropertyArgument arg;
            if (column.getAlias().equals(columnName)) {
                if (column.getFunction() != null && column.getFunction().getName().equals("Score")) {
                    return Float.valueOf(this.getNormalisedScore());
                }
                return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
            }
            if (this.nodeRefs.size() == 1) {
                if (!column.getFunction().getName().equals("PropertyAccessor")) continue;
                arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                String propertyName = arg.getPropertyName();
                if (propertyName.equals(columnName)) {
                    return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
                }
                StringBuilder builder = new StringBuilder();
                builder.append(arg.getSelector()).append(".").append(propertyName);
                propertyName = builder.toString();
                if (!propertyName.equals(columnName)) continue;
                return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
            }
            if (!column.getFunction().getName().equals("PropertyAccessor")) continue;
            arg = (PropertyArgument)column.getFunctionArguments().get("Property");
            StringBuilder builder = new StringBuilder();
            builder.append(arg.getSelector()).append(".").append(arg.getPropertyName());
            String propertyName = builder.toString();
            if (!propertyName.equals(columnName)) continue;
            return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
        }
        return null;
    }

    private float getNormalisedScore() {
        return (float)(Math.atan(this.getScore()) / Math.PI) + 0.5f;
    }

    public Map<String, Serializable> getValues() {
        LinkedHashMap<String, Serializable> answer = new LinkedHashMap<String, Serializable>();
        String[] stringArray = this.resultSet.getMetaData().getColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            answer.put(column, this.getValue(column));
            ++n2;
        }
        return answer;
    }

    public CMISResultSet getCMISResultSet() {
        return this.resultSet;
    }

    public ChildAssociationRef getChildAssocRef() {
        NodeRef nodeRef = this.getNodeRef();
        return this.nodeService.getPrimaryParent(nodeRef);
    }

    public NodeRef getNodeRef() {
        if (this.nodeRefs.size() == 1) {
            return this.nodeRefs.values().iterator().next();
        }
        if (this.allNodeRefsEqual(this.nodeRefs)) {
            return this.nodeRefs.values().iterator().next();
        }
        throw new UnsupportedOperationException("Ambiguous selector");
    }

    private boolean allNodeRefsEqual(Map<String, NodeRef> selected) {
        NodeRef last = null;
        for (NodeRef current : selected.values()) {
            if (last == null) {
                last = current;
                continue;
            }
            if (last.equals((Object)current)) continue;
            return false;
        }
        return true;
    }

    public QName getQName() {
        return this.getChildAssocRef().getQName();
    }

    public Serializable getValue(QName qname) {
        throw new UnsupportedOperationException();
    }
}

