/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import jakarta.servlet.ServletContext;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.deployment.DeploymentMethodProvider;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

public class InfoDataCollector
extends HBBaseDataCollector
implements InitializingBean,
ServletContextAware {
    private static final Log logger = LogFactory.getLog(InfoDataCollector.class);
    private DescriptorDAO currentRepoDescriptorDAO;
    private DescriptorDAO serverDescriptorDAO;
    private DeploymentMethodProvider deploymentMethodProvider;
    private DataSource dataSource;
    private ServletContext servletContext;

    public InfoDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        super(collectorId, collectorVersion, cronExpression, hbJobScheduler);
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setServerDescriptorDAO(DescriptorDAO serverDescriptorDAO) {
        this.serverDescriptorDAO = serverDescriptorDAO;
    }

    public void setDeploymentMethodProvider(DeploymentMethodProvider deploymentMethodProvider) {
        this.deploymentMethodProvider = deploymentMethodProvider;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"serverDescriptorDAO", (Object)this.serverDescriptorDAO);
        PropertyCheck.mandatory((Object)this, (String)"currentRepoDescriptorDAO", (Object)this.currentRepoDescriptorDAO);
        PropertyCheck.mandatory((Object)this, (String)"deploymentMethodProvider", (Object)this.deploymentMethodProvider);
        PropertyCheck.mandatory((Object)this, (String)"dataSource", (Object)this.dataSource);
    }

    @Override
    public List<HBData> collectData() {
        logger.debug((Object)"Preparing repository info data...");
        Descriptor serverDescriptor = this.serverDescriptorDAO.getDescriptor();
        HashMap<String, Object> infoValues = new HashMap<String, Object>();
        infoValues.put("repoName", serverDescriptor.getName());
        HashMap<String, Object> version = new HashMap<String, Object>();
        version.put("full", serverDescriptor.getVersion());
        version.put("servicePack", serverDescriptor.getVersionMajor() + "." + serverDescriptor.getVersionMinor());
        version.put("major", serverDescriptor.getVersionMajor());
        version.put("minor", serverDescriptor.getVersionMinor());
        version.put("patch", serverDescriptor.getVersionRevision());
        version.put("build", serverDescriptor.getVersionBuild());
        String hotfix = serverDescriptor.getVersionLabel();
        if (hotfix != null && hotfix.length() > 0) {
            version.put("hotfix", hotfix.startsWith(".") ? hotfix.substring(1) : hotfix);
        }
        infoValues.put("version", version);
        infoValues.put("schema", serverDescriptor.getSchema());
        infoValues.put("edition", serverDescriptor.getEdition());
        infoValues.put("deploymentMethod", this.deploymentMethodProvider.getDeploymentMethod().toString());
        infoValues.put("osVendor", System.getProperty("os.name"));
        infoValues.put("osVersion", System.getProperty("os.version"));
        infoValues.put("osArch", System.getProperty("os.arch"));
        infoValues.put("javaVendor", System.getProperty("java.vendor"));
        infoValues.put("javaVersion", System.getProperty("java.version"));
        infoValues.put("userLanguage", Locale.getDefault().getLanguage());
        infoValues.put("userTimezone", TimeZone.getDefault().getID());
        infoValues.put("userUTCOffset", OffsetDateTime.now().getOffset().getId().replaceAll("Z", "+00.00"));
        if (this.servletContext != null) {
            infoValues.put("serverInfo", this.servletContext.getServerInfo());
        } else {
            infoValues.put("serverInfo", null);
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Connection con = this.dataSource.getConnection();){
                DatabaseMetaData dbmeta = con.getMetaData();
                HashMap<String, String> db = new HashMap<String, String>();
                db.put("vendor", dbmeta.getDatabaseProductName());
                db.put("version", dbmeta.getDatabaseProductVersion());
                db.put("driverName", dbmeta.getDriverName());
                db.put("driverVersion", dbmeta.getDriverVersion());
                infoValues.put("db", db);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {}
        HBData infoData = new HBData(this.currentRepoDescriptorDAO.getDescriptor().getId(), this.getCollectorId(), this.getCollectorVersion(), new Date(), infoValues);
        return Arrays.asList(infoData);
    }
}

