/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBDataSenderService;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.alfresco.service.license.LicenseService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HBDataCollectorServiceImpl
implements HBDataCollectorService,
LicenseService.LicenseChangeHandler {
    private static final Log logger = LogFactory.getLog(HBDataCollectorServiceImpl.class);
    private Map<String, HBBaseDataCollector> collectors = new HashMap<String, HBBaseDataCollector>();
    private HBDataSenderService hbDataSenderService;
    private final boolean defaultHbState;
    private boolean enabled = false;

    public HBDataCollectorServiceImpl(boolean defaultHeartBeatState) {
        this.defaultHbState = defaultHeartBeatState;
        this.enabled = defaultHeartBeatState;
    }

    public void setHbDataSenderService(HBDataSenderService hbDataSenderService) {
        this.hbDataSenderService = hbDataSenderService;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void registerCollector(HBBaseDataCollector collector) {
        if (this.collectors.containsKey(collector.getCollectorId())) {
            throw new IllegalArgumentException("HeartBeat did not registered collector because a collector with ID: \n" + collector.getCollectorId() + " already exists. Collectors must have unique collector IDs");
        }
        this.scheduleCollector(collector);
        this.collectors.put(collector.getCollectorId(), collector);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HeartBeat registered collector: " + collector.getCollectorId()));
        }
    }

    @Override
    public synchronized void deregisterCollector(HBBaseDataCollector collector) {
        if (this.collectors.remove(collector.getCollectorId(), collector)) {
            collector.getHbJobScheduler().unscheduleJob(collector);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HeartBeat unscheduled job and deregistered collector: " + collector.getCollectorId()));
            }
        }
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.defaultHbState;
    }

    private void scheduleCollector(HBBaseDataCollector collector) {
        if (this.enabled) {
            collector.getHbJobScheduler().scheduleJob(collector);
        } else {
            collector.getHbJobScheduler().unscheduleJob(collector);
        }
    }

    @Override
    public synchronized void onLicenseChange(LicenseDescriptor licenseDescriptor) {
        boolean newEnabled;
        boolean bl = newEnabled = !licenseDescriptor.isHeartBeatDisabled();
        if (newEnabled != this.enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HeartBeat enabled state change. Enabled=" + newEnabled));
            }
            this.setEnable(newEnabled);
            this.restartAllCollectorSchedules();
        }
    }

    @Override
    public synchronized void onLicenseFail() {
        boolean newEnabled = this.isEnabledByDefault();
        if (newEnabled != this.enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HeartBeat enabled state change. Enabled=" + newEnabled));
            }
            this.setEnable(newEnabled);
            this.restartAllCollectorSchedules();
        }
    }

    private void restartAllCollectorSchedules() {
        for (HBBaseDataCollector collector : this.collectors.values()) {
            try {
                this.scheduleCollector(collector);
            }
            catch (Exception e) {
                logger.error((Object)("HeartBeat failed to restart collector: " + collector.getCollectorId()), (Throwable)e);
            }
        }
    }

    private void setEnable(boolean enable) {
        this.enabled = enable;
        if (this.hbDataSenderService != null) {
            this.hbDataSenderService.enable(enable);
        }
    }
}

