/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.alfresco.filesys.alfresco.NetworkFileLegacyReferenceCount;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;
import org.alfresco.jlan.smb.server.disk.JavaNetworkFile;

public class TempNetworkFile
extends JavaNetworkFile
implements NetworkFileStateInterface,
NetworkFileLegacyReferenceCount {
    private boolean changed = false;
    boolean modificationDateSetDirectly = false;
    private int legacyOpenCount = 0;
    private FileState fileState;

    public TempNetworkFile(File file, String netPath) {
        super(file, netPath);
        this.setFullName(netPath);
        this.setAttributes(128);
        this.setClosed(false);
    }

    public TempNetworkFile(File file, String netPath, Reader existingContent) {
        super(file, netPath);
        this.setFullName(netPath);
        this.setAttributes(128);
        this.setClosed(false);
    }

    public File getFile() {
        return this.m_file;
    }

    public String toString() {
        return "TempNetworkFile:" + this.getFullName() + " path: " + this.m_file.getAbsolutePath();
    }

    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.fileState != null) {
            this.fileState.updateAccessDateTime();
        }
        return super.readFile(buf, len, pos, fileOff);
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
        this.changed = true;
        super.writeFile(buf, len, pos);
        long size = this.m_io.length();
        this.setFileSize(size);
        if (this.fileState != null) {
            this.fileState.updateModifyDateTime();
            this.fileState.updateAccessDateTime();
            this.fileState.setFileSize(size);
            this.fileState.setAllocationSize(size + 512L & 0xFFFFFFFFFFFFFE00L);
        }
    }

    public void writeFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        this.changed = true;
        super.writeFile(buffer, length, position, fileOffset);
        long size = this.m_io.length();
        this.setFileSize(size);
        if (this.fileState != null) {
            this.fileState.updateModifyDateTime();
            this.fileState.updateAccessDateTime();
            this.fileState.setFileSize(size);
            this.fileState.setAllocationSize(size + 512L & 0xFFFFFFFFFFFFFE00L);
        }
    }

    public void truncateFile(long size) throws IOException {
        super.truncateFile(size);
        if (size == 0L) {
            this.changed = true;
        }
        this.setFileSize(size);
        if (this.fileState != null) {
            this.fileState.updateModifyDateTime();
            this.fileState.updateAccessDateTime();
            this.fileState.setFileSize(size);
            this.fileState.setAllocationSize(size + 512L & 0xFFFFFFFFFFFFFE00L);
        }
    }

    public void setFileState(FileState fileState) {
        this.fileState = fileState;
    }

    public FileState getFileState() {
        return this.fileState;
    }

    public boolean allowsOpenCloseViaNetworkFile() {
        return false;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isModificationDateSetDirectly() {
        return this.modificationDateSetDirectly;
    }

    public void setModificationDateSetDirectly(boolean modificationDateSetDirectly) {
        this.modificationDateSetDirectly = modificationDateSetDirectly;
    }

    @Override
    public final synchronized int incrementLegacyOpenCount() {
        ++this.legacyOpenCount;
        return this.legacyOpenCount;
    }

    @Override
    public final synchronized int decrementLagacyOpenCount() {
        --this.legacyOpenCount;
        return this.legacyOpenCount;
    }

    @Override
    public final int getLegacyOpenCount() {
        return this.legacyOpenCount;
    }
}

