/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.alfresco.RepositoryDiskInterface;
import org.alfresco.filesys.repo.ClientHelper;
import org.alfresco.filesys.repo.CommandExecutor;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.OpenFileMode;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.RuleEvaluator;
import org.alfresco.filesys.repo.rules.operations.CloseFileOperation;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.MoveFileOperation;
import org.alfresco.filesys.repo.rules.operations.OpenFileOperation;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.FileAttribute;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.smb.SharingMode;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class NonTransactionalRuleContentDiskDriver
implements ExtendedDiskInterface {
    private static final Log logger = LogFactory.getLog(NonTransactionalRuleContentDiskDriver.class);
    private ExtendedDiskInterface diskInterface;
    private RuleEvaluator ruleEvaluator;
    private RepositoryDiskInterface repositoryDiskInterface;
    private CommandExecutor commandExecutor;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"diskInterface", (Object)this.diskInterface);
        PropertyCheck.mandatory((Object)this, (String)"ruleEvaluator", (Object)this.getRuleEvaluator());
        PropertyCheck.mandatory((Object)this, (String)"repositoryDiskInterface", (Object)this.getRepositoryDiskInterface());
        PropertyCheck.mandatory((Object)this, (String)"commandExecutor", (Object)this.getCommandExecutor());
    }

    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String path) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getFileInformation:" + path));
        }
        FileFilterMode.setClient((FileFilterMode.Client)ClientHelper.getClient(sess));
        try {
            FileInfo info;
            FileInfo fileInfo = info = this.diskInterface.getFileInformation(sess, tree, path);
            return fileInfo;
        }
        finally {
            FileFilterMode.clearClient();
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String path) {
        int fileExists = this.diskInterface.fileExists(sess, tree, path);
        return fileExists;
    }

    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        return this.diskInterface.createContext(shareName, args);
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeOpened(sess, tree);
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeClosed(sess, tree);
    }

    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile param) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closeFile:" + param.getFullName()));
        }
        ContentContext tctx = (ContentContext)tree.getContext();
        NodeRef rootNode = tctx.getRootNode();
        DriverState driverState = this.getDriverState(sess);
        String[] paths = FileName.splitPath((String)param.getFullName());
        String folder = paths[0];
        String file = paths[1];
        try {
            EvaluatorContext ctx = this.getEvaluatorContext(driverState, folder);
            CloseFileOperation o = new CloseFileOperation(file, param, rootNode, param.getFullName(), param.hasDeleteOnClose(), param.isForce());
            Command c = this.ruleEvaluator.evaluate(ctx, o);
            this.commandExecutor.execute(sess, tree, c);
            this.releaseEvaluatorContextIfEmpty(driverState, ctx, folder);
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Unable to close file " + param.getFullName(), (Throwable)((Object)ade));
        }
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        try {
            FileFilterMode.setClient((FileFilterMode.Client)ClientHelper.getClient(sess));
            try {
                this.diskInterface.createDirectory(sess, tree, params);
            }
            finally {
                FileFilterMode.clearClient();
            }
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Unable to create directory " + params.getPath(), (Throwable)((Object)ade));
        }
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        try {
            CreateFileOperation o;
            long creationDateTime;
            int attr = params.getAttributes();
            if (logger.isDebugEnabled()) {
                int sharedAccess = params.getSharedAccess();
                String strSharedAccess = SharingMode.getSharingModeAsString((int)sharedAccess);
                logger.debug((Object)("createFile:" + params.getPath() + ", isDirectory: " + params.isDirectory() + ", isStream: " + params.isStream() + ", readOnlyAccess: " + params.isReadOnlyAccess() + ", readWriteAccess: " + params.isReadWriteAccess() + ", writeOnlyAccess:" + params.isWriteOnlyAccess() + ", attributesOnlyAccess:" + params.isAttributesOnlyAccess() + ", sequentialAccessOnly:" + params.isSequentialAccessOnly() + ", requestBatchOpLock:" + params.requestBatchOpLock() + ", requestExclusiveOpLock:" + params.requestExclusiveOpLock() + ", isDeleteOnClose:" + params.isDeleteOnClose() + ", sharedAccess: " + strSharedAccess + ", allocationSize: " + params.getAllocationSize() + ", isHidden:" + FileAttribute.isHidden((int)attr) + ", isSystem:" + FileAttribute.isSystem((int)attr)));
            }
            if ((creationDateTime = params.getCreationDateTime()) != 0L) {
                logger.debug((Object)("creationDateTime is set:" + String.valueOf(new Date(creationDateTime))));
            }
            ContentContext tctx = (ContentContext)tree.getContext();
            NodeRef rootNode = tctx.getRootNode();
            String[] paths = FileName.splitPath((String)params.getPath());
            String folder = paths[0];
            String file = paths[1];
            DriverState driverState = this.getDriverState(sess);
            EvaluatorContext ctx = this.getEvaluatorContext(driverState, folder);
            Command c = this.ruleEvaluator.evaluate(ctx, o = new CreateFileOperation(file, rootNode, params.getPath(), params.getAllocationSize(), FileAttribute.isHidden((int)attr)));
            Object ret = this.commandExecutor.execute(sess, tree, c);
            if (ret != null && ret instanceof NetworkFile) {
                return (NetworkFile)ret;
            }
            logger.error("contract broken - NetworkFile not returned. " + String.valueOf(ret) == null ? "Return value is null" : ret);
            return null;
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Unable to create file " + params.getPath(), (Throwable)((Object)ade));
        }
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        try {
            this.diskInterface.deleteDirectory(sess, tree, dir);
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Unable to delete directory " + dir, (Throwable)((Object)ade));
        }
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("deleteFile name:" + name));
        }
        try {
            ContentContext tctx = (ContentContext)tree.getContext();
            NodeRef rootNode = tctx.getRootNode();
            DriverState driverState = this.getDriverState(sess);
            String[] paths = FileName.splitPath((String)name);
            String folder = paths[0];
            String file = paths[1];
            EvaluatorContext ctx = this.getEvaluatorContext(driverState, folder);
            DeleteFileOperation o = new DeleteFileOperation(file, rootNode, name);
            Command c = this.ruleEvaluator.evaluate(ctx, o);
            this.commandExecutor.execute(sess, tree, c);
            this.releaseEvaluatorContextIfEmpty(driverState, ctx, folder);
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Unable to delete file " + name, (Throwable)((Object)ade));
        }
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        this.diskInterface.flushFile(sess, tree, file);
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        boolean isReadOnly = this.diskInterface.isReadOnly(sess, ctx);
        return isReadOnly;
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams param) throws IOException {
        String path = param.getPath();
        boolean truncate = param.isOverwrite();
        if (logger.isDebugEnabled()) {
            int sharedAccess = param.getSharedAccess();
            String strSharedAccess = SharingMode.getSharingModeAsString((int)sharedAccess);
            logger.debug((Object)("openFile:" + path + ", isDirectory: " + param.isDirectory() + ", isStream: " + param.isStream() + ", readOnlyAccess: " + param.isReadOnlyAccess() + ", readWriteAccess: " + param.isReadWriteAccess() + ", writeOnlyAccess:" + param.isWriteOnlyAccess() + ", attributesOnlyAccess:" + param.isAttributesOnlyAccess() + ", sequentialAccessOnly:" + param.isSequentialAccessOnly() + ", writeThrough:" + param.isWriteThrough() + ", truncate:" + truncate + ", requestBatchOpLock:" + param.requestBatchOpLock() + ", requestExclusiveOpLock:" + param.requestExclusiveOpLock() + ", isDeleteOnClose:" + param.isDeleteOnClose() + ", allocationSize:" + param.getAllocationSize() + ", sharedAccess: " + strSharedAccess + ", openAction: " + param.getOpenAction() + String.valueOf(param)));
        }
        ContentContext tctx = (ContentContext)tree.getContext();
        NodeRef rootNode = tctx.getRootNode();
        DriverState driverState = this.getDriverState(sess);
        String[] paths = FileName.splitPath((String)path);
        String folder = paths[0];
        String file = paths[1];
        EvaluatorContext ctx = this.getEvaluatorContext(driverState, folder);
        OpenFileMode openMode = OpenFileMode.READ_ONLY;
        if (param.isAttributesOnlyAccess()) {
            openMode = OpenFileMode.ATTRIBUTES_ONLY;
        } else if (param.isReadWriteAccess()) {
            openMode = OpenFileMode.READ_WRITE;
        } else if (param.isWriteOnlyAccess()) {
            openMode = OpenFileMode.WRITE_ONLY;
        } else if (param.isReadOnlyAccess()) {
            openMode = OpenFileMode.READ_ONLY;
        } else if (param.isDeleteOnClose()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"open file has delete on close");
            }
            openMode = OpenFileMode.DELETE;
        }
        try {
            OpenFileOperation o = new OpenFileOperation(file, openMode, truncate, rootNode, path);
            Command c = this.ruleEvaluator.evaluate(ctx, o);
            Object ret = this.commandExecutor.execute(sess, tree, c);
            if (ret != null && ret instanceof NetworkFile) {
                NetworkFile x = (NetworkFile)ret;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("returning open file: for path:" + path + ", ret:" + String.valueOf(ret)));
                }
                return x;
            }
            logger.error("contract broken - NetworkFile not returned. " + String.valueOf(ret) == null ? "Return value is null" : ret);
            return null;
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Unable to open file " + param.getPath(), (Throwable)((Object)ade));
        }
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        int readSize = this.diskInterface.readFile(sess, tree, file, buf, bufPos, siz, filePos);
        return readSize;
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldPath, String newPath) throws IOException {
        ContentContext tctx = (ContentContext)tree.getContext();
        NodeRef rootNode = tctx.getRootNode();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("renameFile oldPath:" + oldPath + ", newPath:" + newPath));
        }
        DriverState driverState = this.getDriverState(sess);
        String[] paths = FileName.splitPath((String)oldPath);
        String oldFolder = paths[0];
        String oldFile = paths[1];
        paths = FileName.splitPath((String)newPath);
        String newFolder = paths[0];
        String newFile = paths[1];
        try {
            if (oldFolder.equalsIgnoreCase(newFolder)) {
                logger.debug((Object)"renameFileCommand - is a rename within the same folder");
                EvaluatorContext ctx = this.getEvaluatorContext(driverState, oldFolder);
                RenameFileOperation o = new RenameFileOperation(oldFile, newFile, oldPath, newPath, rootNode);
                Command c = this.ruleEvaluator.evaluate(ctx, o);
                this.commandExecutor.execute(sess, tree, c);
                this.ruleEvaluator.notifyRename(ctx, o, c);
                this.releaseEvaluatorContextIfEmpty(driverState, ctx, oldFolder);
            } else {
                logger.debug((Object)"moveFileCommand - move between folders");
                MoveFileOperation o = new MoveFileOperation(oldFile, newFile, oldPath, newPath, rootNode);
                EvaluatorContext ctx2 = this.getEvaluatorContext(driverState, newFolder);
                Command c = this.ruleEvaluator.evaluate(ctx2, o);
                this.commandExecutor.execute(sess, tree, c);
                this.releaseEvaluatorContextIfEmpty(driverState, ctx2, newFolder);
            }
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Unable to rename file file " + oldPath, (Throwable)((Object)ade));
        }
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        long ret = this.diskInterface.seekFile(sess, tree, file, pos, typ);
        return ret;
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        this.diskInterface.setFileInformation(sess, tree, name, info);
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        FileFilterMode.setClient((FileFilterMode.Client)ClientHelper.getClient(sess));
        try {
            SearchContext context;
            SearchContext searchContext = context = this.diskInterface.startSearch(sess, tree, searchPath, attrib);
            return searchContext;
        }
        finally {
            FileFilterMode.clearClient();
        }
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        this.diskInterface.truncateFile(sess, tree, file, siz);
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        int writeSize = this.diskInterface.writeFile(sess, tree, file, buf, bufoff, siz, fileoff);
        return writeSize;
    }

    public void setDiskInterface(ExtendedDiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    public ExtendedDiskInterface getDiskInterface() {
        return this.diskInterface;
    }

    public void setRuleEvaluator(RuleEvaluator ruleEvaluator) {
        this.ruleEvaluator = ruleEvaluator;
    }

    public RuleEvaluator getRuleEvaluator() {
        return this.ruleEvaluator;
    }

    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        this.diskInterface.registerContext(ctx);
    }

    public void setRepositoryDiskInterface(RepositoryDiskInterface repositoryDiskInterface) {
        this.repositoryDiskInterface = repositoryDiskInterface;
    }

    public RepositoryDiskInterface getRepositoryDiskInterface() {
        return this.repositoryDiskInterface;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DriverState getDriverState(SrvSession sess) {
        SrvSession srvSession = sess;
        synchronized (srvSession) {
            Object state = sess.getDriverState();
            if (state == null) {
                state = new DriverState();
                sess.setDriverState(state);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"new driver state created");
                }
            }
            DriverState driverState = (DriverState)state;
            return driverState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvaluatorContext getEvaluatorContext(DriverState driverState, String folder) {
        Map<String, EvaluatorContext> map = driverState.contextMap;
        synchronized (map) {
            EvaluatorContext ctx = driverState.contextMap.get(folder);
            if (ctx == null) {
                ctx = this.ruleEvaluator.createContext(driverState.sessionState);
                driverState.contextMap.put(folder, ctx);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("new driver context: " + folder));
                }
            }
            return ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEvaluatorContextIfEmpty(DriverState driverState, EvaluatorContext ctx, String folder) {
        Map<String, EvaluatorContext> map = driverState.contextMap;
        synchronized (map) {
            if (ctx != null && ctx.getScenarioInstances().size() <= 0) {
                driverState.contextMap.remove(folder);
            }
        }
    }

    private class DriverState {
        Map<String, Object> sessionState = new ConcurrentHashMap<String, Object>();
        Map<String, EvaluatorContext> contextMap = new ConcurrentHashMap<String, EvaluatorContext>();

        private DriverState() {
        }
    }
}

