/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.alfresco.filesys.alfresco.AlfrescoNetworkFile;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.alfresco.NetworkFileLegacyReferenceCount;
import org.alfresco.filesys.repo.AlfrescoFolder;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.filesys.repo.InFlightCorrectable;
import org.alfresco.filesys.repo.InFlightCorrectorImpl;
import org.alfresco.filesys.repo.NodeRefNetworkFile;
import org.alfresco.filesys.repo.TempNetworkFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.FileAccessToken;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class LegacyFileStateDriver
implements ExtendedDiskInterface {
    private ExtendedDiskInterface diskInterface;
    private OpLockInterface opLockInterface;
    private FileLockingInterface fileLockingInterface;
    private static final Log logger = LogFactory.getLog(LegacyFileStateDriver.class);

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"diskInterface", (Object)this.diskInterface);
        PropertyCheck.mandatory((Object)this, (String)"fileLockingInterface", (Object)this.fileLockingInterface);
        PropertyCheck.mandatory((Object)this, (String)"opLockInterface", (Object)this.getOpLockInterface());
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeOpened(sess, tree);
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeClosed(sess, tree);
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        ContentContext tctx = (ContentContext)tree.getContext();
        FileStateCache cache = null;
        FileState fstate = null;
        FileAccessToken token = null;
        if (tctx.hasStateCache()) {
            cache = tctx.getStateCache();
            fstate = tctx.getStateCache().findFileState(params.getPath(), true);
            token = cache.grantFileAccess(params, fstate, 0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("create file created lock token:" + String.valueOf(token)));
            }
        }
        try {
            NetworkFileLegacyReferenceCount x;
            NetworkFile newFile = this.diskInterface.createFile(sess, tree, params);
            if (newFile instanceof NetworkFileLegacyReferenceCount) {
                NetworkFileLegacyReferenceCount counter = (NetworkFileLegacyReferenceCount)newFile;
                counter.incrementLegacyOpenCount();
            }
            newFile.setAccessToken(token);
            if (tctx.hasStateCache()) {
                NetworkFileLegacyReferenceCount x2;
                fstate.setProcessId(params.getProcessId());
                fstate.setSharedAccess(params.getSharedAccess());
                fstate.setFileStatus(newFile.isDirectory() ? 2 : 1);
                long allocationSize = params.getAllocationSize();
                if (allocationSize > 0L) {
                    fstate.setAllocationSize(allocationSize);
                    fstate.setFileSize(allocationSize);
                }
                if (newFile instanceof NodeRefNetworkFile) {
                    x2 = (NodeRefNetworkFile)newFile;
                    ((AlfrescoNetworkFile)((Object)x2)).setFileState(fstate);
                }
                if (newFile instanceof TempNetworkFile) {
                    x2 = (TempNetworkFile)newFile;
                    ((TempNetworkFile)x2).setFileState(fstate);
                }
            }
            if (newFile instanceof NodeRefNetworkFile) {
                x = (NodeRefNetworkFile)newFile;
                x.setProcessId(params.getProcessId());
                x.setAccessToken(token);
            }
            if (newFile instanceof TempNetworkFile) {
                x = (TempNetworkFile)newFile;
                x.setAccessToken(token);
            }
            return newFile;
        }
        catch (IOException ie) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"create file exception caught", (Throwable)ie);
            }
            if (tctx.hasStateCache() && token != null && cache != null && fstate != null && token != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("create file release lock token:" + String.valueOf(token)));
                }
                cache.releaseFileAccess(fstate, token);
            }
            throw ie;
        }
        catch (RuntimeException re) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"create file exception caught", (Throwable)re);
            }
            if (tctx.hasStateCache() && token != null && cache != null && fstate != null && token != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("create file release lock token:" + String.valueOf(token)));
                }
                cache.releaseFileAccess(fstate, token);
            }
            throw re;
        }
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        NetworkFile networkFile;
        NetworkFile openFile;
        FileAccessToken token;
        boolean rollbackSetToken;
        boolean rollbackCount;
        boolean rollbackOpen;
        block50: {
            ContentContext tctx = (ContentContext)tree.getContext();
            String path = params.getPath();
            rollbackOpen = false;
            boolean rollbackToken = false;
            rollbackCount = false;
            rollbackSetToken = false;
            token = null;
            FileStateCache cache = null;
            FileState fstate = null;
            openFile = null;
            if (tctx.hasStateCache()) {
                cache = tctx.getStateCache();
                fstate = tctx.getStateCache().findFileState(params.getPath(), true);
                if (!params.isDirectory()) {
                    try {
                        token = cache.grantFileAccess(params, fstate, -1);
                    }
                    catch (IOException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("UNABLE to grant file access for path:" + path + ", params" + String.valueOf(params)), (Throwable)e);
                        }
                        throw e;
                    }
                    rollbackToken = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("open file created lock token:" + String.valueOf(token) + ", for path:" + path));
                    }
                }
            }
            try {
                openFile = this.diskInterface.openFile(sess, tree, params);
                rollbackOpen = true;
                if (openFile instanceof NetworkFileLegacyReferenceCount) {
                    NetworkFileLegacyReferenceCount counter = (NetworkFileLegacyReferenceCount)openFile;
                    int legacyOpenCount = counter.incrementLegacyOpenCount();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("openFile: legacyOpenCount: " + legacyOpenCount));
                    }
                    rollbackCount = true;
                } else {
                    logger.debug((Object)"openFile does not implement NetworkFileLegacyReferenceCount");
                }
                if (openFile.hasAccessToken()) {
                    if (cache != null && fstate != null && token != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("already has access token, release lock token:" + String.valueOf(token)));
                        }
                        cache.releaseFileAccess(fstate, token);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("store access token on open network file object token:" + String.valueOf(token)));
                    }
                    openFile.setAccessToken(token);
                    rollbackSetToken = true;
                }
                if (tctx.hasStateCache()) {
                    fstate = tctx.getStateCache().findFileState(path, true);
                    fstate.setProcessId(params.getProcessId());
                    fstate.setSharedAccess(params.getSharedAccess());
                    fstate.setFileSize(openFile.getFileSize());
                    fstate.updateChangeDateTime(openFile.getModifyDate());
                    fstate.updateModifyDateTime(openFile.getModifyDate());
                }
                if (openFile instanceof ContentNetworkFile) {
                    x = (ContentNetworkFile)openFile;
                    x.setProcessId(params.getProcessId());
                    if (fstate != null) {
                        x.setFileState(fstate);
                        fstate.setFileStatus(1);
                    }
                } else if (openFile instanceof TempNetworkFile) {
                    x = (TempNetworkFile)openFile;
                    if (fstate != null) {
                        x.setFileState(fstate);
                        fstate.setFileStatus(1);
                    }
                } else if (openFile instanceof AlfrescoFolder) {
                    x = (AlfrescoFolder)openFile;
                    if (fstate != null) {
                        x.setFileState(fstate);
                        fstate.setFileStatus(2);
                    }
                } else if (openFile instanceof NetworkFile) {
                    if (fstate != null) {
                        fstate.setFileStatus(1);
                    }
                }
                rollbackToken = false;
                rollbackCount = false;
                rollbackSetToken = false;
                rollbackOpen = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("successfully opened file:" + String.valueOf(openFile)));
                }
                networkFile = openFile;
                if (!rollbackToken) break block50;
            }
            catch (Throwable throwable) {
                if (rollbackToken) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("rollback token:" + String.valueOf(token)));
                    }
                    if (cache != null && fstate != null && token != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("open file release lock token:" + String.valueOf(token)));
                        }
                        cache.releaseFileAccess(fstate, token);
                    }
                }
                if (rollbackCount) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("rollback legacy open count:" + String.valueOf(token)));
                    }
                    if (openFile instanceof NetworkFileLegacyReferenceCount) {
                        NetworkFileLegacyReferenceCount counter = (NetworkFileLegacyReferenceCount)openFile;
                        counter.decrementLagacyOpenCount();
                    }
                }
                if (rollbackSetToken) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("rollback set access token:" + String.valueOf(token)));
                    }
                    openFile.setAccessToken(null);
                }
                if (rollbackOpen) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("rollback open:" + String.valueOf(token)));
                    }
                    this.diskInterface.closeFile(sess, tree, openFile);
                }
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rollback token:" + String.valueOf(token)));
            }
            if (cache != null && fstate != null && token != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("open file release lock token:" + String.valueOf(token)));
                }
                cache.releaseFileAccess(fstate, token);
            }
        }
        if (rollbackCount) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rollback legacy open count:" + String.valueOf(token)));
            }
            if (openFile instanceof NetworkFileLegacyReferenceCount) {
                NetworkFileLegacyReferenceCount counter = (NetworkFileLegacyReferenceCount)openFile;
                counter.decrementLagacyOpenCount();
            }
        }
        if (rollbackSetToken) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rollback set access token:" + String.valueOf(token)));
            }
            openFile.setAccessToken(null);
        }
        if (rollbackOpen) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rollback open:" + String.valueOf(token)));
            }
            this.diskInterface.closeFile(sess, tree, openFile);
        }
        return networkFile;
    }

    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        ContentContext tctx = (ContentContext)tree.getContext();
        FileStateCache cache = null;
        FileState fstate = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closeFile:" + file.getFullName() + ", accessToken:" + String.valueOf(file.getAccessToken())));
        }
        int legacyOpenCount = 0;
        if (file instanceof NetworkFileLegacyReferenceCount) {
            NetworkFileLegacyReferenceCount counter = (NetworkFileLegacyReferenceCount)file;
            legacyOpenCount = counter.decrementLagacyOpenCount();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("closeFile: legacyOpenCount=" + legacyOpenCount));
            }
        } else {
            logger.debug((Object)"file to close does not implement NetworkFileLegacyReferenceCount");
        }
        try {
            if (file.hasOpLock()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("File Has OpLock - release oplock for closed file, file=" + file.getFullName()));
                }
                OpLockManager oplockMgr = this.opLockInterface.getOpLockManager(sess, tree);
                oplockMgr.releaseOpLock(file.getOpLock().getPath());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Released oplock for closed file, file=" + file.getFullName()));
                }
            }
            if (file.hasLocks()) {
                LockManager lockMgr;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Release all locks, file=" + file.getFullName()));
                }
                if ((lockMgr = this.fileLockingInterface.getLockManager(sess, tree)) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Releasing locks for closed file, file=" + file.getFullName() + ", locks=" + file.numberOfLocks()));
                    }
                    lockMgr.releaseLocksForFile(sess, tree, file);
                }
            }
            this.diskInterface.closeFile(sess, tree, file);
            logger.debug((Object)"file closed");
        }
        finally {
            if (tctx.hasStateCache()) {
                cache = tctx.getStateCache();
                fstate = cache.findFileState(file.getFullName(), true);
                if ((legacyOpenCount == 0 || file.isForce()) && cache != null && fstate != null && file.getAccessToken() != null) {
                    FileAccessToken token = file.getAccessToken();
                    if (logger.isDebugEnabled() && token != null) {
                        logger.debug((Object)("close file, legacy count == 0 release access token:" + String.valueOf(token)));
                    }
                    cache.releaseFileAccess(fstate, token);
                    file.setAccessToken(null);
                }
                if (fstate.getOpenCount() == 0) {
                    logger.debug((Object)"fstate OpenCount == 0, reset in-flight state");
                    fstate.setAllocationSize(-1L);
                    fstate.setFileSize(-1L);
                    fstate.updateChangeDateTime(0L);
                    fstate.updateModifyDateTime(0L);
                }
            }
        }
    }

    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        this.diskInterface.registerContext(ctx);
    }

    public void setDiskInterface(ExtendedDiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    public ExtendedDiskInterface getDiskInterface() {
        return this.diskInterface;
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        this.diskInterface.createDirectory(sess, tree, params);
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        this.diskInterface.deleteDirectory(sess, tree, dir);
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        FileStateCache cache;
        FileState fstate;
        ContentContext tctx = (ContentContext)tree.getContext();
        this.diskInterface.deleteFile(sess, tree, name);
        if (tctx.hasStateCache() && (fstate = (cache = tctx.getStateCache()).findFileState(name, false)) != null) {
            fstate.setFileStatus(0);
            fstate.setOpenCount(0);
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        return this.diskInterface.fileExists(sess, tree, name);
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        this.diskInterface.flushFile(sess, tree, file);
    }

    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String name) throws IOException {
        return this.diskInterface.getFileInformation(sess, tree, name);
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return this.diskInterface.isReadOnly(sess, ctx);
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        return this.diskInterface.readFile(sess, tree, file, buf, bufPos, siz, filePos);
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        FileStateCache cache;
        FileState fstate;
        ContentContext tctx = (ContentContext)tree.getContext();
        this.diskInterface.renameFile(sess, tree, oldName, newName);
        if (tctx.hasStateCache() && (fstate = (cache = tctx.getStateCache()).findFileState(oldName, false)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rename file state from:" + oldName + ", to:" + newName));
            }
            cache.renameFileState(newName, fstate, fstate.isDirectory());
        }
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        return this.diskInterface.seekFile(sess, tree, file, pos, typ);
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        this.diskInterface.setFileInformation(sess, tree, name, info);
        ContentContext tctx = (ContentContext)tree.getContext();
        if (tctx.hasStateCache()) {
            FileStateCache cache = tctx.getStateCache();
            FileState fstate = cache.findFileState(name, true);
            if (info.hasSetFlag(8)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set modification date in file state cache" + name + ", " + info.getModifyDateTime()));
                }
                Date modifyDate = new Date(info.getModifyDateTime());
                fstate.updateModifyDateTime(modifyDate.getTime());
            }
        }
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        InFlightCorrectorImpl t = new InFlightCorrectorImpl(tree);
        SearchContext ctx = this.diskInterface.startSearch(sess, tree, searchPath, attrib);
        if (ctx instanceof InFlightCorrectable) {
            InFlightCorrectable thingable = (InFlightCorrectable)ctx;
            thingable.setInFlightCorrector(t);
        }
        return ctx;
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        this.diskInterface.truncateFile(sess, tree, file, siz);
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        return this.diskInterface.writeFile(sess, tree, file, buf, bufoff, siz, fileoff);
    }

    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        return this.diskInterface.createContext(shareName, args);
    }

    public void setFileLockingInterface(FileLockingInterface fileLockingInterface) {
        this.fileLockingInterface = fileLockingInterface;
    }

    public FileLockingInterface getFileLockingInterface() {
        return this.fileLockingInterface;
    }

    public void setOpLockInterface(OpLockInterface opLockInterface) {
        this.opLockInterface = opLockInterface;
    }

    public OpLockInterface getOpLockInterface() {
        return this.opLockInterface;
    }
}

