/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.policy.AssociationPolicy;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyComponentImpl;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.repo.policy.PolicyType;
import org.alfresco.repo.policy.PropertyPolicy;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ThreadPoolExecutorFactoryBean;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MTPolicyComponentTest
extends TestCase {
    private static final String TEST_MODEL = "org/alfresco/repo/policy/policycomponenttest_model.xml";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
    private static QName BASE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base");
    private static QName BASE_PROP_A = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base_a");
    private static QName BASE_ASSOC_A = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base_assoc_a");
    private static QName FILE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"file");
    private static QName FILE_PROP_B = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"file_b");
    private static QName FOLDER_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"folder");
    private static QName FOLDER_PROP_D = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"folder_d");
    private static QName TEST_ASPECT = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"aspect");
    private static QName ASPECT_PROP_A = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"aspect_a");
    private static QName INVALID_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"classdoesnotexist");
    private PolicyComponent policyComponent = null;
    static final String BASE_PROTOCOL = "baseProtocol";
    static final String BASE_IDENTIFIER = "baseIdentifier";
    static final String BASE_ID = "baseId";

    protected void setUp() throws Exception {
        TenantService mockTenantService = (TenantService)Mockito.mock(TenantService.class);
        Mockito.when((Object)mockTenantService.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockTenantService.getCurrentUserDomain()).thenReturn((Object)"test.com");
        Mockito.when((Object)mockTenantService.getDomainUser((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)"System");
        Mockito.when((Object)mockTenantService.getBaseName((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn((Object)new NodeRef(BASE_PROTOCOL, BASE_IDENTIFIER, BASE_ID));
        Mockito.when((Object)mockTenantService.getBaseName((StoreRef)ArgumentMatchers.any(StoreRef.class))).thenReturn((Object)new StoreRef(BASE_PROTOCOL, BASE_IDENTIFIER));
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService(mockTenantService);
        this.initDictionaryCaches(dictionaryDAO, mockTenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add(TEST_MODEL);
        bootstrapModels.add(TEST_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService(mockTenantService);
        bootstrap.bootstrap();
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        PolicyComponentImpl x = new PolicyComponentImpl((DictionaryService)dictionary);
        x.setTenantService(mockTenantService);
        this.policyComponent = x;
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO, TenantService tenantService) throws Exception {
        CompiledModelsCache compiledModelsCache = new CompiledModelsCache();
        compiledModelsCache.setDictionaryDAO(dictionaryDAO);
        compiledModelsCache.setTenantService(tenantService);
        compiledModelsCache.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
        ThreadPoolExecutorFactoryBean threadPoolfactory = new ThreadPoolExecutorFactoryBean();
        threadPoolfactory.afterPropertiesSet();
        compiledModelsCache.setThreadPoolExecutor((ThreadPoolExecutor)threadPoolfactory.getObject());
        dictionaryDAO.setDictionaryRegistryCache(compiledModelsCache);
        dictionaryDAO.init();
    }

    public void testJavaBehaviour() {
        JavaBehaviour validBehaviour = new JavaBehaviour((Object)this, "validClassTest");
        TestClassPolicy policy = (TestClassPolicy)validBehaviour.getInterface(TestClassPolicy.class);
        MTPolicyComponentTest.assertNotNull((Object)policy);
        NodeRef nodeRef = new NodeRef("workspace", "SpacesStore", "123");
        Date date = new Date();
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        TestClassPolicyResult result = policy.test("argument", nodeRef, date, storeRef);
        MTPolicyComponentTest.assertEquals((String)"", (String)"ValidTest: argument", (String)result.getString());
        MTPolicyComponentTest.assertEquals((String)"", (Object)nodeRef, (Object)result.getNodeRef());
    }

    public void testRegisterDefinitions() {
        try {
            this.policyComponent.registerClassPolicy(InvalidMetaDataPolicy.class);
            MTPolicyComponentTest.fail((String)"Failed to catch hidden metadata");
        }
        catch (PolicyException policyException) {}
        try {
            this.policyComponent.registerClassPolicy(NoMethodPolicy.class);
            MTPolicyComponentTest.fail((String)"Failed to catch no methods defined in policy");
        }
        catch (PolicyException policyException) {}
        try {
            this.policyComponent.registerClassPolicy(MultiMethodPolicy.class);
            MTPolicyComponentTest.fail((String)"Failed to catch multiple methods defined in policy");
        }
        catch (PolicyException policyException) {}
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        boolean isRegistered = this.policyComponent.isRegisteredPolicy(PolicyType.Class, policyName);
        MTPolicyComponentTest.assertFalse((boolean)isRegistered);
        ClassPolicyDelegate delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        MTPolicyComponentTest.assertNotNull((Object)delegate);
        isRegistered = this.policyComponent.isRegisteredPolicy(PolicyType.Class, policyName);
        MTPolicyComponentTest.assertTrue((boolean)isRegistered);
        PolicyDefinition definition = this.policyComponent.getRegisteredPolicy(PolicyType.Class, policyName);
        MTPolicyComponentTest.assertNotNull((Object)definition);
        MTPolicyComponentTest.assertEquals((Object)policyName, (Object)definition.getName());
        MTPolicyComponentTest.assertEquals((Object)PolicyType.Class, (Object)definition.getType());
        MTPolicyComponentTest.assertEquals(TestClassPolicy.class, (Object)definition.getPolicyInterface());
    }

    public void testBindBehaviour() {
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour validBehaviour = new JavaBehaviour((Object)this, "validClassTest");
        try {
            this.policyComponent.bindClassBehaviour(null, FILE_TYPE, (Behaviour)validBehaviour);
            MTPolicyComponentTest.fail((String)"Failed to catch null policy whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.policyComponent.bindClassBehaviour(policyName, null, (Behaviour)validBehaviour);
            MTPolicyComponentTest.fail((String)"Failed to catch null class reference whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.policyComponent.bindClassBehaviour(policyName, INVALID_TYPE, (Behaviour)validBehaviour);
            MTPolicyComponentTest.fail((String)"Failed to catch invalid class reference whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, null);
            MTPolicyComponentTest.fail((String)"Failed to catch null behaviour whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        JavaBehaviour invalidBehaviour = new JavaBehaviour((Object)this, "methoddoesnotexist");
        this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        try {
            this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)invalidBehaviour);
            MTPolicyComponentTest.fail((String)"Failed to catch invalid behaviour whilst binding behaviour");
        }
        catch (PolicyException policyException) {}
        try {
            BehaviourDefinition definition = this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)validBehaviour);
            MTPolicyComponentTest.assertNotNull((Object)definition);
            MTPolicyComponentTest.assertEquals((Object)policyName, (Object)definition.getPolicy());
            MTPolicyComponentTest.assertEquals((Object)FILE_TYPE, (Object)((ClassBehaviourBinding)definition.getBinding()).getClassQName());
        }
        catch (PolicyException e) {
            MTPolicyComponentTest.fail((String)("Policy exception thrown for valid behaviour" + e.toString()));
        }
    }

    public void testClassDelegate() {
        ClassPolicyDelegate delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour fileBehaviour = new JavaBehaviour((Object)this, "fileTest");
        this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)fileBehaviour);
        NodeRef nodeRef = new NodeRef("workspace", "SpacesStore", "123");
        NodeRef baseNodeRef = new NodeRef(BASE_PROTOCOL, BASE_IDENTIFIER, BASE_ID);
        Date date = new Date();
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        Collection basePolicies = delegate.getList(BASE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)basePolicies);
        MTPolicyComponentTest.assertEquals((int)0, (int)basePolicies.size());
        TestClassPolicy basePolicy = (TestClassPolicy)delegate.get(BASE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)basePolicy);
        TestClassPolicyResult baseResult = basePolicy.test("womble", nodeRef, date, storeRef);
        MTPolicyComponentTest.assertNull((String)"noop handler unexpectedly returned a result", (Object)baseResult);
        Collection filePolicies = delegate.getList(FILE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)filePolicies);
        MTPolicyComponentTest.assertEquals((int)1, (int)filePolicies.size());
        TestClassPolicy filePolicy = (TestClassPolicy)delegate.get(FILE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)filePolicy);
        TestClassPolicyResult fileResult = filePolicy.test("womble", nodeRef, date, storeRef);
        MTPolicyComponentTest.assertEquals((String)"argument type of NodeRef not replaced by base node ref", (Object)fileResult.getNodeRef(), (Object)baseNodeRef);
        JavaBehaviour serviceBehaviour = new JavaBehaviour((Object)this, "serviceTest");
        this.policyComponent.bindClassBehaviour(policyName, (Object)this, (Behaviour)serviceBehaviour);
        Collection file2Policies = delegate.getList(FILE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)file2Policies);
        MTPolicyComponentTest.assertEquals((int)2, (int)file2Policies.size());
        TestClassPolicy filePolicy2 = (TestClassPolicy)delegate.get(FILE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)filePolicy2);
        TestClassPolicyResult fileResult2 = filePolicy2.test("womble", nodeRef, date, storeRef);
        MTPolicyComponentTest.assertEquals((String)"argument type of NodeRef not replaced by base node ref", (Object)fileResult2.getNodeRef(), (Object)baseNodeRef);
        JavaBehaviour file2Behaviour = new JavaBehaviour((Object)this, "fileTest2");
        this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)file2Behaviour);
        Collection file3Policies = delegate.getList(FILE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)file3Policies);
        MTPolicyComponentTest.assertEquals((int)3, (int)file3Policies.size());
        TestClassPolicy filePolicy3 = (TestClassPolicy)delegate.get(FILE_TYPE);
        MTPolicyComponentTest.assertNotNull((Object)filePolicy3);
        TestClassPolicyResult fileResult3 = filePolicy3.test("womble", nodeRef, date, storeRef);
        MTPolicyComponentTest.assertEquals((String)"argument type of NodeRef not replaced by base node ref", (Object)fileResult3.getNodeRef(), (Object)baseNodeRef);
    }

    public TestClassPolicyResult validClassTest(String argument, NodeRef nodeRef, Date date, StoreRef storeRef) {
        TestClassPolicyResult result = new TestClassPolicyResult();
        result.s = "ValidTest: " + argument;
        result.nodeRef = nodeRef;
        result.date = date;
        result.storeRef = storeRef;
        return result;
    }

    public TestClassPolicyResult fileTest(String argument, NodeRef nodeRef, Date date, StoreRef storeRef) {
        TestClassPolicyResult result = new TestClassPolicyResult();
        result.s = "ValidTest: " + argument;
        result.nodeRef = nodeRef;
        result.date = date;
        result.storeRef = storeRef;
        return result;
    }

    public TestClassPolicyResult fileTest2(String argument, NodeRef nodeRef, Date date, StoreRef storeRef) {
        TestClassPolicyResult result = new TestClassPolicyResult();
        result.s = "ValidTest: " + argument;
        result.nodeRef = nodeRef;
        result.date = date;
        result.storeRef = storeRef;
        return result;
    }

    public TestClassPolicyResult serviceTest(String argument, NodeRef nodeRef, Date date, StoreRef storeRef) {
        TestClassPolicyResult result = new TestClassPolicyResult();
        result.s = "ValidTest: " + argument;
        result.nodeRef = nodeRef;
        result.date = date;
        result.storeRef = storeRef;
        return result;
    }

    public static interface InvalidMetaDataPolicy
    extends ClassPolicy {
        public static final int NAMESPACE = 0;

        public String test(String var1);
    }

    public static interface MultiMethodPolicy
    extends ClassPolicy {
        public void a();

        public void b();
    }

    public static interface NoMethodPolicy
    extends ClassPolicy {
    }

    public static interface TestAssociationPolicy
    extends AssociationPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }

    public static interface TestClassPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public TestClassPolicyResult test(String var1, NodeRef var2, Date var3, StoreRef var4);
    }

    public class TestClassPolicyResult {
        String s;
        NodeRef nodeRef;
        StoreRef storeRef;
        ChildAssociationRef childAssociationRef;
        Date date;

        String getString() {
            return this.s;
        }

        NodeRef getNodeRef() {
            return this.nodeRef;
        }
    }

    public static interface TestPropertyPolicy
    extends PropertyPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }
}

