/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.testusers;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.testusers.TestUserComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestUserComponentImpl
implements TestUserComponent {
    private static final Log log = LogFactory.getLog(TestUserComponentImpl.class);
    protected MutableAuthenticationService authService;
    protected PersonService personService;
    protected static final String PASSWORD = "PWD";
    protected static final String FIRST_NAME = "firstName";
    protected static final String LAST_NAME = "lastName";
    protected static final String EMAIL = "email@email.com";
    protected static final String JOB_TITLE = "jobTitle";

    public void setAuthenticationService(MutableAuthenticationService service) {
        this.authService = service;
    }

    public void setPersonService(PersonService service) {
        this.personService = service;
    }

    @Override
    public NodeRef createTestUser(final String userName) {
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef person;
                if (!TestUserComponentImpl.this.authService.authenticationExists(userName)) {
                    log.debug((Object)("Creating authentication " + userName + "..."));
                    TestUserComponentImpl.this.authService.createAuthentication(userName, TestUserComponentImpl.PASSWORD.toCharArray());
                }
                if (TestUserComponentImpl.this.personService.personExists(userName)) {
                    person = TestUserComponentImpl.this.personService.getPerson(userName, false);
                } else {
                    log.debug((Object)("Creating personNode " + userName + "..."));
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
                    ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)TestUserComponentImpl.FIRST_NAME);
                    ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)TestUserComponentImpl.LAST_NAME);
                    ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)TestUserComponentImpl.EMAIL);
                    ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)TestUserComponentImpl.JOB_TITLE);
                    person = TestUserComponentImpl.this.personService.createPerson((Map)ppOne);
                }
                return person;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    @Override
    public void deleteTestUser(final String userName) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    if (TestUserComponentImpl.this.personService.personExists(userName)) {
                        log.debug((Object)("Deleting person " + userName + "..."));
                        TestUserComponentImpl.this.personService.deletePerson(userName);
                    }
                }
                catch (InvalidNodeRefException invalidNodeRefException) {}
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }
}

