/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.context.ApplicationContext;

public class ApplicationContextInit
extends ExternalResource {
    public static final String GLOBAL_INTEGRATION_TEST_CONFIG = "classpath:alfresco/test/global-integration-test-context.xml";
    private final String[] configLocations;
    private ApplicationContext appContext;
    private static final Log log = LogFactory.getLog(ApplicationContextInit.class);

    public ApplicationContextInit() {
        this(ApplicationContextHelper.CONFIG_LOCATIONS);
    }

    public ApplicationContextInit(String ... configLocations) {
        ArrayList<String> requestedConfigs = new ArrayList<String>();
        requestedConfigs.addAll(Arrays.asList(configLocations));
        requestedConfigs.add(GLOBAL_INTEGRATION_TEST_CONFIG);
        this.configLocations = requestedConfigs.toArray(new String[0]);
    }

    public static ApplicationContextInit createStandardContextWithOverrides(String ... additionalConfigLocations) {
        ArrayList<String> contexts = new ArrayList<String>();
        String[] stringArray = ApplicationContextHelper.CONFIG_LOCATIONS;
        int n = ApplicationContextHelper.CONFIG_LOCATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultConfigLocation = stringArray[n2];
            contexts.add(defaultConfigLocation);
            ++n2;
        }
        stringArray = additionalConfigLocations;
        n = additionalConfigLocations.length;
        n2 = 0;
        while (n2 < n) {
            String additionalContext = stringArray[n2];
            contexts.add(additionalContext);
            ++n2;
        }
        String[] contextsAsArray = contexts.toArray(new String[0]);
        return new ApplicationContextInit(contextsAsArray);
    }

    protected void before() {
        log.debug((Object)("Initialising custom Spring Configuration: " + Arrays.asList(this.configLocations).toString()));
        this.appContext = ApplicationContextHelper.getApplicationContext((String[])this.configLocations);
    }

    protected void after() {
    }

    public List<String> getConfigLocations() {
        return Arrays.asList(this.configLocations);
    }

    public ApplicationContext getApplicationContext() {
        if (this.appContext == null) {
            this.before();
        }
        return this.appContext;
    }
}

