/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.Collection;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={BaseSpringTestsCategory.class})
public class SchemaTest
extends DbObjectTestBase<Schema> {
    private Schema left;
    private Schema right;

    @Before
    public void setUp() {
        this.left = new Schema("left_schema");
        this.right = new Schema("right_schema");
    }

    @Override
    protected Schema getThisObject() {
        return this.left;
    }

    @Override
    protected Schema getThatObject() {
        return this.right;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty((DbObject)this.left, "version"), new DbProperty((DbObject)this.right, "version"), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareCollections((Collection)this.left.objects, (Collection)this.right.objects, this.ctx);
    }

    @Test
    public void acceptVisitor() {
        DbObject dbo1 = (DbObject)Mockito.mock(DbObject.class);
        this.left.add(dbo1);
        DbObject dbo2 = (DbObject)Mockito.mock(DbObject.class);
        this.left.add(dbo2);
        DbObject dbo3 = (DbObject)Mockito.mock(DbObject.class);
        this.left.add(dbo3);
        this.left.accept(this.visitor);
        ((DbObject)Mockito.verify((Object)dbo1)).accept(this.visitor);
        ((DbObject)Mockito.verify((Object)dbo2)).accept(this.visitor);
        ((DbObject)Mockito.verify((Object)dbo3)).accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit((DbObject)this.left);
    }

    @Test
    public void sameAs() {
        Assert.assertTrue((String)"Schemas should be considered the same", (boolean)this.left.sameAs((DbObject)this.right));
        Assert.assertTrue((String)"Schemas are the same physical object", (boolean)this.left.sameAs((DbObject)this.left));
        Assert.assertFalse((String)"A table is not the same as a schema", (boolean)this.left.sameAs((DbObject)new Table("left_schema")));
        Assert.assertFalse((String)"null is not the same as a schema", (boolean)this.left.sameAs(null));
    }
}

