/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.schemacomp.DbToXML;
import org.alfresco.util.schemacomp.MultiFileDumper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiFileDumperTest {
    @Mock
    private MultiFileDumper.DbToXMLFactory dbToXMLFactory;
    @Mock
    private DbToXML dbToXMLForA;
    @Mock
    private DbToXML dbToXMLForB;
    @Mock
    private DbToXML dbToXMLForC;

    @Test(expected=IllegalArgumentException.class)
    public void exceptionThrownWhenZeroPrefixesUsed() {
        new MultiFileDumper(new String[0], TempFileProvider.getTempDir(), "", this.dbToXMLFactory, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void exceptionThrownWhenNullPrefixListUsed() {
        new MultiFileDumper(null, TempFileProvider.getTempDir(), "", this.dbToXMLFactory, null);
    }

    @Test
    public void canDumpSchemaToFiles() {
        String[] prefixes = new String[]{"a_", "b_", "c_"};
        File directory = TempFileProvider.getTempDir();
        String fileNamePattern = "SchemaDump-MySQL-{0}-";
        MultiFileDumper dumper = new MultiFileDumper(prefixes, directory, fileNamePattern, this.dbToXMLFactory, null);
        Mockito.when((Object)this.dbToXMLFactory.create((File)ArgumentMatchers.argThat(this.isFileNameStartingWith("SchemaDump-MySQL-a_-")), (String)ArgumentMatchers.eq((Object)"a_"))).thenReturn((Object)this.dbToXMLForA);
        Mockito.when((Object)this.dbToXMLFactory.create((File)ArgumentMatchers.argThat(this.isFileNameStartingWith("SchemaDump-MySQL-b_-")), (String)ArgumentMatchers.eq((Object)"b_"))).thenReturn((Object)this.dbToXMLForB);
        Mockito.when((Object)this.dbToXMLFactory.create((File)ArgumentMatchers.argThat(this.isFileNameStartingWith("SchemaDump-MySQL-c_-")), (String)ArgumentMatchers.eq((Object)"c_"))).thenReturn((Object)this.dbToXMLForC);
        List files = dumper.dumpFiles();
        Iterator it = files.iterator();
        this.assertPathCorrect("SchemaDump-MySQL-a_-", directory, (File)it.next());
        this.assertPathCorrect("SchemaDump-MySQL-b_-", directory, (File)it.next());
        this.assertPathCorrect("SchemaDump-MySQL-c_-", directory, (File)it.next());
        ((DbToXML)Mockito.verify((Object)this.dbToXMLForA)).execute();
        ((DbToXML)Mockito.verify((Object)this.dbToXMLForB)).execute();
        ((DbToXML)Mockito.verify((Object)this.dbToXMLForC)).execute();
    }

    @Test
    public void canDumpSchemaToFilesForDefaultDBPrefixes() {
        File directory = TempFileProvider.getTempDir();
        String fileNamePattern = "SchemaDump-MySQL-{0}-";
        MultiFileDumper dumper = new MultiFileDumper(directory, fileNamePattern, this.dbToXMLFactory, null);
        HashMap<String, DbToXML> xmlExporters = new HashMap<String, DbToXML>(MultiFileDumper.DEFAULT_PREFIXES.length);
        String[] stringArray = MultiFileDumper.DEFAULT_PREFIXES;
        int n = MultiFileDumper.DEFAULT_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            DbToXML dbToXML = (DbToXML)Mockito.mock(DbToXML.class);
            xmlExporters.put(prefix, dbToXML);
            Mockito.when((Object)this.dbToXMLFactory.create((File)ArgumentMatchers.any(File.class), (String)ArgumentMatchers.eq((Object)prefix))).thenReturn((Object)dbToXML);
            ++n2;
        }
        dumper.dumpFiles();
        for (DbToXML dbToXML : xmlExporters.values()) {
            ((DbToXML)Mockito.verify((Object)dbToXML)).execute();
        }
    }

    private ArgumentMatcher<File> isFileNameStartingWith(String startOfName) {
        return new FileNameBeginsWith(startOfName);
    }

    private void assertPathCorrect(String expectedFileNamePrefix, File expectedDirectory, File actualFile) {
        File expectedPath = new File(expectedDirectory, expectedFileNamePrefix);
        if (!actualFile.getAbsolutePath().startsWith(expectedPath.getAbsolutePath())) {
            String failureMsg = "File path " + actualFile.getAbsolutePath() + " does not start as expected: " + expectedPath.getAbsolutePath();
            Assert.fail((String)failureMsg);
        }
    }

    private static class FileNameBeginsWith
    implements ArgumentMatcher<File> {
        private final String startOfName;

        public FileNameBeginsWith(String startOfName) {
            this.startOfName = startOfName;
        }

        public boolean matches(File arg) {
            if (arg != null) {
                File fileArg = arg;
                return fileArg.getName().startsWith(this.startOfName);
            }
            return false;
        }
    }
}

