/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VanillaProtocol;
import org.alfresco.repo.virtual.store.VirtualStoreImpl;
import org.alfresco.repo.virtual.store.VirtualUserPermissions;
import org.alfresco.repo.virtual.template.ApplyTemplateMethodTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VirtualStoreImplTest
extends VirtualizationIntegrationTest {
    private static Log logger = LogFactory.getLog(VirtualStoreImplTest.class);
    private VirtualStoreImpl smartStore;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.smartStore = (VirtualStoreImpl)this.ctx.getBean("smartStore", VirtualStoreImpl.class);
    }

    @Test
    public void testResolveVirtualFolderDefinition_inactiveSynchronization() throws Exception {
        this.txnTamperHint = "VirtualStoreImplTest::testResolveVirtualFolderDefinition_inactiveSynchronization";
        this.txn.rollback();
        NodeRef ntVirtualizedFolder = null;
        NodeRef jsonTemplateContent = null;
        try {
            jsonTemplateContent = this.nodeService.getChildByName(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, "template1.json");
            if (jsonTemplateContent == null) {
                ChildAssociationRef templateChild = this.createContent(this.companyHomeNodeRef, "template1.json", ApplyTemplateMethodTest.class.getResourceAsStream("testTemplate1.json"), "application/json", StandardCharsets.UTF_8.name());
                jsonTemplateContent = templateChild.getChildRef();
            }
            if ((ntVirtualizedFolder = this.nodeService.getChildByName(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, "testCanVirtualize_nonTransactional")) == null) {
                ChildAssociationRef folderChild = this.createFolder(this.companyHomeNodeRef, "testCanVirtualize_nonTransactional");
                ntVirtualizedFolder = folderChild.getChildRef();
            }
            Reference aVanillaRef = ((VanillaProtocol)Protocols.VANILLA.protocol).newReference("/org/alfresco/repo/virtual/node/vanilla.js", "/1", ntVirtualizedFolder, jsonTemplateContent);
            this.smartStore.resolveVirtualFolderDefinition(aVanillaRef);
        }
        catch (Throwable throwable) {
            this.txn = this.transactionService.getUserTransaction();
            this.txn.begin();
            if (ntVirtualizedFolder != null) {
                this.nodeService.deleteNode(ntVirtualizedFolder);
            }
            if (jsonTemplateContent != null) {
                this.nodeService.deleteNode(jsonTemplateContent);
            }
            this.txn.commit();
            throw throwable;
        }
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        if (ntVirtualizedFolder != null) {
            this.nodeService.deleteNode(ntVirtualizedFolder);
        }
        if (jsonTemplateContent != null) {
            this.nodeService.deleteNode(jsonTemplateContent);
        }
        this.txn.commit();
    }

    @Test
    public void testNonVirtualizable() throws Exception {
        NodeRef aNodeRef = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualStoreImpl_createVirtualizedFolder", null);
        Assert.assertFalse((boolean)this.smartStore.canVirtualize(aNodeRef));
        try {
            this.smartStore.virtualize(aNodeRef);
            Assert.fail((String)"Should not be able to virtualize non-virtualizable nodes.");
        }
        catch (VirtualizationException e) {
            logger.info((Object)e);
        }
    }

    @Test
    public void testCanVirtualize() throws Exception {
        NodeRef solrFacetsNodeRef = new NodeRef("workspace://SpacesStore/solr_facets_root_space");
        boolean canVirtualize = this.smartStore.canVirtualize(solrFacetsNodeRef);
        Assert.assertEquals((Object)false, (Object)canVirtualize);
    }

    @Test
    public void testCanCreateFolderNamedV() throws Exception {
        String v = "v";
        Reference reference = Reference.fromNodeRef((NodeRef)new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, v));
        Assert.assertNull((Object)reference);
        ChildAssociationRef folderChild = this.createFolder(this.companyHomeNodeRef, v);
        Assert.assertNotNull((Object)folderChild);
    }

    private String asTypedPermission(String perm) {
        return String.valueOf(this.smartStore.getUserPermissions().getPermissionTypeQName()) + "." + perm;
    }

    private void assertHasQueryNodePermission(AccessStatus accessStatus, String perm) {
        VirtualUserPermissions virtualUserPermissions = this.smartStore.getUserPermissions();
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)virtualUserPermissions.hasQueryNodePermission(perm));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)virtualUserPermissions.hasQueryNodePermission(this.asTypedPermission(perm)));
    }

    private void assertHasVirtualNodePermission(AccessStatus accessStatus, String perm, boolean readonly) {
        VirtualUserPermissions virtualUserPermissions = this.smartStore.getUserPermissions();
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)virtualUserPermissions.hasVirtualNodePermission(perm, readonly));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)virtualUserPermissions.hasVirtualNodePermission(this.asTypedPermission(perm), readonly));
    }

    @Test
    public void testConfiguredUserPermissions() throws Exception {
        this.assertHasQueryNodePermission(AccessStatus.DENIED, "Delete");
        this.assertHasQueryNodePermission(AccessStatus.DENIED, "DeleteNode");
        this.assertHasQueryNodePermission(AccessStatus.DENIED, "ChangePermissions");
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "CreateAssociations", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "Unlock", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "CancelCheckOut", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "Delete", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "DeleteNode", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "ChangePermissions", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "WriteContent", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "Write", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "WriteProperties", true);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "Write", false);
        this.assertHasVirtualNodePermission(AccessStatus.DENIED, "WriteProperties", false);
    }

    @Test
    public void testCanExistNodeIDwithV() {
        this.createAndCheckNodeId("nfile", "specialFile1.txt");
        this.createAndCheckNodeId("vfile", "specialFile2.txt");
        this.createAndCheckNodeId("v" + String.valueOf(Encodings.ZERO.encoding.token) + "file", "specialFile3.txt");
        this.createAndCheckNodeId("v" + String.valueOf(Encodings.HASH.encoding.token) + "file", "specialFile4.txt");
        this.createAndCheckNodeId("v" + String.valueOf(Encodings.PLAIN.encoding.token) + "file", "specialFile5.txt");
        this.createAndCheckNodeId("v" + String.valueOf(Encodings.ZERO.encoding.token) + "0Draft.pdf", "specialFile6.txt");
        NodeRef virtualFolder = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder3", "C/org/alfresco/repo/virtual/template/testTemplate4.json");
        Assert.assertTrue((boolean)this.smartStore.canVirtualize(virtualFolder));
        virtualFolder = this.smartStore.virtualize(virtualFolder).toNodeRef();
        Reference reference = Reference.fromNodeRef((NodeRef)virtualFolder);
        Assert.assertNotNull((Object)reference);
        Assert.assertTrue((boolean)this.nodeService.exists(virtualFolder));
    }

    private void createAndCheckNodeId(String nodeId, String nodeName) {
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NODE_UUID, nodeId);
        props.put(ContentModel.PROP_NAME, nodeName);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)nodeName));
        NodeRef nfileNodeRef = this.nodeService.createNode(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CONTENT, props).getChildRef();
        Reference reference = Reference.fromNodeRef((NodeRef)nfileNodeRef);
        Assert.assertNull((Object)reference);
        Assert.assertTrue((boolean)this.nodeService.exists(nfileNodeRef));
    }
}

