/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.VirtualStoreImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VirtualBehaviourFilterExtensionTest
extends VirtualizationIntegrationTest {
    NodeRef virtualNodeRef;
    BehaviourFilter behaviourFilter;
    VirtualStoreImpl smartStore;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.behaviourFilter = (BehaviourFilter)this.ctx.getBean("policyBehaviourFilter", BehaviourFilter.class);
        this.smartStore = (VirtualStoreImpl)this.ctx.getBean("smartStore", VirtualStoreImpl.class);
        NodeRef nodeRef = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node1");
        this.virtualNodeRef = this.createContent(nodeRef, "actualContentName", "0", "text/plain", "UTF-8").getChildRef();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void auditableAspectOfActualNodesShouldBeEnableByDefault() {
        NodeRef actualNodeRef = this.smartStore.materialize(Reference.fromNodeRef((NodeRef)this.virtualNodeRef));
        Assert.assertTrue((String)"The auditable aspect for the actual node must be enabled by default", (boolean)this.behaviourFilter.isEnabled(actualNodeRef, ContentModel.ASPECT_AUDITABLE));
        Assert.assertTrue((String)"The auditable aspect must be enabled by default even when the virtual node is used", (boolean)this.behaviourFilter.isEnabled(this.virtualNodeRef, ContentModel.ASPECT_AUDITABLE));
    }

    @Test
    public void shouldDisbaleAuditableAspectForTheActualNode() {
        Assert.assertTrue((String)"The auditable aspect must be enabled by default even when the virtual node is used, since it hasn't been disabled yet", (boolean)this.behaviourFilter.isEnabled(this.virtualNodeRef, ContentModel.ASPECT_AUDITABLE));
        NodeRef actualNodeRef = this.smartStore.materialize(Reference.fromNodeRef((NodeRef)this.virtualNodeRef));
        this.behaviourFilter.disableBehaviour(this.virtualNodeRef, ContentModel.ASPECT_AUDITABLE);
        Assert.assertFalse((String)"The auditable aspect for the actual node must not be enable since it has been disabled", (boolean)this.behaviourFilter.isEnabled(actualNodeRef, ContentModel.ASPECT_AUDITABLE));
    }

    @Test
    public void shouldDisableTheActualNode() {
        Assert.assertTrue((String)"The node must be enabled by default even when the virtual node is used, since it hasn't been disabled yet", (boolean)this.behaviourFilter.isEnabled(this.virtualNodeRef));
        NodeRef actualNodeRef = this.smartStore.materialize(Reference.fromNodeRef((NodeRef)this.virtualNodeRef));
        Assert.assertTrue((String)"The actual node must be enable since it hasn't been disabled yet", (boolean)this.behaviourFilter.isEnabled(actualNodeRef));
        this.behaviourFilter.disableBehaviour(this.virtualNodeRef);
        Assert.assertFalse((String)"The actual node must not be enable since it has been disabled", (boolean)this.behaviourFilter.isEnabled(actualNodeRef));
    }
}

