/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.NameBasedUserNameGenerator;

public class NameBasedUserNameGeneratorTest
extends TestCase {
    public void testGenerate() {
        NameBasedUserNameGenerator generator = new NameBasedUserNameGenerator();
        generator.setUserNameLength(10);
        generator.setNamePattern("%firstName%_%lastName%");
        String firstName = "Buffy";
        String lastName = "Summers";
        String emailAddress = "buffy@sunnydale.com";
        String userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)(firstName + "_" + lastName).toLowerCase(), (String)userName);
        userName = generator.generateUserName(firstName, lastName, emailAddress, 1);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)(firstName + "_" + lastName).toLowerCase().substring(0, 7), (String)userName.substring(0, 7));
        NameBasedUserNameGeneratorTest.assertTrue((String)"", (!(firstName + "_" + lastName).toLowerCase().equals(userName) ? 1 : 0) != 0);
        generator.setNamePattern("%emailAddress%");
        userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)emailAddress.toLowerCase(), (String)userName);
        userName = generator.generateUserName(firstName, lastName, emailAddress, 1);
        NameBasedUserNameGeneratorTest.assertTrue((String)"", (!emailAddress.toLowerCase().equals(userName) ? 1 : 0) != 0);
        generator.setNamePattern("%lastName%.%firstName%");
        userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)(lastName + "." + firstName).toLowerCase(), (String)userName);
        generator.setNamePattern("%i%%lastName%");
        userName = generator.generateUserName(firstName, lastName, emailAddress, 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"", (String)"bsummers".toLowerCase(), (String)userName);
    }

    public void testGenerateWhitespaceNames() throws Exception {
        NameBasedUserNameGenerator generator = new NameBasedUserNameGenerator();
        generator.setUserNameLength(10);
        generator.setNamePattern("%firstName%_%lastName%");
        String lastName = "bar";
        NameBasedUserNameGeneratorTest.assertEquals((String)"f_oo_bar", (String)generator.generateUserName(" f oo ", lastName, "", 0));
        NameBasedUserNameGeneratorTest.assertEquals((String)"f_o_o_bar", (String)generator.generateUserName("f o  o", lastName, "", 0));
        NameBasedUserNameGeneratorTest.assertEquals((String)"f_o_o_bar", (String)generator.generateUserName("f\to\t o", lastName, "", 0));
        NameBasedUserNameGeneratorTest.assertEquals((String)"f_o_o_bar", (String)generator.generateUserName("f\no \no", lastName, "", 0));
        NameBasedUserNameGeneratorTest.assertEquals((String)"f_o_o_bar", (String)generator.generateUserName("f\ro\r\no", lastName, "", 0));
    }

    public void testAccentedCharsInNames() throws Exception {
        NameBasedUserNameGenerator generator = new NameBasedUserNameGenerator();
        generator.setUserNameLength(10);
        generator.setNamePattern("%firstName%_%lastName%");
        String firstName = "\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0 \u00e7\u00ea\u00eb\u00e8\u00ef";
        String lastName = "\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4 \u00f6\u00f2\u00fb";
        String username = generator.generateUserName(firstName, lastName, "", 0);
        NameBasedUserNameGeneratorTest.assertEquals((String)"cueaaa_ceeei_iiaaeo_oou", (String)username);
    }
}

