/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractLockStoreTestBase<T extends LockStore> {
    protected T lockStore;

    protected abstract T createLockStore();

    @Before
    public void setUpLockStore() {
        this.lockStore = this.createLockStore();
    }

    @Test
    public void testSetAndGet() {
        NodeRef ephemeralNodeRef = new NodeRef("workspace://SpacesStore/12345");
        LockState ephemeralLock = LockState.createLock((NodeRef)ephemeralNodeRef, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.EPHEMERAL, null);
        NodeRef persistentNodeRef = new NodeRef("workspace://SpacesStore/5838743");
        LockState persistentLock = LockState.createLock((NodeRef)persistentNodeRef, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.PERSISTENT, null);
        this.lockStore.set(ephemeralNodeRef, ephemeralLock);
        this.lockStore.set(persistentNodeRef, persistentLock);
        LockState newLockState = this.lockStore.get(ephemeralNodeRef);
        Assert.assertEquals((Object)ephemeralLock, (Object)newLockState);
        newLockState = this.lockStore.get(persistentNodeRef);
        Assert.assertEquals((Object)persistentLock, (Object)newLockState);
    }

    @Test
    public void testContains() {
        NodeRef nodeRef1 = new NodeRef("workspace://SpacesStore/12345");
        LockState lock1 = LockState.createLock((NodeRef)nodeRef1, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.EPHEMERAL, null);
        NodeRef nodeRef2 = new NodeRef("workspace://SpacesStore/5838743");
        LockState lock2 = LockState.createLock((NodeRef)nodeRef2, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.PERSISTENT, null);
        NodeRef nodeRef3 = new NodeRef("workspace://SpacesStore/65752323");
        this.lockStore.set(nodeRef1, lock1);
        this.lockStore.set(nodeRef2, lock2);
        Assert.assertNotNull((Object)this.lockStore.get(nodeRef1));
        Assert.assertNotNull((Object)this.lockStore.get(nodeRef2));
        Assert.assertNull((Object)this.lockStore.get(nodeRef3));
    }

    @Test
    public void testClear() {
        NodeRef nodeRef1 = new NodeRef("workspace://SpacesStore/12345");
        LockState lock1 = LockState.createLock((NodeRef)nodeRef1, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.EPHEMERAL, null);
        NodeRef nodeRef2 = new NodeRef("workspace://SpacesStore/5838743");
        LockState lock2 = LockState.createLock((NodeRef)nodeRef2, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.PERSISTENT, null);
        this.lockStore.set(nodeRef1, lock1);
        this.lockStore.set(nodeRef2, lock2);
        Assert.assertNotNull((Object)this.lockStore.get(nodeRef1));
        Assert.assertNotNull((Object)this.lockStore.get(nodeRef2));
        this.lockStore.clear();
        Assert.assertNull((Object)this.lockStore.get(nodeRef1));
        Assert.assertNull((Object)this.lockStore.get(nodeRef2));
    }

    @Test
    public void testGetNodes() {
        NodeRef nodeRef1 = new NodeRef("workspace://SpacesStore/1");
        LockState lock1 = LockState.createLock((NodeRef)nodeRef1, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.EPHEMERAL, null);
        NodeRef nodeRef2 = new NodeRef("workspace://SpacesStore/2");
        LockState lock2 = LockState.createLock((NodeRef)nodeRef2, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.PERSISTENT, null);
        NodeRef nodeRef3 = new NodeRef("workspace://SpacesStore/3");
        LockState lock3 = LockState.createLock((NodeRef)nodeRef3, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.EPHEMERAL, null);
        NodeRef nodeRef4 = new NodeRef("workspace://SpacesStore/4");
        LockState lock4 = LockState.createLock((NodeRef)nodeRef4, (LockType)LockType.NODE_LOCK, (String)"owner", null, (Lifetime)Lifetime.PERSISTENT, null);
        this.lockStore.set(nodeRef1, lock1);
        this.lockStore.set(nodeRef2, lock2);
        this.lockStore.set(nodeRef3, lock3);
        this.lockStore.set(nodeRef4, lock4);
        Set unorderedNodes = this.lockStore.getNodes();
        TreeSet<NodeRef> nodes = new TreeSet<NodeRef>(new Comparator<NodeRef>(){

            @Override
            public int compare(NodeRef o1, NodeRef o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        nodes.addAll(unorderedNodes);
        Iterator it = nodes.iterator();
        Assert.assertEquals((Object)nodeRef1, it.next());
        Assert.assertEquals((Object)nodeRef2, it.next());
        Assert.assertEquals((Object)nodeRef3, it.next());
        Assert.assertEquals((Object)nodeRef4, it.next());
    }
}

