/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ImportTimerProgress;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterContentCache;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.debug.NodeStoreInspector;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class ImporterComponentTest
extends BaseSpringTest {
    private ImporterService importerService;
    private ImporterBootstrap importerBootstrap;
    private VersionService versionService;
    private NodeService nodeService;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.importerService = (ImporterService)this.applicationContext.getBean(ServiceRegistry.IMPORTER_SERVICE.getLocalName());
        this.importerBootstrap = (ImporterBootstrap)this.applicationContext.getBean("spacesBootstrap");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.versionService = (VersionService)this.applicationContext.getBean("VersionService");
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        TimeZone tz = TimeZone.getTimeZone("GMT");
        TimeZone.setDefault(tz);
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)tz));
    }

    @After
    public void after() {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    @Test
    public void testImport() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        Location location = new Location(this.storeRef);
        this.importerService.importView((Reader)testReader, location, null, (ImporterProgress)new ImportTimerProgress());
        System.out.println(NodeStoreInspector.dumpNodeStore((NodeService)this.nodeService, (StoreRef)this.storeRef));
    }

    @Test
    public void testImportNotIndexedSubfolder() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/import_not_indexed_subfolder.xml");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader testReader = new InputStreamReader(test, "UTF-8");){
            Location location = new Location(this.storeRef);
            this.importerService.importView((Reader)testReader, location, null, (ImporterProgress)new ImportTimerProgress());
            NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
            NodeRef testParentFolderRef = ((ChildAssociationRef)this.nodeService.getChildAssocs(rootNodeRef).get(0)).getChildRef();
            NodeRef testSubfolderRef = ((ChildAssociationRef)this.nodeService.getChildAssocs(testParentFolderRef).get(0)).getChildRef();
            ImporterComponentTest.assertFalse((String)"The node's isIndexed property should be false.", (boolean)((Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)this.nodeService.getProperty(testSubfolderRef, ContentModel.PROP_IS_INDEXED))));
            ImporterComponentTest.assertFalse((String)"The node's isContentIndexed property should be false.", (boolean)((Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)this.nodeService.getProperty(testSubfolderRef, ContentModel.PROP_IS_CONTENT_INDEXED))));
            ImporterComponentTest.assertTrue((String)"The node should be marked with the indexControl aspect.", (boolean)this.nodeService.getAspects(testSubfolderRef).contains(ContentModel.ASPECT_INDEX_CONTROL));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testImportWithAuditableProperties() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        Location location = new Location(this.storeRef);
        try (InputStreamReader testReader = new InputStreamReader(test, "UTF-8");){
            this.importerService.importView((Reader)testReader, location, null, (ImporterProgress)new ImportTimerProgress());
        }
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        List childAssocs = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "SpaceWith.*"));
        ImporterComponentTest.assertEquals((String)"'SpaceWith*' path not found", (int)2, (int)childAssocs.size());
        NodeRef nodeRef = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        Map nodeProps = this.nodeService.getProperties(nodeRef);
        String createdDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATED));
        String creator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATOR));
        String modifiedDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIED));
        String modifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIER));
        ImporterComponentTest.assertEquals((String)"cm:created not preserved during import", (String)ISO8601DateFormat.format((Date)ISO8601DateFormat.parse((String)"2009-04-30T23:00:00.000Z")), (String)createdDate);
        ImporterComponentTest.assertEquals((String)"cm:creator not preserved during import", (String)"Import Creator", (String)creator);
        ImporterComponentTest.assertEquals((String)"cm:modified not preserved during import", (String)ISO8601DateFormat.format((Date)ISO8601DateFormat.parse((String)"2009-05-01T23:00:00.000Z")), (String)modifiedDate);
        ImporterComponentTest.assertEquals((String)"cm:modifier not preserved during import", (String)"Import Modifier", (String)modifier);
        nodeRef = ((ChildAssociationRef)childAssocs.get(1)).getChildRef();
        nodeProps = this.nodeService.getProperties(nodeRef);
        createdDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATED));
        creator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATOR));
        modifiedDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIED));
        modifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIER));
        ImporterComponentTest.assertEquals((String)"cm:created not preserved during import", (String)ISO8601DateFormat.format((Date)ISO8601DateFormat.parse((String)"2009-04-30T23:00:00.000Z")), (String)createdDate);
        ImporterComponentTest.assertEquals((String)"cm:creator not preserved during import", (String)"Import Creator", (String)creator);
        ImporterComponentTest.assertEquals((String)"cm:modifier not preserved during import", (String)AuthenticationUtil.getSystemUserName(), (String)modifier);
    }

    @Test
    public void testImportWithVersioning() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        Location location = new Location(this.storeRef);
        try (InputStreamReader testReader = new InputStreamReader(test, "UTF-8");){
            this.importerService.importView((Reader)testReader, location, null, (ImporterProgress)new ImportTimerProgress());
        }
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        List childAssocs = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "Version Containing Folder"));
        ImporterComponentTest.assertEquals((String)"'Version Folder' path not found", (int)1, (int)childAssocs.size());
        NodeRef versionFolder = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        childAssocs = this.nodeService.getChildAssocs(versionFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "Versioned Node"));
        ImporterComponentTest.assertEquals((String)"'Versioned Node' path not found", (int)1, (int)childAssocs.size());
        NodeRef versionedNode = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        ImporterComponentTest.assertEquals((Object)"1.15", (Object)this.nodeService.getProperty(versionedNode, ContentModel.PROP_VERSION_LABEL));
        ImporterComponentTest.assertEquals(null, (Object)this.versionService.getVersionHistory(versionFolder));
        VersionHistory vh = this.versionService.getVersionHistory(versionedNode);
        ImporterComponentTest.assertNotNull((Object)vh);
        ImporterComponentTest.assertEquals((int)1, (int)vh.getAllVersions().size());
    }

    @Test
    public void testImportWithUuidBinding() throws Exception {
        block13: {
            Location location = new Location(this.storeRef);
            InputStream test1 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
            try (InputStreamReader testReader1 = new InputStreamReader(test1, "UTF-8");){
                this.importerService.importView((Reader)testReader1, location, null, (ImporterProgress)new ImportTimerProgress());
            }
            InputStream test2 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
            try (InputStreamReader testReader2 = new InputStreamReader(test2, "UTF-8");){
                this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID);
                this.importerService.importView((Reader)testReader2, location, null, (ImporterProgress)new ImportTimerProgress());
            }
            InputStream test3 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
            InputStreamReader testReader3 = new InputStreamReader(test3, "UTF-8");
            try {
                try {
                    this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.THROW_ON_COLLISION);
                    this.importerService.importView((Reader)testReader3, location, null, (ImporterProgress)new ImportTimerProgress());
                    ImporterComponentTest.fail((String)"Failed to detected collision of UUID on import with THROW_ON_COLLISION");
                }
                catch (Throwable throwable) {
                    this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID);
                    testReader3.close();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID);
                testReader3.close();
                throw throwable;
            }
            this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID);
            testReader3.close();
        }
        System.out.println(NodeStoreInspector.dumpNodeStore((NodeService)this.nodeService, (StoreRef)this.storeRef));
    }

    @Test
    public void testBootstrap() {
        StoreRef bootstrapStoreRef = new StoreRef("workspace", "Test_" + System.currentTimeMillis());
        this.importerBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        this.importerBootstrap.bootstrap();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        System.out.println(NodeStoreInspector.dumpNodeStore((NodeService)this.nodeService, (StoreRef)bootstrapStoreRef));
    }

    @Test
    public void testImportFoldersUuidBindingNullUuidNullLocationPath() throws Exception {
        Location location = new Location(this.storeRef);
        InputStream test1 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/import_folders.xml");
        try (InputStreamReader testReader1 = new InputStreamReader(test1, "UTF-8");){
            this.importerService.importView((Reader)testReader1, location, new ImporterBinding(){

                public String getValue(String key) {
                    return null;
                }

                public ImporterBinding.UUID_BINDING getUUIDBinding() {
                    return ImporterBinding.UUID_BINDING.UPDATE_EXISTING;
                }

                public ImporterContentCache getImportConentCache() {
                    return null;
                }

                public QName[] getExcludedClasses() {
                    return null;
                }

                public boolean allowReferenceWithinTransaction() {
                    return true;
                }
            }, (ImporterProgress)new ImportTimerProgress());
        }
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        List childAssocs = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "main folder"));
        ImporterComponentTest.assertEquals((String)"'main folder' path not found", (int)1, (int)childAssocs.size());
        NodeRef mainFolderNode = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        childAssocs = this.nodeService.getChildAssocs(mainFolderNode);
        ImporterComponentTest.assertEquals((String)"'sub folder' path not found", (int)1, (int)childAssocs.size());
        NodeRef subFolderNode = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        childAssocs = this.nodeService.getChildAssocs(subFolderNode);
        ImporterComponentTest.assertEquals((String)"'subsub folder' path not found", (int)2, (int)childAssocs.size());
        childAssocs = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "ArchiveFolder"));
        ImporterComponentTest.assertEquals((String)"'ArchiveFolder' path not found", (int)1, (int)childAssocs.size());
    }
}

