/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.AssociationFieldDefinition;
import org.alfresco.repo.forms.DataTypeParameters;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.FormService;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class FormServiceImplTest
extends BaseAlfrescoSpringTest {
    private FormService formService;
    private NamespaceService namespaceService;
    private ScriptService scriptService;
    private ContentService contentService;
    private WorkflowService workflowService;
    private TestPersonManager personManager;
    private NodeRef document;
    private NodeRef associatedDoc;
    private NodeRef childDoc;
    private NodeRef folder;
    private String documentName;
    private String folderName;
    private static String VALUE_TITLE = "This is the title for the test document";
    private static String VALUE_DESCRIPTION = "This is the description for the test document";
    private static String VALUE_ORIGINATOR = "fred@customer.com";
    private static String VALUE_ADDRESSEE = "bill@example.com";
    private static String VALUE_ADDRESSEES1 = "harry@example.com";
    private static String VALUE_ADDRESSEES2 = "jane@example.com";
    private static String VALUE_ADDRESSEES3 = "alice@example.com";
    private static String VALUE_SUBJECT = "The subject is...";
    private static String VALUE_MIMETYPE = "text/plain";
    private static String VALUE_ENCODING = "UTF-8";
    private static String VALUE_CONTENT = "This is the content for the test document";
    private static String VALUE_ASSOC_CONTENT = "This is the content for the associated document";
    private static Date VALUE_SENT_DATE = new Date();
    private static String LABEL_NAME = "Name";
    private static String LABEL_TITLE = "Title";
    private static String LABEL_DESCRIPTION = "Description";
    private static String LABEL_AUTHOR = "Author";
    private static String LABEL_MODIFIED = "Modified Date";
    private static String LABEL_MODIFIER = "Modifier";
    private static String LABEL_MIMETYPE = "Mimetype";
    private static String LABEL_ENCODING = "Encoding";
    private static String LABEL_SIZE = "Size";
    private static String LABEL_ORIGINATOR = "From";
    private static String LABEL_ADDRESSEE = "To";
    private static String LABEL_ADDRESSEES = "All Recipients";
    private static String LABEL_SUBJECT = "Subject";
    private static String LABEL_SENT_DATE = "Sent Date";
    private static String LABEL_REFERENCES = "References";
    private static String LABEL_CONTAINS = "Contains";
    private static final String USER_ONE = "UserOne_FormServiceImplTest";
    private static final String USER_TWO = "UserTwo_FormServiceImplTest";
    private static final String NODE_FORM_ITEM_KIND = "node";
    private static final String TYPE_FORM_ITEM_KIND = "type";
    private static final String WORKFLOW_FORM_ITEM_KIND = "workflow";
    private static final String TASK_FORM_ITEM_KIND = "task";

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.formService = (FormService)this.applicationContext.getBean("FormService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
        this.scriptService = (ScriptService)this.applicationContext.getBean("ScriptService");
        PersonService personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.workflowService = (WorkflowService)this.applicationContext.getBean("WorkflowService");
        MutableAuthenticationService mutableAuthenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.personManager = new TestPersonManager(mutableAuthenticationService, personService, this.nodeService);
        this.personManager.createPerson(USER_ONE);
        this.personManager.createPerson(USER_TWO);
        this.personManager.setUser(USER_ONE);
        String guid = GUID.generate();
        NodeRef rootNode = this.nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        this.folderName = "testFolder" + guid;
        folderProps.put(ContentModel.PROP_NAME, this.folderName);
        this.folder = this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testFolder" + guid)), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        HashMap<QName, Object> docProps = new HashMap<QName, Object>(1);
        this.documentName = "testDocument" + guid + ".txt";
        docProps.put(ContentModel.PROP_NAME, this.documentName);
        this.document = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
        docProps.put(ContentModel.PROP_NAME, "associatedDocument" + guid + ".txt");
        this.associatedDoc = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("associatedDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
        docProps.put(ContentModel.PROP_NAME, "childDocument" + guid + ".txt");
        this.childDoc = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("childDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
        ContentWriter writer = this.contentService.getWriter(this.document, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(VALUE_MIMETYPE);
        writer.setEncoding(VALUE_ENCODING);
        writer.putContent(VALUE_CONTENT);
        ContentWriter writer2 = this.contentService.getWriter(this.associatedDoc, ContentModel.PROP_CONTENT, true);
        writer2.setMimetype(VALUE_MIMETYPE);
        writer2.setEncoding(VALUE_ENCODING);
        writer2.putContent(VALUE_ASSOC_CONTENT);
        HashMap<QName, Object> aspectProps = new HashMap<QName, Object>(2);
        aspectProps.put(ContentModel.PROP_TITLE, VALUE_TITLE);
        aspectProps.put(ContentModel.PROP_DESCRIPTION, VALUE_DESCRIPTION);
        this.nodeService.addAspect(this.document, ContentModel.ASPECT_TITLED, aspectProps);
        aspectProps = new HashMap(5);
        aspectProps.put(ContentModel.PROP_ORIGINATOR, VALUE_ORIGINATOR);
        aspectProps.put(ContentModel.PROP_ADDRESSEE, VALUE_ADDRESSEE);
        ArrayList<String> addressees = new ArrayList<String>(2);
        addressees.add(VALUE_ADDRESSEES1);
        addressees.add(VALUE_ADDRESSEES2);
        aspectProps.put(ContentModel.PROP_ADDRESSEES, addressees);
        aspectProps.put(ContentModel.PROP_SUBJECT, VALUE_SUBJECT);
        aspectProps.put(ContentModel.PROP_SENTDATE, VALUE_SENT_DATE);
        this.nodeService.addAspect(this.document, ContentModel.ASPECT_EMAILED, aspectProps);
        aspectProps.clear();
        this.nodeService.addAspect(this.document, ContentModel.ASPECT_REFERENCING, aspectProps);
        this.nodeService.createAssociation(this.document, this.associatedDoc, ContentModel.ASSOC_REFERENCES);
    }

    @Test
    public void testGetAllDocForm() throws Exception {
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, this.document.toString()));
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        FormServiceImplTest.assertEquals((String)NODE_FORM_ITEM_KIND, (String)form.getItem().getKind());
        FormServiceImplTest.assertEquals((String)this.document.toString(), (String)form.getItem().getId());
        FormServiceImplTest.assertEquals((String)ContentModel.TYPE_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespaceService), (String)form.getItem().getType());
        FormServiceImplTest.assertNull((String)"Expecting the form groups to be null!", (Object)form.getFieldGroups());
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)"Wrong number of fields", (int)19, (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition nameField = (PropertyFieldDefinition)fieldDefMap.get("cm:name");
        PropertyFieldDefinition titleField = (PropertyFieldDefinition)fieldDefMap.get("cm:title");
        PropertyFieldDefinition descField = (PropertyFieldDefinition)fieldDefMap.get("cm:description");
        PropertyFieldDefinition mimetypeField = (PropertyFieldDefinition)fieldDefMap.get("mimetype");
        PropertyFieldDefinition encodingField = (PropertyFieldDefinition)fieldDefMap.get("encoding");
        PropertyFieldDefinition sizeField = (PropertyFieldDefinition)fieldDefMap.get("size");
        PropertyFieldDefinition originatorField = (PropertyFieldDefinition)fieldDefMap.get("cm:originator");
        PropertyFieldDefinition addresseeField = (PropertyFieldDefinition)fieldDefMap.get("cm:addressee");
        PropertyFieldDefinition addresseesField = (PropertyFieldDefinition)fieldDefMap.get("cm:addressees");
        PropertyFieldDefinition subjectField = (PropertyFieldDefinition)fieldDefMap.get("cm:subjectline");
        PropertyFieldDefinition sentDateField = (PropertyFieldDefinition)fieldDefMap.get("cm:sentdate");
        AssociationFieldDefinition referencesField = (AssociationFieldDefinition)fieldDefMap.get("cm:references");
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:name field", (Object)nameField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:title field", (Object)titleField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:description field", (Object)descField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the mimetype field", (Object)mimetypeField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the encoding field", (Object)encodingField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the size field", (Object)sizeField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:originator field", (Object)originatorField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:addressee field", (Object)addresseeField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:addressees field", (Object)addresseesField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:subjectline field", (Object)subjectField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:sentdate field", (Object)sentDateField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:references field", (Object)referencesField);
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:node-dbid"));
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:store-identifier"));
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:node-uuid"));
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:store-protocol"));
        FormServiceImplTest.assertEquals((String)("Expecting cm:name label to be " + LABEL_NAME), (String)LABEL_NAME, (String)nameField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:title label to be " + LABEL_TITLE), (String)LABEL_TITLE, (String)titleField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:description label to be " + LABEL_DESCRIPTION), (String)LABEL_DESCRIPTION, (String)descField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting mimetype label to be " + LABEL_MIMETYPE), (String)LABEL_MIMETYPE, (String)mimetypeField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting encoding label to be " + LABEL_ENCODING), (String)LABEL_ENCODING, (String)encodingField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting size label to be " + LABEL_SIZE), (String)LABEL_SIZE, (String)sizeField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:originator label to be " + LABEL_ORIGINATOR), (String)LABEL_ORIGINATOR, (String)originatorField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:addressee label to be " + LABEL_ADDRESSEE), (String)LABEL_ADDRESSEE, (String)addresseeField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:addressees label to be " + LABEL_ADDRESSEES), (String)LABEL_ADDRESSEES, (String)addresseesField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:subjectline label to be " + LABEL_SUBJECT), (String)LABEL_SUBJECT, (String)subjectField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:sentdate label to be " + LABEL_SENT_DATE), (String)LABEL_SENT_DATE, (String)sentDateField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:references label to be " + LABEL_REFERENCES), (String)LABEL_REFERENCES, (String)referencesField.getLabel());
        FormServiceImplTest.assertEquals((String)"Expecting cm:name type to be text", (String)"text", (String)nameField.getDataType());
        FormServiceImplTest.assertTrue((String)"Expecting cm:name to be mandatory", (boolean)nameField.isMandatory());
        FormServiceImplTest.assertFalse((String)"Expecting cm:name to be single valued", (boolean)nameField.isRepeating());
        List constraints = nameField.getConstraints();
        FormServiceImplTest.assertEquals((String)"Expecting 1 constraint for cm:name", (int)1, (int)constraints.size());
        PropertyFieldDefinition.FieldConstraint constraint = (PropertyFieldDefinition.FieldConstraint)constraints.get(0);
        FormServiceImplTest.assertEquals((String)"Expecting name of constraint to be 'REGEX'", (String)"REGEX", (String)constraint.getType());
        Map params = constraint.getParameters();
        FormServiceImplTest.assertNotNull((String)"Expecting constraint parameters", (Object)params);
        FormServiceImplTest.assertEquals((String)"Expecting 2 constraint parameters", (int)2, (int)params.size());
        FormServiceImplTest.assertNotNull((String)"Expecting an 'expression' constraint parameter", params.get("expression"));
        FormServiceImplTest.assertNotNull((String)"Expecting an 'requiresMatch' constraint parameter", params.get("requiresMatch"));
        FormServiceImplTest.assertEquals((String)"Expecting cm:addressees type to be text", (String)"text", (String)addresseesField.getDataType());
        FormServiceImplTest.assertFalse((String)"Expecting cm:addressees to be mandatory", (boolean)addresseesField.isMandatory());
        FormServiceImplTest.assertTrue((String)"Expecting cm:addressees to be multi valued", (boolean)addresseesField.isRepeating());
        FormServiceImplTest.assertNull((String)"Expecting constraints for cm:addressees to be null", (Object)addresseesField.getConstraints());
        FormServiceImplTest.assertEquals((String)"Expecting cm:references endpoint type to be cm:content", (String)"cm:content", (String)referencesField.getEndpointType());
        FormServiceImplTest.assertEquals((String)"Expecting cm:references endpoint direction to be TARGET", (String)AssociationFieldDefinition.Direction.TARGET.toString(), (String)referencesField.getEndpointDirection().toString());
        FormServiceImplTest.assertFalse((String)"Expecting cm:references endpoint to be optional", (boolean)referencesField.isEndpointMandatory());
        FormServiceImplTest.assertTrue((String)"Expecting cm:references endpoint to be 1 to many", (boolean)referencesField.isEndpointMany());
        FormData data = form.getFormData();
        FormServiceImplTest.assertNotNull((String)"Expecting form data", (Object)data);
        FormServiceImplTest.assertEquals((Object)VALUE_TITLE, (Object)data.getFieldData(titleField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_DESCRIPTION, (Object)data.getFieldData(descField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_MIMETYPE, (Object)data.getFieldData(mimetypeField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_ENCODING, (Object)data.getFieldData(encodingField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_ORIGINATOR, (Object)data.getFieldData(originatorField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_ADDRESSEE, (Object)data.getFieldData(addresseeField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_SUBJECT, (Object)data.getFieldData(subjectField.getDataKeyName()).getValue());
        FormServiceImplTest.assertTrue((String)"Expecting size to be > 0", ((Long)data.getFieldData(sizeField.getDataKeyName()).getValue() > 0L ? 1 : 0) != 0);
        String addressees = (String)data.getFieldData(addresseesField.getDataKeyName()).getValue();
        FormServiceImplTest.assertNotNull((Object)addressees);
        FormServiceImplTest.assertTrue((String)"Expecting the addressees value to have at least 1 comma", (addressees.indexOf(",") != -1 ? 1 : 0) != 0);
        String[] addresseesArr = StringUtils.delimitedListToStringArray((String)addressees, (String)",");
        FormServiceImplTest.assertEquals((String)"Expecting 2 addressees", (int)2, (int)addresseesArr.length);
        FormServiceImplTest.assertEquals((String)VALUE_ADDRESSEES1, (String)addresseesArr[0]);
        FormServiceImplTest.assertEquals((String)VALUE_ADDRESSEES2, (String)addresseesArr[1]);
        Calendar calTestValue = Calendar.getInstance();
        calTestValue.setTime(VALUE_SENT_DATE);
        Calendar calServiceValue = Calendar.getInstance();
        calServiceValue.setTime((Date)data.getFieldData(sentDateField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((long)calTestValue.getTimeInMillis(), (long)calServiceValue.getTimeInMillis());
        List targets = (List)data.getFieldData(referencesField.getDataKeyName()).getValue();
        FormServiceImplTest.assertEquals((String)"Expecting 1 target", (int)1, (int)targets.size());
        FormServiceImplTest.assertEquals((String)this.associatedDoc.toString(), (String)((String)targets.get(0)));
    }

    @Test
    public void testGetSelectedFieldsDocForm() throws Exception {
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add("cm:name");
        fields.add("cm:title");
        fields.add("mimetype");
        fields.add("cm:modified");
        fields.add("cm:modifier");
        fields.add("cm:subjectline");
        fields.add("cm:sentdate");
        fields.add("cm:references");
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, this.document.toString()), fields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        FormServiceImplTest.assertEquals((String)NODE_FORM_ITEM_KIND, (String)form.getItem().getKind());
        FormServiceImplTest.assertEquals((String)this.document.toString(), (String)form.getItem().getId());
        FormServiceImplTest.assertEquals((String)ContentModel.TYPE_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespaceService), (String)form.getItem().getType());
        FormServiceImplTest.assertNull((String)"Expecting the form groups to be null!", (Object)form.getFieldGroups());
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)("Expecting to find " + fields.size() + " fields"), (int)fields.size(), (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition nameField = (PropertyFieldDefinition)fieldDefMap.get("cm:name");
        PropertyFieldDefinition titleField = (PropertyFieldDefinition)fieldDefMap.get("cm:title");
        PropertyFieldDefinition mimetypeField = (PropertyFieldDefinition)fieldDefMap.get("mimetype");
        PropertyFieldDefinition modifiedField = (PropertyFieldDefinition)fieldDefMap.get("cm:modified");
        PropertyFieldDefinition modifierField = (PropertyFieldDefinition)fieldDefMap.get("cm:modifier");
        PropertyFieldDefinition subjectField = (PropertyFieldDefinition)fieldDefMap.get("cm:subjectline");
        PropertyFieldDefinition sentDateField = (PropertyFieldDefinition)fieldDefMap.get("cm:sentdate");
        AssociationFieldDefinition referencesField = (AssociationFieldDefinition)fieldDefMap.get("cm:references");
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:name field", (Object)nameField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:title field", (Object)titleField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the mimetype field", (Object)mimetypeField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:modified field", (Object)modifiedField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:modifier field", (Object)modifierField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:subjectline field", (Object)subjectField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:sentdate field", (Object)sentDateField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:references field", (Object)referencesField);
        FormServiceImplTest.assertEquals((String)("Expecting cm:name label to be " + LABEL_NAME), (String)LABEL_NAME, (String)nameField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:title label to be " + LABEL_TITLE), (String)LABEL_TITLE, (String)titleField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting mimetype label to be " + LABEL_MIMETYPE), (String)LABEL_MIMETYPE, (String)mimetypeField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:modified label to be " + LABEL_MODIFIED), (String)LABEL_MODIFIED, (String)modifiedField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:modifier label to be " + LABEL_MODIFIER), (String)LABEL_MODIFIER, (String)modifierField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:subjectline label to be " + LABEL_SUBJECT), (String)LABEL_SUBJECT, (String)subjectField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:sentdate label to be " + LABEL_SENT_DATE), (String)LABEL_SENT_DATE, (String)sentDateField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:references label to be " + LABEL_REFERENCES), (String)LABEL_REFERENCES, (String)referencesField.getLabel());
        FormServiceImplTest.assertEquals((String)"Expecting cm:modified type to be datetime", (String)"datetime", (String)modifiedField.getDataType());
        FormServiceImplTest.assertTrue((String)"Expecting cm:modified to be mandatory", (boolean)modifiedField.isMandatory());
        FormServiceImplTest.assertFalse((String)"Expecting cm:modified to be single valued", (boolean)modifiedField.isRepeating());
        FormServiceImplTest.assertEquals((String)"Expecting cm:references endpoint type to be cm:content", (String)"cm:content", (String)referencesField.getEndpointType());
        FormServiceImplTest.assertEquals((String)"Expecting cm:references endpoint direction to be TARGET", (String)AssociationFieldDefinition.Direction.TARGET.toString(), (String)referencesField.getEndpointDirection().toString());
        FormServiceImplTest.assertFalse((String)"Expecting cm:references endpoint to be optional", (boolean)referencesField.isEndpointMandatory());
        FormServiceImplTest.assertTrue((String)"Expecting cm:references endpoint to be 1 to many", (boolean)referencesField.isEndpointMany());
        FormData data = form.getFormData();
        FormServiceImplTest.assertNotNull((String)"Expecting form data", (Object)data);
        FormServiceImplTest.assertEquals((Object)this.documentName, (Object)data.getFieldData(nameField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_TITLE, (Object)data.getFieldData(titleField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_MIMETYPE, (Object)data.getFieldData(mimetypeField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_SUBJECT, (Object)data.getFieldData(subjectField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)USER_ONE, (Object)data.getFieldData(modifierField.getDataKeyName()).getValue());
        Date modifiedDate = (Date)data.getFieldData(modifiedField.getDataKeyName()).getValue();
        FormServiceImplTest.assertNotNull((String)"Expecting to find modified date", (Object)modifiedDate);
        Calendar calTestValue = Calendar.getInstance();
        calTestValue.setTime(VALUE_SENT_DATE);
        Calendar calServiceValue = Calendar.getInstance();
        calServiceValue.setTime((Date)data.getFieldData(sentDateField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((long)calTestValue.getTimeInMillis(), (long)calServiceValue.getTimeInMillis());
        List targets = (List)data.getFieldData(referencesField.getDataKeyName()).getValue();
        FormServiceImplTest.assertEquals((String)"Expecting 1 target", (int)1, (int)targets.size());
        FormServiceImplTest.assertEquals((String)this.associatedDoc.toString(), (String)((String)targets.get(0)));
    }

    @Test
    public void testMissingFieldsDocForm() throws Exception {
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add("cm:name");
        fields.add("cm:title");
        fields.add("cm:author");
        fields.add("wrong-name");
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, this.document.toString()), fields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)("Expecting to find " + (fields.size() - 2) + " fields"), (int)(fields.size() - 2), (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition nameField = (PropertyFieldDefinition)fieldDefMap.get("cm:name");
        PropertyFieldDefinition titleField = (PropertyFieldDefinition)fieldDefMap.get("cm:title");
        PropertyFieldDefinition authorField = (PropertyFieldDefinition)fieldDefMap.get("cm:author");
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:name field", (Object)nameField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:title field", (Object)titleField);
        FormServiceImplTest.assertNull((String)"Expecting cm:author field to be missing", (Object)authorField);
        FormServiceImplTest.assertEquals((String)("Expecting cm:name label to be " + LABEL_NAME), (String)LABEL_NAME, (String)nameField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:title label to be " + LABEL_TITLE), (String)LABEL_TITLE, (String)titleField.getLabel());
        FormData data = form.getFormData();
        FormServiceImplTest.assertNotNull((String)"Expecting form data", (Object)data);
        FormServiceImplTest.assertEquals((Object)this.documentName, (Object)data.getFieldData(nameField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_TITLE, (Object)data.getFieldData(titleField.getDataKeyName()).getValue());
    }

    @Test
    public void testForcedFieldsDocForm() throws Exception {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add("cm:name");
        fields.add("cm:title");
        fields.add("cm:author");
        fields.add("cm:never");
        fields.add("wrong-name");
        ArrayList<String> forcedFields = new ArrayList<String>(2);
        forcedFields.add("cm:author");
        forcedFields.add("cm:never");
        forcedFields.add("wrong-name");
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, this.document.toString()), fields, forcedFields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)("Expecting to find " + (fields.size() - 2) + " fields"), (int)(fields.size() - 2), (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition nameField = (PropertyFieldDefinition)fieldDefMap.get("cm:name");
        PropertyFieldDefinition titleField = (PropertyFieldDefinition)fieldDefMap.get("cm:title");
        PropertyFieldDefinition authorField = (PropertyFieldDefinition)fieldDefMap.get("cm:author");
        PropertyFieldDefinition neverField = (PropertyFieldDefinition)fieldDefMap.get("cm:never");
        PropertyFieldDefinition wrongField = (PropertyFieldDefinition)fieldDefMap.get("wrong-name");
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:name field", (Object)nameField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:title field", (Object)titleField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:author field", (Object)authorField);
        FormServiceImplTest.assertNull((String)"Expecting cm:never field to be missing", (Object)neverField);
        FormServiceImplTest.assertNull((String)"Expecting wrong-name field to be missing", (Object)wrongField);
        FormServiceImplTest.assertEquals((String)("Expecting cm:name label to be " + LABEL_NAME), (String)LABEL_NAME, (String)nameField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:title label to be " + LABEL_TITLE), (String)LABEL_TITLE, (String)titleField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:author label to be " + LABEL_AUTHOR), (String)LABEL_AUTHOR, (String)authorField.getLabel());
        FormData data = form.getFormData();
        FormServiceImplTest.assertNotNull((String)"Expecting form data", (Object)data);
        FormServiceImplTest.assertEquals((Object)this.documentName, (Object)data.getFieldData(nameField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)VALUE_TITLE, (Object)data.getFieldData(titleField.getDataKeyName()).getValue());
        FormServiceImplTest.assertNull((String)"Didn't expect to find a value for cm:author", (Object)data.getFieldData(authorField.getDataKeyName()));
    }

    @Test
    public void testGetAllFolderForm() throws Exception {
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, this.folder.toString()));
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        FormServiceImplTest.assertEquals((String)NODE_FORM_ITEM_KIND, (String)form.getItem().getKind());
        FormServiceImplTest.assertEquals((String)this.folder.toString(), (String)form.getItem().getId());
        FormServiceImplTest.assertEquals((String)ContentModel.TYPE_FOLDER.toPrefixString((NamespacePrefixResolver)this.namespaceService), (String)form.getItem().getType());
        FormServiceImplTest.assertNull((String)"Expecting the form groups to be null!", (Object)form.getFieldGroups());
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)"Wrong number of fields", (int)8, (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition nameField = (PropertyFieldDefinition)fieldDefMap.get("cm:name");
        AssociationFieldDefinition containsField = (AssociationFieldDefinition)fieldDefMap.get("cm:contains");
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:name field", (Object)nameField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:contains field", (Object)containsField);
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:node-dbid"));
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:store-identifier"));
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:node-uuid"));
        FormServiceImplTest.assertFalse((boolean)fieldDefMap.containsKey("sys:store-protocol"));
        FormServiceImplTest.assertEquals((String)("Expecting cm:name label to be " + LABEL_NAME), (String)LABEL_NAME, (String)nameField.getLabel());
        FormServiceImplTest.assertEquals((String)("Expecting cm:contains label to be " + LABEL_CONTAINS), (String)LABEL_CONTAINS, (String)containsField.getLabel());
        FormServiceImplTest.assertEquals((String)"Expecting cm:name type to be text", (String)"text", (String)nameField.getDataType());
        FormServiceImplTest.assertTrue((String)"Expecting cm:name to be mandatory", (boolean)nameField.isMandatory());
        FormServiceImplTest.assertFalse((String)"Expecting cm:name to be single valued", (boolean)nameField.isRepeating());
        FormServiceImplTest.assertEquals((String)"Expecting cm:contains endpoint type to be sys:base", (String)"sys:base", (String)containsField.getEndpointType());
        FormServiceImplTest.assertEquals((String)"Expecting cm:contains endpoint direction to be TARGET", (String)AssociationFieldDefinition.Direction.TARGET.toString(), (String)containsField.getEndpointDirection().toString());
        FormServiceImplTest.assertFalse((String)"Expecting cm:contains endpoint to be optional", (boolean)containsField.isEndpointMandatory());
        FormServiceImplTest.assertTrue((String)"Expecting cm:contains endpoint to be 1 to many", (boolean)containsField.isEndpointMany());
        FormData data = form.getFormData();
        FormServiceImplTest.assertNotNull((String)"Expecting form data", (Object)data);
        FormServiceImplTest.assertEquals((Object)this.folderName, (Object)data.getFieldData(nameField.getDataKeyName()).getValue());
        List children = (List)data.getFieldData(containsField.getDataKeyName()).getValue();
        FormServiceImplTest.assertEquals((String)"Expecting 3 children", (int)3, (int)children.size());
        FormServiceImplTest.assertEquals((String)this.document.toString(), (String)((String)children.get(0)));
        FormServiceImplTest.assertEquals((String)this.associatedDoc.toString(), (String)((String)children.get(1)));
        FormServiceImplTest.assertEquals((String)this.childDoc.toString(), (String)((String)children.get(2)));
    }

    @Test
    public void testSaveNodeForm() throws Exception {
        FormData data = new FormData();
        String newName = "new-" + this.documentName;
        data.addFieldData("prop_cm_name", (Object)newName);
        String newTitle = "This is the new title property";
        data.addFieldData("prop_cm_title", (Object)newTitle);
        String newMimetype = "text/html";
        data.addFieldData("prop_mimetype", (Object)newMimetype);
        String newAuthor = "Gavin Cornwell";
        data.addFieldData("prop_cm_author", (Object)newAuthor);
        String newOriginator = "jane@example.com";
        data.addFieldData("prop_cm_originator", (Object)newOriginator);
        String newAddressees = VALUE_ADDRESSEES1 + "," + VALUE_ADDRESSEES2 + "," + VALUE_ADDRESSEES3;
        data.addFieldData("prop_cm_addressees", (Object)newAddressees);
        data.addFieldData("prop_cm_sentdate", (Object)"");
        data.addFieldData("prop_cm_wrong", (Object)"This should not be persisted");
        data.addFieldData("cm_wrong", (Object)"This should not be persisted");
        data.addFieldData("prop_cm_wrong_property", (Object)"This should not be persisted");
        data.addFieldData("prop_cm_wrong_property_name", (Object)"This should not be persisted");
        data.addFieldData("assoc_cm_wrong_association", (Object)"This should be ignored");
        data.addFieldData("assoc_cm_wrong_association_added", (Object)"This should be ignored");
        data.addFieldData("assoc_cm_wrong_association_removed", (Object)"This should be ignored");
        data.addFieldData("assoc_cm_added", (Object)"This should be ignored");
        this.formService.saveForm(new Item(NODE_FORM_ITEM_KIND, this.document.toString()), data);
        Map updatedProps = this.nodeService.getProperties(this.document);
        String updatedName = (String)updatedProps.get(ContentModel.PROP_NAME);
        String updatedTitle = (String)updatedProps.get(ContentModel.PROP_TITLE);
        String updatedAuthor = (String)updatedProps.get(ContentModel.PROP_AUTHOR);
        String updatedOriginator = (String)updatedProps.get(ContentModel.PROP_ORIGINATOR);
        List updatedAddressees = (List)updatedProps.get(ContentModel.PROP_ADDRESSEES);
        String wrong = (String)updatedProps.get(QName.createQName((String)"cm", (String)"wrong", (NamespacePrefixResolver)this.namespaceService));
        Date sentDate = (Date)updatedProps.get(ContentModel.PROP_SENTDATE);
        FormServiceImplTest.assertEquals((String)newName, (String)updatedName);
        FormServiceImplTest.assertEquals((String)newTitle, (String)updatedTitle);
        FormServiceImplTest.assertEquals((String)newAuthor, (String)updatedAuthor);
        FormServiceImplTest.assertEquals((String)newOriginator, (String)updatedOriginator);
        FormServiceImplTest.assertNull((String)"Expecting sentdate to be null", (Object)sentDate);
        FormServiceImplTest.assertNull((String)"Expecting my:wrong to be null", (Object)wrong);
        FormServiceImplTest.assertNotNull((String)"Expected there to be addressees", (Object)updatedAddressees);
        FormServiceImplTest.assertTrue((String)"Expected there to be 3 addressees", (updatedAddressees.size() == 3 ? 1 : 0) != 0);
        FormServiceImplTest.assertEquals((String)VALUE_ADDRESSEES1, (String)((String)updatedAddressees.get(0)));
        FormServiceImplTest.assertEquals((String)VALUE_ADDRESSEES2, (String)((String)updatedAddressees.get(1)));
        FormServiceImplTest.assertEquals((String)VALUE_ADDRESSEES3, (String)((String)updatedAddressees.get(2)));
        FormServiceImplTest.assertTrue((String)"Expecting the cm:titled to have been applied", (boolean)this.nodeService.hasAspect(this.document, ContentModel.ASPECT_TITLED));
        FormServiceImplTest.assertTrue((String)"Expecting the cm:author to have been applied", (boolean)this.nodeService.hasAspect(this.document, ContentModel.ASPECT_AUTHOR));
        ContentData contentData = (ContentData)updatedProps.get(ContentModel.PROP_CONTENT);
        if (contentData != null) {
            String updatedMimetype = contentData.getMimetype();
            FormServiceImplTest.assertEquals((String)"text/html", (String)updatedMimetype);
        }
    }

    @Test
    public void testGetAllCreateForm() throws Exception {
        Form form = this.formService.getForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"));
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        FormServiceImplTest.assertEquals((String)TYPE_FORM_ITEM_KIND, (String)form.getItem().getKind());
        FormServiceImplTest.assertEquals((String)"cm:content", (String)form.getItem().getId());
        FormServiceImplTest.assertEquals((String)ContentModel.TYPE_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespaceService), (String)form.getItem().getType());
        FormServiceImplTest.assertNull((String)"Expecting the form groups to be null!", (Object)form.getFieldGroups());
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)"Wrong number of fields", (int)8, (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition nameField = (PropertyFieldDefinition)fieldDefMap.get("cm:name");
        PropertyFieldDefinition createdField = (PropertyFieldDefinition)fieldDefMap.get("cm:created");
        PropertyFieldDefinition creatorField = (PropertyFieldDefinition)fieldDefMap.get("cm:creator");
        PropertyFieldDefinition modifiedField = (PropertyFieldDefinition)fieldDefMap.get("cm:modified");
        PropertyFieldDefinition modifierField = (PropertyFieldDefinition)fieldDefMap.get("cm:modifier");
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:name field", (Object)nameField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:created field", (Object)createdField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:creator field", (Object)creatorField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:modified field", (Object)modifiedField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:modifier field", (Object)modifierField);
    }

    @Test
    public void testGetSelectedFieldsCreateForm() throws Exception {
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add("cm:name");
        fields.add("cm:title");
        Form form = this.formService.getForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"), fields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        FormServiceImplTest.assertEquals((String)TYPE_FORM_ITEM_KIND, (String)form.getItem().getKind());
        FormServiceImplTest.assertEquals((String)"cm:content", (String)form.getItem().getId());
        FormServiceImplTest.assertEquals((String)ContentModel.TYPE_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespaceService), (String)form.getItem().getType());
        FormServiceImplTest.assertNull((String)"Expecting the form groups to be null!", (Object)form.getFieldGroups());
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)"Expecting to find 1 field", (int)1, (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition nameField = (PropertyFieldDefinition)fieldDefMap.get("cm:name");
        FormServiceImplTest.assertNotNull((String)"Expecting to find the cm:name field", (Object)nameField);
        ArrayList<String> forcedFields = new ArrayList<String>(2);
        forcedFields.add("cm:title");
        form = this.formService.getForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"), fields, forcedFields);
        fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)"Expecting to find 2 fields", (int)2, (int)fieldDefs.size());
    }

    @Test
    public void testSaveTypeForm() throws Exception {
        FormData data = new FormData();
        String name = "new-" + this.documentName;
        data.addFieldData("prop_cm_name", (Object)name);
        String title = "This is the title property";
        data.addFieldData("prop_cm_title", (Object)title);
        try {
            this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"), data);
            FormServiceImplTest.fail((String)"Expected the persist to fail as there was no destination");
        }
        catch (FormException formException) {}
        data.addFieldData("alf_destination", (Object)this.folder.toString());
        NodeRef newNode = (NodeRef)this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"), data);
        Map props = this.nodeService.getProperties(newNode);
        String newName = (String)props.get(ContentModel.PROP_NAME);
        String newTitle = (String)props.get(ContentModel.PROP_TITLE);
        FormServiceImplTest.assertEquals((String)name, (String)newName);
        FormServiceImplTest.assertEquals((String)title, (String)newTitle);
        FormServiceImplTest.assertTrue((String)"Expecting the cm:titled to have been applied", (boolean)this.nodeService.hasAspect(this.document, ContentModel.ASPECT_TITLED));
        data.addFieldData("alf_destination", (Object)this.folder.toString());
        newNode = (NodeRef)this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"), data);
        FormServiceImplTest.assertNotNull((String)"Expected new node to be created using itemId cm_content", (Object)newNode);
        data.addFieldData("alf_destination", (Object)this.folder.toString());
        newNode = (NodeRef)this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, ContentModel.TYPE_CONTENT.toString()), data);
        FormServiceImplTest.assertNotNull((String)("Expected new node to be created using itemId " + ContentModel.TYPE_CONTENT.toString()), (Object)newNode);
    }

    @Test
    public void testContentForms() throws Exception {
        String name = "created-" + this.documentName;
        String title = "This is the title property";
        String mimetype = "text/html";
        String content = "This is the content.";
        FormData data = this.createContentFormData(name, title, mimetype, content);
        data.addFieldData("alf_destination", (Object)this.folder.toString());
        NodeRef newNode = (NodeRef)this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"), data);
        this.checkContentDetails(newNode, name, title, mimetype, content);
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add("cm:name");
        fields.add("cm:content");
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, newNode.toString()), fields);
        FormServiceImplTest.assertNotNull((Object)form);
        FormServiceImplTest.assertEquals((String)name, (String)form.getFormData().getFieldData("prop_cm_name").getValue().toString());
        String contentUrl = form.getFormData().getFieldData("prop_cm_content").getValue().toString();
        FormServiceImplTest.assertTrue((String)"Expected content url to contain mimetype", (contentUrl.indexOf("mimetype=") != -1 ? 1 : 0) != 0);
        FormServiceImplTest.assertTrue((String)"Expected content url to contain encoding", (contentUrl.indexOf("encoding=") != -1 ? 1 : 0) != 0);
        FormServiceImplTest.assertTrue((String)"Expected content url to contain size", (contentUrl.indexOf("size=") != -1 ? 1 : 0) != 0);
        String name2 = "created2-" + this.documentName;
        data = this.createContentFormData(name2, title, null, content);
        data.addFieldData("alf_destination", (Object)this.folder.toString());
        NodeRef newNode2 = (NodeRef)this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "cm:content"), data);
        this.checkContentDetails(newNode2, name2, title, "text/plain", content);
        Item item = new Item(NODE_FORM_ITEM_KIND, newNode.toString());
        String updatedContent = "This is the updated content";
        String updatedMimetype = "text/plain";
        data = this.createContentFormData(name, title, updatedMimetype, updatedContent);
        this.formService.saveForm(item, data);
        this.checkContentDetails(newNode, name, title, updatedMimetype, updatedContent);
        updatedContent = "<element>The content is now XML</content>";
        updatedMimetype = "text/xml";
        data = this.createContentFormData(name, title, updatedMimetype, updatedContent);
        data.removeFieldData("prop_cm_content");
        data.addFieldData("prop_cm_content", (Object)updatedContent);
        this.formService.saveForm(item, data);
        this.checkContentDetails(newNode, name, title, updatedMimetype, updatedContent);
        updatedContent = "<element attribute=\"true\">The content is still XML</content>";
        data = this.createContentFormData(null, null, null, updatedContent);
        this.formService.saveForm(item, data);
        this.checkContentDetails(newNode, name, title, updatedMimetype, updatedContent);
    }

    private FormData createContentFormData(String name, String title, String mimetype, String content) {
        FormData data = new FormData();
        if (name != null) {
            data.addFieldData("prop_cm_name", (Object)name);
        }
        if (title != null) {
            data.addFieldData("prop_cm_title", (Object)title);
        }
        if (content != null) {
            data.addFieldData("prop_cm_content", (Object)content);
        }
        if (mimetype != null) {
            data.addFieldData("prop_mimetype", (Object)mimetype);
        }
        return data;
    }

    private void checkContentDetails(NodeRef node, String expectedName, String expectedTitle, String expectedMimetype, String expectedContent) {
        Map props = this.nodeService.getProperties(node);
        String name = (String)props.get(ContentModel.PROP_NAME);
        String title = (String)props.get(ContentModel.PROP_TITLE);
        FormServiceImplTest.assertEquals((String)expectedName, (String)name);
        FormServiceImplTest.assertEquals((String)expectedTitle, (String)title);
        ContentData contentData = (ContentData)this.nodeService.getProperty(node, ContentModel.PROP_CONTENT);
        FormServiceImplTest.assertNotNull((Object)contentData);
        String mimetype = contentData.getMimetype();
        FormServiceImplTest.assertEquals((String)expectedMimetype, (String)mimetype);
        ContentReader reader = this.contentService.getReader(node, ContentModel.PROP_CONTENT);
        FormServiceImplTest.assertNotNull((Object)reader);
        String content = reader.getContentString();
        FormServiceImplTest.assertEquals((String)expectedContent, (String)content);
    }

    public void disabledTestFDKModel() throws Exception {
        DictionaryService dictionary = (DictionaryService)this.applicationContext.getBean("DictionaryService");
        try {
            dictionary.getType(QName.createQName((String)"fdk", (String)"everything", (NamespacePrefixResolver)this.namespaceService));
        }
        catch (NamespaceException namespaceException) {
            FormServiceImplTest.fail((String)"FDK namespace is missing, ensure you've made the 'Forms Development Kit' project a dependency of the 'Repository' project when enabling this test!");
        }
        String fdkUri = "http://www.alfresco.org/model/fdk/1.0";
        QName everythingType = QName.createQName((String)fdkUri, (String)"everything");
        QName textProperty = QName.createQName((String)fdkUri, (String)"text");
        QName underscoreProperty = QName.createQName((String)fdkUri, (String)"with_underscore");
        QName dashProperty = QName.createQName((String)fdkUri, (String)"with-dash");
        QName duplicateProperty = QName.createQName((String)fdkUri, (String)"duplicate");
        QName periodProperty = QName.createQName((String)fdkUri, (String)"period");
        String guid = GUID.generate();
        String name = "everything" + guid + ".txt";
        String textValue = "This is some text.";
        String underscoreValue = "Property with an underscore in the name.";
        String dashValue = "Property with a dash in the name.";
        String duplicateValue = "Property with the same name as an association.";
        String periodValue = "day|1";
        HashMap<QName, Object> docProps = new HashMap<QName, Object>(4);
        docProps.put(ContentModel.PROP_NAME, name);
        docProps.put(textProperty, textValue);
        docProps.put(underscoreProperty, underscoreValue);
        docProps.put(dashProperty, dashValue);
        docProps.put(duplicateProperty, duplicateValue);
        docProps.put(periodProperty, periodValue);
        NodeRef everythingNode = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), everythingType, docProps).getChildRef();
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add("cm:name");
        fields.add("fdk:text");
        fields.add("fdk:with_underscore");
        fields.add("fdk:with-dash");
        fields.add("prop:fdk:duplicate");
        fields.add("assoc:fdk:duplicate");
        fields.add("fdk:period");
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, everythingNode.toString()), fields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        FormServiceImplTest.assertEquals((String)"fdk:everything", (String)form.getItem().getType());
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)("Expecting to find " + fields.size() + " fields"), (int)fields.size(), (int)fieldDefs.size());
        PropertyFieldDefinition nameField = null;
        PropertyFieldDefinition textField = null;
        PropertyFieldDefinition underscoreField = null;
        PropertyFieldDefinition dashField = null;
        PropertyFieldDefinition periodField = null;
        PropertyFieldDefinition duplicatePropField = null;
        AssociationFieldDefinition duplicateAssocField = null;
        for (FieldDefinition field : fieldDefs) {
            if (field.getName().equals("cm:name")) {
                nameField = (PropertyFieldDefinition)field;
                continue;
            }
            if (field.getName().equals("fdk:text")) {
                textField = (PropertyFieldDefinition)field;
                continue;
            }
            if (field.getName().equals("fdk:with_underscore")) {
                underscoreField = (PropertyFieldDefinition)field;
                continue;
            }
            if (field.getName().equals("fdk:with-dash")) {
                dashField = (PropertyFieldDefinition)field;
                continue;
            }
            if (field.getName().equals("fdk:duplicate")) {
                if (field instanceof PropertyFieldDefinition) {
                    duplicatePropField = (PropertyFieldDefinition)field;
                    continue;
                }
                if (!(field instanceof AssociationFieldDefinition)) continue;
                duplicateAssocField = (AssociationFieldDefinition)field;
                continue;
            }
            if (!field.getName().equals("fdk:period")) continue;
            periodField = (PropertyFieldDefinition)field;
        }
        FormServiceImplTest.assertNotNull((String)"Expected to find nameField", nameField);
        FormServiceImplTest.assertNotNull((String)"Expected to find textField", textField);
        FormServiceImplTest.assertNotNull((String)"Expected to find underscoreField", underscoreField);
        FormServiceImplTest.assertNotNull((String)"Expected to find dashField", dashField);
        FormServiceImplTest.assertNotNull((String)"Expected to find periodField", periodField);
        FormServiceImplTest.assertNotNull((String)"Expected to find duplicatePropField", duplicatePropField);
        FormServiceImplTest.assertNotNull((String)"Expected to find duplicateAssocField", duplicateAssocField);
        FormData values = form.getFormData();
        FormServiceImplTest.assertEquals((Object)name, (Object)values.getFieldData(nameField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)textValue, (Object)values.getFieldData(textField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)underscoreValue, (Object)values.getFieldData(underscoreField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((Object)dashValue, (Object)values.getFieldData(dashField.getDataKeyName()).getValue());
        FormServiceImplTest.assertEquals((String)periodValue, (String)values.getFieldData(periodField.getDataKeyName()).getValue().toString());
        FormServiceImplTest.assertEquals((Object)duplicateValue, (Object)values.getFieldData(duplicatePropField.getDataKeyName()).getValue());
        FormData.FieldData fieldData = values.getFieldData(duplicateAssocField.getDataKeyName());
        FormServiceImplTest.assertNotNull((Object)fieldData);
        List assocs = (List)fieldData.getValue();
        FormServiceImplTest.assertNotNull((Object)assocs);
        FormServiceImplTest.assertEquals((int)0, (int)assocs.size());
        DataTypeParameters dtp = periodField.getDataTypeParameters();
        FormServiceImplTest.assertNotNull((String)"Expected to find data type parameters for the fdk:period field", (Object)dtp);
        FormData data = new FormData();
        String newText = "This is the new text property";
        data.addFieldData(textField.getDataKeyName(), (Object)newText);
        String newUnderscore = "This is the new value for the underscore property.";
        data.addFieldData(underscoreField.getDataKeyName(), (Object)newUnderscore);
        String newDash = "This is the new value for the dash property.";
        data.addFieldData(dashField.getDataKeyName(), (Object)newDash);
        String newDuplicateProp = "This is the new value for the duplicate property.";
        data.addFieldData(duplicatePropField.getDataKeyName(), (Object)newDuplicateProp);
        data.addFieldData(duplicateAssocField.getDataKeyName() + "_added", (Object)this.document.toString());
        this.formService.saveForm(new Item(NODE_FORM_ITEM_KIND, everythingNode.toString()), data);
        Map updatedProps = this.nodeService.getProperties(everythingNode);
        String updatedText = (String)updatedProps.get(textProperty);
        String updatedUnderscore = (String)updatedProps.get(underscoreProperty);
        String updatedDash = (String)updatedProps.get(dashProperty);
        String updatedDuplicate = (String)updatedProps.get(duplicateProperty);
        FormServiceImplTest.assertEquals((String)newText, (String)updatedText);
        FormServiceImplTest.assertEquals((String)newUnderscore, (String)updatedUnderscore);
        FormServiceImplTest.assertEquals((String)newDash, (String)updatedDash);
        FormServiceImplTest.assertEquals((String)newDuplicateProp, (String)updatedDuplicate);
        assocs = this.nodeService.getTargetAssocs(everythingNode, (QNamePattern)duplicateProperty);
        FormServiceImplTest.assertEquals((int)1, (int)assocs.size());
        fields = new ArrayList(1);
        fields.add("cm:name");
        form = this.formService.getForm(new Item(TYPE_FORM_ITEM_KIND, "fdk:with_underscore"), fields);
        FormServiceImplTest.assertNotNull((Object)form);
        fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((Object)fieldDefs);
        FormServiceImplTest.assertEquals((int)1, (int)fieldDefs.size());
        String nodeName = GUID.generate() + ".txt";
        data = new FormData();
        data.addFieldData("prop_cm_name", (Object)nodeName);
        data.addFieldData("alf_destination", (Object)this.folder.toString());
        NodeRef newNode = (NodeRef)this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "fdk:with_underscore"), data);
        FormServiceImplTest.assertNotNull((Object)newNode);
        fields = new ArrayList(2);
        fields.add("cm:name");
        fields.add("my-fdk:more_text");
        form = this.formService.getForm(new Item(TYPE_FORM_ITEM_KIND, "my-fdk:namespace-with-dash"), fields);
        FormServiceImplTest.assertNotNull((Object)form);
        fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((Object)fieldDefs);
        FormServiceImplTest.assertEquals((int)2, (int)fieldDefs.size());
        nodeName = GUID.generate() + ".txt";
        data = new FormData();
        data.addFieldData("prop_cm_name", (Object)nodeName);
        data.addFieldData("prop_my-fdk_more_text", (Object)"This is some text");
        data.addFieldData("alf_destination", (Object)this.folder.toString());
        newNode = (NodeRef)this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "my-fdk_namespace-with-dash"), data);
        FormServiceImplTest.assertNotNull((Object)newNode);
        Map props = this.nodeService.getProperties(newNode);
        FormServiceImplTest.assertEquals((String)nodeName, (String)((String)props.get(ContentModel.PROP_NAME)));
        FormServiceImplTest.assertEquals((String)"This is some text", (String)((String)props.get(QName.createQName((String)"http://www.alfresco.org/model/my-fdk/1.0", (String)"more_text"))));
    }

    @Test
    public void testGetFormForActivitiTask() throws Exception {
        this.checkGetFormForTask("activiti$activitiReview");
    }

    private void checkGetFormForTask(String defName) {
        WorkflowTask task = this.getWorkflowTask(defName);
        Item item = new Item(TASK_FORM_ITEM_KIND, task.getId());
        Form form = this.formService.getForm(item);
        FormServiceImplTest.assertNotNull((Object)form);
        FormServiceImplTest.assertEquals((String)item.getKind(), (String)form.getItem().getKind());
        FormServiceImplTest.assertEquals((String)item.getId(), (String)form.getItem().getId());
        List fieldDefNames = form.getFieldDefinitionNames();
        FormServiceImplTest.assertTrue((fieldDefNames.size() > 0 ? 1 : 0) != 0);
        List<String> expFields = this.getExpectedTaskFields();
        FormServiceImplTest.assertTrue((boolean)fieldDefNames.containsAll(expFields));
        List definitions = form.getFieldDefinitions();
        String priorityName = WorkflowModel.PROP_PRIORITY.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        for (FieldDefinition definition : definitions) {
            if (!priorityName.equals(definition.getName())) continue;
            FormServiceImplTest.assertEquals((String)"2", (String)definition.getDefaultValue());
            break;
        }
    }

    @Test
    public void testSaveActivitiTask() throws Exception {
        this.checkSaveTask("activiti$activitiReview");
    }

    private void checkSaveTask(String defName) {
        WorkflowTask task = this.getWorkflowTask(defName);
        QName descName = WorkflowModel.PROP_DESCRIPTION;
        Serializable initialDesc = (Serializable)task.getProperties().get(descName);
        String testDesc = "Foo-Bar-Test-String";
        FormServiceImplTest.assertFalse((boolean)testDesc.equals(initialDesc));
        Item item = new Item(TASK_FORM_ITEM_KIND, task.getId());
        FormData data = new FormData();
        String descFieldName = "prop_" + descName.toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(":", "_");
        data.addFieldData(descFieldName, (Object)testDesc, true);
        this.formService.saveForm(item, data);
        WorkflowTask newTask = this.workflowService.getTaskById(task.getId());
        FormServiceImplTest.assertEquals((Object)testDesc, newTask.getProperties().get(descName));
    }

    @Test
    public void testTransitionActivitiTask() throws Exception {
        this.checkTransitionTask("activiti$activitiReview", "Next", "Approve");
    }

    private void checkTransitionTask(String defName, String transitionId, String expOutcome) {
        WorkflowTask task = this.getWorkflowTask(defName);
        QName descName = WorkflowModel.PROP_DESCRIPTION;
        Serializable initialDesc = (Serializable)task.getProperties().get(descName);
        String testDesc = "Foo-Bar-Test-String";
        FormServiceImplTest.assertFalse((boolean)testDesc.equals(initialDesc));
        Item item = new Item(TASK_FORM_ITEM_KIND, task.getId());
        FormData data = new FormData();
        String descFieldName = "prop_" + descName.toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(":", "_");
        data.addFieldData(descFieldName, (Object)testDesc, true);
        String reviewOutcomeFieldName = "prop_wf_reviewOutcome";
        data.addFieldData(reviewOutcomeFieldName, (Object)"Approve", true);
        String transitionDataKey = "prop_transitions";
        data.addFieldData(transitionDataKey, (Object)transitionId);
        this.formService.saveForm(item, data);
        WorkflowTask newTask = this.workflowService.getTaskById(task.getId());
        FormServiceImplTest.assertEquals((String)"The description should have been updated!", (Object)testDesc, newTask.getProperties().get(descName));
        FormServiceImplTest.assertEquals((String)"The task should have been completed!", (Object)WorkflowTaskState.COMPLETED, (Object)newTask.getState());
        Serializable outcome = (Serializable)newTask.getProperties().get(WorkflowModel.PROP_OUTCOME);
        FormServiceImplTest.assertEquals((String)"The transition is wrong!", (Object)expOutcome, (Object)outcome);
    }

    private WorkflowTask getWorkflowTask(String definitionName) {
        WorkflowDefinition reviewDef = this.workflowService.getDefinitionByName(definitionName);
        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
        properties.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER_ONE));
        properties.put(WorkflowModel.ASSOC_PACKAGE, this.folder);
        WorkflowPath path = this.workflowService.startWorkflow(reviewDef.getId(), properties);
        WorkflowTask task = this.getTaskForPath(path);
        String startTaskId = reviewDef.getStartTaskDefinition().getId();
        if (startTaskId.equals(task.getDefinition().getId())) {
            this.workflowService.endTask(task.getId(), null);
            task = this.getTaskForPath(path);
        }
        return task;
    }

    private WorkflowTask getTaskForPath(WorkflowPath path) {
        List tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        FormServiceImplTest.assertNotNull((Object)tasks);
        FormServiceImplTest.assertTrue((tasks.size() > 0 ? 1 : 0) != 0);
        WorkflowTask task = (WorkflowTask)tasks.get(0);
        return task;
    }

    private List<String> getExpectedTaskFields() {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add(WorkflowModel.PROP_DESCRIPTION.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        fields.add(WorkflowModel.PROP_STATUS.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        fields.add(WorkflowModel.PROP_PRIORITY.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        fields.add(WorkflowModel.PROP_COMMENT.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        fields.add(WorkflowModel.PROP_DUE_DATE.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        return fields;
    }

    @Test
    public void testActivitiWorkflowForm() throws Exception {
        this.checkWorkflowForms("activiti$activitiAdhoc", "Next|Task Done");
    }

    private void checkWorkflowForms(String workflowDefName, String transitionLabels) throws Exception {
        ArrayList<String> fields = new ArrayList<String>(8);
        String taskIdName = WorkflowModel.PROP_TASK_ID.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String workflowDescName = WorkflowModel.PROP_WORKFLOW_DESCRIPTION.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String workflowDueDateName = WorkflowModel.PROP_WORKFLOW_DUE_DATE.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String packageItemsName = "packageItems";
        fields.add(taskIdName);
        fields.add(workflowDescName);
        fields.add(workflowDueDateName);
        fields.add(packageItemsName);
        Form form = this.formService.getForm(new Item(WORKFLOW_FORM_ITEM_KIND, workflowDefName), fields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        FormServiceImplTest.assertEquals((String)WORKFLOW_FORM_ITEM_KIND, (String)form.getItem().getKind());
        FormServiceImplTest.assertEquals((String)workflowDefName, (String)form.getItem().getId());
        List fieldDefs = form.getFieldDefinitions();
        FormServiceImplTest.assertNotNull((String)"Expecting to find fields", (Object)fieldDefs);
        FormServiceImplTest.assertEquals((String)("Expecting to find " + fields.size() + " fields"), (int)fields.size(), (int)fieldDefs.size());
        HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
        for (FieldDefinition fieldDef : fieldDefs) {
            fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
        PropertyFieldDefinition idField = (PropertyFieldDefinition)fieldDefMap.get(taskIdName);
        PropertyFieldDefinition descriptionField = (PropertyFieldDefinition)fieldDefMap.get(workflowDescName);
        PropertyFieldDefinition dueDateField = (PropertyFieldDefinition)fieldDefMap.get(workflowDueDateName);
        AssociationFieldDefinition packageItemsField = (AssociationFieldDefinition)fieldDefMap.get(packageItemsName);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the bpm:taskId field", (Object)idField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the bpm:workflowDescription field", (Object)descriptionField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the bpm:workflowDueDate field", (Object)dueDateField);
        FormServiceImplTest.assertNotNull((String)"Expecting to find the packageItems field", (Object)packageItemsField);
        List tasks = this.workflowService.getAssignedTasks(USER_ONE, WorkflowTaskState.IN_PROGRESS);
        int tasksBefore = tasks.size();
        FormData data = new FormData();
        data.addFieldData("prop_bpm_workflowDescription", (Object)"This is a new adhoc task");
        data.addFieldData("assoc_bpm_assignee_added", (Object)this.personManager.get(USER_ONE).toString());
        data.addFieldData("assoc_packageItems_added", (Object)this.document.toString());
        WorkflowInstance workflow = (WorkflowInstance)this.formService.saveForm(new Item(WORKFLOW_FORM_ITEM_KIND, workflowDefName), data);
        tasks = this.workflowService.getAssignedTasks(USER_ONE, WorkflowTaskState.IN_PROGRESS);
        int tasksAfter = tasks.size();
        FormServiceImplTest.assertTrue((String)"Expecting there to be more tasks", (tasksAfter > tasksBefore ? 1 : 0) != 0);
        FormServiceImplTest.assertEquals((String)workflowDefName, (String)workflow.getDefinition().getName());
        String taskId = ((WorkflowTask)tasks.get(0)).getId();
        fields.clear();
        fields.add(taskIdName);
        fields.add("transitions");
        fields.add("message");
        fields.add("taskOwner");
        fields.add(packageItemsName);
        form = this.formService.getForm(new Item(TASK_FORM_ITEM_KIND, taskId), fields);
        FormData taskData = form.getFormData();
        FormServiceImplTest.assertEquals((String)taskId.substring(taskId.indexOf(36) + 1), (String)taskData.getFieldData("prop_bpm_taskId").getValue().toString());
        FormServiceImplTest.assertEquals((Object)transitionLabels, (Object)taskData.getFieldData("prop_transitions").getValue());
        String expOwner = "UserOne_FormServiceImplTest|" + this.personManager.getFirstName(USER_ONE) + "|" + this.personManager.getLastName(USER_ONE);
        FormServiceImplTest.assertEquals((Object)expOwner, (Object)taskData.getFieldData("prop_taskOwner").getValue());
        FormServiceImplTest.assertEquals((Object)"This is a new adhoc task", (Object)taskData.getFieldData("prop_message").getValue());
        FormServiceImplTest.assertNotNull((Object)taskData.getFieldData("assoc_packageItems").getValue());
        String comment = "This is a comment";
        data = new FormData();
        data.addFieldData("prop_bpm_comment", (Object)comment);
        this.formService.saveForm(new Item(TASK_FORM_ITEM_KIND, taskId), data);
        WorkflowTask task = this.workflowService.getTaskById(taskId);
        String taskComment = (String)task.getProperties().get(WorkflowModel.PROP_COMMENT);
        FormServiceImplTest.assertEquals((String)comment, (String)taskComment);
        this.personManager.setUser(USER_TWO);
        try {
            this.formService.saveForm(new Item(TASK_FORM_ITEM_KIND, taskId), data);
            FormServiceImplTest.fail((String)"Task was updated by an unauthorized user");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    @Test
    public void testNoForm() throws Exception {
        FormData data;
        try {
            this.formService.getForm(new Item("Invalid Kind", "Invalid Id"));
            FormServiceImplTest.fail((String)"Expecting getForm for 'Invalid Kind/Item' to fail");
        }
        catch (Exception exception) {}
        String missingNode = this.document.toString().replace("-", "x");
        try {
            this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, missingNode));
            FormServiceImplTest.fail((String)"Expecting getForm for a missing node to fail");
        }
        catch (FormNotFoundException formNotFoundException) {}
        try {
            this.formService.saveForm(new Item("Invalid Kind", "Invalid Id"), new FormData());
            FormServiceImplTest.fail((String)"Expecting saveForm for 'Invalid Kind/Item' to fail");
        }
        catch (Exception exception) {}
        try {
            this.formService.saveForm(new Item(NODE_FORM_ITEM_KIND, missingNode), new FormData());
            FormServiceImplTest.fail((String)"Expecting saveForm for a missing node to fail");
        }
        catch (Exception exception) {}
        try {
            data = new FormData();
            data.addFieldData("alf_destination", (Object)this.folder.toString());
            this.formService.saveForm(new Item(TYPE_FORM_ITEM_KIND, "cm_content"), data);
            FormServiceImplTest.fail((String)"Expecting saveForm for a 'type' item kind containing an underscore to fail");
        }
        catch (Exception exception) {}
        try {
            data = new FormData();
            data.addFieldData("prop_bpm_workflowDescription", (Object)"This is a new adhoc task");
            data.addFieldData("assoc_bpm_assignee_added", (Object)this.personManager.get(USER_ONE).toString());
            data.addFieldData("assoc_packageItems_added", (Object)this.document.toString());
            this.formService.saveForm(new Item(WORKFLOW_FORM_ITEM_KIND, "activiti$activiti_Adhoc"), data);
            FormServiceImplTest.fail((String)"Expecting saveForm for a 'workflow' item kind containing an underscore to fail");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testFormData() throws Exception {
        FormData formData = new FormData();
        formData.addFieldData("singleValue", (Object)"one");
        FormServiceImplTest.assertEquals((String)"Expecting value of 'one'", (Object)"one", (Object)formData.getFieldData("singleValue").getValue());
        formData.addFieldData("multipleValues", (Object)"one");
        Object value = formData.getFieldData("multipleValues").getValue();
        FormServiceImplTest.assertTrue((String)"Expecting 'multipleValues' to be a String object", (boolean)(value instanceof String));
        formData.addFieldData("multipleValues", (Object)"two");
        value = formData.getFieldData("multipleValues").getValue();
        FormServiceImplTest.assertTrue((String)"Expecting 'multipleValues' to be a List object", (boolean)(value instanceof List));
        formData.addFieldData("multipleValues", (Object)"three");
        List list = (List)formData.getFieldData("multipleValues").getValue();
        FormServiceImplTest.assertEquals((String)"Expecting 'multipleValues' List to have 3 items", (int)3, (int)list.size());
        formData.addFieldData("listValue", new ArrayList());
        formData.addFieldData("listValue", (Object)"one");
        formData.addFieldData("listValue", (Object)"two");
        list = (List)formData.getFieldData("listValue").getValue();
        FormServiceImplTest.assertEquals((String)"Expecting 'listValue' List to have 2 items", (int)2, (int)list.size());
        formData.addFieldData("overwritten", (Object)"one", true);
        formData.addFieldData("overwritten", (Object)"two", true);
        formData.addFieldData("overwritten", (Object)"three", true);
        value = formData.getFieldData("overwritten").getValue();
        FormServiceImplTest.assertTrue((String)"Expecting 'overwritten' to be a String object", (boolean)(value instanceof String));
        FormServiceImplTest.assertEquals((String)"Expecting 'overwritten' value to be 'three'", (Object)"three", (Object)value);
    }

    @Test
    public void testFormContext() throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>(2);
        context.put("nodeRef", this.folder);
        context.put("name", "Gavin Cornwell");
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, this.document.toString()), context);
        FormServiceImplTest.assertNotNull((Object)form);
    }

    @Test
    public void testNonContentNode() throws Exception {
        HashMap<QName, CallSite> nodeProps = new HashMap<QName, CallSite>(1);
        String nodeName = "testNode" + GUID.generate();
        nodeProps.put(ContentModel.PROP_NAME, (CallSite)((Object)nodeName));
        NodeRef node = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), ContentModel.TYPE_CMOBJECT, nodeProps).getChildRef();
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add("cm:name");
        fields.add("cm:creator");
        fields.add("cm:created");
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, node.toString()), fields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        List fieldNames = form.getFieldDefinitionNames();
        FormServiceImplTest.assertEquals((int)3, (int)fieldNames.size());
        FormData data = new FormData();
        String newName = "new-" + nodeName;
        data.addFieldData("prop_cm_name", (Object)newName);
        this.formService.saveForm(new Item(NODE_FORM_ITEM_KIND, node.toString()), data);
        Map updatedProps = this.nodeService.getProperties(node);
        String updatedName = (String)updatedProps.get(ContentModel.PROP_NAME);
        FormServiceImplTest.assertEquals((String)newName, (String)updatedName);
    }

    @Test
    public void testMNT_10969() throws Exception {
        HashMap<QName, CallSite> nodeProps = new HashMap<QName, CallSite>(1);
        String nodeName = "testNode" + GUID.generate();
        nodeProps.put(ContentModel.PROP_NAME, (CallSite)((Object)nodeName));
        NodeRef node = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), ContentModel.TYPE_CONTENT, nodeProps).getChildRef();
        this.nodeService.addAspect(node, ContentModel.ASPECT_WEBDAV_OBJECT, null);
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add(ContentModel.PROP_DEAD_PROPERTIES.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        Form form = this.formService.getForm(new Item(NODE_FORM_ITEM_KIND, node.toString()), fields);
        FormServiceImplTest.assertNotNull((String)"Expecting form to be present", (Object)form);
        List fieldNames = form.getFieldDefinitionNames();
        FormServiceImplTest.assertEquals((int)1, (int)fieldNames.size());
        FormData data = new FormData();
        String value = ",titi,toto,";
        data.addFieldData("prop_webdav_deadproperties", (Object)value);
        this.formService.saveForm(new Item(NODE_FORM_ITEM_KIND, node.toString()), data);
        Map updatedProps = this.nodeService.getProperties(node);
        List savedValue = (List)updatedProps.get(ContentModel.PROP_DEAD_PROPERTIES);
        FormServiceImplTest.assertEquals(Arrays.asList("", "titi", "toto", ""), (Object)savedValue);
    }

    @Test
    public void testJavascriptAPI() throws Exception {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("testDoc", this.document.toString());
        model.put("testDocName", this.documentName);
        model.put("testAssociatedDoc", this.associatedDoc.toString());
        model.put("folder", this.folder.toString());
        model.put("folderName", this.folderName);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/forms/script/test_formService.js");
        this.scriptService.executeScript((ScriptLocation)location, model);
    }
}

