/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.util.Collections;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentRestoreParams;
import org.alfresco.repo.content.ContentServiceImpl;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.repo.content.directurl.SystemWideDirectUrlConfig;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class ContentServiceImplUnitTest {
    private static final Boolean ENABLED = Boolean.TRUE;
    private static final Boolean DISABLED = Boolean.FALSE;
    private static final Long SYS_DEFAULT_EXPIRY_TIME_IN_SECS = 30L;
    private static final Long SYS_MAX_EXPIRY_TIME_IN_SECS = 300L;
    private static final NodeRef NODE_REF = new NodeRef("content://Node/Ref");
    public static final String SOME_CONTENT_URL = "someContentUrl";
    private static final NodeRef NODE_REF_2 = new NodeRef("content://Node/Ref2");
    public static final String SOME_FILE_NAME = "someFilename";
    private static final String X_AMZ_HEADER_1 = "x-amz-header1";
    private static final String VALUE_1 = "value1";
    private static final String X_AMZ_HEADER_2 = "x-amz-header-2";
    private static final String VALUE_2 = "value2";
    private static final QName PROP_CONTENT_QNAME = ContentModel.PROP_CONTENT;
    @InjectMocks
    private ContentServiceImpl contentService;
    @Mock
    private ContentStore mockContentStore;
    @Mock
    private NodeService mockNodeService;
    @Mock
    private ContentData mockContentData;
    @Mock
    private DictionaryService mockDictionaryService;

    @Before
    public void setup() {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.mockNodeService.getProperty(NODE_REF, ContentModel.PROP_CONTENT)).thenReturn((Object)this.mockContentData);
        Mockito.when((Object)this.mockContentData.getContentUrl()).thenReturn((Object)SOME_CONTENT_URL);
        Mockito.when((Object)this.mockContentData.getMimetype()).thenReturn((Object)"someMimetype");
        Mockito.when((Object)this.mockNodeService.getProperty(NODE_REF, ContentModel.PROP_NAME)).thenReturn((Object)SOME_FILE_NAME);
    }

    @Test
    public void testIsContentDirectUrlEnabled_SystemWideIsDisabled() {
        this.setupSystemWideDirectAccessConfig(DISABLED);
        Assert.assertFalse((String)"Expected contentDirectUrl to be disabled", (boolean)this.contentService.isContentDirectUrlEnabled());
        ((ContentStore)Mockito.verify((Object)this.mockContentStore, (VerificationMode)Mockito.never())).isContentDirectUrlEnabled();
    }

    @Test
    public void testIsContentDirectUrlEnabled_SystemWideIsEnabledButStoreIsDisabled() {
        this.setupSystemWideDirectAccessConfig(ENABLED);
        Mockito.when((Object)this.mockContentStore.isContentDirectUrlEnabled()).thenReturn((Object)DISABLED);
        Assert.assertFalse((String)"Expected contentDirectUrl to be disabled", (boolean)this.contentService.isContentDirectUrlEnabled());
    }

    @Test
    public void testIsContentDirectUrlEnabled_SystemWideIsEnabledAndStoreIsEnabled() {
        this.setupSystemWideDirectAccessConfig(ENABLED);
        Mockito.when((Object)this.mockContentStore.isContentDirectUrlEnabled()).thenReturn((Object)ENABLED);
        Assert.assertTrue((String)"Expected contentDirectUrl to be enabled", (boolean)this.contentService.isContentDirectUrlEnabled());
    }

    @Test
    public void testRequestContentDirectUrl_SystemWideIsDisabled() {
        this.setupSystemWideDirectAccessConfig(DISABLED);
        Assert.assertThrows(DirectAccessUrlDisabledException.class, () -> this.contentService.requestContentDirectUrl(NODE_REF, PROP_CONTENT_QNAME, true, Long.valueOf(20L)));
        ((ContentStore)Mockito.verify((Object)this.mockContentStore, (VerificationMode)Mockito.never())).isContentDirectUrlEnabled();
    }

    @Test
    public void testRequestContentDirectUrl_SystemWideIsEnabledButStoreIsDisabled() {
        this.setupSystemWideDirectAccessConfig(ENABLED);
        Mockito.when((Object)this.mockContentStore.isContentDirectUrlEnabled()).thenReturn((Object)DISABLED);
        DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(NODE_REF, PROP_CONTENT_QNAME, true, Long.valueOf(20L));
        Assert.assertNull((Object)directAccessUrl);
        ((ContentStore)Mockito.verify((Object)this.mockContentStore, (VerificationMode)Mockito.never())).requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()));
    }

    @Test
    public void testRequestContentDirectUrl_StoreIsEnabledButNotImplemented() {
        this.setupSystemWideDirectAccessConfig(ENABLED);
        Mockito.when((Object)this.mockContentStore.isContentDirectUrlEnabled()).thenReturn((Object)ENABLED);
        DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(NODE_REF, PROP_CONTENT_QNAME, true, Long.valueOf(20L));
        Assert.assertNull((Object)directAccessUrl);
        ((ContentStore)Mockito.verify((Object)this.mockContentStore, (VerificationMode)Mockito.times((int)1))).requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()));
    }

    @Test
    public void testRequestContentDirectUrl_StoreRequestContentDirectUrlIsCalledWithFileNameOverride() {
        DirectAccessUrl mockDirectAccessUrl = new DirectAccessUrl();
        mockDirectAccessUrl.setAttachment(true);
        mockDirectAccessUrl.setContentUrl(SOME_CONTENT_URL);
        this.setupSystemWideDirectAccessConfig(ENABLED);
        Mockito.when((Object)this.mockContentStore.isContentDirectUrlEnabled()).thenReturn((Object)ENABLED);
        Mockito.when((Object)this.mockContentStore.requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), (String)ArgumentMatchers.eq((Object)"fileNameOverride.txt"), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn((Object)mockDirectAccessUrl);
        DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(NODE_REF, PROP_CONTENT_QNAME, true, Long.valueOf(20L), "fileNameOverride.txt");
        Assert.assertEquals((String)"fileName was not set properly on the DirectAccessUrl response", (Object)"fileNameOverride.txt", (Object)directAccessUrl.getFileName());
        ((ContentStore)Mockito.verify((Object)this.mockContentStore, (VerificationMode)Mockito.times((int)1))).requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), (String)ArgumentMatchers.eq((Object)"fileNameOverride.txt"), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()));
    }

    @Test
    public void testRequestContentDirectUrl_StoreRequestContentDirectUrlIsCalledWithNodeNamePropertyWhenFileNameOverrideIsNull() {
        DirectAccessUrl mockDirectAccessUrl = new DirectAccessUrl();
        mockDirectAccessUrl.setAttachment(true);
        mockDirectAccessUrl.setContentUrl(SOME_CONTENT_URL);
        this.setupSystemWideDirectAccessConfig(ENABLED);
        Mockito.when((Object)this.mockContentStore.isContentDirectUrlEnabled()).thenReturn((Object)ENABLED);
        Mockito.when((Object)this.mockContentStore.requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), (String)ArgumentMatchers.eq((Object)SOME_FILE_NAME), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn((Object)mockDirectAccessUrl);
        DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(NODE_REF, PROP_CONTENT_QNAME, true, Long.valueOf(20L), null);
        Assert.assertEquals((String)"fileName was not set properly on the DirectAccessUrl response", (Object)SOME_FILE_NAME, (Object)directAccessUrl.getFileName());
        ((ContentStore)Mockito.verify((Object)this.mockContentStore, (VerificationMode)Mockito.times((int)1))).requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), (String)ArgumentMatchers.eq((Object)SOME_FILE_NAME), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()));
    }

    @Test
    public void testRequestContentDirectUrl_StoreRequestContentDirectUrlIsCalledWithNodeNamePropertyWhenFileNameOverrideIsEmpty() {
        DirectAccessUrl mockDirectAccessUrl = new DirectAccessUrl();
        mockDirectAccessUrl.setAttachment(true);
        mockDirectAccessUrl.setContentUrl(SOME_CONTENT_URL);
        this.setupSystemWideDirectAccessConfig(ENABLED);
        Mockito.when((Object)this.mockContentStore.isContentDirectUrlEnabled()).thenReturn((Object)ENABLED);
        Mockito.when((Object)this.mockContentStore.requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), (String)ArgumentMatchers.eq((Object)SOME_FILE_NAME), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn((Object)mockDirectAccessUrl);
        DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(NODE_REF, PROP_CONTENT_QNAME, true, Long.valueOf(20L), "");
        Assert.assertEquals((String)"fileName was not set properly on the DirectAccessUrl response", (Object)SOME_FILE_NAME, (Object)directAccessUrl.getFileName());
        ((ContentStore)Mockito.verify((Object)this.mockContentStore, (VerificationMode)Mockito.times((int)1))).requestContentDirectUrl(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true), (String)ArgumentMatchers.eq((Object)SOME_FILE_NAME), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()));
    }

    @Test
    public void shouldReturnStoragePropertiesWhenTheyExist() {
        Map<String, String> storageObjectPropsMap = Map.of(X_AMZ_HEADER_1, VALUE_1, X_AMZ_HEADER_2, VALUE_2);
        Mockito.when((Object)this.mockContentStore.getStorageProperties(SOME_CONTENT_URL)).thenReturn(storageObjectPropsMap);
        Map objectStorageProperties = this.contentService.getStorageProperties(NODE_REF, ContentModel.PROP_CONTENT);
        Assert.assertFalse((boolean)objectStorageProperties.isEmpty());
        Assert.assertEquals(storageObjectPropsMap, (Object)objectStorageProperties);
    }

    @Test
    public void shouldReturnEmptyStoragePropertiesWhenTheyDontExist() {
        Mockito.when((Object)this.mockContentStore.getStorageProperties(SOME_CONTENT_URL)).thenReturn(Collections.emptyMap());
        Map objectStorageProperties = this.contentService.getStorageProperties(NODE_REF, ContentModel.PROP_CONTENT);
        Assert.assertTrue((boolean)objectStorageProperties.isEmpty());
    }

    @Test
    public void getStoragePropertiesThrowsExceptionWhenNoContentFound() {
        Mockito.when((Object)this.mockNodeService.getProperty(NODE_REF_2, ContentModel.PROP_CONTENT)).thenReturn((Object)"dummy");
        Mockito.when((Object)this.mockDictionaryService.getProperty(ContentModel.PROP_CONTENT)).thenReturn(null);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.contentService.getStorageProperties(NODE_REF_2, ContentModel.PROP_CONTENT));
    }

    @Test
    public void getStoragePropertiesThrowsExceptionWhenNoContentUrlFound() {
        ContentData contentWithoutUrl = new ContentData(null, null, 0L, null);
        Mockito.when((Object)this.mockNodeService.getProperty(NODE_REF_2, ContentModel.PROP_CONTENT)).thenReturn((Object)contentWithoutUrl);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.contentService.getStorageProperties(NODE_REF_2, ContentModel.PROP_CONTENT));
    }

    @Test
    public void shouldRequestSendContentToArchiveSucceed() {
        Map archiveParams = Collections.emptyMap();
        Mockito.when((Object)this.mockContentStore.requestSendContentToArchive(SOME_CONTENT_URL, archiveParams)).thenReturn((Object)true);
        boolean sendContentToArchive = this.contentService.requestSendContentToArchive(NODE_REF, ContentModel.PROP_CONTENT, archiveParams);
        Assert.assertEquals((Object)true, (Object)sendContentToArchive);
    }

    @Test
    public void requestSendContentToArchiveThrowsExceptionWhenNotImplemented() {
        Map archiveParams = Collections.emptyMap();
        Mockito.when((Object)this.mockContentStore.requestSendContentToArchive(SOME_CONTENT_URL, archiveParams)).thenCallRealMethod();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.contentService.requestSendContentToArchive(NODE_REF, ContentModel.PROP_CONTENT, archiveParams));
    }

    @Test
    public void requestSendContentToArchiveThrowsExceptionWhenContentNotFound() {
        Map archiveParams = Collections.emptyMap();
        Mockito.when((Object)this.mockNodeService.getProperty(NODE_REF_2, ContentModel.PROP_CONTENT)).thenReturn((Object)"dummy");
        Mockito.when((Object)this.mockDictionaryService.getProperty(ContentModel.PROP_CONTENT)).thenReturn(null);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.contentService.requestSendContentToArchive(NODE_REF_2, ContentModel.PROP_CONTENT, archiveParams));
    }

    @Test
    public void requestRestoreContentFromArchiveThrowsExceptionWhenContentNotFound() {
        Mockito.when((Object)this.mockNodeService.getProperty(NODE_REF_2, ContentModel.PROP_CONTENT)).thenReturn((Object)"dummy");
        Mockito.when((Object)this.mockDictionaryService.getProperty(ContentModel.PROP_CONTENT)).thenReturn(null);
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), "High");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.contentService.requestRestoreContentFromArchive(NODE_REF_2, ContentModel.PROP_CONTENT, restoreParams));
    }

    @Test
    public void shouldRequestRestoreContentFromArchiveSucceed() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), "High");
        Mockito.when((Object)this.mockContentStore.requestRestoreContentFromArchive(SOME_CONTENT_URL, restoreParams)).thenReturn((Object)true);
        boolean restoreContentFromArchive = this.contentService.requestRestoreContentFromArchive(NODE_REF, ContentModel.PROP_CONTENT, restoreParams);
        Assert.assertEquals((Object)true, (Object)restoreContentFromArchive);
    }

    @Test
    public void requestRestoreContentFromArchiveThrowsExceptionWhenNotImplemented() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), "High");
        Mockito.when((Object)this.mockContentStore.requestRestoreContentFromArchive(SOME_CONTENT_URL, restoreParams)).thenCallRealMethod();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.contentService.requestRestoreContentFromArchive(NODE_REF, ContentModel.PROP_CONTENT, restoreParams));
    }

    private void setupSystemWideDirectAccessConfig(Boolean isEnabled) {
        SystemWideDirectUrlConfig sysConfig = new SystemWideDirectUrlConfig();
        sysConfig.setEnabled(isEnabled);
        sysConfig.setDefaultExpiryTimeInSec(SYS_DEFAULT_EXPIRY_TIME_IN_SECS);
        sysConfig.setMaxExpiryTimeInSec(SYS_MAX_EXPIRY_TIME_IN_SECS);
        sysConfig.validate();
        this.contentService.setSystemWideDirectUrlConfig(sysConfig);
    }
}

