/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.AuditComponentImpl;
import org.alfresco.repo.audit.AuditFilter;
import org.alfresco.repo.audit.PropertyAuditFilter;
import org.alfresco.repo.audit.UserAuditFilter;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.audit.model.AuditModelException;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ResourceUtils;

@Category(value={OwnJVMTestsCategory.class})
public class AuditComponentTest
extends TestCase {
    private static final String APPLICATION_TEST = "Alfresco Test";
    private static final String APPLICATION_ACTIONS_TEST = "Actions Test";
    private static final String APPLICATION_API_TEST = "Test AuthenticationService";
    private static final String APPLICATION_ALF12638_TEST = "Test ALF-12638";
    private static final String APPLICATION_MNT10767_TEST = "Test MNT-10767";
    private static final String APPLICATION_ONE = "app1";
    private static final String APPLICATION_TWO = "app2";
    private static final String APPLICATION_THREE = "app3";
    private static final Log logger = LogFactory.getLog(AuditComponentTest.class);
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuditModelRegistryImpl auditModelRegistry;
    private AuditComponentImpl auditComponent;
    private AuditService auditService;
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;
    private TransactionServiceImpl transactionServiceImpl;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private NodeRef nodeRef;
    private String user;

    public void setUp() throws Exception {
        this.auditModelRegistry = (AuditModelRegistryImpl)ctx.getBean("auditModel.modelRegistry");
        UserAuditFilter userAuditFilter = new UserAuditFilter();
        userAuditFilter.setUserFilterPattern("~System;~null;.*");
        userAuditFilter.afterPropertiesSet();
        this.auditComponent = (AuditComponentImpl)ctx.getBean("auditComponent");
        this.auditComponent.setUserAuditFilter(userAuditFilter);
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.auditService = this.serviceRegistry.getAuditService();
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.transactionServiceImpl = (TransactionServiceImpl)ctx.getBean("transactionService");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
        AuthenticationUtil.RunAsWork<NodeRef> testRunAs = new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return AuditComponentTest.this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            }
        };
        this.nodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)testRunAs, (String)AuthenticationUtil.getSystemUserName());
        this.user = "User-" + this.getName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.user);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> resetDisabledPathsCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuditComponentTest.this.auditComponent.resetDisabledPaths(AuditComponentTest.APPLICATION_TEST);
                AuditComponentTest.this.auditComponent.resetDisabledPaths(AuditComponentTest.APPLICATION_ACTIONS_TEST);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)resetDisabledPathsCallback);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        this.auditModelRegistry.destroy();
    }

    public void testSetUp() {
    }

    public void testAreAuditValuesRequired() {
        boolean auditRequiredAtAll = this.auditComponent.areAuditValuesRequired();
        AuditComponentTest.assertTrue((String)"Auditing should be enabled for this test", (boolean)auditRequiredAtAll);
        boolean auditRequiredForBogus = this.auditComponent.areAuditValuesRequired("bogus");
        AuditComponentTest.assertFalse((String)"Path 'bogus' should not have any audit associated with it.", (boolean)auditRequiredForBogus);
        boolean auditRequiredForTest = this.auditComponent.areAuditValuesRequired("/test");
        AuditComponentTest.assertTrue((String)"'test' is recording audit values", (boolean)auditRequiredForTest);
    }

    public void testAuditWithBadPath() throws Exception {
        this.auditComponent.recordAuditValues("/test", Collections.emptyMap());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    AuditComponentTest.this.auditComponent.recordAuditValues("test", null);
                    AuditComponentTest.fail((String)"Failed to detect illegal path");
                }
                catch (AuditModelException auditModelException) {}
                try {
                    AuditComponentTest.this.auditComponent.recordAuditValues("/test/", null);
                    AuditComponentTest.fail((String)"Failed to detect illegal path");
                }
                catch (AuditModelException auditModelException) {}
                Map auditedValues = AuditComponentTest.this.auditComponent.recordAuditValues("/bogus", null);
                AuditComponentTest.assertNotNull((Object)auditedValues);
                AuditComponentTest.assertTrue((String)"Invalid application should not audit anything", (boolean)auditedValues.isEmpty());
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
    }

    public void testAudit_Basic() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<String, Object> values = new HashMap<String, Object>(13);
                values.put("/3.1/4.1", 41L);
                values.put("/3.1/4.2", "42");
                values.put("/3.1/4.3", new Date());
                values.put("/3.1/4.4", "");
                values.put("/3.1/4.5", null);
                AuditComponentTest.this.auditComponent.recordAuditValues("/test/one.one/two.one", values);
                return null;
            }
        };
        AuthenticationUtil.RunAsWork<Void> testRunAs = new AuthenticationUtil.RunAsWork<Void>((RetryingTransactionHelper.RetryingTransactionCallback)testCallback){
            private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$testCallback;
            {
                this.val$testCallback = retryingTransactionCallback;
            }

            public Void doWork() throws Exception {
                return (Void)AuditComponentTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.val$testCallback);
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)testRunAs, (String)"SomeOtherUser");
    }

    private Map<String, Serializable> auditTestAction(String action, NodeRef nodeRef, Map<String, Serializable> parameters) {
        final HashMap<String, Object> adjustedValues = new HashMap<String, Object>(parameters.size() * 2);
        adjustedValues.put(AuditApplication.buildPath((String[])new String[]{"context-node"}), nodeRef);
        for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
            String paramName = entry.getKey();
            String path = AuditApplication.buildPath((String[])new String[]{action, "params", paramName});
            adjustedValues.put(path, entry.getValue());
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>> auditCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>>(){

            public Map<String, Serializable> execute() throws Throwable {
                String actionPath = AuditApplication.buildPath((String[])new String[]{"actions-test/actions"});
                return AuditComponentTest.this.auditComponent.recordAuditValues(actionPath, adjustedValues);
            }
        };
        return (Map)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)auditCallback, true, false);
    }

    private void checkAuditMaps(Map<String, Serializable> result, Map<String, Serializable> expected) {
        String failure = EqualsHelper.getMapDifferenceReport(result, expected);
        if (failure != null) {
            AuditComponentTest.fail((String)failure);
        }
    }

    private void auditAction01(String actionName) throws Exception {
        Date valueA = new Date();
        String valueB = "BBB-value-here";
        Float valueC = Float.valueOf(16.0f);
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(13);
        parameters.put("A", valueA);
        parameters.put("B", (Serializable)((Object)valueB));
        parameters.put("C", valueC);
        parameters.put("a", valueA);
        parameters.put("b", (Serializable)((Object)valueB));
        parameters.put("c", valueC);
        Map<String, Serializable> result = this.auditTestAction(actionName, this.nodeRef, parameters);
        HashMap<String, Serializable> expected = new HashMap<String, Serializable>();
        expected.put("/actions-test/actions/user", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        expected.put("/actions-test/actions/context-node/noderef", (Serializable)this.nodeRef);
        expected.put("/actions-test/actions/action-01/params/A/value", valueA);
        expected.put("/actions-test/actions/action-01/params/B/value", (Serializable)((Object)valueB));
        expected.put("/actions-test/actions/action-01/params/C/value", valueC);
        this.checkAuditMaps(result, expected);
    }

    public void testAudit_Action01() throws Exception {
        this.auditAction01("action-01");
    }

    public void testAudit_Action01Mapped() throws Exception {
        this.auditAction01("action-01-mapped");
    }

    private void auditAction02(String actionName) throws Exception {
        Date valueA = new Date();
        String valueB = "BBB-value-here";
        Float valueC = Float.valueOf(16.0f);
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(13);
        parameters.put("A", valueA);
        parameters.put("B", (Serializable)((Object)valueB));
        parameters.put("C", valueC);
        parameters.put("a", valueA);
        parameters.put("b", (Serializable)((Object)valueB));
        parameters.put("c", valueC);
        Map<String, Serializable> result = this.auditTestAction(actionName, this.nodeRef, parameters);
        HashMap<String, Serializable> expected = new HashMap<String, Serializable>();
        expected.put("/actions-test/actions/user", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        expected.put("/actions-test/actions/context-node/noderef", (Serializable)this.nodeRef);
        expected.put("/actions-test/actions/action-02/valueA", valueA);
        expected.put("/actions-test/actions/action-02/valueB", (Serializable)((Object)valueB));
        expected.put("/actions-test/actions/action-02/valueC", valueC);
        this.checkAuditMaps(result, expected);
    }

    public void testAudit_Action02Sourced() throws Exception {
        this.auditAction02("action-02-sourced");
    }

    public void testQuery_Action01() throws Exception {
        Long beforeTime = System.currentTimeMillis();
        this.testAudit_Action01();
        final StringBuilder sb = new StringBuilder();
        final MutableInt rowCount = new MutableInt();
        AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                AuditComponentTest.assertNotNull((Object)applicationName);
                AuditComponentTest.assertNotNull((Object)user);
                sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                rowCount.setValue(rowCount.intValue() + 1);
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(true);
        params.setApplicationName(APPLICATION_ACTIONS_TEST);
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        this.auditComponent.auditQuery(callback, params, Integer.MAX_VALUE);
        AuditComponentTest.assertTrue((String)"Expected some data", (rowCount.intValue() > 0 ? 1 : 0) != 0);
        logger.debug((Object)sb.toString());
        int allResults = rowCount.intValue();
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        this.auditComponent.auditQuery(callback, params, 1);
        AuditComponentTest.assertEquals((String)"Expected to limit data", (int)1, (int)rowCount.intValue());
        logger.debug((Object)sb.toString());
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setToTime(beforeTime);
        this.auditComponent.auditQuery(callback, params, Integer.MAX_VALUE);
        params.setToTime(null);
        logger.debug((Object)sb.toString());
        int resultsBefore = rowCount.intValue();
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setFromTime(beforeTime);
        this.auditComponent.auditQuery(callback, params, Integer.MAX_VALUE);
        params.setFromTime(null);
        logger.debug((Object)sb.toString());
        int resultsAfter = rowCount.intValue();
        AuditComponentTest.assertEquals((String)"Time-limited queries did not get all results before and after a time", (int)allResults, (int)(resultsBefore + resultsAfter));
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setUser(this.user);
        this.auditComponent.auditQuery(callback, params, Integer.MAX_VALUE);
        params.setUser(null);
        AuditComponentTest.assertTrue((String)"Expected some data for specific user", (rowCount.intValue() > 0 ? 1 : 0) != 0);
        logger.debug((Object)sb.toString());
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setUser("Numpty");
        this.auditComponent.auditQuery(callback, params, Integer.MAX_VALUE);
        params.setUser(null);
        AuditComponentTest.assertTrue((String)"Expected no data for bogus user", (rowCount.intValue() == 0 ? 1 : 0) != 0);
        logger.debug((Object)sb.toString());
    }

    public void testAudit_EnableDisableAuditPaths() throws Exception {
        Date valueA = new Date();
        String valueB = "BBB-value-here";
        Float valueC = Float.valueOf(16.0f);
        final HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(13);
        parameters.put("A", valueA);
        parameters.put("B", (Serializable)((Object)valueB));
        parameters.put("C", valueC);
        parameters.put("a", valueA);
        parameters.put("b", (Serializable)((Object)valueB));
        parameters.put("c", valueC);
        Map<String, Serializable> result = this.auditTestAction("action-01", this.nodeRef, parameters);
        final HashMap<String, Serializable> expected = new HashMap<String, Serializable>();
        expected.put("/actions-test/actions/user", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        expected.put("/actions-test/actions/context-node/noderef", (Serializable)this.nodeRef);
        expected.put("/actions-test/actions/action-01/params/A/value", valueA);
        expected.put("/actions-test/actions/action-01/params/B/value", (Serializable)((Object)valueB));
        expected.put("/actions-test/actions/action-01/params/C/value", valueC);
        this.checkAuditMaps(result, expected);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> disableAuditCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<String, Serializable> expectedInner = new HashMap<String, Serializable>(expected);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test/actions/action-01/params/A");
                expectedInner.remove("/actions-test/actions/action-01/params/A/value");
                Map<String, Serializable> result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test/actions/action-01/params/B");
                expectedInner.remove("/actions-test/actions/action-01/params/B/value");
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test");
                expectedInner.clear();
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.enableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test/actions/action-01/params/B");
                expectedInner.clear();
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.enableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test");
                expectedInner = new HashMap(expected);
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, null);
                expectedInner.clear();
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.enableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, null);
                expectedInner = new HashMap(expected);
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)disableAuditCallback, false);
    }

    public void testAuditAuthenticationService() throws Exception {
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(true);
        params.setApplicationName(APPLICATION_API_TEST);
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-authenticationservice.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
        final ArrayList results = new ArrayList(5);
        final StringBuilder sb = new StringBuilder();
        AuditService.AuditQueryCallback auditQueryCallback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                results.add(entryId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Audit Entry " + String.valueOf(entryId) + ": " + applicationName + ", " + user + ", " + String.valueOf(new Date(time)) + "\n   Data: " + String.valueOf(values)));
                }
                sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        this.clearAuditLog(APPLICATION_API_TEST);
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertTrue((String)"There should be no audit entries for the API test after a clear", (boolean)results.isEmpty());
        final MutableAuthenticationService authenticationService = this.serviceRegistry.getAuthenticationService();
        AuthenticationUtil.RunAsWork<Void> createAuthenticationWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (!authenticationService.authenticationExists(AuditComponentTest.this.getName())) {
                    authenticationService.createAuthentication(AuditComponentTest.this.getName(), AuditComponentTest.this.getName().toCharArray());
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createAuthenticationWork, (String)AuthenticationUtil.getSystemUserName());
        this.clearAuditLog(APPLICATION_API_TEST);
        try {
            AuthenticationUtil.pushAuthentication();
            authenticationService.authenticate(this.getName(), this.getName().toCharArray());
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertFalse((String)"Did not get any audit results after successful login", (boolean)results.isEmpty());
        this.clearAuditLog(APPLICATION_API_TEST);
        int iterations = 1000;
        int i = 0;
        while (i < iterations) {
            block11: {
                try {
                    try {
                        AuthenticationUtil.pushAuthentication();
                        authenticationService.authenticate("banana", "****".toCharArray());
                        AuditComponentTest.fail((String)"Invalid authentication attempt should fail");
                    }
                    catch (AuthenticationException authenticationException) {
                        AuthenticationUtil.popAuthentication();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    AuthenticationUtil.popAuthentication();
                    throw throwable;
                }
                AuthenticationUtil.popAuthentication();
            }
            ++i;
        }
        i = 0;
        while (i < 60) {
            results.clear();
            sb.delete(0, sb.length());
            this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
            if (results.size() == iterations) break;
            Thread.sleep(5000L);
            ++i;
        }
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertEquals((String)"Incorrect number of audit entries after failed login", (int)iterations, (int)results.size());
        Collections.sort(results);
        long minId = (Long)results.get(0);
        long maxId = (Long)results.get(100);
        ArrayList<Long> remainingResults = new ArrayList<Long>(results.subList(100, results.size()));
        long before = System.currentTimeMillis();
        int deleted = this.deleteAuditEntries(APPLICATION_API_TEST, minId, maxId);
        System.out.println("Clearing " + deleted + " entries by from/to ID took " + (System.currentTimeMillis() - before) + "ms.");
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertEquals((String)"Range of audit entries were not deleted", (int)remainingResults.size(), (int)results.size());
        before = System.currentTimeMillis();
        this.deleteAuditEntries(remainingResults);
        System.out.println("Clearing " + remainingResults.size() + " entries by set of IDs took " + (System.currentTimeMillis() - before) + "ms.");
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertEquals((String)"Explicit audit entries were not deleted", (int)0, (int)results.size());
    }

    public void testAuditQuery_MinId() throws Exception {
        AuditService.AuditQueryCallback auditQueryCallback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Audit Entry " + String.valueOf(entryId) + ": " + applicationName + ", " + user + ", " + String.valueOf(new Date(time)) + "\n   Data: " + String.valueOf(values)));
                }
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(APPLICATION_API_TEST);
        params.setForward(false);
        params.setToId(Long.valueOf(Long.MAX_VALUE));
        this.queryAuditLog(auditQueryCallback, params, 1);
    }

    public void testAuditQuery_MaxId() throws Exception {
        AuditService.AuditQueryCallback auditQueryCallback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Audit Entry " + String.valueOf(entryId) + ": " + applicationName + ", " + user + ", " + String.valueOf(new Date(time)) + "\n   Data: " + String.valueOf(values)));
                }
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(APPLICATION_API_TEST);
        params.setForward(false);
        params.setToId(Long.valueOf(Long.MAX_VALUE));
        this.queryAuditLog(auditQueryCallback, params, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuditFailedNodeAccess() throws Exception {
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(true);
        params.setApplicationName(APPLICATION_ALF12638_TEST);
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-alf-12638.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
        final ArrayList results = new ArrayList(5);
        final StringBuilder sb = new StringBuilder();
        AuditService.AuditQueryCallback auditQueryCallback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                results.add(entryId);
                sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        this.clearAuditLog(APPLICATION_ALF12638_TEST);
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
        AuditComponentTest.assertTrue((String)"There should be no audit entries for the API test after a clear", (boolean)results.isEmpty());
        try {
            this.nodeService.getRootNode(new StoreRef("system://system"));
            AuditComponentTest.fail((String)"Should not be allowed to get 'system://system'");
        }
        catch (AccessDeniedException accessDeniedException) {}
        boolean success = false;
        int i = 0;
        while (i < 30) {
            this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
            if (results.size() > 1) {
                logger.debug((Object)sb.toString());
                success = true;
                break;
            }
            AuditComponentTest auditComponentTest = this;
            synchronized (auditComponentTest) {
                try {
                    ((Object)((Object)this)).wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
        AuditComponentTest.assertTrue((String)"There should be exactly one audit entry for the API test", (boolean)success);
    }

    public void testApplication() throws Exception {
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-mnt-10070.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
        this.auditModelRegistry.setProperty("audit.enabled", "true");
        this.auditModelRegistry.setProperty("audit.enabled.auditingToDatabase", "true");
        this.auditModelRegistry.setProperty("audit.app1.enabled", "true");
        this.auditModelRegistry.setProperty("audit.filter.app1.default.enabled", "true");
        this.auditModelRegistry.setProperty("audit.filter.app1.login.user", "~System;~null;.*");
        this.auditModelRegistry.setProperty("audit.app2.enabled", "true");
        this.auditModelRegistry.setProperty("audit.filter.app2.default.enabled", "true");
        this.auditModelRegistry.setProperty("audit.filter.app2.login.user", "~System;~null;~admin;.*");
        this.auditModelRegistry.setProperty("audit.app3.enabled", "true");
        this.auditModelRegistry.setProperty("audit.filter.app3.default.enabled", "true");
        this.auditModelRegistry.setProperty("audit.filter.app3.login.user", "~System;~null;.*");
        this.auditModelRegistry.afterPropertiesSet();
        AuthenticationUtil.setRunAsUserSystem();
        AuditApplication applicationOne = this.auditModelRegistry.getAuditApplicationByName(APPLICATION_ONE);
        AuditComponentTest.assertNotNull((String)"Application 'app1' dosn't exist", (Object)applicationOne);
        AuditApplication applicationTwo = this.auditModelRegistry.getAuditApplicationByName(APPLICATION_TWO);
        AuditComponentTest.assertNotNull((String)"Application 'app2' dosn't exist", (Object)applicationTwo);
        AuditApplication applicationThree = this.auditModelRegistry.getAuditApplicationByName(APPLICATION_THREE);
        AuditComponentTest.assertNotNull((String)"Application 'app3' dosn't exist", (Object)applicationThree);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        PropertyAuditFilter filter = new PropertyAuditFilter();
        Properties properties = new Properties();
        properties.put("audit.enabled", "true");
        properties.put("audit.app1.enabled", "true");
        properties.put("audit.filter.app1.default.enabled", "true");
        properties.put("audit.filter.app1.default.user", "~System;~null;.*");
        properties.put("audit.app2.enabled", "true");
        properties.put("audit.filter.app2.default.enabled", "true");
        properties.put("audit.filter.app2.default.user", "~System;~null;~admin;.*");
        properties.put("audit.app3.enabled", "true");
        properties.put("audit.filter.app3.default.enabled", "true");
        properties.put("audit.filter.app3.default.user", "~System;~null;.*");
        filter.setProperties(properties);
        this.auditComponent.setAuditFilter((AuditFilter)filter);
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("/transaction/user", AuthenticationUtil.getFullyAuthenticatedUser());
        auditMap.put("/transaction/action", "CREATE");
        auditMap.put("/transaction/type", "cm:content");
        Map recordedAuditMap = this.auditComponent.recordAuditValues("/alfresco-access", auditMap);
        AuditComponentTest.assertFalse((String)"Audit values is empty.", (boolean)recordedAuditMap.isEmpty());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("/app1/transaction/action", "CREATE");
        expected.put("/app3/transaction/type", "cm:content");
        String failure = EqualsHelper.getMapDifferenceReport((Map)recordedAuditMap, expected);
        if (failure != null) {
            AuditComponentTest.fail((String)failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuditSubordinateCall() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(true);
        params.setApplicationName(APPLICATION_MNT10767_TEST);
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-mnt-10767.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
        final ArrayList results = new ArrayList(5);
        final StringBuilder sb = new StringBuilder();
        AuditService.AuditQueryCallback auditQueryCallback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                results.add(entryId);
                sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        this.clearAuditLog(APPLICATION_MNT10767_TEST);
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
        AuditComponentTest.assertTrue((String)"There should be no audit entries for the API test after a clear", (boolean)results.isEmpty());
        PolicyComponent policyComponent = (PolicyComponent)ctx.getBean("policyComponent");
        policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_FOLDER, (Behaviour)new JavaBehaviour((Object)this, "onCreateFolderMNT10767"));
        NodeRef workingRootNodeRef = null;
        try {
            workingRootNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)("working_root" + System.currentTimeMillis())), ContentModel.TYPE_FOLDER).getChildRef();
            boolean success = false;
            int i = 0;
            while (i < 30) {
                this.queryAuditLog(auditQueryCallback, params, Integer.MAX_VALUE);
                if (results.size() > 1) {
                    logger.debug((Object)sb.toString());
                    success = true;
                    break;
                }
                AuditComponentTest auditComponentTest = this;
                synchronized (auditComponentTest) {
                    try {
                        ((Object)((Object)this)).wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++i;
            }
            AuditComponentTest.assertTrue((String)"There should be audit entry for the API test", (boolean)success);
        }
        catch (Throwable throwable) {
            if (workingRootNodeRef != null) {
                this.nodeService.deleteNode(workingRootNodeRef);
            }
            throw throwable;
        }
        if (workingRootNodeRef != null) {
            this.nodeService.deleteNode(workingRootNodeRef);
        }
    }

    public void onCreateFolderMNT10767(ChildAssociationRef childAssocRef) {
        NodeRef newFolderRef = childAssocRef.getChildRef();
        this.fileFolderService.create(newFolderRef, "testcontent-" + System.currentTimeMillis(), ContentModel.TYPE_CONTENT);
    }

    public void testAuditOverlimitProperties() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < 1500) {
                    sb.append("a");
                    ++i;
                }
                MLText mlTextValue = new MLText();
                mlTextValue.put((Object)Locale.ENGLISH, (Object)sb.toString());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("String", sb.toString());
                MLText mlTextValue1 = new MLText();
                mlTextValue1.put((Object)Locale.ENGLISH, (Object)sb.toString());
                map.put("MLText", (String)mlTextValue1);
                ArrayList<String> list = new ArrayList<String>();
                list.add(sb.toString());
                MLText mlTextValue2 = new MLText();
                mlTextValue2.put((Object)Locale.ENGLISH, (Object)sb.toString());
                list.add((String)mlTextValue2);
                HashMap<String, Object> values = new HashMap<String, Object>(13);
                values.put("/3.1/4.1", sb.toString());
                values.put("/3.1/4.2", mlTextValue);
                values.put("map", map);
                values.put("collection", list);
                values.put("unmodifiableCollection", (Serializable)((Object)Collections.unmodifiableCollection(list)));
                AuditComponentTest.this.auditComponent.recordAuditValues("/test/one.one/two.one", values);
                return null;
            }
        };
        AuthenticationUtil.RunAsWork<Void> testRunAs = new AuthenticationUtil.RunAsWork<Void>((RetryingTransactionHelper.RetryingTransactionCallback)testCallback){
            private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$testCallback;
            {
                this.val$testCallback = retryingTransactionCallback;
            }

            public Void doWork() throws Exception {
                return (Void)AuditComponentTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.val$testCallback);
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)testRunAs, (String)"SomeOtherUser");
    }

    private void clearAuditLog(final String applicationName) {
        AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuditComponentTest.this.auditService.clearAudit(applicationName, null, null);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminRoleName());
    }

    private void deleteAuditEntries(final List<Long> auditEntryIds) {
        AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuditComponentTest.this.auditService.clearAudit(auditEntryIds);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminRoleName());
    }

    private Integer deleteAuditEntries(final String applicationName, final long fromId, final long toId) {
        AuthenticationUtil.RunAsWork<Integer> work = new AuthenticationUtil.RunAsWork<Integer>(){

            public Integer doWork() throws Exception {
                return AuditComponentTest.this.auditService.clearAuditByIdRange(applicationName, Long.valueOf(fromId), Long.valueOf(toId));
            }
        };
        return (Integer)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminRoleName());
    }

    private void queryAuditLog(final AuditService.AuditQueryCallback callback, final AuditQueryParameters parameters, final int maxResults) {
        AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuditComponentTest.this.auditService.auditQuery(callback, parameters, maxResults);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminRoleName());
    }

    public void testAuditInReadOnly() throws Exception {
        QName veto = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"TestVeto");
        this.transactionServiceImpl.setAllowWrite(false, veto);
        try {
            this.auditAction02("action-02");
        }
        finally {
            this.transactionServiceImpl.setAllowWrite(true, veto);
        }
    }

    public void testAuditTruncatedValues() {
        final String stringValue = RandomStringUtils.randomAlphanumeric((int)1025);
        final MLText mlTextValue = new MLText();
        mlTextValue.put((Object)Locale.ENGLISH, (Object)stringValue);
        RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>>(){

            public Map<String, Serializable> execute() throws Throwable {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("/3.1/4.1", stringValue);
                values.put("/3.1/4.2", (String)mlTextValue);
                return AuditComponentTest.this.auditComponent.recordAuditValues("/test/one.one/two.one", values);
            }
        };
        AuthenticationUtil.RunAsWork<Map<String, Serializable>> testRunAs = new AuthenticationUtil.RunAsWork<Map<String, Serializable>>((RetryingTransactionHelper.RetryingTransactionCallback)testCallback){
            private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$testCallback;
            {
                this.val$testCallback = retryingTransactionCallback;
            }

            public Map<String, Serializable> doWork() throws Exception {
                return (Map)AuditComponentTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.val$testCallback);
            }
        };
        Map result = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)testRunAs, (String)"SomeOtherUser");
        AuditComponentTest.assertEquals((Object)stringValue, result.get("/test/1.1/2.1/3.1/4.1/value.1"));
        AuditComponentTest.assertEquals((Object)mlTextValue, result.get("/test/1.1/2.1/3.1/4.2/value.2"));
    }
}

