/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ContentMetadataEmbedder;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ContentMetadataEmbedderTest
extends BaseSpringTest {
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private MimetypeService mimetypeService;
    private MetadataExtracterRegistry metadataExtracterRegistry;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private ContentMetadataEmbedder executer;
    private long origSize = -1L;
    private long newSize = -1L;
    private static final String ID = GUID.generate();

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        this.mimetypeService = (MimetypeService)this.applicationContext.getBean("mimetypeService");
        this.metadataExtracterRegistry = (MetadataExtracterRegistry)this.applicationContext.getBean("metadataExtracterRegistry");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter cw = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        cw.setMimetype("application/pdf");
        cw.putContent(AbstractContentTransformerTest.loadQuickTestFile("pdf"));
        this.executer = new ContentMetadataEmbedder();
        this.executer.setNodeService(this.nodeService);
        this.executer.setContentService(this.contentService);
        this.executer.setMetadataExtracterRegistry(this.metadataExtracterRegistry);
        this.executer.setApplicableTypes(new String[]{ContentModel.TYPE_CONTENT.toString()});
    }

    @Test
    public void testFailingEmbedder() {
        MockFailingEmbedder embedder = new MockFailingEmbedder();
        this.setupEmbedderActionAndThenExecute(embedder);
        ContentMetadataEmbedderTest.assertEquals((String)"The original content should remain unchanged on embed failures", (long)this.origSize, (long)this.newSize);
    }

    @Test
    public void testSuccessfulEmbedder() {
        MockSuccessfulEmbedder embedder = new MockSuccessfulEmbedder();
        this.setupEmbedderActionAndThenExecute(embedder);
        ContentMetadataEmbedderTest.assertNotSame((String)"The original content should remain unchanged on embed failures", (Object)this.origSize, (Object)this.newSize);
    }

    private void setupEmbedderActionAndThenExecute(AbstractMappingMetadataExtracter embedder) {
        embedder.setRegistry(this.metadataExtracterRegistry);
        embedder.setDictionaryService(this.dictionaryService);
        embedder.setMimetypeService(this.mimetypeService);
        embedder.register();
        String myCreator = "Embedded creator";
        Map origProps = this.nodeService.getProperties(this.nodeRef);
        origProps.put(ContentModel.PROP_AUTHOR, myCreator);
        this.nodeService.setProperties(this.nodeRef, origProps);
        ActionImpl action = new ActionImpl(null, ID, "set-property-value", null);
        ContentReader origReader = this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        this.origSize = origReader.getSize();
        ContentMetadataEmbedderTest.assertTrue((this.origSize > 0L ? 1 : 0) != 0);
        this.executer.execute((Action)action, this.nodeRef);
        ContentReader embeddedReader = this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        this.newSize = embeddedReader.getSize();
    }

    private static class MockEmbedder
    extends AbstractMappingMetadataExtracter {
        private static final Collection<String> MIMETYPES = Arrays.asList("application/pdf");

        public MockEmbedder() {
            super(new HashSet<String>(MIMETYPES), new HashSet<String>(MIMETYPES));
        }

        protected Map<String, Set<QName>> readMappingProperties(String propertiesUrl) {
            return null;
        }

        protected Map<String, Set<QName>> getDefaultMapping() {
            HashMap<String, Set<QName>> mapping = new HashMap<String, Set<QName>>(1);
            HashSet<QName> qnames = new HashSet<QName>(1);
            qnames.add(ContentModel.PROP_AUTHOR);
            mapping.put("author", qnames);
            return mapping;
        }

        protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
            return null;
        }
    }

    private static class MockFailingEmbedder
    extends MockEmbedder {
        private MockFailingEmbedder() {
        }

        protected void embedInternal(Map<String, Serializable> metadata, ContentReader reader, ContentWriter writer) throws Throwable {
            throw new IOException("Forced test failure");
        }
    }

    private static class MockSuccessfulEmbedder
    extends MockEmbedder {
        private MockSuccessfulEmbedder() {
        }

        protected void embedInternal(Map<String, Serializable> metadata, ContentReader reader, ContentWriter writer) throws Throwable {
            File htmlFile = AbstractContentTransformerTest.loadQuickTestFile("html");
            writer.putContent(htmlFile);
        }
    }
}

