/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.CompareMimeTypeEvaluator;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CompareMimeTypeEvaluatorTest
extends BaseSpringTest {
    private NodeService nodeService;
    private ContentService contentService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private CompareMimeTypeEvaluator evaluator;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.evaluator = (CompareMimeTypeEvaluator)this.applicationContext.getBean("compare-mime-type");
    }

    @Test
    public void testContentPropertyComparisons() {
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "compare-property-value");
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/plain");
        contentWriter.putContent("This is some test content.");
        condition.setParameterValue("value", (Serializable)((Object)"text/plain"));
        CompareMimeTypeEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate((ActionCondition)condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"text/html"));
        CompareMimeTypeEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate((ActionCondition)condition, this.nodeRef));
    }
}

