/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.tasklistener;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.delegate.VariableScope;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.script.ActivitiScriptBase;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;

public class ScriptTaskListener
extends ActivitiScriptBase
implements TaskListener {
    private static final long serialVersionUID = 1L;
    private static final String TASK_BINDING_NAME = "task";

    public void notify(DelegateTask delegateTask) {
        if (this.script != null) {
            String scriptString = this.getStringValue(this.script, (VariableScope)delegateTask);
            String scriptProcessorName = this.getStringValue(this.scriptProcessor, (VariableScope)delegateTask);
            String runAsUser = this.getStringValue(this.runAs, (VariableScope)delegateTask);
            boolean clearAuthenticationContext = this.checkFullyAuthenticatedUser(delegateTask);
            Map<String, Object> scriptModel = this.getInputMap(delegateTask, runAsUser);
            this.getServiceRegistry().getScriptService().buildCoreModel(scriptModel);
            try {
                Object object = this.executeScript(scriptString, scriptModel, scriptProcessorName, runAsUser);
            }
            finally {
                if (clearAuthenticationContext) {
                    AuthenticationUtil.clearCurrentSecurityContext();
                }
            }
        } else {
            throw new IllegalArgumentException("The field 'script' should be set on the TaskListener");
        }
    }

    protected Map<String, Object> getInputMap(DelegateTask delegateTask, String runAsUser) {
        HashMap<String, Object> scriptModel = new HashMap<String, Object>(1);
        ActivitiScriptNode personNode = this.getPersonNode(runAsUser);
        if (personNode != null) {
            ServiceRegistry registry = this.getServiceRegistry();
            scriptModel.put("person", personNode);
            NodeRef userHomeNode = (NodeRef)registry.getNodeService().getProperty(personNode.getNodeRef(), ContentModel.PROP_HOMEFOLDER);
            if (userHomeNode != null) {
                scriptModel.put("userhome", new ActivitiScriptNode(userHomeNode, registry));
            }
        }
        scriptModel.put(TASK_BINDING_NAME, delegateTask);
        scriptModel.put("execution", delegateTask.getExecution());
        Map variables = delegateTask.getExecution().getVariables();
        for (Map.Entry varEntry : variables.entrySet()) {
            scriptModel.put((String)varEntry.getKey(), varEntry.getValue());
        }
        return scriptModel;
    }

    private boolean checkFullyAuthenticatedUser(DelegateTask delegateTask) {
        String userName;
        if (AuthenticationUtil.getFullyAuthenticatedUser() == null && (userName = delegateTask.getAssignee()) != null) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            return true;
        }
        return false;
    }
}

