/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingResults;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.Pair;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class MLTranslationInterceptor
implements MethodInterceptor {
    private static final Set<String> METHOD_NAMES_LIST = new HashSet<String>(13);
    private static final Set<String> METHOD_NAMES_SINGLE;
    private static final Set<String> METHOD_NAMES_OTHER;
    private static Log logger;
    private NodeService nodeService;
    private MultilingualContentService multilingualContentService;
    private FileFolderService fileFolderService;

    static {
        METHOD_NAMES_LIST.add("list");
        METHOD_NAMES_LIST.add("listFiles");
        METHOD_NAMES_LIST.add("listFolders");
        METHOD_NAMES_LIST.add("listDeepFolders");
        METHOD_NAMES_LIST.add("search");
        METHOD_NAMES_LIST.add("getNamePath");
        METHOD_NAMES_SINGLE = new HashSet<String>(13);
        METHOD_NAMES_SINGLE.add("getLocalizedSibling");
        METHOD_NAMES_SINGLE.add("searchSimple");
        METHOD_NAMES_SINGLE.add("rename");
        METHOD_NAMES_SINGLE.add("move");
        METHOD_NAMES_SINGLE.add("moveFrom");
        METHOD_NAMES_SINGLE.add("copy");
        METHOD_NAMES_SINGLE.add("create");
        METHOD_NAMES_SINGLE.add("makeFolders");
        METHOD_NAMES_SINGLE.add("getNamePath");
        METHOD_NAMES_SINGLE.add("resolveNamePath");
        METHOD_NAMES_SINGLE.add("getFileInfo");
        METHOD_NAMES_OTHER = new HashSet<String>(13);
        METHOD_NAMES_OTHER.add("delete");
        METHOD_NAMES_OTHER.add("getReader");
        METHOD_NAMES_OTHER.add("getWriter");
        METHOD_NAMES_OTHER.add("getType");
        METHOD_NAMES_OTHER.add("exists");
        METHOD_NAMES_OTHER.add("getNameOnlyPath");
        logger = LogFactory.getLog(MLTranslationInterceptor.class);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    private NodeRef getTranslatedNodeRef(NodeRef nodeRef) {
        if (nodeRef == null) {
            return nodeRef;
        }
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
            return nodeRef;
        }
        Locale filterLocale = I18NUtil.getContentLocaleOrNull();
        if (filterLocale == null) {
            return nodeRef;
        }
        NodeRef translatedNodeRef = this.multilingualContentService.getTranslationForLocale(nodeRef, filterLocale);
        if (logger.isDebugEnabled()) {
            if (nodeRef.equals((Object)translatedNodeRef)) {
                logger.debug((Object)("NodeRef substitution: " + String.valueOf(nodeRef) + " --> " + String.valueOf(translatedNodeRef)));
            } else {
                logger.debug((Object)("NodeRef substitution: " + String.valueOf(nodeRef) + " (no change)"));
            }
        }
        return translatedNodeRef;
    }

    private FileInfo getTranslatedFileInfo(FileInfo fileInfo) {
        if (fileInfo == null) {
            return null;
        }
        if (fileInfo.isFolder()) {
            return fileInfo;
        }
        NodeRef nodeRef = fileInfo.getNodeRef();
        NodeRef translatedNodeRef = this.getTranslatedNodeRef(nodeRef);
        FileInfo translatedFileInfo = null;
        translatedFileInfo = nodeRef.equals((Object)translatedNodeRef) ? fileInfo : this.fileFolderService.getFileInfo(translatedNodeRef);
        return translatedFileInfo;
    }

    private List<FileInfo> processList(List<FileInfo> fileInfos) {
        HashMap<FileInfo, FileInfo> translatedFileInfos = new HashMap<FileInfo, FileInfo>(17);
        for (FileInfo fileInfo : fileInfos) {
            FileInfo translatedFileInfo = this.getTranslatedFileInfo(fileInfo);
            translatedFileInfos.put(fileInfo, translatedFileInfo);
        }
        ArrayList<FileInfo> orderedResults = new ArrayList<FileInfo>(fileInfos.size());
        HashSet<FileInfo> alreadyPresent = new HashSet<FileInfo>(fileInfos.size() * 2 + 1);
        for (FileInfo info : fileInfos) {
            FileInfo translatedFileInfo = (FileInfo)translatedFileInfos.get(info);
            if (alreadyPresent.contains(translatedFileInfo)) continue;
            alreadyPresent.add(translatedFileInfo);
            orderedResults.add(translatedFileInfo);
        }
        return orderedResults;
    }

    private PagingResults<FileInfo> processPagingResults(final PagingResults<FileInfo> fileInfos) {
        final List<FileInfo> orderedResults = this.processList(fileInfos.getPage());
        PagingResults<FileInfo> orderedPagingResults = new PagingResults<FileInfo>(){

            public String getQueryExecutionId() {
                return fileInfos.getQueryExecutionId();
            }

            public List<FileInfo> getPage() {
                return orderedResults;
            }

            public boolean hasMoreItems() {
                return fileInfos.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return fileInfos.getTotalResultCount();
            }
        };
        return orderedPagingResults;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object ret = null;
        String methodName = invocation.getMethod().getName();
        if (I18NUtil.getContentLocaleOrNull() == null) {
            return invocation.proceed();
        }
        if (METHOD_NAMES_LIST.contains(methodName)) {
            Object result = invocation.proceed();
            if (result instanceof List) {
                return this.processList((List)result);
            }
            if (result instanceof PagingResults) {
                return this.processPagingResults((PagingResults<FileInfo>)((PagingResults)result));
            }
            throw new ClassCastException("Unexpected return type from method " + methodName + " in " + String.valueOf(this));
        }
        if (METHOD_NAMES_SINGLE.contains(methodName)) {
            Object obj = invocation.proceed();
            if (obj instanceof FileInfo) {
                FileInfo fileInfo = (FileInfo)obj;
                ret = this.getTranslatedFileInfo(fileInfo);
            } else if (obj instanceof NodeRef) {
                NodeRef nodeRef = (NodeRef)obj;
                ret = this.getTranslatedNodeRef(nodeRef);
            }
        } else if (METHOD_NAMES_OTHER.contains(methodName)) {
            ret = invocation.proceed();
        } else {
            throw new RuntimeException("Method not handled by interceptor: " + methodName);
        }
        return ret;
    }
}

