/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.query.ibatis;

import java.util.List;
import org.alfresco.repo.domain.query.AbstractCannedQueryDAOImpl;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.domain.query.QueryException;
import org.alfresco.util.PropertyCheck;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;

public class CannedQueryDAOImpl
extends AbstractCannedQueryDAOImpl {
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    public void init() {
        super.init();
        PropertyCheck.mandatory((Object)this, (String)"template", (Object)this.template);
    }

    private final String makeQueryName(String sqlNamespace, String queryName) {
        return new StringBuilder(sqlNamespace.length() + queryName.length() + 1).append(sqlNamespace).append(".").append(queryName).toString();
    }

    @Override
    public Long executeCountQuery(String sqlNamespace, String queryName, Object parameterObj) {
        String query = this.makeQueryName(sqlNamespace, queryName);
        try {
            Long result = (Long)this.template.selectOne(query, parameterObj);
            if (result == null) {
                result = 0L;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executed query: \n   Query:  " + query + "\n   Params: " + String.valueOf(parameterObj) + "\n   Result: " + String.valueOf(result)));
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new QueryException("Count query results must return exactly one Long value: \n   Query:  " + query + "\n   Params: " + String.valueOf(parameterObj), e);
        }
        catch (Throwable e) {
            throw new QueryException("Failed to execute query: \n   Query:  " + query + "\n   Params: " + String.valueOf(parameterObj), e);
        }
    }

    @Override
    public <R> R executeQueryUnique(String sqlNamespace, String queryName, Object parameterObj) {
        String query = this.makeQueryName(sqlNamespace, queryName);
        Object obj = this.template.selectOne(query, parameterObj);
        try {
            return (R)obj;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Return type of query does not match expected type.", e);
        }
    }

    @Override
    public <R> List<R> executeQuery(String sqlNamespace, String queryName, Object parameterObj, int offset, int limit) {
        if (offset < 0 || offset == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Query result offset must be zero or greater.");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Query results limit must be greater than zero.");
        }
        String query = this.makeQueryName(sqlNamespace, queryName);
        try {
            List result;
            if (offset == 0 && limit == Integer.MAX_VALUE) {
                result = this.template.selectList(query, parameterObj);
            } else {
                RowBounds bounds = new RowBounds(offset, limit);
                result = this.template.selectList(query, parameterObj, bounds);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executed query: \n   Query:  " + query + "\n   Params: " + String.valueOf(parameterObj) + "\n   Result: " + String.valueOf(result)));
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Return type of query does not match expected type.", e);
        }
        catch (Throwable e) {
            throw new QueryException("Failed to execute query: \n   Namespace: " + sqlNamespace + "\n   queryName: " + queryName + "\n   Parameter: " + String.valueOf(parameterObj) + "\n   Offset:    " + offset + "\n   Limit:     " + limit, e);
        }
    }

    @Override
    public <R> void executeQuery(String sqlNamespace, String queryName, Object parameterObj, int offset, int limit, CannedQueryDAO.ResultHandler<R> handler) {
        if (offset < 0 || offset == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Query result offset must be zero or greater.");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Query results limit must be greater than zero.");
        }
        String query = this.makeQueryName(sqlNamespace, queryName);
        ResultHandlerTranslator<R> resultHandler = new ResultHandlerTranslator<R>(handler);
        try {
            if (offset == 0 && limit == Integer.MAX_VALUE) {
                this.template.select(query, parameterObj, resultHandler);
            } else {
                RowBounds bounds = new RowBounds(offset, limit);
                this.template.select(query, parameterObj, bounds, resultHandler);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Return type of query does not match expected type.", e);
        }
        catch (Throwable e) {
            throw new QueryException("Failed to execute query: \n   Namespace: " + sqlNamespace + "\n   queryName: " + queryName + "\n   Parameter: " + String.valueOf(parameterObj) + "\n   Offset:    " + offset + "\n   Limit:     " + limit, e);
        }
    }

    private static class ResultHandlerTranslator<R>
    implements ResultHandler {
        private final CannedQueryDAO.ResultHandler<R> target;
        boolean stopped = false;

        private ResultHandlerTranslator(CannedQueryDAO.ResultHandler<R> target) {
            this.target = target;
        }

        public void handleResult(ResultContext ctx) {
            if (this.stopped || ctx.isStopped()) {
                return;
            }
            boolean more = this.target.handleResult(ctx.getResultObject());
            if (!more) {
                ctx.stop();
                this.stopped = true;
            }
        }
    }
}

