/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.ModelInUseException;
import org.alfresco.repo.dictionary.ModelValidator;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelException;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class ModelValidatorTest {
    private static final String TEST_MODEL_URI_PART1 = "http://www.alfresco.org/model/testmodelvalidatoramespace";
    private static final String TEST_MODEL_URI_PART2 = "/1.0";
    private static final String TEST_MODEL_DESC = "This is test custom model desc";
    private static final String TEST_MODEL_AUTHOR = "John Doe";
    private ApplicationContext ctx;
    private String testNamespace;
    private String modelName;
    private ModelValidator modelValidator;
    private DictionaryDAO dictionaryDAO;
    private QNameDAO qnameDAO;
    private NamespaceDAO namespaceDAO;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private VersionService versionService;
    private TransactionService transactionService;
    private NodeArchiveService nodeArchiveService;
    private CustomModelService customModelService;
    private M2Model model;
    private QName modelQName;
    private QName typeQName;
    private M2Type type;
    private QName propertyQName;
    private M2Property property;

    @Before
    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.modelValidator = (ModelValidator)this.ctx.getBean("modelValidator");
        this.dictionaryDAO = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        this.qnameDAO = (QNameDAO)this.ctx.getBean("qnameDAO");
        this.namespaceDAO = (NamespaceDAO)this.ctx.getBean("namespaceDAO");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.fileFolderService = (FileFolderService)this.ctx.getBean("FileFolderService");
        this.contentService = (ContentService)this.ctx.getBean("contentService");
        this.versionService = (VersionService)this.ctx.getBean("VersionService");
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.nodeArchiveService = (NodeArchiveService)this.ctx.getBean("nodeArchiveService");
        this.customModelService = (CustomModelService)this.ctx.getBean("customModelService");
        this.modelName = "modelvalidatortest" + System.currentTimeMillis();
        this.addModel();
    }

    @AfterClass
    public static void cleanUp() {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private QName addModel() {
        this.testNamespace = "http://www.alfresco.org/test/" + this.modelName;
        this.modelQName = QName.createQName((String)this.testNamespace, (String)this.modelName);
        this.model = M2Model.createModel((String)(this.modelName + ":" + this.modelName));
        this.model.createNamespace(this.testNamespace, this.modelName);
        this.model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        this.model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        this.typeQName = QName.createQName((String)this.testNamespace, (String)"type1");
        this.type = this.model.createType(this.modelName + ":" + this.typeQName.getLocalName());
        this.type.setParentName("cm:folder");
        this.propertyQName = QName.createQName((String)this.testNamespace, (String)"prop1");
        this.property = this.type.createProperty(this.modelName + ":" + this.propertyQName.getLocalName());
        this.property.setType("d:text");
        this.dictionaryDAO.putModel(this.model);
        return this.modelQName;
    }

    private NodeRef getParentNodeRef() {
        NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef parentNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)("working root" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        return parentNodeRef;
    }

    @Test
    public void testInvalidModelDelete() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final QName modelQName = QName.createQName((String)this.testNamespace, (String)this.modelName);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef parentNodeRef = ModelValidatorTest.this.getParentNodeRef();
                FileInfo folder = ModelValidatorTest.this.fileFolderService.create(parentNodeRef, GUID.generate(), ContentModel.TYPE_FOLDER);
                Assert.assertNotNull((Object)folder);
                NodeRef folderNodeRef = folder.getNodeRef();
                FileInfo node = ModelValidatorTest.this.fileFolderService.create(folderNodeRef, GUID.generate(), ModelValidatorTest.this.typeQName);
                Assert.assertNotNull((Object)node);
                NodeRef nodeRef = node.getNodeRef();
                ContentWriter writer = ModelValidatorTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.putContent("Test");
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(ModelValidatorTest.this.propertyQName, "Test");
                ModelValidatorTest.this.nodeService.setProperties(nodeRef, properties);
                ModelValidatorTest.this.versionService.createVersion(nodeRef, null);
                return nodeRef;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createNodeCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteModelCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (ModelValidatorTest.this.modelValidator.canDeleteModel(modelQName)) {
                    Assert.fail((String)"Model delete should have failed");
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteModelCallback, false, true);
    }

    @Test
    public void testInvalidModelDeleteArchivedNode() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final QName modelQName = QName.createQName((String)this.testNamespace, (String)this.modelName);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef parentNodeRef = ModelValidatorTest.this.getParentNodeRef();
                FileInfo folder = ModelValidatorTest.this.fileFolderService.create(parentNodeRef, GUID.generate(), ContentModel.TYPE_FOLDER);
                Assert.assertNotNull((Object)folder);
                NodeRef folderNodeRef = folder.getNodeRef();
                FileInfo node = ModelValidatorTest.this.fileFolderService.create(folderNodeRef, GUID.generate(), ModelValidatorTest.this.typeQName);
                Assert.assertNotNull((Object)node);
                NodeRef nodeRef = node.getNodeRef();
                ContentWriter writer = ModelValidatorTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.putContent("Test");
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(ModelValidatorTest.this.propertyQName, "Test");
                ModelValidatorTest.this.nodeService.setProperties(nodeRef, properties);
                ModelValidatorTest.this.versionService.createVersion(nodeRef, null);
                return nodeRef;
            }
        };
        final NodeRef nodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createNodeCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ModelValidatorTest.this.nodeService.deleteNode(nodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNodeCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteModelCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (ModelValidatorTest.this.modelValidator.canDeleteModel(modelQName)) {
                    Assert.fail((String)"Model delete should have failed");
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteModelCallback, false, true);
    }

    @Test
    public void testModelDelete() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final QName modelQName = QName.createQName((String)this.testNamespace, (String)this.modelName);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef parentNodeRef = ModelValidatorTest.this.getParentNodeRef();
                FileInfo folder = ModelValidatorTest.this.fileFolderService.create(parentNodeRef, GUID.generate(), ContentModel.TYPE_FOLDER);
                Assert.assertNotNull((Object)folder);
                NodeRef folderNodeRef = folder.getNodeRef();
                FileInfo node = ModelValidatorTest.this.fileFolderService.create(folderNodeRef, GUID.generate(), ModelValidatorTest.this.typeQName);
                Assert.assertNotNull((Object)node);
                NodeRef nodeRef = node.getNodeRef();
                ContentWriter writer = ModelValidatorTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.putContent("Test");
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(ModelValidatorTest.this.propertyQName, "Test");
                ModelValidatorTest.this.nodeService.setProperties(nodeRef, properties);
                ModelValidatorTest.this.versionService.createVersion(nodeRef, null);
                return nodeRef;
            }
        };
        final NodeRef nodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createNodeCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ModelValidatorTest.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                ModelValidatorTest.this.nodeService.deleteNode(nodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNodeCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteModelCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (!ModelValidatorTest.this.modelValidator.canDeleteModel(modelQName)) {
                    Assert.fail((String)"Model delete should have succeeded");
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteModelCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkQNamesCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertNotNull((Object)ModelValidatorTest.this.qnameDAO.getQName(ModelValidatorTest.this.propertyQName));
                Assert.assertNotNull((Object)ModelValidatorTest.this.qnameDAO.getQName(ModelValidatorTest.this.typeQName));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkQNamesCallback, false, true);
    }

    @Test
    public void testInvalidPropertyDelete() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef parentNodeRef = ModelValidatorTest.this.getParentNodeRef();
                FileInfo folder = ModelValidatorTest.this.fileFolderService.create(parentNodeRef, GUID.generate(), ContentModel.TYPE_FOLDER);
                Assert.assertNotNull((Object)folder);
                NodeRef folderNodeRef = folder.getNodeRef();
                FileInfo node = ModelValidatorTest.this.fileFolderService.create(folderNodeRef, GUID.generate(), ModelValidatorTest.this.typeQName);
                Assert.assertNotNull((Object)node);
                NodeRef nodeRef = node.getNodeRef();
                ContentWriter writer = ModelValidatorTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.putContent("Test");
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(ModelValidatorTest.this.propertyQName, "Test");
                ModelValidatorTest.this.nodeService.setProperties(nodeRef, properties);
                ModelValidatorTest.this.versionService.createVersion(nodeRef, null);
                return nodeRef;
            }
        };
        final NodeRef nodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createNodeCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteModelCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ModelValidatorTest.this.type.removeProperty(ModelValidatorTest.this.modelName + ":" + ModelValidatorTest.this.propertyQName.getLocalName());
                CompiledModel compiledModel = ModelValidatorTest.this.model.compile(ModelValidatorTest.this.dictionaryDAO, ModelValidatorTest.this.namespaceDAO, true);
                try {
                    ModelValidatorTest.this.modelValidator.validateModel(compiledModel);
                    Assert.fail((String)"Property delete should have failed");
                }
                catch (ModelInUseException modelInUseException) {
                    System.out.println("help");
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteModelCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ModelValidatorTest.this.nodeService.deleteNode(nodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNodeCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> purgeArchiveCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ModelValidatorTest.this.nodeArchiveService.purgeAllArchivedNodes(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)purgeArchiveCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteModelAgainCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ModelValidatorTest.this.type.removeProperty(ModelValidatorTest.this.modelName + ":" + ModelValidatorTest.this.propertyQName.getLocalName());
                CompiledModel compiledModel = ModelValidatorTest.this.model.compile(ModelValidatorTest.this.dictionaryDAO, ModelValidatorTest.this.namespaceDAO, true);
                ModelValidatorTest.this.modelValidator.validateModel(compiledModel);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteModelAgainCallback, false, true);
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.type.removeProperty(this.property.getName());
        this.model.removeImport("http://www.alfresco.org/model/dictionary/1.0");
        CompiledModel compiledModel = this.model.compile(this.dictionaryDAO, this.namespaceDAO, true);
        this.modelValidator.validateModel(compiledModel);
        this.model.removeImport("http://www.alfresco.org/model/content/1.0");
        try {
            this.model.compile(this.dictionaryDAO, this.namespaceDAO, true);
            Assert.fail((String)"Should have failed as the model's type references the content model (cm:folder).");
        }
        catch (DictionaryException dictionaryException) {}
        this.model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        this.model.compile(this.dictionaryDAO, this.namespaceDAO, true);
        this.model.removeNamespace(this.testNamespace);
        try {
            this.model.compile(this.dictionaryDAO, this.namespaceDAO, true);
            Assert.fail((String)"Should have failed as the type's name references the namespace.");
        }
        catch (DictionaryException dictionaryException) {}
    }

    @Test
    public void testValidatePrefixForModelWithValidPrefix() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String inactiveModelName = "testCustomModel1" + System.currentTimeMillis();
        String activeModelName = "testCustomModel2" + System.currentTimeMillis();
        String inactiveModelPrefix = "testmodelvalidatorpfx1-" + System.currentTimeMillis();
        this.createAndVerifyTestModel(inactiveModelName, inactiveModelPrefix, false);
        String activeModelPrefix = "testmodelvalidatorpfx2-" + System.currentTimeMillis();
        this.createAndVerifyTestModel(activeModelName, activeModelPrefix, true);
        this.validatePrefix(inactiveModelName);
        this.validatePrefix(activeModelName);
    }

    @Test
    public void testValidatePrefixForModelWithDuplicatePrefix() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String customModel1Name = "testCustomModel1" + System.currentTimeMillis();
        String customModel2Name = "testCustomModel2" + System.currentTimeMillis();
        String modelPrefix = "acs701-prefix01-" + System.currentTimeMillis();
        this.createAndVerifyTestModel(customModel1Name, modelPrefix, false);
        this.validatePrefix(customModel1Name);
        try {
            this.createAndVerifyTestModel(customModel2Name, modelPrefix, true);
            Assert.fail((String)"Expected a CustomModelException for model with a duplicate namespace prefix");
        }
        catch (CustomModelException customModelException) {}
    }

    private void createAndVerifyTestModel(String testModelName, String prefix, boolean activate) {
        String uri = TEST_MODEL_URI_PART1 + System.currentTimeMillis() + TEST_MODEL_URI_PART2;
        Pair namespacePair = new Pair((Object)uri, (Object)prefix);
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + testModelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setDescription(TEST_MODEL_DESC);
        model.setAuthor(TEST_MODEL_AUTHOR);
        CustomModelDefinition modelDefinition = this.createModel(model, activate);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)testModelName, (Object)modelDefinition.getName().getLocalName());
        NamespaceDefinition namespaceDefinition = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        Assert.assertNotNull((Object)namespaceDefinition);
        Assert.assertEquals((Object)namespacePair.getFirst(), (Object)namespaceDefinition.getUri());
        Assert.assertEquals((Object)namespacePair.getSecond(), (Object)namespaceDefinition.getPrefix());
        NodeRef modelNodeRef = this.customModelService.getModelNodeRef(testModelName);
        boolean isActive = Boolean.TRUE.equals(this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_MODEL_ACTIVE));
        Assert.assertEquals((Object)activate, (Object)isActive);
    }

    private CustomModelDefinition createModel(final M2Model m2Model, final boolean activate) {
        RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition> createModelCallback = new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Throwable {
                CustomModelDefinition cmd = ModelValidatorTest.this.customModelService.createCustomModel(m2Model, activate);
                return cmd;
            }
        };
        return (CustomModelDefinition)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createModelCallback, false, true);
    }

    private void validatePrefix(final String modelName) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateInactiveModelPrefixCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef modelNodeRef = ModelValidatorTest.this.customModelService.getModelNodeRef(modelName);
                ModelValidatorTest.this.modelValidator.validateModelNamespacePrefix(modelNodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateInactiveModelPrefixCallback, false, true);
    }
}

