/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.io.Serializable;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.repo.virtual.template.VirtualQueryConstraintDecorator;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class PropertyValueConstraint
extends VirtualQueryConstraintDecorator {
    private QName property;
    private Serializable value;
    private NamespacePrefixResolver nspResolver;

    public PropertyValueConstraint(VirtualQueryConstraint decoratedConstraint, QName property, Serializable value, NamespacePrefixResolver nspResolver) {
        super(decoratedConstraint);
        this.property = property;
        this.value = value;
        this.nspResolver = nspResolver;
    }

    @Override
    public SearchParameters applyDecorations(ActualEnvironment environment, SearchParameters searchParameters, VirtualQuery query) throws VirtualizationException {
        if ("fts-alfresco".equals(searchParameters.getLanguage())) {
            SearchParameters searchParametersCopy = searchParameters.copy();
            return this.applyFTS(searchParametersCopy);
        }
        throw new VirtualizationException("Unsupported constrating language " + searchParameters.getLanguage());
    }

    protected SearchParameters applyFTS(SearchParameters searchParameters) {
        SearchParameters constrainedParameters = searchParameters.copy();
        Object theQuery = constrainedParameters.getQuery();
        theQuery = "(" + (String)theQuery + ") and ( =" + this.property.toPrefixString(this.nspResolver) + ":\"" + this.value.toString() + "\" )";
        constrainedParameters.setQuery((String)theQuery);
        return constrainedParameters;
    }
}

