/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.serviceaccount;

import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.alfresco.repo.serviceaccount.ServiceAccountRegistry;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ServiceAccountRegistryImpl
implements ServiceAccountRegistry,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceAccountRegistryImpl.class);
    public static final String KEY_PREFIX = "serviceaccount.role.";
    private Properties globalProperties;
    private final ConcurrentMap<String, String> saRoleMap = new ConcurrentHashMap<String, String>();

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    @Override
    public void register(String serviceAccountName, String serviceAccountRole) {
        this.saRoleMap.put(serviceAccountName, serviceAccountRole);
        LOGGER.info("Service account '{}' is registered with the role '{}'.", (Object)serviceAccountName, (Object)serviceAccountRole);
    }

    @Override
    public Optional<String> getServiceAccountRole(String serviceAccountName) {
        return Optional.ofNullable((String)this.saRoleMap.get(serviceAccountName));
    }

    @Override
    public Set<String> getServiceAccountNames() {
        return Set.copyOf(this.saRoleMap.keySet());
    }

    private void init() {
        this.globalProperties.stringPropertyNames().stream().filter(key -> key.startsWith(KEY_PREFIX)).forEach(key -> {
            String name = key.substring(KEY_PREFIX.length());
            if (this.isNotValidProperty((String)key, name, "name")) {
                return;
            }
            String role = this.globalProperties.getProperty((String)key);
            if (this.isNotValidProperty((String)key, role, "role")) {
                return;
            }
            role = role.toUpperCase(Locale.ENGLISH);
            if (!PermissionService.SVC_AUTHORITIES_SET.contains(role = this.getRoleWithPrefix(role))) {
                LOGGER.warn("Invalid service account role '{}'. The role is not recognized.", (Object)role);
                return;
            }
            this.register(name, role);
        });
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"globalProperties", (Object)this.globalProperties);
        this.init();
    }

    private String getRoleWithPrefix(String saRole) {
        if (!((String)saRole).startsWith("ROLE_")) {
            saRole = "ROLE_" + (String)saRole;
        }
        return saRole;
    }

    private boolean isNotValidProperty(String key, String value, String valueType) {
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("Invalid service account {} defined in the property '{}'. The {} cannot be an empty string.", new Object[]{valueType, key, valueType});
            return true;
        }
        return false;
    }
}

