/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.validator;

import java.util.ArrayList;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.SQLServerDialect;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.validator.TypeNameOnlyValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypeNameOnlyValidatorTest {
    private TypeNameOnlyValidator validator;
    private DiffContext ctx;
    private Results validationResults;

    @Before
    public void setUp() throws Exception {
        this.validator = new TypeNameOnlyValidator();
        this.validationResults = new Results();
        this.ctx = new DiffContext((Dialect)new SQLServerDialect(), this.validationResults, null, null);
    }

    @Test
    public void validateOnlyColumnsTest() {
        try {
            this.validator.validate(null, (DbObject)new Index(null, null, new ArrayList()), this.ctx);
            Assert.fail((String)"TypeNameOnlyValidator should validate only Column");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    @Test
    public void validateColumnNamesTest() {
        this.assertValidation((DbObject)this.column("nvarchar(1)"), (DbObject)this.column("nvarchar(2)"), false);
        this.assertValidation((DbObject)this.column("numeric"), (DbObject)this.column("numeric"), false);
        this.assertValidation((DbObject)this.column("nvarchar(1)"), (DbObject)this.column("varchar(1)"), true);
        this.assertValidation((DbObject)this.column("numeric() identity"), (DbObject)this.column("numeric() identity"), false);
    }

    private void assertValidation(DbObject reference, DbObject target, boolean shouldFail) {
        int shouldFailInt = shouldFail ? 1 : 0;
        int beforeValidationResultsSize = this.validationResults.size();
        this.validator.validate(reference, target, this.ctx);
        Assert.assertEquals((long)(this.validationResults.size() - beforeValidationResultsSize), (long)shouldFailInt);
    }

    private Column column(String typeName) {
        return new Column(null, null, typeName, true);
    }
}

