/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.Map;
import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceJITProvisioningHandler;
import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.OIDCUserInfo;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

public class IdentityServiceJITProvisioningHandlerUnitTest {
    @Mock
    private IdentityServiceFacade identityServiceFacade;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ClientRegistration clientRegistration;
    @Mock
    private PersonService personService;
    @Mock
    private IdentityServiceFacade.DecodedAccessToken decodedAccessToken;
    @Mock
    private TransactionService transactionService;
    @Mock
    private IdentityServiceConfig identityServiceConfig;
    @Mock
    private DecodedTokenUser decodedTokenUser;
    private IdentityServiceJITProvisioningHandler jitProvisioningHandler;
    private UserInfoAttrMapping expectedMapping;
    private static final String JWT_TOKEN = "myToken";
    private static final String USERNAME = "johny123";
    private static final String FIRST_NAME = "John";
    private static final String LAST_NAME = "Doe";
    private static final String EMAIL = "johny123@email.com";
    public static final String USERNAME_CLAIM = "nickname";
    public static final String EMAIL_CLAIM = "email";
    public static final String FIRST_NAME_CLAIM = "given_name";
    public static final String LAST_NAME_CLAIM = "family_name";

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.transactionService.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)this.identityServiceFacade.decodeToken(JWT_TOKEN)).thenReturn((Object)this.decodedAccessToken);
        Mockito.when((Object)this.personService.createMissingPeople()).thenReturn((Object)true);
        Mockito.when((Object)this.identityServiceFacade.getClientRegistration()).thenReturn((Object)this.clientRegistration);
        Mockito.when((Object)this.clientRegistration.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName()).thenReturn((Object)USERNAME_CLAIM);
        Mockito.when((Object)this.identityServiceConfig.getEmailAttribute()).thenReturn((Object)EMAIL_CLAIM);
        Mockito.when((Object)this.identityServiceConfig.getFirstNameAttribute()).thenReturn((Object)FIRST_NAME_CLAIM);
        Mockito.when((Object)this.identityServiceConfig.getLastNameAttribute()).thenReturn((Object)LAST_NAME_CLAIM);
        this.expectedMapping = new UserInfoAttrMapping(USERNAME_CLAIM, FIRST_NAME_CLAIM, LAST_NAME_CLAIM, EMAIL_CLAIM);
        this.jitProvisioningHandler = new IdentityServiceJITProvisioningHandler(this.identityServiceFacade, this.personService, this.transactionService, this.identityServiceConfig);
    }

    @Test
    public void shouldExtractUserInfoForExistingUser() {
        Mockito.when((Object)this.clientRegistration.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName()).thenReturn((Object)"preferred_username");
        Mockito.when((Object)this.personService.personExists(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)USERNAME);
        this.jitProvisioningHandler = new IdentityServiceJITProvisioningHandler(this.identityServiceFacade, this.personService, this.transactionService, this.identityServiceConfig);
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)USERNAME, (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(JWT_TOKEN, this.expectedMapping);
    }

    @Test
    public void shouldExtractUserInfoForExistingUserWithProviderPrincipalAttribute() {
        Mockito.when((Object)this.identityServiceConfig.getPrincipalAttribute()).thenReturn((Object)USERNAME_CLAIM);
        Mockito.when((Object)this.personService.personExists(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim(USERNAME_CLAIM)).thenReturn((Object)USERNAME);
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)USERNAME, (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(JWT_TOKEN, this.expectedMapping);
    }

    @Test
    public void shouldExtractUserInfoFromAccessTokenAndCreateUser() {
        Mockito.when((Object)this.clientRegistration.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName()).thenReturn((Object)"preferred_username");
        Mockito.when((Object)this.personService.personExists(USERNAME)).thenReturn((Object)false);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.decodedAccessToken.getClaim(FIRST_NAME_CLAIM)).thenReturn((Object)FIRST_NAME);
        Mockito.when((Object)this.decodedAccessToken.getClaim(LAST_NAME_CLAIM)).thenReturn((Object)LAST_NAME);
        Mockito.when((Object)this.decodedAccessToken.getClaim(EMAIL_CLAIM)).thenReturn((Object)EMAIL);
        this.jitProvisioningHandler = new IdentityServiceJITProvisioningHandler(this.identityServiceFacade, this.personService, this.transactionService, this.identityServiceConfig);
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)USERNAME, (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)FIRST_NAME, (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)LAST_NAME, (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)EMAIL, (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertTrue((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService)).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(JWT_TOKEN, this.expectedMapping);
    }

    @Test
    public void shouldExtractUserInfoFromUserInfoEndpointAndCreateUser() {
        Mockito.when((Object)this.decodedTokenUser.username()).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.decodedTokenUser.firstName()).thenReturn((Object)FIRST_NAME);
        Mockito.when((Object)this.decodedTokenUser.lastName()).thenReturn((Object)LAST_NAME);
        Mockito.when((Object)this.decodedTokenUser.email()).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.personService.personExists(USERNAME)).thenReturn((Object)false);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, this.expectedMapping)).thenReturn(Optional.of(this.decodedTokenUser));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)USERNAME, (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)FIRST_NAME, (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)LAST_NAME, (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)EMAIL, (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertTrue((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService)).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, this.expectedMapping);
    }

    @Test
    public void shouldReturnEmptyOptionalIfUsernameNotExtracted() {
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, this.expectedMapping)).thenReturn(Optional.of(this.decodedTokenUser));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertFalse((boolean)result.isPresent());
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, this.expectedMapping);
    }

    @Test
    public void shouldCallUserInfoEndpointToGetUsername() {
        Mockito.when((Object)this.personService.personExists(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)"");
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, this.expectedMapping)).thenReturn(Optional.of(DecodedTokenUser.validateAndCreate((String)USERNAME, null, null, null)));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)USERNAME, (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, this.expectedMapping);
    }

    @Test
    public void shouldCallUserInfoEndpointToGetUsernameWithProvidedPrincipalAttribute() {
        Mockito.when((Object)this.identityServiceConfig.getPrincipalAttribute()).thenReturn((Object)USERNAME_CLAIM);
        Mockito.when((Object)this.personService.personExists(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim(USERNAME_CLAIM)).thenReturn((Object)"");
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, this.expectedMapping)).thenReturn(Optional.of(DecodedTokenUser.validateAndCreate((String)USERNAME, null, null, null)));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)USERNAME, (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, this.expectedMapping);
    }

    @Test
    public void shouldNotCallUserInfoEndpointIfTokenIsNullOrEmpty() {
        this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(null);
        this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded("");
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).decodeToken(null);
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).decodeToken("");
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(null, this.expectedMapping);
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(null, this.expectedMapping);
    }
}

