/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.invitation.site.InviteSender;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ModelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.surf.util.URLEncoder;

public class InviteNominatedSender
extends InviteSender {
    private static final Log logger = LogFactory.getLog(InviteNominatedSender.class);
    public static final String WF_INSTANCE_ID = "wf_instanceId";
    public static final String WF_PACKAGE = "wf_package";
    public static final String SITE_LEAVE_HASH = "#leavesite";
    private static final String SITE_DASHBOARD_ENDPOINT_PATTERN = "/page/site/{0}/dashboard";
    private static final List<String> INVITE_NOMINATED_EXPECTED_PROPERTIES = Arrays.asList("inwf_inviteeUserName", "inwf_resourceName", "inwf_inviterUserName", "inwf_inviteeUserName", "inwf_inviteeRole", "inwf_inviteeGenPassword", "inwf_resourceName", "inwf_inviteTicket", "inwf_serverPath", "inwf_acceptUrl", "inwf_rejectUrl", "wf_instanceId", "wf_package");

    public InviteNominatedSender(ServiceRegistry services, Repository repository, MessageService messageService) {
        super(services, repository, messageService);
    }

    public void sendMail(Map<String, String> properties) {
        this.sendMail("app:company_home/app:dictionary/app:email_templates/cm:invite/cm:invite-email.html.ftl", "invitation.invitesender.email.subject", properties);
    }

    @Override
    public void sendMail(String emailTemplateXpath, String emailSubjectKey, Map<String, String> properties) {
        this.checkProperties(properties);
        ParameterCheck.mandatory((String)"Properties", properties);
        NodeRef inviter = this.personService.getPerson(properties.get("inwf_inviterUserName"));
        String inviteeName = properties.get("inwf_inviteeUserName");
        NodeRef invitee = this.personService.getPerson(inviteeName);
        Action mail = this.actionService.createAction("mail");
        mail.setParameterValue("from", (Serializable)((Object)this.getEmail(inviter)));
        String recipient = this.getEmail(invitee);
        if (StringUtils.isEmpty((CharSequence)recipient)) {
            logger.warn((Object)"Cannot send invitation: Invitee user account does not have email");
            return;
        }
        mail.setParameterValue("to", (Serializable)((Object)recipient));
        mail.setParameterValue("subject", (Serializable)((Object)emailSubjectKey));
        mail.setParameterValue("subjectParams", (Serializable)new Object[]{ModelUtil.getProductName(this.repoAdminService), this.getSiteName(properties)});
        mail.setParameterValue("template", (Serializable)this.getEmailTemplateNodeRef(emailTemplateXpath));
        mail.setParameterValue("template_model", (Serializable)((Object)this.buildMailTextModel(properties)));
        mail.setParameterValue("ignore_send_failure", Boolean.valueOf(true));
        this.actionService.executeAction(mail, this.getWorkflowPackage(properties));
    }

    @Override
    protected Map<String, Serializable> buildMailTextModel(Map<String, String> properties) {
        NodeRef inviter = this.personService.getPerson(properties.get("inwf_inviterUserName"));
        NodeRef invitee = this.personService.getPerson(properties.get("inwf_inviteeUserName"));
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("companyhome", (Serializable)this.repository.getCompanyHome());
        model.put("userhome", (Serializable)this.repository.getUserHome(this.repository.getPerson()));
        model.put("productName", (Serializable)((Object)ModelUtil.getProductName(this.repoAdminService)));
        Map<String, String> args = this.buildArgs(properties, inviter, invitee);
        model.put("args", (Serializable)((Object)args));
        return model;
    }

    private Map<String, String> buildArgs(Map<String, String> properties, NodeRef inviter, NodeRef invitee) {
        String params = this.buildUrlParamString(properties);
        String acceptLink = this.makeLink(properties.get("inwf_serverPath"), properties.get("inwf_acceptUrl"), params, null);
        String rejectLink = this.makeLink(properties.get("inwf_serverPath"), properties.get("inwf_rejectUrl"), params, null);
        String siteDashboardEndpoint = this.getSiteDashboardEndpoint(properties);
        String siteDashboardLink = this.makeLink(properties.get("inwf_serverPath"), siteDashboardEndpoint, null, null);
        String siteLeaveLink = this.makeLink(properties.get("inwf_serverPath"), siteDashboardEndpoint, null, SITE_LEAVE_HASH);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("inviteePersonRef", invitee.toString());
        args.put("inviterPersonRef", inviter.toString());
        args.put("siteName", this.getSiteName(properties));
        args.put("inviteeSiteRole", this.getRoleName(properties));
        args.put("inviteeUserName", properties.get("inwf_inviteeUserName"));
        args.put("inviteeGenPassword", properties.get("inwf_inviteeGenPassword"));
        args.put("acceptLink", acceptLink);
        args.put("rejectLink", rejectLink);
        args.put("siteDashboardLink", siteDashboardLink);
        args.put("siteLeaveLink", siteLeaveLink);
        return args;
    }

    protected String makeLink(String location, String endpoint, String queryParams, String hashParam) {
        location = ((String)location).endsWith("/") ? location : (String)location + "/";
        String string = endpoint = endpoint.startsWith("/") ? endpoint.substring(1) : endpoint;
        queryParams = queryParams != null ? (((String)queryParams).startsWith("?") ? queryParams : "?" + (String)queryParams) : "";
        hashParam = hashParam != null ? (((String)hashParam).startsWith("#") ? hashParam : "#" + (String)hashParam) : "";
        return (String)location + endpoint + (String)queryParams + (String)hashParam;
    }

    private String getRoleName(Map<String, String> properties) {
        String roleName = properties.get("inwf_inviteeRole");
        String role = this.messageService.getMessage("invitation.invitesender.email.role." + roleName);
        if (role == null) {
            role = roleName;
        }
        return role;
    }

    private String getEmail(NodeRef person) {
        return (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
    }

    private NodeRef getWorkflowPackage(Map<String, String> properties) {
        String packageRef = properties.get(WF_PACKAGE);
        return new NodeRef(packageRef);
    }

    private String buildUrlParamString(Map<String, String> properties) {
        StringBuilder params = new StringBuilder("?inviteId=");
        params.append(properties.get(WF_INSTANCE_ID));
        params.append("&inviteeUserName=");
        params.append(URLEncoder.encode((String)properties.get("inwf_inviteeUserName")));
        params.append("&siteShortName=");
        params.append(properties.get("inwf_resourceName"));
        params.append("&inviteTicket=");
        params.append(properties.get("inwf_inviteTicket"));
        return params.toString();
    }

    private String getSiteDashboardEndpoint(Map<String, String> properties) {
        String siteName = properties.get("inwf_resourceName");
        return MessageFormat.format(SITE_DASHBOARD_ENDPOINT_PATTERN, siteName);
    }

    @Override
    public List<String> getRequiredProperties() {
        return INVITE_NOMINATED_EXPECTED_PROPERTIES;
    }

    @Override
    protected String getWorkflowPropForSiteName() {
        return "inwf_resourceName";
    }
}

