/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.cache.SimpleCache;
import org.springframework.beans.factory.BeanNameAware;

public final class DefaultSimpleCache<K extends Serializable, V>
implements SimpleCache<K, V>,
BeanNameAware {
    private static final int DEFAULT_CAPACITY = Integer.MAX_VALUE;
    private Cache<K, AbstractMap.SimpleImmutableEntry<K, V>> cache;
    private String cacheName;
    private final int maxItems;
    private final boolean useMaxItems;
    private final int ttlSecs;
    private final int maxIdleSecs;

    public DefaultSimpleCache(int maxItems, boolean useMaxItems, int ttlSecs, int maxIdleSecs, String cacheName) {
        if (maxItems == 0) {
            maxItems = Integer.MAX_VALUE;
        } else if (maxItems < 0) {
            throw new IllegalArgumentException("maxItems may not be negative, but was " + maxItems);
        }
        this.maxItems = maxItems;
        this.useMaxItems = useMaxItems;
        this.ttlSecs = ttlSecs;
        this.maxIdleSecs = maxIdleSecs;
        this.setBeanName(cacheName);
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (useMaxItems) {
            builder.maximumSize((long)maxItems);
        }
        if (ttlSecs > 0) {
            builder.expireAfterWrite((long)ttlSecs, TimeUnit.SECONDS);
        }
        if (maxIdleSecs > 0) {
            builder.expireAfterAccess((long)maxIdleSecs, TimeUnit.SECONDS);
        }
        builder.concurrencyLevel(32);
        this.cache = builder.build();
    }

    public DefaultSimpleCache(int maxItems, String cacheName) {
        this(maxItems, true, 0, 0, cacheName);
    }

    public DefaultSimpleCache() {
        this(0, false, 0, 0, null);
    }

    public boolean contains(K key) {
        return this.cache.asMap().containsKey(key);
    }

    public Collection<K> getKeys() {
        return this.cache.asMap().keySet();
    }

    public V get(K key) {
        AbstractMap.SimpleImmutableEntry kvp = (AbstractMap.SimpleImmutableEntry)this.cache.getIfPresent(key);
        if (kvp == null) {
            return null;
        }
        return kvp.getValue();
    }

    public void put(K key, V value) {
        this.putAndCheckUpdate(key, value);
    }

    public boolean putAndCheckUpdate(K key, V value) {
        AbstractMap.SimpleImmutableEntry<K, V> kvp = new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        AbstractMap.SimpleImmutableEntry<K, V> priorKVP = this.cache.asMap().put(key, kvp);
        return priorKVP != null && !priorKVP.equals(kvp);
    }

    public void remove(K key) {
        this.cache.invalidate(key);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public String toString() {
        return "DefaultSimpleCache[maxItems=" + this.maxItems + ", useMaxItems=" + this.useMaxItems + ", cacheName=" + this.cacheName + "]";
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public boolean isUseMaxItems() {
        return this.useMaxItems;
    }

    public int getTTLSecs() {
        return this.ttlSecs;
    }

    public int getMaxIdleSecs() {
        return this.maxIdleSecs;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setBeanName(String cacheName) {
        this.cacheName = cacheName;
    }
}

