/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.script;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.action.script.ScriptExecutionDetails;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ExecutionDetails;
import org.alfresco.service.cmr.action.ExecutionSummary;

public class ScriptActionTrackingService
extends BaseScopableProcessorExtension {
    private ServiceRegistry serviceRegistry;
    private ActionTrackingService actionTrackingService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setActionTrackingService(ActionTrackingService actionTrackingService) {
        this.actionTrackingService = actionTrackingService;
    }

    public void requestActionCancellation(ScriptExecutionDetails action) {
        this.actionTrackingService.requestActionCancellation(action.getExecutionDetails().getExecutionSummary());
    }

    public ScriptExecutionDetails[] getAllExecutingActions() {
        List<ExecutionSummary> running = this.actionTrackingService.getAllExecutingActions();
        return this.toDetails(running);
    }

    public ScriptExecutionDetails[] getExecutingActions(String type) {
        List<ExecutionSummary> running = this.actionTrackingService.getExecutingActions(type);
        return this.toDetails(running);
    }

    public ScriptExecutionDetails[] getExecutingActions(Action action) {
        List<ExecutionSummary> running = this.actionTrackingService.getExecutingActions(action);
        return this.toDetails(running);
    }

    private ScriptExecutionDetails[] toDetails(List<ExecutionSummary> running) {
        ArrayList<ScriptExecutionDetails> details = new ArrayList<ScriptExecutionDetails>();
        for (ExecutionSummary summary : running) {
            ExecutionDetails detail = this.actionTrackingService.getExecutionDetails(summary);
            if (detail == null) continue;
            details.add(new ScriptExecutionDetails(detail, this.serviceRegistry));
        }
        return details.toArray(new ScriptExecutionDetails[details.size()]);
    }
}

