/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import jakarta.transaction.UserTransaction;
import java.util.Random;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionAwareSingleton;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.Before;
import org.junit.Test;

public class TransactionAwareSingletonTest
extends BaseSpringTest {
    private static Random rand = new Random();
    private TransactionAwareSingleton<Integer> singleton = new TransactionAwareSingleton();
    private static final Integer INTEGER_ONE = 1;
    private static final Integer INTEGER_TWO = 2;
    private TransactionService transactionService;
    private static final int THREAD_COUNT = 20;

    @Before
    public void setUp() throws Exception {
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
    }

    @Test
    public void testCommit() throws Throwable {
        UserTransaction txn = this.transactionService.getUserTransaction();
        try {
            txn.begin();
            this.singleton.put((Object)INTEGER_ONE);
            this.check(INTEGER_ONE, true);
            this.check(null, false);
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {}
            throw e;
        }
        this.check(INTEGER_ONE, true);
        this.check(INTEGER_ONE, false);
    }

    @Test
    public void testRollback() throws Throwable {
        UserTransaction txn = this.transactionService.getUserTransaction();
        try {
            txn.begin();
            this.singleton.put((Object)INTEGER_TWO);
            this.check(INTEGER_TWO, true);
            this.check(null, false);
            txn.rollback();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {}
            throw e;
        }
        this.check(null, true);
        this.check(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Test
    public void testThreadsCommit() throws Throwable {
        threads = new TestThread[20];
        i = 0;
        while (i < 20) {
            thread = new TestThread(true);
            thread.start();
            threads[i] = thread;
            ++i;
        }
        i = 0;
        ** GOTO lbl26
        {
            var3_3 = this;
            synchronized (var3_3) {
                try {
                    this.wait(20L);
                }
                catch (Throwable v0) {}
            }
            do {
                if (!threads[i].finished) continue block6;
                if (threads[i].error != null) {
                    throw threads[i].error;
                }
                ++i;
lbl26:
                // 2 sources

            } while (i < 20);
        }
    }

    @Test
    public void testThreadsRollback() throws Throwable {
        TestThread[] threads = new TestThread[20];
        int i = 0;
        while (i < 20) {
            TestThread thread = new TestThread(false);
            thread.start();
            threads[i] = thread;
            ++i;
        }
    }

    private void check(final Integer expected, boolean inTransaction) {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                Integer actual = (Integer)TransactionAwareSingletonTest.this.singleton.get();
                if (expected == null) {
                    TransactionAwareSingletonTest.assertNull((String)("Expected null but got " + String.valueOf(actual)), (Object)actual);
                } else {
                    TransactionAwareSingletonTest.assertTrue((String)("Values don't match: " + String.valueOf(expected) + " != " + String.valueOf(actual)), (boolean)actual.equals(expected));
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkWork, false, !inTransaction);
    }

    private class TestThread
    extends Thread {
        private boolean finished = false;
        private Throwable error;
        private boolean commit;
        private Integer value = (int)System.nanoTime();

        public TestThread(boolean commit) {
            this.commit = commit;
        }

        @Override
        public synchronized void run() {
            UserTransaction txn = TransactionAwareSingletonTest.this.transactionService.getUserTransaction();
            try {
                txn.begin();
                TransactionAwareSingletonTest.this.singleton.put((Object)this.value);
                try {
                    this.wait((long)(rand.nextDouble() * 1000.0) + 1L);
                }
                catch (InterruptedException interruptedException) {}
                TransactionAwareSingletonTest.this.check(this.value, true);
                if (this.commit) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (Throwable e) {
                try {
                    txn.rollback();
                }
                catch (Throwable throwable) {}
                this.error = e;
            }
            if (!this.commit) {
                try {
                    TransactionAwareSingletonTest.this.check(null, false);
                }
                catch (Throwable e) {
                    this.error = e;
                }
            }
            this.finished = true;
        }
    }
}

