/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentExistsException;
import org.alfresco.repo.content.ContentLimitProvider;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public abstract class AbstractContentStore
implements ContentStore {
    private static Log logger = LogFactory.getLog(AbstractContentStore.class);
    private static final int PROTOCOL_DELIMETER_LENGTH = "://".length();
    protected ContentLimitProvider contentLimitProvider = new ContentLimitProvider.NoLimitProvider();

    public static final boolean isValidContentUrl(String contentUrl) {
        if (contentUrl == null) {
            return false;
        }
        int index = contentUrl.indexOf("://");
        if (index <= 0) {
            return false;
        }
        return contentUrl.length() > index + PROTOCOL_DELIMETER_LENGTH;
    }

    public void setContentLimitProvider(ContentLimitProvider contentLimitProvider) {
        this.contentLimitProvider = contentLimitProvider;
    }

    protected Pair<String, String> getContentUrlParts(String contentUrl) {
        if (contentUrl == null) {
            throw new IllegalArgumentException("The contentUrl may not be null");
        }
        int index = contentUrl.indexOf("://");
        if (index <= 0) {
            throw new UnsupportedContentUrlException(this, contentUrl);
        }
        String protocol = contentUrl.substring(0, index);
        String identifier = contentUrl.substring(index + PROTOCOL_DELIMETER_LENGTH, contentUrl.length());
        if (identifier.length() == 0) {
            throw new UnsupportedContentUrlException(this, contentUrl);
        }
        return new Pair((Object)protocol, (Object)identifier);
    }

    public boolean isContentUrlSupported(String contentUrl) {
        try {
            this.getReader(contentUrl);
            return true;
        }
        catch (UnsupportedContentUrlException unsupportedContentUrlException) {
            return false;
        }
    }

    public boolean delete(String contentUrl) {
        throw new UnsupportedOperationException();
    }

    protected ContentWriter getWriterInternal(ContentReader existingContentReader, String newContentUrl) {
        throw new UnsupportedOperationException("Override getWriterInternal (preferred) or getWriter");
    }

    public ContentWriter getWriter(ContentContext context) {
        ContentReader existingContentReader = context.getExistingContentReader();
        String contentUrl = context.getContentUrl();
        if (!this.isWriteSupported()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Write requests are not supported for this store:\n   Store:   " + String.valueOf(this) + "\n   Context: " + String.valueOf(context)));
            }
            throw new UnsupportedOperationException("Write operations are not supported by this store: " + String.valueOf(this));
        }
        if (contentUrl != null) {
            if (!this.isContentUrlSupported(contentUrl)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Specific writer content URL is unsupported: \n   Store:   " + String.valueOf(this) + "\n   Context: " + String.valueOf(context)));
                }
                throw new UnsupportedContentUrlException(this, contentUrl);
            }
            if (this.exists(contentUrl)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The content location is already used: \n   Store:   " + String.valueOf(this) + "\n   Context: " + String.valueOf(context)));
                }
                throw new ContentExistsException(this, contentUrl);
            }
        }
        ContentWriter writer = this.getWriterInternal(existingContentReader, contentUrl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched new writer: \n   Store:   " + String.valueOf(this) + "\n   Context: " + String.valueOf(context) + "\n   Writer:  " + String.valueOf(writer)));
        }
        return writer;
    }

    public boolean exists(String contentUrl) {
        ContentReader reader = this.getReader(contentUrl);
        return reader.exists();
    }

    public long getSpaceFree() {
        return -1L;
    }

    public long getSpaceTotal() {
        return -1L;
    }

    public String getRootLocation() {
        return ".";
    }
}

