/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

public class AdminUserPatch
extends AbstractPatch
implements InitializingBean {
    private static final String MSG_START = "patch.updateAdminUserWhenDefault.start";
    private static final String MSG_RESULT = "patch.updateAdminUserWhenDefault.result";
    private static final String MSG_NO_ACTION = "patch.updateAdminUserWhenDefault.noaction";
    private static final Log logger = LogFactory.getLog(AdminUserPatch.class);
    public static String DEFAULT_SHA = "f378d5d7b947d5c26f478e21819e7ec3a6668c8149b050d086c64447bc40173b";
    private ChildApplicationContextManager authenticationContextManager;
    private RepositoryAuthenticationDao authenticationDao;

    public void setAuthenticationContextManager(ChildApplicationContextManager authenticationContextManager) {
        this.authenticationContextManager = authenticationContextManager;
    }

    @Override
    protected String applyInternal() throws Exception {
        Map userProperties;
        String sha256;
        String adminUsername;
        NodeRef userNodeRef;
        StringBuilder result = new StringBuilder(I18NUtil.getMessage((String)MSG_START));
        if (this.authenticationDao != null && (userNodeRef = this.authenticationDao.getUserOrNull(adminUsername = AuthenticationUtil.getAdminUserName())) != null && DEFAULT_SHA.equals(sha256 = (String)(userProperties = this.nodeService.getProperties(userNodeRef)).get(ContentModel.PROP_PASSWORD_SHA256))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing password sha256 hash for user: " + adminUsername));
            }
            this.nodeService.removeProperty(userNodeRef, ContentModel.PROP_PASSWORD_SHA256);
            result.append(I18NUtil.getMessage((String)MSG_RESULT, (Object[])new Object[]{adminUsername}));
        }
        return result.toString();
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"authenticationContextManager", (Object)this.authenticationContextManager);
        for (String contextName : this.authenticationContextManager.getInstanceIds()) {
            ApplicationContext ctx = this.authenticationContextManager.getApplicationContext(contextName);
            try {
                this.authenticationDao = (RepositoryAuthenticationDao)ctx.getBean(RepositoryAuthenticationDao.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
    }
}

