/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import net.sf.acegisecurity.AccessDeniedException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.AlfrescoCmisServiceCall;
import org.alfresco.opencmis.CMISNodeInfoImpl;
import org.alfresco.opencmis.CMISRenditionMapping;
import org.alfresco.opencmis.CmisActivityPoster;
import org.alfresco.opencmis.ObjectFilter;
import org.alfresco.opencmis.RangeInputStream;
import org.alfresco.opencmis.dictionary.CMISActionEvaluator;
import org.alfresco.opencmis.dictionary.CMISAllowedActionEnum;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.dictionary.CMISObjectVariant;
import org.alfresco.opencmis.dictionary.CMISPropertyAccessor;
import org.alfresco.opencmis.dictionary.DocumentTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.FolderTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.ItemTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryService;
import org.alfresco.opencmis.search.CMISResultSet;
import org.alfresco.opencmis.search.CMISResultSetColumn;
import org.alfresco.opencmis.search.CMISResultSetRow;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailHelper;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.activities.ActivityInfo;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.sync.events.types.ContentEventImpl;
import org.alfresco.sync.events.types.ContentReadRangeEvent;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.repo.Client;
import org.alfresco.sync.repo.events.EventPreparator;
import org.alfresco.sync.repo.events.EventPublisher;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.util.StringUtils;

public class CMISConnector
implements ApplicationContextAware,
ApplicationListener<ApplicationContextEvent>,
TenantDeployer {
    private static Log logger = LogFactory.getLog(CMISConnector.class);
    private static Map<String, QName> SORT_PROPERTY_MAPPINGS = new HashMap<String, QName>();
    public static final char ID_SEPERATOR = ';';
    public static final char REPLACEMENT_CHAR = '_';
    public static final String ASSOC_ID_PREFIX = "assoc:";
    public static final String PWC_VERSION_LABEL = "pwc";
    public static final String UNVERSIONED_VERSION_LABEL = "1.0";
    public static final String RENDITION_NONE = "cmis:none";
    public static final String CMIS_CHANGELOG_AUDIT_APPLICATION = "CMISChangeLog";
    public static final String ALFRESCO_EXTENSION_NAMESPACE = "http://www.alfresco.org";
    public static final String CMIS_NAMESPACE = "http://docs.oasis-open.org/ns/cmis/core/200908/";
    public static final String ASPECTS = "aspects";
    public static final String SET_ASPECTS = "setAspects";
    public static final String APPLIED_ASPECTS = "appliedAspects";
    public static final String ASPECTS_TO_ADD = "aspectsToAdd";
    public static final String ASPECTS_TO_REMOVE = "aspectsToRemove";
    public static final String PROPERTIES = "properties";
    private static final BigInteger TYPES_DEFAULT_MAX_ITEMS;
    private static final BigInteger TYPES_DEFAULT_DEPTH;
    private static final BigInteger OBJECTS_DEFAULT_MAX_ITEMS;
    private static final BigInteger OBJECTS_DEFAULT_DEPTH;
    private static final int CONTENT_CHANGES_DEFAULT_MAX_ITEMS = 10000;
    private static final String QUERY_NAME_OBJECT_ID = "cmis:objectId";
    private static final String QUERY_NAME_OBJECT_TYPE_ID = "cmis:objectTypeId";
    private static final String QUERY_NAME_BASE_TYPE_ID = "cmis:baseTypeId";
    private static final String CMIS_USER = "cmis:user";
    private static final BigInteger maxInt;
    private static final BigInteger minInt;
    private static final BigInteger maxLong;
    private static final BigInteger minLong;
    private ProcessorLifecycle lifecycle = new ProcessorLifecycle();
    private DescriptorService descriptorService;
    private NodeService nodeService;
    private VersionService versionService;
    private CheckOutCheckInService checkOutCheckInService;
    private LockService lockService;
    private ContentService contentService;
    @Deprecated
    private RenditionService renditionService;
    private FileFolderService fileFolderService;
    private TenantAdminService tenantAdminService;
    private TransactionService transactionService;
    private AuthenticationService authenticationService;
    private PermissionService permissionService;
    private ModelDAO permissionModelDao;
    private CMISDictionaryService cmisDictionaryService;
    private CMISDictionaryService cmisDictionaryService11;
    private CMISQueryService cmisQueryService;
    private CMISQueryService cmisQueryService11;
    private MimetypeService mimetypeService;
    private AuditService auditService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private SiteService siteService;
    private ActionService actionService;
    @Deprecated
    private ThumbnailService thumbnailService;
    private ServiceRegistry serviceRegistry;
    private EventPublisher eventPublisher;
    private CmisActivityPoster activityPoster;
    private BehaviourFilter behaviourFilter;
    private HiddenAspect hiddenAspect;
    private StoreRef storeRef;
    private String rootPath;
    private Map<String, List<String>> kindToRenditionNames;
    private SimpleCache<String, Object> singletonCache;
    private final String KEY_CMIS_ROOT_NODEREF = "key.cmisRoot.noderef";
    private final String KEY_CMIS_RENDITION_MAPPING_NODEREF = "key.cmisRenditionMapping.noderef";
    private String proxyUser;
    private boolean openHttpSession = false;
    private BigInteger typesDefaultMaxItems = TYPES_DEFAULT_MAX_ITEMS;
    private BigInteger typesDefaultDepth = TYPES_DEFAULT_DEPTH;
    private BigInteger objectsDefaultMaxItems = OBJECTS_DEFAULT_MAX_ITEMS;
    private BigInteger objectsDefaultDepth = OBJECTS_DEFAULT_DEPTH;
    private int contentChangesDefaultMaxItems = 10000;
    private List<PermissionDefinition> repositoryPermissions;
    private Map<String, PermissionMapping> permissionMappings;
    private ObjectFilter objectFilter;
    private int bulkMaxItems = 1000;
    private int bulkBatchSize = 20;
    private int bulkWorkerThreads = 2;
    private File tmp;

    static {
        SORT_PROPERTY_MAPPINGS.put("cmis:lastModificationDate", ContentModel.PROP_MODIFIED);
        SORT_PROPERTY_MAPPINGS.put("cmis:creationDate", ContentModel.PROP_CREATED);
        TYPES_DEFAULT_MAX_ITEMS = BigInteger.valueOf(50L);
        TYPES_DEFAULT_DEPTH = BigInteger.valueOf(-1L);
        OBJECTS_DEFAULT_MAX_ITEMS = BigInteger.valueOf(200L);
        OBJECTS_DEFAULT_DEPTH = BigInteger.valueOf(10L);
        maxInt = BigInteger.valueOf(Integer.MAX_VALUE);
        minInt = BigInteger.valueOf(Integer.MIN_VALUE);
        maxLong = BigInteger.valueOf(Long.MAX_VALUE);
        minLong = BigInteger.valueOf(Long.MIN_VALUE);
    }

    public void setObjectFilter(ObjectFilter objectFilter) {
        this.objectFilter = objectFilter;
    }

    public void setStore(String store) {
        this.storeRef = new StoreRef(store);
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityPoster(CmisActivityPoster activityPoster) {
        this.activityPoster = activityPoster;
    }

    public CmisActivityPoster getActivityPoster() {
        return this.activityPoster;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public boolean isHidden(NodeRef nodeRef) {
        FileFilterMode.Client client = FileFilterMode.getClient();
        return this.hiddenAspect.getVisibility(client, nodeRef) == HiddenAspect.Visibility.NotVisible;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public BigInteger getTypesDefaultMaxItems() {
        return this.typesDefaultMaxItems;
    }

    public void setTypesDefaultMaxItems(BigInteger typesDefaultMaxItems) {
        this.typesDefaultMaxItems = typesDefaultMaxItems;
    }

    public BigInteger getTypesDefaultDepth() {
        return this.typesDefaultDepth;
    }

    public void setTypesDefaultDepth(BigInteger typesDefaultDepth) {
        this.typesDefaultDepth = typesDefaultDepth;
    }

    public BigInteger getObjectsDefaultMaxItems() {
        return this.objectsDefaultMaxItems;
    }

    public void setObjectsDefaultMaxItems(BigInteger objectsDefaultMaxItems) {
        this.objectsDefaultMaxItems = objectsDefaultMaxItems;
    }

    public BigInteger getObjectsDefaultDepth() {
        return this.objectsDefaultDepth;
    }

    public void setObjectsDefaultDepth(BigInteger objectsDefaultDepth) {
        this.objectsDefaultDepth = objectsDefaultDepth;
    }

    public void setContentChangesDefaultMaxItems(int contentChangesDefaultMaxItems) {
        if (contentChangesDefaultMaxItems < 1) {
            throw new IllegalArgumentException("The default maximum number of content changes to retrieve must be greater than zero.");
        }
        if (contentChangesDefaultMaxItems == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The server cannot return 2147483647 content changes in a request!");
        }
        this.contentChangesDefaultMaxItems = contentChangesDefaultMaxItems;
    }

    public void setRenditionKindMapping(Map<String, List<String>> renditionKinds) {
        this.kindToRenditionNames = renditionKinds;
    }

    public void setOpenHttpSession(boolean openHttpSession) {
        this.openHttpSession = openHttpSession;
    }

    public boolean openHttpSession() {
        return this.openHttpSession;
    }

    @Deprecated
    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public final ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public DescriptorService getDescriptorService() {
        return this.descriptorService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public VersionService getVersionService() {
        return this.versionService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public CheckOutCheckInService getCheckOutCheckInService() {
        return this.checkOutCheckInService;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Deprecated
    public void setrenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setSingletonCache(SimpleCache<String, Object> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPermissionModelDao(ModelDAO permissionModelDao) {
        this.permissionModelDao = permissionModelDao;
    }

    public void setOpenCMISDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void setOpenCMISDictionaryService11(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService11 = cmisDictionaryService;
    }

    public CMISDictionaryService getOpenCMISDictionaryService() {
        CmisVersion cmisVersion = this.getRequestCmisVersion();
        if (cmisVersion.equals((Object)CmisVersion.CMIS_1_0)) {
            return this.cmisDictionaryService;
        }
        return this.cmisDictionaryService11;
    }

    public void setOpenCMISQueryService(CMISQueryService cmisQueryService) {
        this.cmisQueryService = cmisQueryService;
    }

    public void setOpenCMISQueryService11(CMISQueryService cmisQueryService) {
        this.cmisQueryService11 = cmisQueryService;
    }

    public CMISQueryService getOpenCMISQueryService() {
        CmisVersion cmisVersion = this.getRequestCmisVersion();
        if (cmisVersion.equals((Object)CmisVersion.CMIS_1_0)) {
            return this.cmisQueryService;
        }
        return this.cmisQueryService11;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setProxyUser(String proxyUser) {
        throw new UnsupportedOperationException("proxyUser setting not implemented.  Please raise a JIRA request.");
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setBulkMaxItems(int size) {
        this.bulkMaxItems = size;
    }

    public int getBulkMaxItems() {
        return this.bulkMaxItems;
    }

    public void setBulkBatchSize(int size) {
        this.bulkBatchSize = size;
    }

    public int getBulkBatchSize() {
        return this.bulkBatchSize;
    }

    public void setBulkWorkerThreads(int threads) {
        this.bulkWorkerThreads = threads;
    }

    public int getBulkWorkerThreads() {
        return this.bulkWorkerThreads;
    }

    public void setup() {
        File tempDir = TempFileProvider.getTempDir();
        this.tmp = new File(tempDir, "CMISAppend");
        if (!this.tmp.exists() && !this.tmp.mkdir()) {
            throw new AlfrescoRuntimeException("Failed to create CMIS temporary directory");
        }
    }

    public void init() {
        this.tenantAdminService.register(this);
        this.getRenditionMapping();
        this.getRootNodeRef();
        this.repositoryPermissions = this.getRepositoryPermissions();
        this.permissionMappings = this.getPermissionMappings();
    }

    public void destroy() {
        this.singletonCache.remove((Serializable)((Object)"key.cmisRoot.noderef"));
        this.singletonCache.remove((Serializable)((Object)"key.cmisRenditionMapping.noderef"));
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        this.lifecycle.onApplicationEvent((ApplicationEvent)event);
    }

    public Pair<QName, Boolean> getSortProperty(String cmisPropertyName, String direction) {
        QName sortPropName = null;
        Pair sortProp = null;
        PropertyDefinitionWrapper propDef = this.getOpenCMISDictionaryService().findPropertyByQueryName(cmisPropertyName);
        if (propDef != null && (sortPropName = propDef.getPropertyId().equals(QUERY_NAME_BASE_TYPE_ID) ? GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER : propDef.getPropertyAccessor().getMappedProperty()) == null) {
            sortPropName = SORT_PROPERTY_MAPPINGS.get(cmisPropertyName);
        }
        if (sortPropName != null) {
            boolean sortAsc = direction == null ? true : direction.equalsIgnoreCase("asc");
            sortProp = new Pair((Object)sortPropName, (Object)sortAsc);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignore sort property '" + cmisPropertyName + " - mapping not found"));
        }
        return sortProp;
    }

    public void createThumbnails(NodeRef nodeRef, Set<String> thumbnailNames) {
        if (thumbnailNames == null || thumbnailNames.size() == 0) {
            return;
        }
        ThumbnailRegistry registry = this.thumbnailService.getThumbnailRegistry();
        Serializable value = this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
        if (contentData == null) {
            logger.info((Object)"Unable to create thumbnails as there is no content");
            return;
        }
        long size = contentData.getSize();
        String mimeType = contentData.getMimetype();
        for (String thumbnailName : thumbnailNames) {
            ThumbnailDefinition details = registry.getThumbnailDefinition(thumbnailName);
            if (details == null) {
                logger.warn((Object)("The thumbnail name '" + thumbnailName + "' is not registered"));
                continue;
            }
            if (registry.isThumbnailDefinitionAvailable(contentData.getContentUrl(), mimeType, size, nodeRef, details)) {
                org.alfresco.service.cmr.action.Action action = ThumbnailHelper.createCreateThumbnailAction(details, this.serviceRegistry);
                this.actionService.executeAction(action, nodeRef, true, true);
                continue;
            }
            logger.info((Object)("Unable to create thumbnail '" + details.getName() + "' for " + mimeType + " as no transformer is currently available"));
        }
    }

    public void extractMetadata(NodeRef nodeRef) {
        org.alfresco.service.cmr.action.Action action = this.actionService.createAction("extract-metadata");
        action.setExecuteAsynchronously(true);
        this.actionService.executeAction(action, nodeRef, true, true);
    }

    public SiteInfo getSite(NodeRef nodeRef) {
        return this.siteService.getSite(nodeRef);
    }

    public boolean filter(NodeRef nodeRef) {
        return this.objectFilter.filter(nodeRef);
    }

    public boolean disableBehaviour(QName className) {
        boolean wasEnabled = this.behaviourFilter.isEnabled(className);
        if (wasEnabled) {
            this.behaviourFilter.disableBehaviour(className);
        }
        return wasEnabled;
    }

    public boolean enableBehaviour(QName className) {
        boolean isEnabled = this.behaviourFilter.isEnabled(className);
        if (!isEnabled) {
            this.behaviourFilter.enableBehaviour(className);
        }
        return isEnabled;
    }

    public boolean disableBehaviour(QName className, NodeRef nodeRef) {
        boolean wasEnabled = this.behaviourFilter.isEnabled(nodeRef, className);
        if (wasEnabled) {
            this.behaviourFilter.disableBehaviour(nodeRef, className);
        }
        return wasEnabled;
    }

    public boolean enableBehaviour(QName className, NodeRef nodeRef) {
        boolean isEnabled = this.behaviourFilter.isEnabled(nodeRef, className);
        if (!isEnabled) {
            this.behaviourFilter.enableBehaviour(nodeRef, className);
        }
        return isEnabled;
    }

    public StoreRef getRootStoreRef() {
        return this.getRootNodeRef().getStoreRef();
    }

    public void deleteNode(NodeRef nodeRef, boolean postActivity) {
        ActivityInfo activityInfo = null;
        if (postActivity &= !this.hiddenAspect.hasHiddenAspect(nodeRef)) {
            activityInfo = this.activityPoster.getActivityInfo(nodeRef);
        }
        this.getNodeService().deleteNode(nodeRef);
        if (postActivity && activityInfo != null) {
            this.activityPoster.postFileFolderDeleted(activityInfo);
        }
    }

    public RetryingTransactionHelper getRetryingTransactionHelper() {
        return this.transactionService.getRetryingTransactionHelper();
    }

    public NodeRef getRootNodeRef() {
        NodeRef rootNodeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.cmisRoot.noderef"));
        if (rootNodeRef == null) {
            rootNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return CMISConnector.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            NodeRef root = (this).CMISConnector.this.nodeService.getRootNode((this).CMISConnector.this.storeRef);
                            List rootNodes = (this).CMISConnector.this.searchService.selectNodes(root, (this).CMISConnector.this.rootPath, null, (NamespacePrefixResolver)(this).CMISConnector.this.namespaceService, false);
                            if (rootNodes.size() != 1) {
                                throw new CmisRuntimeException("Unable to locate CMIS root path " + (this).CMISConnector.this.rootPath);
                            }
                            return (NodeRef)rootNodes.get(0);
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (rootNodeRef == null) {
                throw new CmisObjectNotFoundException("Root folder path '" + this.rootPath + "' not found!");
            }
            this.singletonCache.put((Serializable)((Object)"key.cmisRoot.noderef"), (Object)rootNodeRef);
        }
        return rootNodeRef;
    }

    public String getName(NodeRef nodeRef) {
        try {
            Serializable name = this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME);
            return name instanceof String ? (String)((Object)name) : null;
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return null;
        }
    }

    public String getCurrentVersionId(String objectId) {
        if (objectId == null) {
            return null;
        }
        int sepIndex = objectId.lastIndexOf(59);
        if (sepIndex > -1) {
            return objectId.substring(0, sepIndex);
        }
        return objectId;
    }

    public CMISNodeInfoImpl createNodeInfo(String objectId) {
        return new CMISNodeInfoImpl(this, objectId);
    }

    public CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef) {
        return this.createNodeInfo(nodeRef, null, null, null, true);
    }

    public CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef, QName nodeType, Map<QName, Serializable> nodeProps, VersionHistory versionHistory, boolean checkExists) {
        return new CMISNodeInfoImpl(this, nodeRef, nodeType, nodeProps, versionHistory, checkExists);
    }

    public CMISNodeInfoImpl createNodeInfo(AssociationRef assocRef) {
        return new CMISNodeInfoImpl(this, assocRef);
    }

    private String getGuid(String id) {
        int idx = id.lastIndexOf("/");
        if (idx != -1) {
            return id.substring(idx + 1);
        }
        return id;
    }

    public String constructObjectId(AssociationRef assocRef, String versionLabel) {
        return this.constructObjectId(assocRef, versionLabel, this.isPublicApi());
    }

    public String constructObjectId(AssociationRef assocRef, String versionLabel, boolean dropStoreRef) {
        StringBuilder sb = new StringBuilder(ASSOC_ID_PREFIX);
        if (dropStoreRef) {
            sb.append(assocRef.getId());
        } else {
            sb.append(assocRef.toString());
        }
        if (versionLabel != null) {
            sb.append(';');
            sb.append(versionLabel);
        }
        return sb.toString();
    }

    public String constructObjectId(String incomingObjectId) {
        return this.constructObjectId(incomingObjectId, null);
    }

    public String constructObjectId(String incomingNodeId, String versionLabel) {
        return this.constructObjectId(incomingNodeId, versionLabel, this.isPublicApi());
    }

    public String constructObjectId(String incomingNodeId, String versionLabel, boolean dropStoreRef) {
        StringBuilder sb = new StringBuilder();
        if (dropStoreRef) {
            sb.append(this.getGuid(incomingNodeId));
        } else {
            sb.append(incomingNodeId);
        }
        if (versionLabel != null) {
            sb.append(';');
            sb.append(versionLabel);
        }
        return sb.toString();
    }

    public void createVersion(NodeRef nodeRef, VersionType versionType, String reason) {
        HashMap<String, Serializable> versionProperties;
        if (this.versionService.getVersionHistory(nodeRef) == null) {
            versionProperties = new HashMap<String, Serializable>(2);
            versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
            versionProperties.put("description", (Serializable)((Object)"Initial version"));
            this.versionService.createVersion(nodeRef, versionProperties);
        }
        versionProperties = new HashMap(2);
        versionProperties.put("versionType", (Serializable)((Object)versionType));
        versionProperties.put("description", (Serializable)((Object)reason));
        this.versionService.createVersion(nodeRef, versionProperties);
    }

    public CmisVersion getRequestCmisVersion() {
        CallContext callContext = AlfrescoCmisServiceCall.get();
        CmisVersion cmisVersion = callContext != null ? callContext.getCmisVersion() : CmisVersion.CMIS_1_0;
        return cmisVersion;
    }

    private boolean isPublicApi() {
        boolean isPublicApi = false;
        CallContext callContext = AlfrescoCmisServiceCall.get();
        if (callContext != null) {
            String value = (String)callContext.get("isPublicApi");
            isPublicApi = value == null ? false : Boolean.parseBoolean(value);
        }
        return isPublicApi;
    }

    public String constructObjectId(NodeRef incomingNodeRef, String versionLabel) {
        return this.constructObjectId(incomingNodeRef, versionLabel, this.isPublicApi());
    }

    public String constructObjectId(NodeRef incomingNodeRef, String versionLabel, boolean dropStoreRef) {
        StringBuilder sb = new StringBuilder();
        sb.append(dropStoreRef ? incomingNodeRef.getId() : incomingNodeRef.toString());
        if (versionLabel != null) {
            sb.append(';');
            sb.append(versionLabel);
        }
        return sb.toString();
    }

    public String createObjectId(NodeRef nodeRef) {
        return this.createObjectId(nodeRef, this.isPublicApi());
    }

    public String createObjectId(NodeRef nodeRef, boolean dropStoreRef) {
        QName typeQName = this.nodeService.getType(nodeRef);
        TypeDefinitionWrapper type = this.getOpenCMISDictionaryService().findNodeType(typeQName);
        if (type instanceof ItemTypeDefinitionWrapper) {
            return this.constructObjectId(nodeRef, null);
        }
        if (type instanceof FolderTypeDefintionWrapper) {
            return this.constructObjectId(nodeRef, null, dropStoreRef);
        }
        Object versionLabel = this.getNodeService().getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL);
        if (versionLabel == null) {
            versionLabel = UNVERSIONED_VERSION_LABEL;
        }
        return this.constructObjectId(nodeRef, (String)versionLabel, dropStoreRef);
    }

    private boolean isFolder(NodeRef nodeRef) {
        return this.getType(nodeRef) instanceof FolderTypeDefintionWrapper;
    }

    public TypeDefinitionWrapper getType(NodeRef nodeRef) {
        try {
            QName typeQName = this.nodeService.getType(nodeRef);
            return this.getOpenCMISDictionaryService().findNodeType(typeQName);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return null;
        }
    }

    public TypeDefinitionWrapper getType(AssociationRef assocRef) {
        QName typeQName = assocRef.getTypeQName();
        return this.getOpenCMISDictionaryService().findAssocType(typeQName);
    }

    public TypeDefinitionWrapper getType(String cmisTypeId) {
        return this.getOpenCMISDictionaryService().findType(cmisTypeId);
    }

    public TypeDefinitionWrapper getTypeForCreate(String cmisTypeId, BaseTypeId baseTypeId) {
        TypeDefinitionWrapper type = this.getType(cmisTypeId);
        if (type == null || type.getBaseTypeId() != baseTypeId) {
            switch (baseTypeId) {
                case CMIS_DOCUMENT: {
                    throw new CmisConstraintException("Type is not a document type!");
                }
                case CMIS_FOLDER: {
                    throw new CmisConstraintException("Type is not a folder type!");
                }
                case CMIS_RELATIONSHIP: {
                    throw new CmisConstraintException("Type is not a relationship type!");
                }
                case CMIS_POLICY: {
                    throw new CmisConstraintException("Type is not a policy type!");
                }
                case CMIS_ITEM: {
                    throw new CmisConstraintException("Type is not an item type!");
                }
            }
        }
        if (!type.getTypeDefinition(false).isCreatable().booleanValue()) {
            throw new CmisConstraintException("Type is not creatable!");
        }
        return type;
    }

    public void applyVersioningState(NodeRef nodeRef, VersioningState versioningState) {
        if (versioningState == VersioningState.CHECKEDOUT) {
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
            }
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT, null);
            this.getCheckOutCheckInService().checkout(nodeRef);
        } else if (versioningState == VersioningState.MAJOR || versioningState == VersioningState.MINOR) {
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
            }
            HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(5);
            versionProperties.put("versionType", (Serializable)((Object)(versioningState == VersioningState.MAJOR ? VersionType.MAJOR : VersionType.MINOR)));
            versionProperties.put("description", (Serializable)((Object)"Initial Version"));
            this.versionService.createVersion(nodeRef, versionProperties);
        }
    }

    public void checkChildObjectType(CMISNodeInfo folderInfo, String childType) {
        TypeDefinitionWrapper targetType = folderInfo.getType();
        PropertyDefinitionWrapper allowableChildObjectTypeProperty = targetType.getPropertyById("cmis:allowedChildObjectTypeIds");
        List childTypes = (List)((Object)allowableChildObjectTypeProperty.getPropertyAccessor().getValue(folderInfo));
        if (childTypes == null || childTypes.isEmpty()) {
            return;
        }
        if (!childTypes.contains(childType)) {
            throw new CmisConstraintException("Objects of type '" + childType + "' cannot be added to this folder!");
        }
    }

    public ObjectData createCMISObject(CMISNodeInfo info, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        if (info.getType() == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        Properties nodeProps = info.isRelationship() ? this.getAssocProperties(info, filter) : this.getNodeProperties(info, filter);
        return this.createCMISObjectImpl(info, nodeProps, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
    }

    private ObjectData createCMISObjectImpl(final CMISNodeInfo info, Properties nodeProps, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        final ObjectDataImpl result = new ObjectDataImpl();
        if (includeAllowableActions) {
            result.setAllowableActions(this.getAllowableActions(info));
        }
        if (includePolicyIds) {
            result.setPolicyIds((PolicyIdList)new PolicyIdListImpl());
        }
        if (info.isRelationship()) {
            result.setProperties(this.getAssocProperties(info, filter));
            if (includeAcl) {
                result.setAcl((Acl)new AccessControlListImpl(Collections.EMPTY_LIST));
                result.setIsExactAcl(Boolean.FALSE);
            }
        } else {
            List<CmisExtensionElement> extensions;
            result.setProperties(nodeProps);
            if (includeRelationships != IncludeRelationships.NONE) {
                result.setRelationships(this.getRelationships(info.getNodeRef(), includeRelationships));
            }
            if (!RENDITION_NONE.equals(renditionFilter)) {
                List<RenditionData> renditions = this.getRenditions(info.getNodeRef(), renditionFilter, null, null);
                if (renditions != null && !renditions.isEmpty()) {
                    result.setRenditions(renditions);
                } else {
                    result.setRenditions(Collections.EMPTY_LIST);
                }
            }
            if (includeAcl) {
                AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        Acl acl = CMISConnector.this.getACL(info.getCurrentNodeNodeRef(), false);
                        if (acl != null) {
                            result.setAcl(acl);
                            result.setIsExactAcl(acl.isExact());
                        }
                        return null;
                    }
                });
            }
            if (!(extensions = this.getAspectExtensions(info, filter, result.getProperties().getProperties().keySet())).isEmpty()) {
                result.getProperties().setExtensions(Collections.singletonList(new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, ASPECTS, null, extensions)));
            }
        }
        return result;
    }

    public String getPath(NodeRef nodeRef) {
        try {
            Path path = this.nodeService.getPath(nodeRef);
            NodeRef rootNode = this.getRootNodeRef();
            int i = 0;
            while (i < path.size()) {
                ChildAssociationRef assocRef;
                NodeRef node;
                Path.Element element = path.get(i);
                if (element instanceof Path.ChildAssocElement && (node = (assocRef = ((Path.ChildAssocElement)element).getRef()).getChildRef()).equals((Object)rootNode)) break;
                ++i;
            }
            StringBuilder displayPath = new StringBuilder(64);
            if (path.size() - i == 1) {
                displayPath.append("/");
            } else {
                ++i;
                while (i < path.size()) {
                    Path.Element element = path.get(i);
                    if (element instanceof Path.ChildAssocElement) {
                        ChildAssociationRef assocRef = ((Path.ChildAssocElement)element).getRef();
                        NodeRef node = assocRef.getChildRef();
                        displayPath.append("/");
                        displayPath.append(this.nodeService.getProperty(node, ContentModel.PROP_NAME));
                    }
                    ++i;
                }
            }
            return displayPath.toString();
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return null;
        }
    }

    public ContentStream getContentStream(CMISNodeInfo info, String streamId, BigInteger offset, BigInteger length) {
        TypeDefinitionWrapper type = info.getType();
        this.checkDocumentTypeForContent(type);
        ContentStreamImpl result = new ContentStreamImpl();
        result.setFileName(info.getName());
        NodeRef streamNodeRef = info.getNodeRef();
        if (streamId != null && streamId.length() > 0) {
            CMISNodeInfoImpl streamInfo = this.createNodeInfo(streamId);
            if (!streamInfo.isVariant(CMISObjectVariant.CURRENT_VERSION)) {
                throw new CmisInvalidArgumentException("Stream id is invalid: " + streamId + ", expected variant " + String.valueOf(CMISObjectVariant.CURRENT_VERSION) + ", got variant " + String.valueOf(streamInfo.getObjectVariant()));
            }
            streamNodeRef = streamInfo.getNodeRef();
            type = streamInfo.getType();
            this.checkDocumentTypeForContent(type);
        }
        try {
            ContentReader contentReader = this.contentService.getReader(streamNodeRef, ContentModel.PROP_CONTENT);
            if (contentReader == null) {
                throw new CmisConstraintException("Document has no content!");
            }
            result.setMimeType(contentReader.getMimetype());
            long contentSize = contentReader.getSize();
            if (offset == null && length == null) {
                result.setStream(contentReader.getContentInputStream());
                result.setLength(BigInteger.valueOf(contentSize));
                this.publishReadEvent(streamNodeRef, info.getName(), result.getMimeType(), contentSize, contentReader.getEncoding(), null);
            } else {
                long len;
                long off = offset == null ? 0L : offset.longValue();
                long l = len = length == null ? contentSize : length.longValue();
                if (off + len > contentSize) {
                    len = contentReader.getSize() - off;
                }
                result.setStream((InputStream)new RangeInputStream(contentReader.getContentInputStream(), off, len));
                result.setLength(BigInteger.valueOf(len));
                this.publishReadEvent(streamNodeRef, info.getName(), result.getMimeType(), contentSize, contentReader.getEncoding(), off + " - " + len);
            }
        }
        catch (Exception e) {
            if (e instanceof CmisBaseException) {
                throw (CmisBaseException)e;
            }
            StringBuilder msg = new StringBuilder("Failed to retrieve content: " + e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null) {
                msg.append(", ");
                msg.append(cause.getMessage());
            }
            throw new CmisRuntimeException(msg.toString(), (Throwable)e);
        }
        return result;
    }

    protected void publishReadEvent(final NodeRef nodeRef, final String name, final String mimeType, final long contentSize, final String encoding, final String range) {
        final QName nodeType = nodeRef == null ? null : this.nodeService.getType(nodeRef);
        this.eventPublisher.publishEvent(new EventPreparator(){

            public Event prepareEvent(String user, String networkId, String transactionId) {
                if (StringUtils.hasText((String)range)) {
                    return new ContentReadRangeEvent(user, networkId, transactionId, nodeRef.getId(), null, nodeType.toString(), Client.asType((Client.ClientType)Client.ClientType.cmis), name, mimeType, contentSize, encoding, range);
                }
                return new ContentEventImpl("content.download", user, networkId, transactionId, nodeRef.getId(), null, nodeType.toString(), Client.asType((Client.ClientType)Client.ClientType.cmis), name, mimeType, contentSize, encoding);
            }
        });
    }

    public void appendContent(CMISNodeInfo nodeInfo, ContentStream contentStream, boolean isLastChunk) throws IOException {
        ContentReader reader;
        NodeRef nodeRef = nodeInfo.getNodeRef();
        this.disableBehaviour(ContentModel.ASPECT_VERSIONABLE, nodeRef);
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CMIS_UPDATE_CONTEXT)) {
            HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
            props.put(ContentModel.PROP_GOT_FIRST_CHUNK, true);
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_CMIS_UPDATE_CONTEXT, props);
        }
        InputStream existingContentInput = (reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT)) != null ? reader.getContentInputStream() : null;
        InputStream input = contentStream.getStream();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        BufferedOutputStream out = new BufferedOutputStream(writer.getContentOutputStream());
        InputStream in = null;
        in = existingContentInput != null ? new SequenceInputStream(existingContentInput, input) : input;
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
            if (isLastChunk) {
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CMIS_UPDATE_CONTEXT);
                this.getActivityPoster().postFileFolderUpdated(nodeInfo.isFolder(), nodeRef);
                this.createVersion(nodeRef, VersionType.MINOR, "Appended content stream");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
            this.enableBehaviour(ContentModel.ASPECT_VERSIONABLE, nodeRef);
        }
    }

    private void checkDocumentTypeForContent(TypeDefinitionWrapper type) {
        if (type == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        if (!(type instanceof DocumentTypeDefinitionWrapper)) {
            throw new CmisStreamNotSupportedException("Object is not a document!");
        }
        if (((DocumentTypeDefinition)type.getTypeDefinition(false)).getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED) {
            throw new CmisConstraintException("Document cannot have content!");
        }
    }

    private void addAspectProperties(CMISNodeInfo info, String filter, PropertiesImpl result) {
        if (this.getRequestCmisVersion().equals((Object)CmisVersion.CMIS_1_1)) {
            HashSet<String> propertyIds = new HashSet<String>();
            Set<String> filterSet = this.splitFilter(filter);
            Set aspects = info.getNodeAspects();
            for (QName aspect : aspects) {
                TypeDefinitionWrapper aspectType = this.getOpenCMISDictionaryService().findNodeType(aspect);
                if (aspectType == null) continue;
                for (PropertyDefinitionWrapper propDef : aspectType.getProperties()) {
                    if (propertyIds.contains(propDef.getPropertyId()) || filterSet != null && !filterSet.contains(propDef.getPropertyDefinition().getQueryName())) continue;
                    Serializable value = propDef.getPropertyAccessor().getValue(info);
                    result.addProperty(this.getProperty(propDef.getPropertyDefinition().getPropertyType(), propDef, value));
                    propertyIds.add(propDef.getPropertyId());
                }
            }
        }
    }

    public Properties getNodeProperties(CMISNodeInfo info, String filter) {
        PropertiesImpl result = new PropertiesImpl();
        Set<String> filterSet = this.splitFilter(filter);
        for (PropertyDefinitionWrapper propDef : info.getType().getProperties()) {
            if (!propDef.getPropertyId().equals(QUERY_NAME_OBJECT_ID) && filterSet != null && !filterSet.contains(propDef.getPropertyDefinition().getQueryName())) continue;
            Serializable value = propDef.getPropertyAccessor().getValue(info);
            result.addProperty(this.getProperty(propDef.getPropertyDefinition().getPropertyType(), propDef, value));
        }
        this.addAspectProperties(info, filter, result);
        return result;
    }

    public Properties getAssocProperties(CMISNodeInfo info, String filter) {
        PropertiesImpl result = new PropertiesImpl();
        Set<String> filterSet = this.splitFilter(filter);
        for (PropertyDefinitionWrapper propDefWrap : info.getType().getProperties()) {
            PropertyDefinition propDef = propDefWrap.getPropertyDefinition();
            if (filterSet != null && !filterSet.contains(propDef.getQueryName())) continue;
            CMISPropertyAccessor cmisPropertyAccessor = propDefWrap.getPropertyAccessor();
            Serializable value = cmisPropertyAccessor.getValue(info);
            PropertyType propType = propDef.getPropertyType();
            AbstractPropertyData<?> propertyData = this.getProperty(propType, propDefWrap, value);
            result.addProperty(propertyData);
        }
        return result;
    }

    public List<CmisExtensionElement> getAspectExtensions(CMISNodeInfo info, String filter, Set<String> alreadySetProperties) {
        ArrayList<CmisExtensionElement> extensions = new ArrayList<CmisExtensionElement>();
        HashSet<String> propertyIds = new HashSet<String>(alreadySetProperties);
        ArrayList<CmisExtensionElement> propertyExtensionList = new ArrayList<CmisExtensionElement>();
        Set<String> filterSet = this.splitFilter(filter);
        Set aspects = info.getNodeAspects();
        for (QName aspect : aspects) {
            TypeDefinitionWrapper aspectType = this.getOpenCMISDictionaryService().findNodeType(aspect);
            if (aspectType == null) continue;
            AspectDefinition aspectDefinition = this.dictionaryService.getAspect(aspect);
            Map aspectProperties = aspectDefinition.getProperties();
            extensions.add((CmisExtensionElement)new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, APPLIED_ASPECTS, null, aspectType.getTypeId()));
            for (PropertyDefinitionWrapper propDef : aspectType.getProperties()) {
                boolean addPropertyToExtensionList;
                boolean bl = addPropertyToExtensionList = this.getRequestCmisVersion().equals((Object)CmisVersion.CMIS_1_1) && aspectProperties.keySet().contains(propDef.getAlfrescoName());
                if (propertyIds.contains(propDef.getPropertyId()) && !addPropertyToExtensionList || filterSet != null && !filterSet.contains(propDef.getPropertyDefinition().getQueryName())) continue;
                Serializable value = propDef.getPropertyAccessor().getValue(info);
                propertyExtensionList.add(this.createAspectPropertyExtension(propDef.getPropertyDefinition(), value));
                propertyIds.add(propDef.getPropertyId());
            }
        }
        if (!propertyExtensionList.isEmpty()) {
            CmisExtensionElementImpl propertiesExtension = new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, PROPERTIES, null, propertyExtensionList);
            extensions.addAll(Collections.singletonList(propertiesExtension));
        }
        return extensions;
    }

    private CmisExtensionElement createAspectPropertyExtension(PropertyDefinition<?> propertyDefinition, Object value) {
        String name = switch (propertyDefinition.getPropertyType()) {
            case PropertyType.BOOLEAN -> "propertyBoolean";
            case PropertyType.DATETIME -> "propertyDateTime";
            case PropertyType.DECIMAL -> "propertyDecimal";
            case PropertyType.INTEGER -> "propertyInteger";
            case PropertyType.ID -> "propertyId";
            default -> "propertyString";
        };
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("propertyDefinitionId", propertyDefinition.getId());
        attributes.put("queryName", propertyDefinition.getQueryName());
        if (propertyDefinition.getDisplayName() != null && propertyDefinition.getDisplayName().trim().length() > 0) {
            attributes.put("displayName", propertyDefinition.getDisplayName());
        }
        if (propertyDefinition.getLocalName() != null && propertyDefinition.getLocalName().trim().length() > 0) {
            attributes.put("localName", propertyDefinition.getLocalName());
        }
        ArrayList<CmisExtensionElementImpl> propertyValues = new ArrayList<CmisExtensionElementImpl>();
        if (value != null) {
            if (value instanceof List) {
                for (Object o : (List)value) {
                    if (o != null) {
                        propertyValues.add(new CmisExtensionElementImpl(CMIS_NAMESPACE, "value", null, this.convertAspectPropertyValue(o)));
                        continue;
                    }
                    logger.warn((Object)("Unexpected null entry in list value for property " + propertyDefinition.getDisplayName() + ", value = " + String.valueOf(value)));
                }
            } else {
                propertyValues.add(new CmisExtensionElementImpl(CMIS_NAMESPACE, "value", null, this.convertAspectPropertyValue(value)));
            }
        }
        return new CmisExtensionElementImpl(CMIS_NAMESPACE, name, attributes, propertyValues);
    }

    private String convertAspectPropertyValue(Object value) {
        if (value instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.setTime((Date)value);
            value = cal;
        }
        if (value instanceof GregorianCalendar) {
            DatatypeFactory df;
            try {
                df = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException("Aspect conversation exception: " + e.getMessage(), e);
            }
            return df.newXMLGregorianCalendar((GregorianCalendar)value).toXMLFormat();
        }
        if (AlfrescoCmisServiceCall.get() != null && ("atompub".equals(AlfrescoCmisServiceCall.get().getBinding()) || "webservices".equals(AlfrescoCmisServiceCall.get().getBinding()))) {
            return this.filterXmlRestrictedCharacters(value.toString());
        }
        return value.toString();
    }

    private AbstractPropertyData<?> getProperty(PropertyType propType, PropertyDefinitionWrapper propDef, Serializable value) {
        PropertyBooleanImpl result = null;
        switch (propType) {
            case BOOLEAN: {
                result = new PropertyBooleanImpl();
                if (value instanceof List) {
                    result.setValues((List)((Object)value));
                    break;
                }
                result.setValue((Object)((Boolean)value));
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeImpl();
                if (value instanceof List) {
                    ((PropertyDateTimeImpl)result).setValues((List)DefaultTypeConverter.INSTANCE.convert(GregorianCalendar.class, (Collection)((List)((Object)value))));
                    break;
                }
                ((PropertyDateTimeImpl)result).setValue((Object)((GregorianCalendar)DefaultTypeConverter.INSTANCE.convert(GregorianCalendar.class, (Object)value)));
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalImpl();
                if (value instanceof List) {
                    ((PropertyDecimalImpl)result).setValues((List)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Collection)((List)((Object)value))));
                    break;
                }
                ((PropertyDecimalImpl)result).setValue((Object)((BigDecimal)DefaultTypeConverter.INSTANCE.convert(BigDecimal.class, (Object)value)));
                break;
            }
            case HTML: {
                result = new PropertyHtmlImpl();
                if (value instanceof List) {
                    ((PropertyHtmlImpl)result).setValues((List)((Object)value));
                    break;
                }
                ((PropertyHtmlImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            case ID: {
                result = new PropertyIdImpl();
                if (value instanceof List) {
                    ((PropertyIdImpl)result).setValues((List)((Object)value));
                    break;
                }
                if (value instanceof NodeRef) {
                    ((PropertyIdImpl)result).setValue((Object)this.constructObjectId((NodeRef)value, null));
                    break;
                }
                ((PropertyIdImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerImpl();
                if (value instanceof List) {
                    ((PropertyIntegerImpl)result).setValues((List)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Collection)((List)((Object)value))));
                    break;
                }
                ((PropertyIntegerImpl)result).setValue((Object)((BigInteger)DefaultTypeConverter.INSTANCE.convert(BigInteger.class, (Object)value)));
                break;
            }
            case STRING: {
                result = new PropertyStringImpl();
                if (value instanceof List) {
                    ((PropertyStringImpl)result).setValues((List)((Object)value));
                    break;
                }
                if (AlfrescoCmisServiceCall.get() != null && ("atompub".equals(AlfrescoCmisServiceCall.get().getBinding()) || "webservices".equals(AlfrescoCmisServiceCall.get().getBinding()))) {
                    ((PropertyStringImpl)result).setValue((Object)this.filterXmlRestrictedCharacters((String)((Object)value)));
                    break;
                }
                ((PropertyStringImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            case URI: {
                result = new PropertyUriImpl();
                if (value instanceof List) {
                    ((PropertyUriImpl)result).setValues((List)((Object)value));
                    break;
                }
                ((PropertyUriImpl)result).setValue((Object)((String)((Object)value)));
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype! Spec change?");
            }
        }
        if (propDef != null) {
            result.setId(propDef.getPropertyDefinition().getId());
            result.setQueryName(propDef.getPropertyDefinition().getQueryName());
            result.setDisplayName(propDef.getPropertyDefinition().getDisplayName());
            result.setLocalName(propDef.getPropertyDefinition().getLocalName());
        }
        return result;
    }

    private String filterXmlRestrictedCharacters(String origValue) {
        if (origValue == null) {
            return origValue;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < origValue.length()) {
            char ch = origValue.charAt(i);
            boolean restricted = ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r';
            sb.append(restricted ? (char)'_' : (char)ch);
            ++i;
        }
        return sb.toString();
    }

    private Set<String> splitFilter(String filter) {
        if (filter == null) {
            return null;
        }
        if (filter.trim().length() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = filter.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).equals("*")) {
                return null;
            }
            if (s.length() > 0) {
                result.add(s);
            }
            ++n2;
        }
        result.add(QUERY_NAME_OBJECT_ID);
        result.add(QUERY_NAME_OBJECT_TYPE_ID);
        result.add(QUERY_NAME_BASE_TYPE_ID);
        return result;
    }

    public AllowableActions getAllowableActions(CMISNodeInfo info) {
        AllowableActionsImpl result = new AllowableActionsImpl();
        HashSet<Action> allowableActions = new HashSet<Action>();
        result.setAllowableActions(allowableActions);
        for (CMISActionEvaluator evaluator : info.getType().getActionEvaluators().values()) {
            if (!evaluator.isAllowed(info)) continue;
            allowableActions.add(evaluator.getAction());
        }
        return result;
    }

    public List<ObjectData> getRelationships(NodeRef nodeRef, IncludeRelationships includeRelationships) {
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            return result;
        }
        ArrayList assocs = new ArrayList();
        if (includeRelationships == IncludeRelationships.SOURCE || includeRelationships == IncludeRelationships.BOTH) {
            assocs.addAll(this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        if (includeRelationships == IncludeRelationships.TARGET || includeRelationships == IncludeRelationships.BOTH) {
            assocs.addAll(this.nodeService.getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        for (AssociationRef assocRef : assocs) {
            TypeDefinitionWrapper assocTypeDef = this.getOpenCMISDictionaryService().findAssocType(assocRef.getTypeQName());
            if (assocTypeDef == null || this.getType(assocRef.getSourceRef()) == null || this.getType(assocRef.getTargetRef()) == null) continue;
            try {
                result.add(this.createCMISObject(this.createNodeInfo(assocRef), null, false, IncludeRelationships.NONE, RENDITION_NONE, false, false));
            }
            catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            }
            catch (CmisObjectNotFoundException cmisObjectNotFoundException) {
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        return result;
    }

    public ObjectList getObjectRelationships(NodeRef nodeRef, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount) {
        ObjectListImpl result = new ObjectListImpl();
        result.setHasMoreItems(Boolean.valueOf(false));
        result.setNumItems(BigInteger.ZERO);
        result.setObjects(new ArrayList());
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            return result;
        }
        ArrayList assocs = new ArrayList();
        if (relationshipDirection == RelationshipDirection.SOURCE || relationshipDirection == RelationshipDirection.EITHER) {
            assocs.addAll(this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        if (relationshipDirection == RelationshipDirection.TARGET || relationshipDirection == RelationshipDirection.EITHER) {
            assocs.addAll(this.nodeService.getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
        int skip = skipCount == null ? 0 : skipCount.intValue();
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int counter = 0;
        boolean hasMore = false;
        if (max > 0) {
            for (AssociationRef assocRef : assocs) {
                TypeDefinitionWrapper assocTypeDef = this.getOpenCMISDictionaryService().findAssocType(assocRef.getTypeQName());
                if (assocTypeDef == null || this.getType(assocRef.getSourceRef()) == null || this.getType(assocRef.getTargetRef()) == null || typeId != null && !assocTypeDef.getTypeId().equals(typeId)) continue;
                ++counter;
                if (skip > 0) {
                    --skip;
                    continue;
                }
                if (--max > 0) {
                    try {
                        result.getObjects().add(this.createCMISObject(this.createNodeInfo(assocRef), filter, includeAllowableActions, IncludeRelationships.NONE, RENDITION_NONE, false, false));
                    }
                    catch (CmisObjectNotFoundException cmisObjectNotFoundException) {}
                    continue;
                }
                hasMore = true;
            }
        }
        result.setNumItems(BigInteger.valueOf(counter));
        result.setHasMoreItems(Boolean.valueOf(hasMore));
        return result;
    }

    public List<RenditionData> getRenditions(NodeRef nodeRef, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        CMISRenditionMapping mapping = this.getRenditionMapping();
        return mapping.getRenditions(nodeRef, renditionFilter, maxItems, skipCount);
    }

    public Acl getACL(NodeRef nodeRef, boolean onlyBasicPermissions) {
        AccessControlListImpl result = new AccessControlListImpl();
        ArrayList ordered = new ArrayList(this.permissionService.getAllSetPermissions(nodeRef));
        Collections.sort(ordered, new AccessPermissionComparator());
        HashMap aceMap = new HashMap();
        for (AccessPermission entry : ordered) {
            HashMap<Boolean, AccessControlEntryImpl> directAce;
            if (entry.getAccessStatus() == AccessStatus.ALLOWED) {
                AccessControlEntryImpl ace;
                directAce = (HashMap<Boolean, AccessControlEntryImpl>)aceMap.get(entry.getAuthority());
                if (directAce == null) {
                    directAce = new HashMap<Boolean, AccessControlEntryImpl>();
                    aceMap.put(entry.getAuthority(), directAce);
                }
                if ((ace = (AccessControlEntryImpl)directAce.get(entry.isSetDirectly())) == null) {
                    ace = new AccessControlEntryImpl();
                    ace.setPrincipal((Principal)new AccessControlPrincipalDataImpl(entry.getAuthority()));
                    ace.setPermissions(new ArrayList());
                    ace.setDirect(entry.isSetDirectly());
                    directAce.put(entry.isSetDirectly(), ace);
                }
                ace.getPermissions().add(entry.getPermission());
                continue;
            }
            if (entry.getAccessStatus() != AccessStatus.DENIED || (directAce = (Map)aceMap.get(entry.getAuthority())) == null) continue;
            for (AccessControlEntryImpl ace : directAce.values()) {
                ace.getPermissions().remove(entry.getPermission());
            }
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        result.setAces(aces);
        for (Map bothAces : aceMap.values()) {
            AccessControlEntryImpl indirectAce;
            List<String> permissions;
            AccessControlEntryImpl directAce = (AccessControlEntryImpl)bothAces.get(true);
            if (directAce != null && !directAce.getPermissions().isEmpty() && (permissions = this.translatePermissionsToCMIS(directAce.getPermissions(), onlyBasicPermissions)) != null && !permissions.isEmpty()) {
                directAce.setPermissions(permissions);
                aces.add(directAce);
            }
            if ((indirectAce = (AccessControlEntryImpl)bothAces.get(false)) == null || indirectAce.getPermissions().isEmpty()) continue;
            List<String> permissions2 = this.translatePermissionsToCMIS(indirectAce.getPermissions(), onlyBasicPermissions);
            indirectAce.setPermissions(permissions2);
            if (directAce != null && !directAce.getPermissions().isEmpty()) {
                indirectAce.getPermissions().removeAll(directAce.getPermissions());
            }
            if (indirectAce.getPermissions().isEmpty()) continue;
            aces.add(indirectAce);
        }
        result.setExact(Boolean.valueOf(!onlyBasicPermissions));
        return result;
    }

    private List<String> translatePermissionsToCMIS(List<String> permissions, boolean onlyBasicPermissions) {
        TreeSet<String> result = new TreeSet<String>();
        for (String permission : permissions) {
            PermissionReference permissionReference = this.permissionModelDao.getPermissionReference(null, permission);
            if (onlyBasicPermissions) {
                if (this.permissionModelDao.hasFull(permissionReference)) {
                    result.add("cmis:all");
                }
                Set<PermissionReference> longForms = this.permissionModelDao.getGranteePermissions(permissionReference);
                HashSet<String> shortForms = new HashSet<String>();
                for (PermissionReference longForm : longForms) {
                    shortForms.add(this.permissionModelDao.isUnique(longForm) ? longForm.getName() : longForm.toString());
                }
                for (String perm : shortForms) {
                    if ("Read".equals(perm)) {
                        result.add("cmis:read");
                        continue;
                    }
                    if ("Write".equals(perm)) {
                        result.add("cmis:write");
                        continue;
                    }
                    if (!"All".equals(perm)) continue;
                    result.add("cmis:all");
                }
                if ("Read".equals(permission)) {
                    result.add("cmis:read");
                    continue;
                }
                if ("Write".equals(permission)) {
                    result.add("cmis:write");
                    continue;
                }
                if (!"All".equals(permission)) continue;
                result.add("cmis:all");
                continue;
            }
            if (permission.startsWith("{")) {
                result.add(permission);
                continue;
            }
            if ("Read".equals(permission)) {
                result.add("cmis:read");
                continue;
            }
            if ("Write".equals(permission)) {
                result.add("cmis:write");
                continue;
            }
            if ("All".equals(permission)) {
                result.add("cmis:all");
                continue;
            }
            result.add(permissionReference.toString());
        }
        return new ArrayList<String>(result);
    }

    public void applyACL(NodeRef nodeRef, TypeDefinitionWrapper type, Acl addAces, Acl removeAces) {
        boolean hasRemove;
        boolean hasAdd = addAces != null && addAces.getAces() != null && !addAces.getAces().isEmpty();
        boolean bl = hasRemove = removeAces != null && removeAces.getAces() != null && !removeAces.getAces().isEmpty();
        if (!hasAdd && !hasRemove) {
            return;
        }
        if (!type.getTypeDefinition(false).isControllableAcl().booleanValue()) {
            throw new CmisConstraintException("Object is not ACL controllable!");
        }
        if (hasRemove) {
            Set permissions = this.permissionService.getAllSetPermissions(nodeRef);
            Acl onlyDirectAcl = this.excludeInheritedAces(nodeRef, removeAces);
            for (Ace ace : onlyDirectAcl.getAces()) {
                String principalId = ace.getPrincipalId();
                if (CMIS_USER.equals(principalId)) {
                    principalId = AuthenticationUtil.getFullyAuthenticatedUser();
                }
                for (String permission : this.translatePermissionsFromCMIS(ace.getPermissions())) {
                    AccessPermissionImpl toCheck = new AccessPermissionImpl(permission, AccessStatus.ALLOWED, principalId, 0);
                    if (!permissions.contains(toCheck)) {
                        throw new CmisConstraintException("No matching ACE found to remove!");
                    }
                    this.permissionService.deletePermission(nodeRef, principalId, permission);
                }
            }
        }
        if (hasAdd) {
            for (Ace ace : addAces.getAces()) {
                String principalId = ace.getPrincipalId();
                if (CMIS_USER.equals(principalId)) {
                    principalId = AuthenticationUtil.getFullyAuthenticatedUser();
                }
                for (String permission : this.translatePermissionsFromCMIS(ace.getPermissions())) {
                    this.permissionService.setPermission(nodeRef, principalId, permission, true);
                }
            }
        }
    }

    private Map<String, Set<String>> convertAclToMap(Acl acl) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (acl == null || acl.getAces() == null) {
            return result;
        }
        for (Ace ace : acl.getAces()) {
            if (!ace.isDirect() || ace.getPrincipal() == null || ace.getPrincipal().getId() == null) continue;
            HashSet permissions = (HashSet)result.get(ace.getPrincipal().getId());
            if (permissions == null) {
                permissions = new HashSet();
                result.put(ace.getPrincipal().getId(), permissions);
            }
            if (ace.getPermissions() == null) continue;
            permissions.addAll(ace.getPermissions());
        }
        return result;
    }

    protected Acl excludeInheritedAces(NodeRef nodeRef, Acl acl) {
        ArrayList<AccessControlEntryImpl> newAces = new ArrayList<AccessControlEntryImpl>();
        Acl allACLs = this.getACL(nodeRef, false);
        Map<String, Set<String>> originalsAcls = this.convertAclToMap(allACLs);
        Map<String, Set<String>> newAcls = this.convertAclToMap(acl);
        for (Map.Entry<String, Set<String>> ace : originalsAcls.entrySet()) {
            Set<String> addPermissions = newAcls.get(ace.getKey());
            if (addPermissions != null) {
                ace.getValue().addAll(addPermissions);
            }
            if (ace.getValue().isEmpty()) continue;
            newAces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(ace.getKey()), new ArrayList(ace.getValue())));
        }
        return new AccessControlListImpl(newAces);
    }

    public void applyACL(NodeRef nodeRef, TypeDefinitionWrapper type, Acl aces) {
        boolean hasAces;
        boolean bl = hasAces = aces != null && aces.getAces() != null && !aces.getAces().isEmpty();
        if (!hasAces && !this.permissionService.getInheritParentPermissions(nodeRef)) {
            return;
        }
        if (!type.getTypeDefinition(false).isControllableAcl().booleanValue()) {
            throw new CmisConstraintException("Object is not ACL controllable!");
        }
        this.permissionService.deletePermissions(nodeRef);
        for (Ace ace : aces.getAces()) {
            String principalId = ace.getPrincipalId();
            if (CMIS_USER.equals(principalId)) {
                principalId = AuthenticationUtil.getFullyAuthenticatedUser();
            }
            List<String> permissions = this.translatePermissionsFromCMIS(ace.getPermissions());
            for (String permission : permissions) {
                this.permissionService.setPermission(nodeRef, principalId, permission, true);
            }
        }
    }

    private List<String> translatePermissionsFromCMIS(List<String> permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (permissions == null) {
            return result;
        }
        for (String permission : permissions) {
            if (permission == null) {
                throw new CmisConstraintException("Invalid null permission!");
            }
            if ("cmis:read".equals(permission)) {
                result.add("Read");
                continue;
            }
            if ("cmis:write".equals(permission)) {
                result.add("Write");
                continue;
            }
            if ("cmis:all".equals(permission)) {
                result.add("All");
                continue;
            }
            if (!permission.startsWith("{")) {
                result.add(permission);
                continue;
            }
            int sepIndex = permission.lastIndexOf(46);
            if (sepIndex == -1) {
                result.add(permission);
                continue;
            }
            result.add(permission.substring(sepIndex + 1));
        }
        return result;
    }

    public void applyPolicies(NodeRef nodeRef, TypeDefinitionWrapper type, List<String> policies) {
        if (policies == null || policies.isEmpty()) {
            return;
        }
        if (!type.getTypeDefinition(false).isControllablePolicy().booleanValue()) {
            throw new CmisConstraintException("Object is not policy controllable!");
        }
    }

    public ObjectList query(String statement, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        ObjectListImpl result = new ObjectListImpl();
        result.setObjects(new ArrayList());
        CMISQueryOptions options = new CMISQueryOptions(statement, this.getRootStoreRef());
        CmisVersion cmisVersion = this.getRequestCmisVersion();
        options.setCmisVersion(cmisVersion);
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        int skip = 0;
        if (skipCount != null && skipCount.intValue() >= 0) {
            skip = skipCount.intValue();
            options.setSkipCount(skip);
        }
        if (maxItems != null && maxItems.intValue() >= 0) {
            options.setMaxItems(maxItems.intValue());
        }
        boolean fetchObject = includeAllowableActions != false || includeRelationships != IncludeRelationships.NONE || !RENDITION_NONE.equals(renditionFilter);
        try (CMISResultSet rs = this.getOpenCMISQueryService().query(options);){
            CMISResultSetColumn[] columns = rs.getMetaData().getColumns();
            Iterator<CMISResultSetRow> iterator = rs.iterator();
            while (iterator.hasNext()) {
                TypeDefinitionWrapper type;
                CMISResultSetRow row = iterator.next();
                NodeRef nodeRef = row.getNodeRef();
                if (!this.nodeService.exists(nodeRef) || this.filter(nodeRef) || (type = this.getType(nodeRef)) == null) continue;
                ObjectDataImpl hit = new ObjectDataImpl();
                PropertiesImpl properties = new PropertiesImpl();
                hit.setProperties((Properties)properties);
                Map<String, Serializable> values = row.getValues();
                CMISResultSetColumn[] cMISResultSetColumnArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    CMISResultSetColumn column = cMISResultSetColumnArray[n2];
                    AbstractPropertyData<?> property = this.getProperty(column.getCMISDataType(), column.getCMISPropertyDefinition(), values.get(column.getName()));
                    property.setQueryName(column.getName());
                    properties.addProperty(property);
                    ++n2;
                }
                if (fetchObject) {
                    CMISNodeInfoImpl nodeInfo;
                    if (includeAllowableActions.booleanValue() && !(nodeInfo = this.createNodeInfo(nodeRef)).getObjectVariant().equals((Object)CMISObjectVariant.NOT_EXISTING)) {
                        hit.setAllowableActions(this.getAllowableActions(nodeInfo));
                    }
                    if (includeRelationships != IncludeRelationships.NONE) {
                        hit.setRelationships(this.getRelationships(nodeRef, includeRelationships));
                    }
                    if (!RENDITION_NONE.equals(renditionFilter)) {
                        List<RenditionData> renditions = this.getRenditions(nodeRef, renditionFilter, null, null);
                        if (renditions != null && !renditions.isEmpty()) {
                            hit.setRenditions(renditions);
                        } else {
                            hit.setRenditions(Collections.EMPTY_LIST);
                        }
                    }
                }
                result.getObjects().add(hit);
            }
            long numberFound = rs.getNumberFound();
            if (numberFound != -1L) {
                result.setNumItems(BigInteger.valueOf(numberFound));
            }
            result.setHasMoreItems(Boolean.valueOf(rs.hasMore()));
        }
        return result;
    }

    public void setProperties(NodeRef nodeRef, TypeDefinitionWrapper type, Properties properties, String ... exclude) {
        Serializable secondaryTypesProperty;
        if (properties == null) {
            return;
        }
        Map incomingPropsMap = properties.getProperties();
        if (incomingPropsMap == null) {
            return;
        }
        HashMap<String, Pair<TypeDefinitionWrapper, Serializable>> propsMap = new HashMap<String, Pair<TypeDefinitionWrapper, Serializable>>();
        for (String propertyId : incomingPropsMap.keySet()) {
            PropertyData property = (PropertyData)incomingPropsMap.get(propertyId);
            Object propDef = type.getPropertyById(property.getId());
            if (propDef == null && (propDef = this.getOpenCMISDictionaryService().findProperty(propertyId)) == null) {
                throw new CmisInvalidArgumentException("Property " + property.getId() + " is unknown!");
            }
            Boolean isOnWorkingCopy = this.checkOutCheckInService.isWorkingCopy(nodeRef);
            Updatability updatability = propDef.getPropertyDefinition().getUpdatability();
            if (!this.isUpdatable(updatability, isOnWorkingCopy)) {
                throw new CmisInvalidArgumentException("Property " + propertyId + " is read-only!");
            }
            TypeDefinitionWrapper propType = propDef.getOwningType();
            Serializable value = this.getValue(property, propDef.getPropertyDefinition().getCardinality() == Cardinality.MULTI);
            Pair pair = new Pair((Object)propType, (Object)value);
            propsMap.put(propertyId, (Pair<TypeDefinitionWrapper, Serializable>)pair);
        }
        Pair pair = (Pair)propsMap.get("cmis:secondaryObjectTypeIds");
        Serializable serializable = secondaryTypesProperty = pair != null ? (Serializable)pair.getSecond() : null;
        if (secondaryTypesProperty != null) {
            if (!(secondaryTypesProperty instanceof List)) {
                throw new CmisInvalidArgumentException("Secondary types must be a list!");
            }
            List secondaryTypes = (List)((Object)secondaryTypesProperty);
            if (secondaryTypes != null && secondaryTypes.size() > 0) {
                this.processSecondaryTypes(nodeRef, secondaryTypes, propsMap);
            }
        }
        for (String propertyId : propsMap.keySet()) {
            if (propertyId.equals("cmis:secondaryObjectTypeIds")) continue;
            pair = (Pair)propsMap.get(propertyId);
            TypeDefinitionWrapper propType = (TypeDefinitionWrapper)pair.getFirst();
            Serializable value = (Serializable)pair.getSecond();
            if (Arrays.binarySearch(exclude, propertyId) >= 0) continue;
            this.setProperty(nodeRef, propType, propertyId, value);
        }
        List extensions = properties.getExtensions();
        if (extensions != null) {
            boolean isNameChanging = properties.getProperties().containsKey("cmis:name");
            for (CmisExtensionElement extension : extensions) {
                if (!ALFRESCO_EXTENSION_NAMESPACE.equals(extension.getNamespace()) || !SET_ASPECTS.equals(extension.getName())) continue;
                this.setAspectProperties(nodeRef, isNameChanging, extension);
                break;
            }
        }
    }

    private void processSecondaryTypes(NodeRef nodeRef, List secondaryTypes, Map<String, Pair<TypeDefinitionWrapper, Serializable>> propsToAdd) {
        Set existingAspects = this.nodeService.getAspects(nodeRef);
        HashSet<QName> secondaryTypeAspects = new HashSet<QName>();
        for (Object o : secondaryTypes) {
            String secondaryType = (String)o;
            TypeDefinitionWrapper wrapper = this.getOpenCMISDictionaryService().findType(secondaryType);
            if (wrapper != null) {
                QName aspectQName = wrapper.getAlfrescoName();
                secondaryTypeAspects.add(aspectQName);
                continue;
            }
            throw new CmisInvalidArgumentException("Invalid secondary type id " + secondaryType);
        }
        HashSet<QName> aspectsToIgnore = new HashSet<QName>();
        aspectsToIgnore.add(ContentModel.ASPECT_REFERENCEABLE);
        aspectsToIgnore.add(ContentModel.ASPECT_LOCALIZED);
        aspectsToIgnore.add(ContentModel.ASPECT_WORKING_COPY);
        HashSet<String> namespacesToIgnore = new HashSet<String>(Collections.singletonList("http://www.alfresco.org/model/system/1.0"));
        HashSet<QName> toAdd = new HashSet<QName>(secondaryTypeAspects);
        toAdd.removeAll(existingAspects);
        toAdd.removeAll(aspectsToIgnore);
        toAdd.removeIf(a -> namespacesToIgnore.contains(a.getNamespaceURI()));
        HashSet aspectsToRemove = new HashSet();
        aspectsToRemove.addAll(existingAspects);
        aspectsToRemove.removeAll(aspectsToIgnore);
        Iterator it = aspectsToRemove.iterator();
        while (it.hasNext()) {
            QName aspectQName = (QName)it.next();
            TypeDefinitionWrapper w = this.getOpenCMISDictionaryService().findNodeType(aspectQName);
            if (w != null && !secondaryTypeAspects.contains(aspectQName) && !namespacesToIgnore.contains(aspectQName.getNamespaceURI())) continue;
            it.remove();
        }
        for (QName aspectQName : aspectsToRemove) {
            this.nodeService.removeAspect(nodeRef, aspectQName);
        }
        for (QName aspectQName : toAdd) {
            this.nodeService.addAspect(nodeRef, aspectQName, null);
        }
    }

    public void addSecondaryTypes(NodeRef nodeRef, List<String> secondaryTypes) {
        if (secondaryTypes != null && secondaryTypes.size() > 0) {
            for (String secondaryType : secondaryTypes) {
                TypeDefinitionWrapper type = this.getType(secondaryType);
                if (type == null) {
                    throw new CmisInvalidArgumentException("Invalid secondaryType: " + secondaryType);
                }
                this.nodeService.addAspect(nodeRef, type.getAlfrescoName(), null);
            }
        }
    }

    public void removeSecondaryTypes(NodeRef nodeRef, List<String> secondaryTypes) {
        if (secondaryTypes != null && secondaryTypes.size() > 0) {
            for (String secondaryType : secondaryTypes) {
                TypeDefinitionWrapper type = this.getType(secondaryType);
                if (type == null) {
                    throw new CmisInvalidArgumentException("Invalid secondaryType: " + secondaryType);
                }
                this.nodeService.removeAspect(nodeRef, type.getAlfrescoName());
            }
        }
    }

    private void setAspectProperties(NodeRef nodeRef, boolean isNameChanging, CmisExtensionElement aspectExtension) {
        if (aspectExtension.getChildren() == null) {
            return;
        }
        ArrayList<String> aspectsToAdd = new ArrayList<String>();
        ArrayList<String> aspectsToRemove = new ArrayList<String>();
        HashMap aspectProperties = new HashMap();
        for (CmisExtensionElement extension : aspectExtension.getChildren()) {
            if (!ALFRESCO_EXTENSION_NAMESPACE.equals(extension.getNamespace())) continue;
            if (ASPECTS_TO_ADD.equals(extension.getName()) && extension.getValue() != null) {
                aspectsToAdd.add(extension.getValue());
                continue;
            }
            if (ASPECTS_TO_REMOVE.equals(extension.getName()) && extension.getValue() != null) {
                aspectsToRemove.add(extension.getValue());
                continue;
            }
            if (!PROPERTIES.equals(extension.getName()) || extension.getChildren() == null) continue;
            for (CmisExtensionElement property : extension.getChildren()) {
                String propertyId;
                if (!property.getName().startsWith("property")) continue;
                String string = propertyId = property.getAttributes() == null ? null : (String)property.getAttributes().get("propertyDefinitionId");
                if (propertyId == null || property.getChildren() == null) continue;
                PropertyType propertyType = PropertyType.STRING;
                DatatypeFactory df = null;
                if (property.getName().equals("propertyBoolean")) {
                    propertyType = PropertyType.BOOLEAN;
                } else if (property.getName().equals("propertyInteger")) {
                    propertyType = PropertyType.INTEGER;
                } else if (property.getName().equals("propertyDateTime")) {
                    propertyType = PropertyType.DATETIME;
                    try {
                        df = DatatypeFactory.newInstance();
                    }
                    catch (DatatypeConfigurationException e) {
                        throw new CmisRuntimeException("Aspect conversation exception: " + e.getMessage(), (Throwable)e);
                    }
                } else if (property.getName().equals("propertyDecimal")) {
                    propertyType = PropertyType.DECIMAL;
                }
                ArrayList<Object> values = new ArrayList<Object>();
                if (property.getChildren() != null) {
                    for (CmisExtensionElement valueElement : property.getChildren()) {
                        if (!"value".equals(valueElement.getName())) continue;
                        switch (propertyType) {
                            case BOOLEAN: {
                                try {
                                    values.add(Boolean.parseBoolean(valueElement.getValue()));
                                    break;
                                }
                                catch (Exception e) {
                                    throw new CmisInvalidArgumentException("Invalid property aspect value: " + propertyId, (Throwable)e);
                                }
                            }
                            case DATETIME: {
                                try {
                                    values.add(df.newXMLGregorianCalendar(valueElement.getValue()).toGregorianCalendar());
                                    break;
                                }
                                catch (Exception e) {
                                    throw new CmisInvalidArgumentException("Invalid property aspect value: " + propertyId, (Throwable)e);
                                }
                            }
                            case INTEGER: {
                                BigInteger value = null;
                                try {
                                    value = new BigInteger(valueElement.getValue());
                                }
                                catch (Exception e) {
                                    throw new CmisInvalidArgumentException("Invalid property aspect value: " + propertyId, (Throwable)e);
                                }
                                PropertyDefinitionWrapper propDef = this.getOpenCMISDictionaryService().findProperty(propertyId);
                                if (propDef == null) {
                                    throw new CmisInvalidArgumentException("Property " + propertyId + " is unknown!");
                                }
                                QName propertyQName = propDef.getPropertyAccessor().getMappedProperty();
                                if (propertyQName == null) {
                                    throw new CmisConstraintException("Unable to set property " + propertyId + "!");
                                }
                                org.alfresco.service.cmr.dictionary.PropertyDefinition def = this.dictionaryService.getProperty(propertyQName);
                                QName dataDef = def.getDataType().getName();
                                if (dataDef.equals((Object)DataTypeDefinition.INT) && (value.compareTo(maxInt) > 0 || value.compareTo(minInt) < 0)) {
                                    throw new CmisConstraintException("Value is out of range for property " + propertyId);
                                }
                                if (dataDef.equals((Object)DataTypeDefinition.LONG) && (value.compareTo(maxLong) > 0 || value.compareTo(minLong) < 0)) {
                                    throw new CmisConstraintException("Value is out of range for property " + propertyId);
                                }
                                values.add(value);
                                break;
                            }
                            case DECIMAL: {
                                try {
                                    values.add(new BigDecimal(valueElement.getValue()));
                                    break;
                                }
                                catch (Exception e) {
                                    throw new CmisInvalidArgumentException("Invalid property aspect value: " + propertyId, (Throwable)e);
                                }
                            }
                            default: {
                                values.add(valueElement.getValue());
                            }
                        }
                    }
                }
                aspectProperties.put(QName.createQName((String)propertyId, (NamespacePrefixResolver)this.namespaceService), values);
            }
        }
        String aspectType = null;
        try {
            QName typeName;
            TypeDefinitionWrapper type;
            Iterator<Object> iterator = aspectsToRemove.iterator();
            while (iterator.hasNext()) {
                String string;
                aspectType = string = (String)iterator.next();
                type = this.getType(string);
                if (type == null) {
                    throw new CmisInvalidArgumentException("Invalid aspect: " + aspectType);
                }
                typeName = type.getAlfrescoName();
                if (typeName.equals((Object)ContentModel.ASPECT_HIDDEN)) {
                    if (!this.hiddenAspect.isClientControlled(nodeRef) && !aspectProperties.containsKey(ContentModel.PROP_CLIENT_CONTROLLED)) continue;
                    this.nodeService.removeAspect(nodeRef, typeName);
                    continue;
                }
                this.nodeService.removeAspect(nodeRef, typeName);
            }
            iterator = aspectsToAdd.iterator();
            while (iterator.hasNext()) {
                String string;
                aspectType = string = (String)iterator.next();
                type = this.getType(string);
                if (type == null) {
                    throw new CmisInvalidArgumentException("Invalid aspect: " + aspectType);
                }
                typeName = type.getAlfrescoName();
                if (typeName.equals((Object)ContentModel.ASPECT_HIDDEN)) {
                    if (!this.hiddenAspect.isClientControlled(nodeRef) && !aspectProperties.containsKey(ContentModel.PROP_CLIENT_CONTROLLED)) continue;
                    this.nodeService.addAspect(nodeRef, type.getAlfrescoName(), Collections.emptyMap());
                    continue;
                }
                this.nodeService.addAspect(nodeRef, type.getAlfrescoName(), Collections.emptyMap());
            }
        }
        catch (InvalidAspectException invalidAspectException) {
            throw new CmisInvalidArgumentException("Invalid aspect: " + aspectType);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            throw new CmisInvalidArgumentException("Invalid node: " + String.valueOf(nodeRef));
        }
        for (Map.Entry entry : aspectProperties.entrySet()) {
            QName propertyQName = (QName)entry.getKey();
            if (((List)entry.getValue()).isEmpty()) {
                if (HiddenAspect.HIDDEN_PROPERTIES.contains(entry.getKey())) {
                    if (!this.hiddenAspect.isClientControlled(nodeRef) && !aspectProperties.containsKey(ContentModel.PROP_CLIENT_CONTROLLED)) continue;
                    this.nodeService.removeProperty(nodeRef, propertyQName);
                    continue;
                }
                this.nodeService.removeProperty(nodeRef, (QName)entry.getKey());
                continue;
            }
            if (HiddenAspect.HIDDEN_PROPERTIES.contains(entry.getKey())) {
                if (!this.hiddenAspect.isClientControlled(nodeRef) && !aspectProperties.containsKey(ContentModel.PROP_CLIENT_CONTROLLED)) continue;
                this.nodeService.setProperty(nodeRef, (QName)entry.getKey(), ((List)entry.getValue()).size() == 1 ? (Serializable)((List)entry.getValue()).get(0) : (Serializable)entry.getValue());
                continue;
            }
            Serializable value = (Serializable)entry.getValue();
            this.nodeService.setProperty(nodeRef, (QName)entry.getKey(), ((List)entry.getValue()).size() == 1 ? (Serializable)((List)entry.getValue()).get(0) : value);
        }
    }

    public void setProperty(NodeRef nodeRef, TypeDefinitionWrapper type, String propertyId, Serializable value) {
        if (propertyId == null) {
            throw new CmisInvalidArgumentException("Cannot process not null property!");
        }
        PropertyDefinitionWrapper propDef = type.getPropertyById(propertyId);
        if (propDef == null) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " is unknown!");
        }
        Boolean isOnWorkingCopy = this.checkOutCheckInService.isWorkingCopy(nodeRef);
        Updatability updatability = propDef.getPropertyDefinition().getUpdatability();
        if (!this.isUpdatable(updatability, isOnWorkingCopy)) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " is read-only!");
        }
        if (propDef.getPropertyId().equals("cmis:secondaryObjectTypeIds")) {
            throw new IllegalArgumentException("Cannot process cmis:secondaryObjectTypeIds in setProperty");
        }
        QName propertyQName = propDef.getPropertyAccessor().getMappedProperty();
        if (propertyQName == null) {
            throw new CmisConstraintException("Unable to set property " + propertyId + "!");
        }
        if (propertyId.equals("cmis:name")) {
            if (!(value instanceof String)) {
                throw new CmisInvalidArgumentException("Object name must be a string!");
            }
            try {
                String newName = value.toString();
                if (isOnWorkingCopy.booleanValue()) {
                    String wcLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_WORKING_COPY_LABEL));
                    if (wcLabel == null) {
                        wcLabel = CheckOutCheckInServiceImpl.getWorkingCopyLabel();
                    }
                    if (!newName.contains(wcLabel)) {
                        newName = CheckOutCheckInServiceImpl.createWorkingCopyName(newName, wcLabel);
                    }
                }
                this.fileFolderService.rename(nodeRef, newName);
            }
            catch (FileExistsException e) {
                throw new CmisContentAlreadyExistsException("An object with this name already exists!", (Throwable)((Object)e));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CmisInvalidArgumentException("Object with id " + nodeRef.getId() + " not found!");
            }
        } else {
            if (propDef.getPropertyDefinition().getPropertyType() == PropertyType.INTEGER && value instanceof BigInteger) {
                org.alfresco.service.cmr.dictionary.PropertyDefinition def = this.dictionaryService.getProperty(propertyQName);
                QName dataDef = def.getDataType().getName();
                BigInteger bigValue = (BigInteger)value;
                if ((bigValue.compareTo(maxInt) > 0 || bigValue.compareTo(minInt) < 0) && dataDef.equals((Object)DataTypeDefinition.INT)) {
                    throw new CmisConstraintException("Value is out of range for property " + propertyQName.getLocalName());
                }
                if ((bigValue.compareTo(maxLong) > 0 || bigValue.compareTo(minLong) < 0) && dataDef.equals((Object)DataTypeDefinition.LONG)) {
                    throw new CmisConstraintException("Value is out of range for property " + propertyQName.getLocalName());
                }
            }
            this.nodeService.setProperty(nodeRef, propertyQName, value);
        }
    }

    private Serializable getValue(PropertyData<?> property, boolean isMultiValue) {
        if (property.getValues() == null || property.getValues().isEmpty()) {
            return null;
        }
        if (isMultiValue) {
            return (Serializable)((Object)property.getValues());
        }
        return (Serializable)property.getValues().get(0);
    }

    public ObjectList getContentChanges(Holder<String> changeLogToken, BigInteger maxItems) {
        final ObjectListImpl result = new ObjectListImpl();
        result.setObjects(new ArrayList());
        final ArrayList entryIds = new ArrayList();
        EntryIdCallback changeLogCollectingCallback = new EntryIdCallback(this, true){

            @Override
            public boolean handleAuditEntry(Long entryId, String user, long time, Map<String, Serializable> values) {
                entryIds.add(entryId);
                result.getObjects().addAll(this.createChangeEvents(time, values));
                return super.handleAuditEntry(entryId, user, time, values);
            }
        };
        Long from = null;
        if (changeLogToken != null && changeLogToken.getValue() != null) {
            try {
                from = Long.parseLong((String)changeLogToken.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                throw new CmisInvalidArgumentException("Invalid change log token: " + (String)changeLogToken.getValue());
            }
        }
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(CMIS_CHANGELOG_AUDIT_APPLICATION);
        params.setForward(true);
        params.setFromId(from);
        int maxResults = maxItems == null ? this.contentChangesDefaultMaxItems : maxItems.intValue();
        maxResults = maxResults < 1 ? this.contentChangesDefaultMaxItems : maxResults;
        maxResults = maxResults > this.contentChangesDefaultMaxItems ? this.contentChangesDefaultMaxItems : maxResults;
        int queryFor = maxResults + 1;
        this.auditService.auditQuery(changeLogCollectingCallback, params, queryFor);
        int resultSize = result.getObjects().size();
        boolean hasMoreItems = entryIds.size() >= maxResults;
        result.setHasMoreItems(Boolean.valueOf(hasMoreItems));
        if (hasMoreItems && resultSize >= maxResults) {
            result.getObjects().remove(resultSize - 1);
            entryIds.remove(resultSize - 1);
        }
        if (changeLogToken != null) {
            Long newChangeLogToken = entryIds.isEmpty() ? from : (Long)entryIds.get(entryIds.size() - 1);
            changeLogToken.setValue((Object)String.valueOf(newChangeLogToken));
        }
        return result;
    }

    private List<ObjectData> createChangeEvents(long time, Map<String, Serializable> values) {
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        if (values == null || values.size() == 0) {
            return result;
        }
        GregorianCalendar changeTime = new GregorianCalendar();
        changeTime.setTimeInMillis(time);
        String appPath = "/CMISChangeLog/";
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            String path;
            if (entry.getKey() == null || !(entry.getValue() instanceof Map) || !(path = entry.getKey()).startsWith(appPath)) continue;
            ChangeType changeType = null;
            String changePath = path.substring(appPath.length()).toLowerCase();
            ChangeType[] changeTypeArray = ChangeType.values();
            int n = changeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeType c = changeTypeArray[n2];
                if (changePath.startsWith(c.value().toLowerCase())) {
                    changeType = c;
                    break;
                }
                ++n2;
            }
            if (changeType == null) continue;
            Map valueMap = (Map)((Object)entry.getValue());
            String objectId = (String)valueMap.get("objectId");
            ObjectDataImpl object = new ObjectDataImpl();
            result.add((ObjectData)object);
            PropertiesImpl properties = new PropertiesImpl();
            object.setProperties((Properties)properties);
            PropertyIdImpl objectIdProperty = new PropertyIdImpl(QUERY_NAME_OBJECT_ID, objectId);
            properties.addProperty((PropertyData)objectIdProperty);
            ChangeEventInfoDataImpl changeEvent = new ChangeEventInfoDataImpl();
            object.setChangeEventInfo((ChangeEventInfo)changeEvent);
            changeEvent.setChangeType(changeType);
            changeEvent.setChangeTime(changeTime);
        }
        return result;
    }

    public String getStringProperty(Properties properties, String propertyId) {
        if (properties == null || properties.getProperties() == null) {
            return null;
        }
        PropertyData property = (PropertyData)properties.getProperties().get(propertyId);
        if (!(property instanceof PropertyString)) {
            return null;
        }
        return (String)((PropertyString)property).getFirstValue();
    }

    public String getIdProperty(Properties properties, String propertyId) {
        if (properties == null || properties.getProperties() == null) {
            return null;
        }
        PropertyData property = (PropertyData)properties.getProperties().get(propertyId);
        if (!(property instanceof PropertyId)) {
            return null;
        }
        return (String)((PropertyId)property).getFirstValue();
    }

    public String getNameProperty(Properties properties, String fallback) {
        String name = this.getStringProperty(properties, "cmis:name");
        if (name == null || name.trim().length() == 0) {
            if (fallback == null) {
                throw new CmisInvalidArgumentException("Property cmis:name must be set!");
            }
            name = fallback;
        }
        return name;
    }

    public String getObjectTypeIdProperty(Properties properties) {
        String objectTypeId = this.getIdProperty(properties, QUERY_NAME_OBJECT_TYPE_ID);
        if (objectTypeId == null || objectTypeId.trim().length() == 0) {
            throw new CmisInvalidArgumentException("Property cmis:objectTypeId must be set!");
        }
        return objectTypeId;
    }

    public String getSourceIdProperty(Properties properties) {
        String id = this.getIdProperty(properties, "cmis:sourceId");
        if (id == null || id.trim().length() == 0) {
            throw new CmisInvalidArgumentException("Property cmis:sourceId must be set!");
        }
        return id;
    }

    public String getTargetIdProperty(Properties properties) {
        String id = this.getIdProperty(properties, "cmis:targetId");
        if (id == null || id.trim().length() == 0) {
            throw new CmisInvalidArgumentException("Property cmis:targetId must be set!");
        }
        return id;
    }

    public RepositoryInfo getRepositoryInfo(CmisVersion cmisVersion) {
        return this.createRepositoryInfo(cmisVersion);
    }

    public String getRepositoryId() {
        return this.descriptorService.getCurrentRepositoryDescriptor().getId();
    }

    private RepositoryInfo createRepositoryInfo(CmisVersion cmisVersion) {
        Descriptor currentDescriptor = this.descriptorService.getCurrentRepositoryDescriptor();
        boolean auditEnabled = this.auditService.isAuditEnabled(CMIS_CHANGELOG_AUDIT_APPLICATION, "/CMISChangeLog");
        String latestChangeLogToken = null;
        if (auditEnabled) {
            EntryIdCallback auditQueryCallback = new EntryIdCallback(false);
            AuditQueryParameters params = new AuditQueryParameters();
            params.setApplicationName(CMIS_CHANGELOG_AUDIT_APPLICATION);
            params.setForward(false);
            this.auditService.auditQuery(auditQueryCallback, params, 1);
            String entryId = auditQueryCallback.getEntryId();
            latestChangeLogToken = entryId == null ? "0" : entryId;
        }
        RepositoryInfoImpl ri = new RepositoryInfoImpl();
        ri.setId(currentDescriptor.getId());
        ri.setName(currentDescriptor.getName());
        ri.setDescription(currentDescriptor.getName());
        ri.setVendorName("Alfresco");
        ri.setProductName("Alfresco " + this.descriptorService.getServerDescriptor().getEdition());
        ri.setProductVersion(currentDescriptor.getVersion());
        NodeRef rootNodeRef = this.getRootNodeRef();
        ri.setRootFolder(this.constructObjectId(rootNodeRef, null));
        ri.setCmisVersion(cmisVersion);
        ri.setChangesIncomplete(Boolean.valueOf(true));
        ri.setChangesOnType(Arrays.asList(BaseTypeId.CMIS_DOCUMENT, BaseTypeId.CMIS_FOLDER));
        ri.setLatestChangeLogToken(latestChangeLogToken);
        ri.setPrincipalAnonymous(AuthenticationUtil.getGuestUserName());
        ri.setPrincipalAnyone("GROUP_EVERYONE");
        RepositoryCapabilitiesImpl repCap = new RepositoryCapabilitiesImpl();
        ri.setCapabilities((RepositoryCapabilities)repCap);
        repCap.setAllVersionsSearchable(Boolean.valueOf(false));
        repCap.setCapabilityAcl(CapabilityAcl.MANAGE);
        repCap.setCapabilityChanges(auditEnabled ? CapabilityChanges.OBJECTIDSONLY : CapabilityChanges.NONE);
        repCap.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.ANYTIME);
        repCap.setCapabilityJoin(CapabilityJoin.NONE);
        repCap.setCapabilityQuery(CapabilityQuery.BOTHCOMBINED);
        repCap.setCapabilityRendition(CapabilityRenditions.READ);
        repCap.setIsPwcSearchable(Boolean.valueOf(false));
        repCap.setIsPwcUpdatable(Boolean.valueOf(true));
        repCap.setSupportsGetDescendants(Boolean.valueOf(true));
        repCap.setSupportsGetFolderTree(Boolean.valueOf(true));
        repCap.setSupportsMultifiling(Boolean.valueOf(true));
        repCap.setSupportsUnfiling(Boolean.valueOf(false));
        repCap.setSupportsVersionSpecificFiling(Boolean.valueOf(false));
        AclCapabilitiesDataImpl aclCap = new AclCapabilitiesDataImpl();
        ri.setAclCapabilities((AclCapabilities)aclCap);
        aclCap.setAclPropagation(AclPropagation.PROPAGATE);
        aclCap.setSupportedPermissions(SupportedPermissions.BOTH);
        aclCap.setPermissionDefinitionData(this.repositoryPermissions);
        aclCap.setPermissionMappingData(this.permissionMappings);
        return ri;
    }

    private List<PermissionDefinition> getRepositoryPermissions() {
        ArrayList<PermissionDefinition> result = new ArrayList<PermissionDefinition>();
        Set<PermissionReference> all = this.permissionModelDao.getAllPermissions();
        for (PermissionReference pr : all) {
            result.add(this.createPermissionDefinition(pr));
        }
        PermissionReference allPermission = this.permissionModelDao.getPermissionReference(null, "All");
        result.add(this.createPermissionDefinition(allPermission));
        PermissionDefinitionDataImpl cmisPermission = new PermissionDefinitionDataImpl();
        cmisPermission.setId("cmis:read");
        cmisPermission.setDescription("CMIS Read");
        result.add((PermissionDefinition)cmisPermission);
        cmisPermission = new PermissionDefinitionDataImpl();
        cmisPermission.setId("cmis:write");
        cmisPermission.setDescription("CMIS Write");
        result.add((PermissionDefinition)cmisPermission);
        cmisPermission = new PermissionDefinitionDataImpl();
        cmisPermission.setId("cmis:all");
        cmisPermission.setDescription("CMIS All");
        result.add((PermissionDefinition)cmisPermission);
        return result;
    }

    private PermissionDefinition createPermissionDefinition(PermissionReference pr) {
        PermissionDefinitionDataImpl permission = new PermissionDefinitionDataImpl();
        permission.setId(pr.getQName().toString() + "." + pr.getName());
        permission.setDescription(permission.getId());
        return permission;
    }

    private Map<String, PermissionMapping> getPermissionMappings() {
        HashMap<String, PermissionMapping> result = new HashMap<String, PermissionMapping>();
        for (CMISAllowedActionEnum e : EnumSet.allOf(CMISAllowedActionEnum.class)) {
            for (Map.Entry<String, List<String>> m : e.getPermissionMapping().entrySet()) {
                PermissionMappingDataImpl mapping = new PermissionMappingDataImpl();
                mapping.setKey(m.getKey());
                mapping.setPermissions(m.getValue());
                result.put(mapping.getKey(), (PermissionMapping)mapping);
            }
        }
        return result;
    }

    @Deprecated
    private CMISRenditionMapping getRenditionMapping() {
        CMISRenditionMapping renditionMapping = (CMISRenditionMapping)this.singletonCache.get((Serializable)((Object)"key.cmisRenditionMapping.noderef"));
        if (renditionMapping == null) {
            renditionMapping = new CMISRenditionMapping(this.nodeService, this.contentService, this.renditionService, this.transactionService, this.kindToRenditionNames);
            this.singletonCache.put((Serializable)((Object)"key.cmisRenditionMapping.noderef"), (Object)renditionMapping);
        }
        return renditionMapping;
    }

    private boolean isUpdatable(Updatability updatability, Boolean isOnWorkingCopy) {
        return updatability != Updatability.READONLY && (updatability != Updatability.WHENCHECKEDOUT || isOnWorkingCopy != false);
    }

    public static class AccessPermissionComparator
    implements Comparator<AccessPermission> {
        @Override
        public int compare(AccessPermission left, AccessPermission right) {
            if (left.getPosition() != right.getPosition()) {
                return right.getPosition() - left.getPosition();
            }
            if (left.getAccessStatus() != right.getAccessStatus()) {
                return left.getAccessStatus() == AccessStatus.DENIED ? -1 : 1;
            }
            int compare = left.getAuthority().compareTo(right.getAuthority());
            if (compare != 0) {
                return compare;
            }
            return left.getPermission().compareTo(right.getPermission());
        }
    }

    private class EntryIdCallback
    implements AuditService.AuditQueryCallback {
        private final boolean valuesRequired;
        private Long entryId;

        public EntryIdCallback(boolean valuesRequired) {
            this.valuesRequired = valuesRequired;
        }

        public String getEntryId() {
            return this.entryId == null ? null : this.entryId.toString();
        }

        @Override
        public boolean valuesRequired() {
            return this.valuesRequired;
        }

        @Override
        public final boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
            if (applicationName.equals(CMISConnector.CMIS_CHANGELOG_AUDIT_APPLICATION)) {
                return this.handleAuditEntry(entryId, user, time, values);
            }
            return true;
        }

        public boolean handleAuditEntry(Long entryId, String user, long time, Map<String, Serializable> values) {
            this.entryId = entryId;
            return true;
        }

        @Override
        public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
            throw new CmisRuntimeException("Audit entry " + String.valueOf(entryId) + ": " + errorMsg, error);
        }
    }

    private class ProcessorLifecycle
    extends AbstractLifecycleBean {
        private ProcessorLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            CMISConnector.this.init();
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

