/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class RenditionPreventionRegistry {
    private final Set<QName> registeredContentClasses = new HashSet<QName>();
    private NamespaceService namespaceService;

    public void setNamespaceService(NamespaceService service) {
        this.namespaceService = service;
    }

    public void register(String contentClass) {
        QName qname = QName.createQName((String)contentClass, (NamespacePrefixResolver)this.namespaceService);
        this.registeredContentClasses.add(qname);
    }

    public Set<QName> getRegisteredQNames() {
        return Collections.unmodifiableSet(this.registeredContentClasses);
    }

    public boolean isContentClassRegistered(String contentClassName) {
        QName qname = QName.createQName((String)contentClassName, (NamespacePrefixResolver)this.namespaceService);
        return this.isContentClassRegistered(qname);
    }

    public boolean isContentClassRegistered(QName aspectQName) {
        return this.registeredContentClasses.contains(aspectQName);
    }

    public static class SelfRegisteringClassName {
        private final String contentClassName;
        private RenditionPreventionRegistry registry;

        public SelfRegisteringClassName(String className) {
            this.contentClassName = className;
        }

        public void setRegistry(RenditionPreventionRegistry registry) {
            this.registry = registry;
        }

        public void register() {
            this.registry.register(this.contentClassName);
        }
    }
}

