/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import java.util.Map;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.context.ApplicationContext;

public class ServiceAccountRoleTest {
    private static final ApplicationContextInit APP_CONTEXT = new ApplicationContextInit();
    private static final TemporarySites TEST_SITES = new TemporarySites(APP_CONTEXT);
    private static final TemporaryNodes TEST_NODES = new TemporaryNodes(APP_CONTEXT);
    private static final AlfrescoPerson NORMAL_USER = ServiceAccountRoleTest.getAlfrescoPerson("john.doe" + System.currentTimeMillis());
    private static final AlfrescoPerson EDITOR_SA = ServiceAccountRoleTest.getAlfrescoPerson("test-editor-sa");
    private static final AlfrescoPerson COLLABORATOR_SA = ServiceAccountRoleTest.getAlfrescoPerson("test-collaborator-sa");
    private static final AlfrescoPerson ADMIN_SA = ServiceAccountRoleTest.getAlfrescoPerson("test-admin-sa");
    private static final String TEST_TEXT_FILE_NAME = "testTextFile.txt";
    @ClassRule
    public static final RuleChain STATIC_RULE_CHAIN = RuleChain.outerRule((TestRule)APP_CONTEXT).around((TestRule)TEST_SITES).around((TestRule)TEST_NODES).around((TestRule)NORMAL_USER).around((TestRule)EDITOR_SA).around((TestRule)COLLABORATOR_SA).around((TestRule)ADMIN_SA);
    private static NodeService nodeService;
    private static SiteService siteService;
    private static PermissionService permissionService;
    private static Properties globalProperties;
    private static NodeRef testTextFile;

    @BeforeClass
    public static void initStaticData() throws Exception {
        ApplicationContext context = APP_CONTEXT.getApplicationContext();
        nodeService = (NodeService)context.getBean("NodeService", NodeService.class);
        siteService = (SiteService)context.getBean("SiteService", SiteService.class);
        permissionService = (PermissionService)context.getBean("permissionService", PermissionService.class);
        globalProperties = (Properties)context.getBean("global-properties", Properties.class);
        ServiceAccountRoleTest.serviceAccountsShouldExistInGlobalProperties();
        SiteInfo testSite = ServiceAccountRoleTest.createTestSite();
        ServiceAccountRoleTest.createTestFile(testSite);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private static AlfrescoPerson getAlfrescoPerson(String username) {
        return new AlfrescoPerson(APP_CONTEXT, username);
    }

    private static SiteInfo createTestSite() {
        return TEST_SITES.createSite("sitePreset", "saTestSite" + System.currentTimeMillis(), "SA Test Site", "sa test site desc", SiteVisibility.PRIVATE, AuthenticationUtil.getAdminUserName());
    }

    private static void createTestFile(SiteInfo testSite) {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        NodeRef docLib = siteService.getContainer(testSite.getShortName(), "documentLibrary");
        NodeRef testFolder = TEST_NODES.createFolder(docLib, "testFolder", AuthenticationUtil.getAdminUserName());
        testTextFile = TEST_NODES.createNodeWithTextContent(testFolder, TEST_TEXT_FILE_NAME, ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "The quick brown fox jumps over the lazy dog.");
        Map<QName, String> props = Map.of(ContentModel.PROP_NAME, TEST_TEXT_FILE_NAME, ContentModel.PROP_DESCRIPTION, "Desc added by Admin.");
        nodeService.setProperties(testTextFile, props);
    }

    private static void serviceAccountsShouldExistInGlobalProperties() {
        ServiceAccountRoleTest.assertServiceAccountIsDefined("ROLE_EDITOR_SERVICE_ACCOUNT", EDITOR_SA.getUsername());
        ServiceAccountRoleTest.assertServiceAccountIsDefined("ROLE_COLLABORATOR_SERVICE_ACCOUNT", COLLABORATOR_SA.getUsername());
        ServiceAccountRoleTest.assertServiceAccountIsDefined("ROLE_ADMIN_SERVICE_ACCOUNT", ADMIN_SA.getUsername());
    }

    private static void assertServiceAccountIsDefined(String expectedRole, String username) {
        Assert.assertEquals((Object)expectedRole, (Object)globalProperties.getProperty("serviceaccount.role." + username));
    }

    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void normalUserReadAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "Read");
    }

    @Test
    public void editorSaReadAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(EDITOR_SA, "Read");
    }

    @Test
    public void collaboratorSaReadAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(COLLABORATOR_SA, "Read");
    }

    @Test
    public void adminSaReadAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "Read");
    }

    @Test
    public void normalUserWriteAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "Write");
    }

    @Test
    public void editorSaWriteAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(EDITOR_SA, "Write");
    }

    @Test
    public void collaboratorSaWriteAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(COLLABORATOR_SA, "Write");
    }

    @Test
    public void adminSaWriteAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "Write");
    }

    @Test
    public void normalUserAddChildrenAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "AddChildren");
    }

    @Test
    public void editorSaAddChildrenAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(EDITOR_SA, "AddChildren");
    }

    @Test
    public void collaboratorSaAddChildrenAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(COLLABORATOR_SA, "AddChildren");
    }

    @Test
    public void adminSaAddChildrenAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "AddChildren");
    }

    @Test
    public void normalUserDeleteAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "Delete");
    }

    @Test
    public void editorSaDeleteAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(EDITOR_SA, "Delete");
    }

    @Test
    public void collaboratorSaDeleteAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(COLLABORATOR_SA, "Delete");
    }

    @Test
    public void adminSaDeleteAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "Delete");
    }

    @Test
    public void normalUserAssociationAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "ReadAssociations");
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "CreateAssociations");
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "DeleteAssociations");
    }

    @Test
    public void editorSaAssociationAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(EDITOR_SA, "ReadAssociations");
        ServiceAccountRoleTest.assertAccessDenied(EDITOR_SA, "CreateAssociations");
        ServiceAccountRoleTest.assertAccessDenied(EDITOR_SA, "DeleteAssociations");
    }

    @Test
    public void collaboratorSaAssociationAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(COLLABORATOR_SA, "ReadAssociations");
        ServiceAccountRoleTest.assertAccessDenied(COLLABORATOR_SA, "CreateAssociations");
        ServiceAccountRoleTest.assertAccessDenied(COLLABORATOR_SA, "DeleteAssociations");
    }

    @Test
    public void adminSaAssociationAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "ReadAssociations");
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "CreateAssociations");
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "DeleteAssociations");
    }

    @Test
    public void normalUserReadPermissionsAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(NORMAL_USER, "ReadPermissions");
    }

    @Test
    public void editorSaReadPermissionsAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(EDITOR_SA, "ReadPermissions");
    }

    @Test
    public void collaboratorSaReadPermissionsAccessShouldBeDenied() {
        ServiceAccountRoleTest.assertAccessDenied(COLLABORATOR_SA, "ReadPermissions");
    }

    @Test
    public void adminSaReadPermissionsAccessShouldBeAllowed() {
        ServiceAccountRoleTest.assertAccessAllowed(ADMIN_SA, "ReadPermissions");
    }

    private static void assertAccessDenied(AlfrescoPerson user, String permission) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)user.getUsername());
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)permissionService.hasPermission(testTextFile, permission));
    }

    private static void assertAccessAllowed(AlfrescoPerson user, String permission) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)user.getUsername());
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)permissionService.hasPermission(testTextFile, permission));
    }
}

