/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.audit.AuditRecord;
import org.alfresco.repo.audit.AuditRecordUtils;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class AuditRecordUtilsTest {
    @Test
    public void testGenerateAuditRecordBuilderTest() {
        HashMap<String, Object> testData = new HashMap<String, Object>();
        testData.put("/alfresco-access/transaction/path", "/app:company_home");
        testData.put("/alfresco-access/transaction/user", "admin");
        testData.put("/alfresco-access/transaction/sub-actions", "updateNodeProperties");
        Instant now = Instant.now();
        testData.put("/alfresco-access/transaction/properties/from", (Serializable)((Object)Map.of(QName.createQName((String)"modified"), Date.from(now))));
        testData.put("/alfresco-access/transaction/properties/to", (Serializable)((Object)Map.of(QName.createQName((String)"modified"), Date.from(now))));
        AuditRecord.Builder builder = AuditRecordUtils.generateAuditRecordBuilder(testData, (int)"/alfresco-access/".length());
        builder.setAuditRecordType("alfresco-access");
        AuditRecord auditRecord = builder.build();
        Assert.assertNotNull((Object)auditRecord);
        Assert.assertEquals((Object)"alfresco-access", (Object)auditRecord.getAuditApplicationId());
        Map auditData = auditRecord.getAuditData();
        Assert.assertEquals((long)1L, (long)auditData.size());
        HashMap transaction = (HashMap)auditData.get("transaction");
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((long)4L, (long)transaction.size());
        Assert.assertEquals(testData.get("/alfresco-access/transaction/path"), transaction.get("path"));
        Assert.assertEquals(testData.get("/alfresco-access/transaction/user"), transaction.get("user"));
        Assert.assertEquals(testData.get("/alfresco-access/transaction/sub-actions"), transaction.get("sub-actions"));
        HashMap properties = (HashMap)transaction.get("properties");
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertEquals(testData.get("/alfresco-access/transaction/properties/from"), properties.get("from"));
        Assert.assertEquals(testData.get("/alfresco-access/transaction/properties/to"), properties.get("to"));
    }

    @Test
    public void testGenerateAuditRecordBuilderTestNodeRef() {
        HashMap testData = new HashMap();
        HashMap<String, Object> expectedValue = new HashMap<String, Object>();
        expectedValue.put("nodeRef", new NodeRef("workspace://SpacesStore/bfa612e6-1a02-46a0-a612-e61a02e6a036"));
        expectedValue.put("objectId", "bfa612e6-1a02-46a0-a612-e61a02e6a036;1.0");
        testData.put("/CMISChangeLog/CREATED/result/value", expectedValue);
        AuditRecord.Builder builder = AuditRecordUtils.generateAuditRecordBuilder(testData, (int)"/CMISChangeLog/".length());
        builder.setAuditRecordType("CMISChangeLog");
        AuditRecord auditRecord = builder.build();
        Assert.assertNotNull((Object)auditRecord);
        Assert.assertEquals((Object)"CMISChangeLog", (Object)auditRecord.getAuditApplicationId());
        Map auditData = auditRecord.getAuditData();
        Assert.assertEquals((long)1L, (long)auditData.size());
        HashMap created = (HashMap)auditData.get("CREATED");
        Assert.assertNotNull((Object)created);
        Assert.assertEquals((long)1L, (long)created.size());
        HashMap result = (HashMap)created.get("result");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        HashMap resultValue = (HashMap)result.get("value");
        Assert.assertNotNull((Object)resultValue);
        Assert.assertEquals((long)2L, (long)resultValue.size());
        NodeRef expectedNodeRef = (NodeRef)expectedValue.get("nodeRef");
        Assert.assertEquals((Object)expectedNodeRef.getId(), resultValue.get("nodeRef"));
        Assert.assertEquals(expectedValue.get("objectId"), resultValue.get("objectId"));
    }

    @Test
    public void testQnameAsAKeyInMap() {
        HashMap testData = new HashMap();
        HashMap<QName, String> value = new HashMap<QName, String>();
        value.put(QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"Parent Group"), "site_swsdp_SiteManager");
        value.put(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"userName"), "admin");
        value.put(QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"Null qname value"), null);
        testData.put("/alfresco-access/path", value);
        AuditRecord.Builder builder = AuditRecordUtils.generateAuditRecordBuilder(testData, (int)"/alfresco-access/".length());
        builder.setAuditRecordType("alfresco-access");
        AuditRecord auditRecord = builder.build();
        Assert.assertNotNull((Object)auditRecord);
        Assert.assertEquals((Object)"alfresco-access", (Object)auditRecord.getAuditApplicationId());
        Map auditData = auditRecord.getAuditData();
        Assert.assertEquals((long)1L, (long)auditData.size());
        HashMap path = (HashMap)auditData.get("path");
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)"site_swsdp_SiteManager", path.get("{http://www.alfresco.org/model/recordsmanagement/1.0}Parent Group"));
        Assert.assertEquals((Object)"admin", path.get("{http://www.alfresco.org/model/content/1.0}userName"));
        Assert.assertNull(path.get("{http://www.alfresco.org/model/recordsmanagement/1.0}Null qname value"));
    }

    @Test
    public void testNullAsAValueInMap() {
        HashMap testData = new HashMap();
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("KeyOne", null);
        value.put("KeyTwo", null);
        testData.put("/alfresco-access/path", value);
        AuditRecord.Builder builder = AuditRecordUtils.generateAuditRecordBuilder(testData, (int)"/alfresco-access/".length());
        builder.setAuditRecordType("alfresco-access");
        AuditRecord auditRecord = builder.build();
        Assert.assertNotNull((Object)auditRecord);
        Assert.assertEquals((Object)"alfresco-access", (Object)auditRecord.getAuditApplicationId());
        Map auditData = auditRecord.getAuditData();
        Assert.assertEquals((long)1L, (long)auditData.size());
        HashMap path = (HashMap)auditData.get("path");
        Assert.assertNotNull((Object)path);
        Assert.assertNull(path.get("KeyOne"));
        Assert.assertNull(path.get("KeyTwo"));
    }
}

