/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.List;
import java.util.Map;
import org.alfresco.heartbeat.AuthoritiesDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.descriptor.Descriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AuthoritiesDataCollectorTest {
    private AuthoritiesDataCollector authorityDataCollector;
    private List<HBData> collectedData;
    private HeartBeatJobScheduler mockScheduler;

    @Before
    public void setUp() {
        HBDataCollectorService mockCollectorService = (HBDataCollectorService)Mockito.mock(HBDataCollectorService.class);
        AuthorityService authorityService = (AuthorityService)Mockito.mock(AuthorityService.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
        Descriptor mockDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)mockDescriptor.getId()).thenReturn((Object)"mock_id");
        DescriptorDAO descriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        Mockito.when((Object)descriptorDAO.getDescriptor()).thenReturn((Object)mockDescriptor);
        this.authorityDataCollector = new AuthoritiesDataCollector("acs.repository.usage.authorities", "1.0", "0 0 0 ? * *", this.mockScheduler);
        this.authorityDataCollector.setAuthorityService(authorityService);
        this.authorityDataCollector.setCurrentRepoDescriptorDAO(descriptorDAO);
        this.authorityDataCollector.setHbDataCollectorService(mockCollectorService);
        this.collectedData = this.authorityDataCollector.collectData();
    }

    @Test
    public void testHBDataFields() {
        for (HBData data : this.collectedData) {
            Assert.assertNotNull((Object)data.getCollectorId());
            Assert.assertNotNull((Object)data.getCollectorVersion());
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertNotNull((Object)data.getSystemId());
            Assert.assertNotNull((Object)data.getTimestamp());
        }
    }

    @Test
    public void testAuthDataIsCollected() {
        HBData authorityInfo = this.grabDataByCollectorId(this.authorityDataCollector.getCollectorId());
        Assert.assertNotNull((String)"Authority info data missing.", (Object)authorityInfo);
        Map data = authorityInfo.getData();
        Assert.assertTrue((boolean)data.containsKey("numUsers"));
        Assert.assertTrue((boolean)data.containsKey("numGroups"));
    }

    private HBData grabDataByCollectorId(String collectorId) {
        for (HBData d : this.collectedData) {
            if (d.getCollectorId() == null || !d.getCollectorId().equals(collectorId)) continue;
            return d;
        }
        return null;
    }
}

