/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.List;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolHashStringifier;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.Stringifier;

public class NodeHashStringifier
extends ProtocolHashStringifier {
    private static final long serialVersionUID = 1L;

    public NodeHashStringifier(HashStore classpathHashStore, Stringifier referenceDispatcher) {
        super(classpathHashStore, referenceDispatcher);
    }

    @Override
    public String stringify(Reference reference) throws ReferenceEncodingException {
        Protocol protocol = reference.getProtocol();
        if (!Protocols.NODE.protocol.equals(protocol)) {
            throw new ReferenceEncodingException("Unsupported protocol " + String.valueOf(protocol));
        }
        Resource resource = reference.getResource();
        String resourceString = this.stringify(resource);
        List<Parameter> parameters = reference.getParameters();
        ReferenceParameter referenceParameter = (ReferenceParameter)parameters.get(0);
        Reference parentReference = (Reference)referenceParameter.getValue();
        String parametersString = this.dispatchStringifyReference(parentReference);
        return "3-" + resourceString + "-" + parametersString;
    }
}

