/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.security.permissions.PermissionCheckCollection;

public class PermissionCheckCollectionTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    public void testBasicWrapping() throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        Collection proxiedList = PermissionCheckCollection.PermissionCheckCollectionMixin.create(list, (int)2000, (long)10000L, (int)1000);
        PermissionCheckCollectionTest.assertTrue((String)"Proxied object must still be a List", (boolean)(proxiedList instanceof List));
        PermissionCheckCollectionTest.assertEquals((String)"List values incorrect", (int)3, (int)proxiedList.size());
        PermissionCheckCollectionTest.assertTrue((String)"Proxied object must also be a PermissionCheckCollection", (boolean)(proxiedList instanceof PermissionCheckCollection));
        PermissionCheckCollection proxiedPermissionCheckCollection = (PermissionCheckCollection)proxiedList;
        PermissionCheckCollectionTest.assertEquals((String)"targetResultCount value incorrect", (int)2000, (int)proxiedPermissionCheckCollection.getTargetResultCount());
        PermissionCheckCollectionTest.assertEquals((String)"cutOffAfterTimeMs value incorrect", (long)10000L, (long)proxiedPermissionCheckCollection.getCutOffAfterTimeMs());
        PermissionCheckCollectionTest.assertEquals((String)"cutOffAfterCount value incorrect", (int)1000, (int)proxiedPermissionCheckCollection.getCutOffAfterCount());
    }

    public void testVolumeWrapping() throws Exception {
        int count = 10000;
        long before = System.nanoTime();
        int i = 0;
        while (i < count) {
            this.testBasicWrapping();
            ++i;
        }
        long after = System.nanoTime();
        double average = (double)(after - before) / (double)count / 1000000.0;
        System.out.println("Average is " + average + "ms per wrap.");
    }
}

