/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.LockedException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParamsImpl;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AbstractChainingAuthenticationService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.InMemoryTicketComponentImpl;
import org.alfresco.repo.security.authentication.MD4PasswordEncoderImpl;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.RepositoryAuthenticatedUser;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.repo.security.authentication.ShaPasswordEncoderImpl;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.GUID;

@Category(value={OwnJVMTestsCategory.class})
public class AuthenticationTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private AuthorityService authorityService;
    private TenantService tenantService;
    private TenantAdminService tenantAdminService;
    private CompositePasswordEncoder compositePasswordEncoder;
    private MutableAuthenticationDao dao;
    private AuthenticationManager authenticationManager;
    private TicketComponent ticketComponent;
    private SimpleCache<String, InMemoryTicketComponentImpl.Ticket> ticketsCache;
    private SimpleCache<String, String> usernameToTicketIdCache;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationService pubAuthenticationService;
    private AuthenticationComponent authenticationComponent;
    private AuthenticationComponent authenticationComponentImpl;
    private TransactionService transactionService;
    private PersonService pubPersonService;
    private PersonService personService;
    private SysAdminParamsImpl sysAdminParams;
    private UserTransaction userTransaction;
    private NodeRef rootNodeRef;
    private NodeRef systemNodeRef;
    private NodeRef typesNodeRef;
    private NodeRef personAndyNodeRef;
    private static char[] DONT_CARE_PASSWORD = "1 really don't care".toCharArray();
    private Dialect dialect;
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private SimpleCache<String, RepositoryAuthenticationDao.CacheEntry> authenticationCache;
    private SimpleCache<String, NodeRef> immutableSingletonCache;
    private static final String TEST_RUN = "" + System.currentTimeMillis();
    private static final String TEST_TENANT_DOMAIN = TEST_RUN + ".my.test";
    private static final String DEFAULT_ADMIN_PW = "admin";
    private static final String TENANT_ADMIN_PW = "admin" + TEST_TENANT_DOMAIN;

    public AuthenticationTest() {
    }

    public AuthenticationTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.dialect = (Dialect)ctx.getBean("dialect");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService");
        this.compositePasswordEncoder = (CompositePasswordEncoder)ctx.getBean("compositePasswordEncoder");
        this.ticketComponent = (TicketComponent)ctx.getBean("ticketComponent");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.pubAuthenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponentImpl = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.pubPersonService = (PersonService)ctx.getBean("PersonService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.policyComponent = (PolicyComponent)ctx.getBean("policyComponent");
        this.behaviourFilter = (BehaviourFilter)ctx.getBean("policyBehaviourFilter");
        this.authenticationCache = (SimpleCache)ctx.getBean("authenticationCache");
        this.immutableSingletonCache = (SimpleCache)ctx.getBean("immutableSingletonCache");
        this.ticketsCache = (SimpleCache)ctx.getBean("ticketsCache");
        this.usernameToTicketIdCache = (SimpleCache)ctx.getBean("usernameToTicketIdCache");
        ChildApplicationContextFactory sysAdminSubsystem = (ChildApplicationContextFactory)ctx.getBean("sysAdmin");
        AuthenticationTest.assertNotNull((String)"sysAdminSubsystem", (Object)sysAdminSubsystem);
        ApplicationContext sysAdminCtx = sysAdminSubsystem.getApplicationContext();
        this.sysAdminParams = (SysAdminParamsImpl)sysAdminCtx.getBean("sysAdminParams");
        this.dao = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        ChildApplicationContextManager authenticationChain = (ChildApplicationContextManager)ctx.getBean("Authentication");
        ApplicationContext subsystem = authenticationChain.getApplicationContext((String)authenticationChain.getInstanceIds().iterator().next());
        this.authenticationManager = (AuthenticationManager)subsystem.getBean("authenticationManager");
        this.transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                try {
                    AuthenticationTest.this.deleteAndy();
                    return null;
                }
                finally {
                    AuthenticationTest.this.authenticationComponent.clearCurrentSecurityContext();
                }
            }
        }, false, true);
        this.userTransaction = this.transactionService.getUserTransaction();
        this.userTransaction.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"people");
        this.systemNodeRef = this.nodeService.createNode(this.rootNodeRef, children, system, container).getChildRef();
        this.typesNodeRef = this.nodeService.createNode(this.systemNodeRef, children, types, container).getChildRef();
        Map<QName, Serializable> props = this.createPersonProperties("Andy");
        this.personAndyNodeRef = this.nodeService.createNode(this.typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        AuthenticationTest.assertNotNull((Object)this.personAndyNodeRef);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    private void deleteAndy() {
        RepositoryAuthenticationDao dao = new RepositoryAuthenticationDao();
        dao.setTransactionService(this.transactionService);
        dao.setAuthorityService(this.authorityService);
        dao.setTenantService(this.tenantService);
        dao.setNodeService(this.nodeService);
        dao.setNamespaceService(this.getNamespacePrefixReolsver(""));
        dao.setCompositePasswordEncoder(this.compositePasswordEncoder);
        dao.setPolicyComponent(this.policyComponent);
        dao.setAuthenticationCache(this.authenticationCache);
        dao.setSingletonCache(this.immutableSingletonCache);
        if (dao.userExists("andy")) {
            dao.deleteUser("andy");
        }
        if (dao.userExists("Andy")) {
            dao.deleteUser("Andy");
        }
        if (this.personService.personExists("andy")) {
            this.personService.deletePerson("andy");
        }
        if (this.personService.personExists("Andy")) {
            this.personService.deletePerson("Andy");
        }
    }

    protected void tearDown() throws Exception {
        if (this.userTransaction.getStatus() == 0 || this.userTransaction.getStatus() == 1) {
            this.userTransaction.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    public void testSystemTicket() throws Exception {
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getFullAuthentication());
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getRunAsAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("andy", "andy".toCharArray());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getFullAuthentication());
        AuthenticationTest.assertNull((Object)AuthenticationUtil.getRunAsAuthentication());
        this.pubAuthenticationService.authenticate("andy", "andy".toCharArray());
        String userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        AuthenticationTest.assertEquals((String)"andy", (String)this.ticketComponent.getAuthorityForTicket(ticket));
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        AuthenticationTest.assertTrue((boolean)this.pubPersonService.personExists(userName));
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuthenticationTest.assertEquals((String)"andy", (String)AuthenticationTest.this.ticketComponent.getAuthorityForTicket(AuthenticationTest.this.pubAuthenticationService.getCurrentTicket()));
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.pubPersonService.getPerson(userName);
        AuthenticationTest.assertTrue((boolean)this.pubPersonService.personExists(userName));
        String newticket = this.pubAuthenticationService.getCurrentTicket();
        AuthenticationTest.assertEquals((String)ticket, (String)newticket);
        AuthenticationTest.assertEquals((String)"andy", (String)this.ticketComponent.getAuthorityForTicket(newticket));
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        this.pubAuthenticationService.validate(ticket);
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
        this.pubAuthenticationService.validate(newticket);
        userName = this.pubAuthenticationService.getCurrentUserName();
        AuthenticationTest.assertEquals((String)"andy", (String)userName);
    }

    public void xtestScalability() {
        long create = 0L;
        this.authenticationComponent.authenticate(AuthenticationUtil.getAdminUserName(), DEFAULT_ADMIN_PW.toCharArray());
        int i = 0;
        while (i < 10000) {
            String id = "TestUser-" + i;
            long start = System.nanoTime();
            this.authenticationService.createAuthentication(id, id.toCharArray());
            long end = System.nanoTime();
            create += end - start;
            if (i > 0 && i % 100 == 0) {
                System.out.println("Count = " + i);
                System.out.println("Average create : " + (float)(create / (long)i) / 1000000.0f);
                start = System.nanoTime();
                this.dao.userExists(id);
                end = System.nanoTime();
                System.out.println("Exists : " + (float)(end - start) / 1000000.0f);
            }
            ++i;
        }
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void testNewTicketOnLogin() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        String ticket1 = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        if (this.ticketComponent.getUseSingleTicketPerUser()) {
            AuthenticationTest.assertTrue((boolean)ticket1.equals(this.pubAuthenticationService.getCurrentTicket()));
        } else {
            AuthenticationTest.assertFalse((boolean)ticket1.equals(this.pubAuthenticationService.getCurrentTicket()));
        }
    }

    public void testGuest() {
        this.authenticationService.authenticate(AuthenticationUtil.getGuestUserName(), "".toCharArray());
        Set guestUsers = this.authenticationService.getDefaultGuestUserNames();
        AuthenticationTest.assertNotNull((Object)guestUsers);
        AuthenticationTest.assertTrue((boolean)guestUsers.contains(AuthenticationUtil.getGuestUserName()));
    }

    public void testCreateUsers() {
        this.authenticationService.createAuthentication(AuthenticationUtil.getGuestUserName(), DONT_CARE_PASSWORD);
        this.authenticationService.authenticate(AuthenticationUtil.getGuestUserName(), DONT_CARE_PASSWORD);
        AuthenticationTest.assertEquals((String)AuthenticationUtil.getGuestUserName(), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.createAuthentication("Andy", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("Andy", DONT_CARE_PASSWORD);
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        if (!this.tenantService.isEnabled()) {
            this.authenticationService.createAuthentication("Mr.Woof.Banana@chocolate.chip.cookie.com", DONT_CARE_PASSWORD);
            this.authenticationService.authenticate("Mr.Woof.Banana@chocolate.chip.cookie.com", DONT_CARE_PASSWORD);
            AuthenticationTest.assertEquals((String)"Mr.Woof.Banana@chocolate.chip.cookie.com", (String)this.authenticationService.getCurrentUserName());
        }
        try {
            this.authenticationService.createAuthentication("Andy_Woof/Domain", DONT_CARE_PASSWORD);
            this.authenticationService.authenticate("Andy_Woof/Domain", DONT_CARE_PASSWORD);
            AuthenticationTest.fail((String)"Tenant domain ~,./<>?\\\\| is not valid format\"");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private RepositoryAuthenticationDao createRepositoryAuthenticationDao() {
        RepositoryAuthenticationDao dao = new RepositoryAuthenticationDao();
        dao.setTransactionService(this.transactionService);
        dao.setTenantService(this.tenantService);
        dao.setNodeService(this.nodeService);
        dao.setAuthorityService(this.authorityService);
        dao.setNamespaceService(this.getNamespacePrefixReolsver(""));
        dao.setCompositePasswordEncoder(this.compositePasswordEncoder);
        dao.setPolicyComponent(this.policyComponent);
        dao.setAuthenticationCache(this.authenticationCache);
        dao.setSingletonCache(this.immutableSingletonCache);
        return dao;
    }

    public void testAuthenticateMultiTenant() {
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!AuthenticationTest.this.tenantAdminService.existsTenant(TEST_TENANT_DOMAIN)) {
                    AuthenticationTest.this.tenantAdminService.createTenant(TEST_TENANT_DOMAIN, TENANT_ADMIN_PW.toCharArray(), null);
                }
                return null;
            }
        }, (String)"");
        this.authenticateMultiTenantWork(AuthenticationUtil.getAdminUserName(), DEFAULT_ADMIN_PW);
        this.authenticateMultiTenantWork(AuthenticationUtil.getAdminUserName() + "@" + TEST_TENANT_DOMAIN, TENANT_ADMIN_PW);
    }

    private void authenticateMultiTenantWork(String userName, String password) {
        String hashedPassword = this.dao.getMD4HashedPassword(userName);
        AuthenticationTest.assertNotNull((Object)hashedPassword);
        AuthenticationTest.assertEquals((String)this.compositePasswordEncoder.encode("md4", password, null), (String)hashedPassword);
    }

    public void testCheckUserDisabledTenant() {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        String domainName = "ace4909.domain";
        String userName = "ace4909@" + domainName;
        Map<QName, Serializable> props = this.createPersonProperties(userName);
        NodeRef userNodeRef = this.personService.createPerson(props);
        AuthenticationTest.assertNotNull((Object)userNodeRef);
        this.authenticationService.createAuthentication(userName, "passwd".toCharArray());
        this.tenantAdminService.createTenant(domainName, TENANT_ADMIN_PW.toCharArray(), null);
        this.tenantAdminService.disableTenant(domainName);
        AuthenticationTest.assertTrue((String)"The user should exist", (boolean)this.dao.userExists(userName));
    }

    public void testCheckUserDeletedTenant() {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        String domainName = "ace4909.domain";
        String userName = "ace4909@" + domainName;
        Map<QName, Serializable> props = this.createPersonProperties(userName);
        NodeRef userNodeRef = this.personService.createPerson(props);
        AuthenticationTest.assertNotNull((Object)userNodeRef);
        this.authenticationService.createAuthentication(userName, "passwd".toCharArray());
        this.tenantAdminService.createTenant(domainName, TENANT_ADMIN_PW.toCharArray(), null);
        this.tenantAdminService.deleteTenant(domainName);
        AuthenticationTest.assertTrue((String)"The user should exist", (boolean)this.dao.userExists(userName));
    }

    public void testCreateAndyUserAndUpdatePassword() {
        RepositoryAuthenticationDao dao = this.createRepositoryAuthenticationDao();
        dao.createUser("Andy", "cabbage".toCharArray());
        AuthenticationTest.assertNotNull((Object)dao.getUserOrNull("Andy"));
        RepositoryAuthenticatedUser andyDetails = (RepositoryAuthenticatedUser)dao.loadUserByUsername("Andy");
        AuthenticationTest.assertNotNull((String)"User unexpectedly null", (Object)andyDetails);
        AuthenticationTest.assertEquals((String)"Unexpected username", (String)"Andy", (String)andyDetails.getUsername());
        Serializable originalSalt = andyDetails.getSalt();
        AuthenticationTest.assertNotNull((String)"Salt was not generated", (Object)originalSalt);
        AuthenticationTest.assertTrue((String)"Account unexpectedly expired", (boolean)andyDetails.isAccountNonExpired());
        AuthenticationTest.assertTrue((String)"Account unexpectedly locked", (boolean)andyDetails.isAccountNonLocked());
        AuthenticationTest.assertTrue((String)"Credentials unexpectedly expired", (boolean)andyDetails.isCredentialsNonExpired());
        AuthenticationTest.assertTrue((String)"User unexpectedly disabled", (boolean)andyDetails.isEnabled());
        AuthenticationTest.assertNotSame((String)"Password was not hashed", (Object)"cabbage", (Object)andyDetails.getPassword());
        AuthenticationTest.assertTrue((String)"Failed to recalculate same password hash", (boolean)this.compositePasswordEncoder.matches(this.compositePasswordEncoder.getPreferredEncoding(), "cabbage", andyDetails.getPassword(), (Object)originalSalt));
        AuthenticationTest.assertEquals((String)"User does not have a single authority", (int)1, (int)andyDetails.getAuthorities().length);
        dao.updateUser("Andy", "carrot".toCharArray());
        RepositoryAuthenticatedUser newDetails = (RepositoryAuthenticatedUser)dao.loadUserByUsername("Andy");
        AuthenticationTest.assertNotNull((String)"New details were null", (Object)newDetails);
        AuthenticationTest.assertEquals((String)"New details contain wrong username", (String)"Andy", (String)newDetails.getUsername());
        Serializable updatedSalt = newDetails.getSalt();
        AuthenticationTest.assertNotNull((String)"New details contain null salt", (Object)updatedSalt);
        AuthenticationTest.assertTrue((String)"Updated account is expired", (boolean)newDetails.isAccountNonExpired());
        AuthenticationTest.assertTrue((String)"Updated account is locked", (boolean)newDetails.isAccountNonLocked());
        AuthenticationTest.assertTrue((String)"Updated account has expired credentials", (boolean)newDetails.isCredentialsNonExpired());
        AuthenticationTest.assertTrue((String)"Updated account is not enabled", (boolean)newDetails.isEnabled());
        AuthenticationTest.assertNotSame((String)"Updated account contains unhashed password", (Object)"carrot", (Object)newDetails.getPassword());
        AuthenticationTest.assertEquals((String)"Updated account should have a single authority", (int)1, (int)newDetails.getAuthorities().length);
        AuthenticationTest.assertTrue((String)"Failed to validate updated password hash", (boolean)this.compositePasswordEncoder.matches(this.compositePasswordEncoder.getPreferredEncoding(), "carrot", newDetails.getPassword(), (Object)updatedSalt));
        AuthenticationTest.assertNotSame((String)"Expected salt to be replaced when password was updated", (Object)originalSalt, (Object)updatedSalt);
        dao.updateUser("Andy", "cabbage".toCharArray());
        RepositoryAuthenticatedUser thirdDetails = (RepositoryAuthenticatedUser)dao.loadUserByUsername("Andy");
        Serializable thirdSalt = thirdDetails.getSalt();
        AuthenticationTest.assertNotSame((String)"New salt should not match original salt", (Object)thirdSalt, (Object)originalSalt);
        AuthenticationTest.assertNotSame((String)"New salt should not match previous salt", (Object)thirdSalt, (Object)updatedSalt);
        AuthenticationTest.assertTrue((String)"New password hash was not reproducible", (boolean)this.compositePasswordEncoder.matches(this.compositePasswordEncoder.getPreferredEncoding(), "cabbage", thirdDetails.getPassword(), (Object)thirdSalt));
        dao.deleteUser("Andy");
        AuthenticationTest.assertFalse((String)"Should not be a cache entry for 'Andy'.", (boolean)this.authenticationCache.contains((Serializable)((Object)"Andy")));
        AuthenticationTest.assertNull((String)"DAO should report that 'Andy' does not exist.", (Object)dao.getUserOrNull("Andy"));
    }

    public void testStaleAuthenticationCacheRecovery() {
        RepositoryAuthenticationDao dao = this.createRepositoryAuthenticationDao();
        AuthenticationTest.assertFalse((String)"Must start with no cache entry for 'Andy'.", (boolean)this.authenticationCache.contains((Serializable)((Object)"Andy")));
        dao.createUser("Andy", "cabbage".toCharArray());
        NodeRef andyNodeRef = dao.getUserOrNull("Andy");
        AuthenticationTest.assertNotNull((Object)andyNodeRef);
        AuthenticationTest.assertTrue((String)"Andy's node should exist. ", (boolean)this.nodeService.exists(andyNodeRef));
        this.behaviourFilter.disableBehaviour(andyNodeRef);
        this.nodeService.deleteNode(andyNodeRef);
        AuthenticationTest.assertTrue((String)"Should still have an entry for 'Andy'.", (boolean)this.authenticationCache.contains((Serializable)((Object)"Andy")));
        AuthenticationTest.assertNull((String)"Invalid node should be detected for 'Andy'.", (Object)dao.getUserOrNull("Andy"));
        AuthenticationTest.assertFalse((String)"Cache entry should have been removed for 'Andy'.", (boolean)this.authenticationCache.contains((Serializable)((Object)"Andy")));
    }

    public void testRepositoryAuthenticationDaoWithoutTxn() throws Exception {
        RepositoryAuthenticationDao dao = this.createRepositoryAuthenticationDao();
        dao.createUser("Andy", "cabbage".toCharArray());
        this.authenticationCache.remove((Serializable)((Object)"Andy"));
        this.userTransaction.commit();
        dao.userExists("Andy");
        AuthenticationTest.assertTrue((String)"Should now have an entry for 'Andy'.", (boolean)this.authenticationCache.contains((Serializable)((Object)"Andy")));
    }

    public void testAuthentication() {
        this.dao.createUser("GUEST", DONT_CARE_PASSWORD);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"GUEST", (Object)new String(DONT_CARE_PASSWORD));
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.createUser("Andy", "squash".toCharArray());
        token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"squash");
        token.setAuthenticated(false);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setEnabled("Andy", false);
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (DisabledException disabledException) {}
        this.dao.setEnabled("Andy", true);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setLocked("Andy", true);
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (LockedException lockedException) {}
        this.dao.setLocked("Andy", false);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpires("Andy", true);
        this.dao.setCredentialsExpire("Andy", true);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", null);
        this.dao.setCredentialsExpiryDate("Andy", null);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() - 10000L));
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AccountExpiredException accountExpiredException) {}
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() - 10000L));
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (CredentialsExpiredException credentialsExpiredException) {}
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.deleteUser("Andy");
    }

    public void testCreateAuthenticationWhileRunningAsSystem() throws Exception {
        this.userTransaction.rollback();
        AuthenticationUtil.RunAsWork<Object> authWorkAsMuppet = new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                AuthenticationUtil.RunAsWork<Object> authWorkAsSystem = new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        RetryingTransactionHelper.RetryingTransactionCallback<Object> txnWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            public Object execute() throws Throwable {
                                ((this).this).AuthenticationTest.this.pubAuthenticationService.createAuthentication("blah", "pwd".toCharArray());
                                ((this).this).AuthenticationTest.this.pubAuthenticationService.deleteAuthentication("blah");
                                return null;
                            }
                        };
                        return (this).AuthenticationTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)txnWork, false, true);
                    }
                };
                return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)authWorkAsSystem, (String)AuthenticationUtil.getSystemUserName());
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)authWorkAsMuppet, (String)"muppet");
    }

    public void testPushAndPopAuthentication() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)"user1");
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.setRunAsUser((String)"user2");
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user2", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)"user3");
        AuthenticationUtil.setRunAsUser((String)"user4");
        AuthenticationTest.assertEquals((String)"user3", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user4", (String)AuthenticationUtil.getRunAsUser());
        AuthenticationUtil.popAuthentication();
        AuthenticationTest.assertEquals((String)"user1", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        AuthenticationTest.assertEquals((String)"user2", (String)AuthenticationUtil.getRunAsUser());
    }

    public void testAuthenticationFailure() {
        this.dao.createUser("Andy", "squash".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"turnip");
        token.setAuthenticated(false);
        try {
            Authentication result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (BadCredentialsException badCredentialsException) {}
        this.dao.deleteUser("Andy");
    }

    public void testTicket() {
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = this.ticketComponent.getNewTicket(this.getUserName(result));
        String user = this.ticketComponent.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        user = null;
        try {
            user = this.ticketComponent.validateTicket("INVALID");
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {
            AuthenticationTest.assertNull((Object)user);
        }
        this.ticketComponent.invalidateTicketById(ticket);
        try {
            user = this.ticketComponent.validateTicket(ticket);
            AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        this.dao.deleteUser("Andy");
    }

    public void testTicketRepeat() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(false);
        tc.setValidDuration("P0D");
        tc.setTicketsCache(this.ticketsCache);
        tc.setUsernameToTicketIdCache(this.usernameToTicketIdCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        this.dao.deleteUser("Andy");
    }

    public void testTicketOneOff() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(true);
        tc.setTicketsExpire(false);
        tc.setValidDuration("P0D");
        tc.setTicketsCache(this.ticketsCache);
        tc.setUsernameToTicketIdCache(this.usernameToTicketIdCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertTrue((!this.ticketComponent.getCurrentTicket("Andy", true).equals(ticket) ? 1 : 0) != 0);
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketExpiryMode() {
        this.ticketsCache.clear();
        this.usernameToTicketIdCache.clear();
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P5S");
        tc.setTicketsCache(this.ticketsCache);
        tc.setUsernameToTicketIdCache(this.usernameToTicketIdCache);
        tc.setExpiryMode(InMemoryTicketComponentImpl.ExpiryMode.AFTER_FIXED_TIME.toString());
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        tc.setExpiryMode(InMemoryTicketComponentImpl.ExpiryMode.AFTER_INACTIVITY.toString());
        ticket = tc.getNewTicket(this.getUserName(result));
        int i = 0;
        while (i < 50) {
            AuthenticationTest e = this;
            synchronized (e) {
                try {
                    ((Object)((Object)this)).wait(100L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                tc.validateTicket(ticket);
            }
            ++i;
        }
        AuthenticationTest authenticationTest2 = this;
        synchronized (authenticationTest2) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketExpires() {
        this.ticketsCache.clear();
        this.usernameToTicketIdCache.clear();
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P5S");
        tc.setTicketsCache(this.ticketsCache);
        tc.setUsernameToTicketIdCache(this.usernameToTicketIdCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException authenticationException) {}
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketDoesNotExpire() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P1D");
        tc.setTicketsCache(this.ticketsCache);
        tc.setUsernameToTicketIdCache(this.usernameToTicketIdCache);
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getNewTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        tc.validateTicket(ticket);
        AuthenticationTest.assertEquals((String)this.ticketComponent.getCurrentTicket("Andy", true), (String)ticket);
        this.dao.deleteUser("Andy");
    }

    public void testAuthenticationServiceGetNewTicket() {
        this.authenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        String ticket1 = this.authenticationService.getCurrentTicket();
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        String ticket2 = this.authenticationService.getCurrentTicket();
        if (this.ticketComponent.getUseSingleTicketPerUser()) {
            AuthenticationTest.assertTrue((boolean)ticket1.equals(ticket2));
        } else {
            AuthenticationTest.assertFalse((boolean)ticket1.equals(ticket2));
        }
    }

    public void testAuthenticationService1() {
        this.authenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.authenticationService.authenticate("Andy", "auth1".toCharArray());
            AuthenticationTest.fail((String)"Authentication should have been rejected");
        }
        catch (AuthenticationException authenticationException) {}
    }

    public void testAuthenticationService2() {
        this.authenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.authenticationService.authenticate("Andy", "auth2".toCharArray());
            AuthenticationTest.fail((String)"Authentication should have been rejected");
        }
        catch (AuthenticationException authenticationException) {}
    }

    public void testAuthenticationService3() {
        this.authenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        try {
            this.authenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Invalid taicket should have been rejected");
        }
        catch (AuthenticationException authenticationException) {}
    }

    public void testAuthenticationService4() {
        this.authenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        try {
            this.authenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Invalid ticket should have been rejected");
        }
        catch (AuthenticationException authenticationException) {
            AuthenticationTest.assertNull((Object)this.authenticationComponentImpl.getCurrentAuthentication());
        }
    }

    public void testAuthenticationService() {
        this.authenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth4".toCharArray(), "auth5".toCharArray());
        this.authenticationService.authenticate("Andy", "auth5".toCharArray());
        this.authenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationService.getCurrentUserName());
        this.dao.deleteUser("Andy");
    }

    public void testAuthenticationService0() {
        this.authenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationService.getCurrentUserName());
        this.dao.deleteUser("Andy");
    }

    public void testPubAuthenticationService1() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
            AuthenticationTest.fail((String)"Authentication should fail");
        }
        catch (AuthenticationException authenticationException) {}
    }

    public void testPubAuthenticationService2() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.pubAuthenticationService.authenticate("Andy", "auth2".toCharArray());
            AuthenticationTest.fail((String)"Authentication should fail");
        }
        catch (AuthenticationException authenticationException) {}
    }

    public void testPubAuthenticationService3() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticket);
        try {
            this.pubAuthenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Ticket should not validate");
        }
        catch (AuthenticationException authenticationException) {}
    }

    public void testAlwaysGetNewTicket() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticket);
        String ticketRenew = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticketRenew);
        AuthenticationTest.assertEquals((String)ticketRenew, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticketRenew);
        try {
            this.pubAuthenticationService.validate(ticketRenew);
            AuthenticationTest.fail((String)"Ticket should not validate");
        }
        catch (AuthenticationException authenticationException) {}
        try {
            this.pubAuthenticationService.getCurrentTicket();
            AuthenticationTest.fail((String)" Previous call to validate should have cleared the context, so no new tickets should be issued");
        }
        catch (Exception exception) {}
    }

    public void testPubAuthenticationService() {
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.pubAuthenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticateAsGuest();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticket);
    }

    public void testPubAuthenticationService0() {
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.pubAuthenticationService.authenticate("GUEST", DONT_CARE_PASSWORD);
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticateAsGuest();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticket);
        AuthenticationTest.assertEquals((String)ticket, (String)this.authenticationService.getCurrentTicket());
        this.pubAuthenticationService.invalidateTicket(ticket);
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth4".toCharArray());
        try {
            this.pubAuthenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
            AuthenticationTest.fail((String)"Should not be able to update");
        }
        catch (AuthenticationException authenticationException) {}
    }

    public void testAbstractAuthenticationComponentGuestUserSupport() {
        this.authenticationComponent.setGuestUserAsCurrentUser();
        AuthenticationTest.assertEquals((String)this.authenticationComponent.getCurrentUserName(), (String)this.authenticationComponent.getGuestUserName());
    }

    public void testPassThroughLogin() {
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.setCurrentUser("Andy");
        AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
    }

    public void testAuthenticationServiceImpl() {
        Set domains = this.authenticationService.getDomains();
        AuthenticationTest.assertNotNull((Object)domains);
        domains = this.authenticationService.getDomainsThatAllowUserCreation();
        AuthenticationTest.assertNotNull((Object)domains);
        domains = this.authenticationService.getDomiansThatAllowUserPasswordChanges();
        AuthenticationTest.assertNotNull((Object)domains);
        domains = this.authenticationService.getDomainsThatAllowUserDeletion();
        AuthenticationTest.assertNotNull((Object)domains);
        List services = ((AbstractChainingAuthenticationService)this.authenticationService).getUsableAuthenticationServices();
        for (AuthenticationService service : services) {
            if (!(service instanceof AuthenticationServiceImpl)) continue;
            AuthenticationServiceImpl impl = (AuthenticationServiceImpl)service;
            AuthenticationTest.assertFalse((String)"Not just anyone", (boolean)impl.authenticationExists("anyone"));
            AuthenticationTest.assertFalse((String)"Hardcoded to true", (boolean)impl.getAuthenticationEnabled("anyone"));
            this.authenticationService.invalidateUserSession("anyone");
            impl.setDomain("mydomain");
            String domain = impl.getDomain();
            AuthenticationTest.assertEquals((String)"mydomain", (String)domain);
            Set ticketComponents = impl.getTicketComponents();
            AuthenticationTest.assertNotNull((Object)ticketComponents);
            boolean allows = impl.getAllowsUserPasswordChange();
            impl.setAllowsUserPasswordChange(allows);
            AuthenticationTest.assertEquals((boolean)allows, (boolean)impl.getAllowsUserPasswordChange());
            allows = impl.getAllowsUserDeletion();
            impl.setAllowsUserDeletion(allows);
            AuthenticationTest.assertEquals((boolean)allows, (boolean)impl.getAllowsUserDeletion());
            allows = impl.getAllowsUserCreation();
            impl.setAllowsUserCreation(allows);
            AuthenticationTest.assertEquals((boolean)allows, (boolean)impl.getAllowsUserCreation());
            AuthenticationTest.assertFalse((boolean)impl.isCurrentUserTheSystemUser());
            Set users = impl.getUsersWithTickets(true);
            AuthenticationTest.assertNotNull((Object)users);
            int tickets = impl.countTickets(true);
            AuthenticationTest.assertFalse((tickets < users.size() ? 1 : 0) != 0);
            tickets = impl.invalidateTickets(true);
            AuthenticationTest.assertTrue((boolean)impl.guestUserAuthenticationAllowed());
            break;
        }
    }

    public void testLoginNotExistingTenant() {
        boolean wasEnabled = AuthenticationUtil.isMtEnabled();
        try {
            this.tenantAdminService.createTenant(GUID.generate() + "test1.test", DEFAULT_ADMIN_PW.toCharArray());
            String notExistingTenant = GUID.generate() + "tenant.test";
            String userName = "user@" + notExistingTenant;
            AuthenticationTest.assertFalse((boolean)this.tenantAdminService.existsTenant(notExistingTenant));
            try {
                this.pubAuthenticationService.authenticate(userName, GUID.generate().toCharArray());
                AuthenticationTest.fail();
            }
            catch (AuthenticationException authenticationException) {}
        }
        finally {
            AuthenticationUtil.setMtEnabled((boolean)wasEnabled);
        }
    }

    public void testMaxUsers() {
        final String user1 = GUID.generate();
        final String user2 = GUID.generate();
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuthenticationTest.this.authenticationService.createAuthentication(user1, "password".toCharArray());
                AuthenticationTest.this.authenticationService.createAuthentication(user2, "password".toCharArray());
                AuthenticationTest.this.ticketComponent.invalidateTickets(false);
                return null;
            }
        });
        int maxUsers = this.sysAdminParams.getMaxUsers();
        try {
            this.sysAdminParams.setMaxUsers(1);
            this.authenticationService.authenticate(user1, "password".toCharArray());
            try {
                this.authenticationService.authenticate(user2, "password".toCharArray());
                AuthenticationTest.fail((String)"Number of logins should not exceed maxUsers setting");
            }
            catch (AuthenticationException authenticationException) {}
        }
        finally {
            this.sysAdminParams.setMaxUsers(maxUsers);
        }
    }

    public void testRehashedPasswordOnAuthentication() {
        String defaultPreferredEncoding = this.compositePasswordEncoder.getPreferredEncoding();
        this.compositePasswordEncoder.setPreferredEncoding("md4");
        try {
            try {
                AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
                this.authenticationComponent.setSystemUserAsCurrentUser();
                this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
                NodeRef andyUserNodeRef = this.getRepositoryAuthenticationDao().getUserOrNull("Andy");
                AuthenticationTest.assertNotNull((Object)andyUserNodeRef);
                Map userProps = this.nodeService.getProperties(andyUserNodeRef);
                String passwordProp = (String)userProps.get(ContentModel.PROP_PASSWORD);
                AuthenticationTest.assertNull((String)"Expected the password property to be null", (Object)passwordProp);
                String password2Prop = (String)userProps.get(ContentModel.PROP_PASSWORD_SHA256);
                AuthenticationTest.assertNull((String)"Expected the password2 property to be null", (Object)password2Prop);
                String passwordHashProp = (String)userProps.get(ContentModel.PROP_PASSWORD_HASH);
                AuthenticationTest.assertNotNull((String)"Expected the passwordHash property to be populated", (Object)passwordHashProp);
                List hashIndicatorProp = (List)userProps.get(ContentModel.PROP_HASH_INDICATOR);
                AuthenticationTest.assertNotNull((String)"Expected the hashIndicator property to be populated", (Object)hashIndicatorProp);
                MD4PasswordEncoderImpl md4PasswordEncoder = new MD4PasswordEncoderImpl();
                String md4Password = md4PasswordEncoder.encodePassword("auth1", null);
                String salt = (String)userProps.get(ContentModel.PROP_SALT);
                ShaPasswordEncoderImpl sha256PasswordEncoder = new ShaPasswordEncoderImpl(256);
                String sha256Password = sha256PasswordEncoder.encodePassword("auth1", (Object)salt);
                userProps.put(ContentModel.PROP_PASSWORD, md4Password);
                userProps.put(ContentModel.PROP_PASSWORD_SHA256, sha256Password);
                userProps.remove(ContentModel.PROP_PASSWORD_HASH);
                userProps.remove(ContentModel.PROP_HASH_INDICATOR);
                this.nodeService.setProperties(andyUserNodeRef, userProps);
                Map updatedProps = this.nodeService.getProperties(andyUserNodeRef);
                String usernameProp = (String)updatedProps.get(ContentModel.PROP_USER_USERNAME);
                AuthenticationTest.assertEquals((String)"Expected the username property to be 'Andy'", (String)"Andy", (String)usernameProp);
                passwordProp = (String)updatedProps.get(ContentModel.PROP_PASSWORD);
                AuthenticationTest.assertNotNull((String)"Expected the password property to be populated", (Object)passwordProp);
                password2Prop = (String)updatedProps.get(ContentModel.PROP_PASSWORD_SHA256);
                AuthenticationTest.assertNotNull((String)"Expected the password2 property to be populated", (Object)password2Prop);
                passwordHashProp = (String)updatedProps.get(ContentModel.PROP_PASSWORD_HASH);
                AuthenticationTest.assertNull((String)"Expected the passwordHash property to be null", (Object)passwordHashProp);
                hashIndicatorProp = (List)updatedProps.get(ContentModel.PROP_HASH_INDICATOR);
                AuthenticationTest.assertNull((String)"Expected the hashIndicator property to be null", (Object)hashIndicatorProp);
                this.authenticationComponent.clearCurrentSecurityContext();
                this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
                AuthenticationTest.assertEquals((String)"Andy", (String)this.authenticationService.getCurrentUserName());
                this.userTransaction.commit();
                this.userTransaction = this.transactionService.getUserTransaction();
                this.userTransaction.begin();
                this.authenticationComponent.setSystemUserAsCurrentUser();
                Map upgradedProps = this.nodeService.getProperties(andyUserNodeRef);
                passwordProp = (String)upgradedProps.get(ContentModel.PROP_PASSWORD);
                AuthenticationTest.assertNull((String)"Expected the password property to be null", (Object)passwordProp);
                password2Prop = (String)upgradedProps.get(ContentModel.PROP_PASSWORD_SHA256);
                AuthenticationTest.assertNull((String)"Expected the password2 property to be null", (Object)password2Prop);
                passwordHashProp = (String)upgradedProps.get(ContentModel.PROP_PASSWORD_HASH);
                AuthenticationTest.assertNotNull((String)"Expected the passwordHash property to be populated", (Object)passwordHashProp);
                hashIndicatorProp = (List)upgradedProps.get(ContentModel.PROP_HASH_INDICATOR);
                AuthenticationTest.assertNotNull((String)"Expected the hashIndicator property to be populated", (Object)hashIndicatorProp);
                AuthenticationTest.assertTrue((String)"Expected there to be a single hash indicator entry", (hashIndicatorProp.size() == 1 ? 1 : 0) != 0);
                String preferredEncoding = this.compositePasswordEncoder.getPreferredEncoding();
                String hashEncoding = (String)hashIndicatorProp.get(0);
                AuthenticationTest.assertEquals((String)("Expected hash indicator to be '" + preferredEncoding + "' but it was: " + hashEncoding), (String)preferredEncoding, (String)hashEncoding);
                this.deleteAndy();
                this.authenticationComponent.clearCurrentSecurityContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.compositePasswordEncoder.setPreferredEncoding(defaultPreferredEncoding);
        }
    }

    public void testGetsMD4Password() {
        String defaultPreferredEncoding = this.compositePasswordEncoder.getPreferredEncoding();
        this.compositePasswordEncoder.setPreferredEncoding("md4");
        try {
            String user = "mduzer";
            String rawPass = "roarPazzw0rd";
            this.dao.createUser(user, null, rawPass.toCharArray());
            NodeRef userNodeRef = this.getRepositoryAuthenticationDao().getUserOrNull(user);
            AuthenticationTest.assertNotNull((Object)userNodeRef);
            String pass = this.dao.getMD4HashedPassword(user);
            AuthenticationTest.assertNotNull((Object)pass);
            AuthenticationTest.assertTrue((boolean)this.compositePasswordEncoder.matches("md4", rawPass, pass, null));
            Map properties = this.nodeService.getProperties(userNodeRef);
            properties.remove(ContentModel.PROP_PASSWORD_HASH);
            properties.remove(ContentModel.PROP_HASH_INDICATOR);
            properties.remove(ContentModel.PROP_PASSWORD);
            properties.remove(ContentModel.PROP_PASSWORD_SHA256);
            String encoded = this.compositePasswordEncoder.encodePassword("md4", (Object)rawPass, List.of("md4"));
            properties.put(ContentModel.PROP_PASSWORD, encoded);
            this.nodeService.setProperties(userNodeRef, properties);
            pass = this.dao.getMD4HashedPassword(user);
            AuthenticationTest.assertNotNull((Object)pass);
            AuthenticationTest.assertEquals((String)encoded, (String)pass);
            this.dao.deleteUser(user);
        }
        finally {
            this.compositePasswordEncoder.setPreferredEncoding(defaultPreferredEncoding);
        }
    }

    public void testCreateUserWithHashedPassword() throws Exception {
        String SOME_PASSWORD = "1 passw0rd";
        String defaultencoding = this.compositePasswordEncoder.getPreferredEncoding();
        String user1 = "uzer" + GUID.generate();
        String user2 = "uzer" + GUID.generate();
        List<String> encs = Arrays.asList("bcrypt10", "md4");
        final String myTestDomain = TEST_TENANT_DOMAIN + "my.test";
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!AuthenticationTest.this.tenantAdminService.existsTenant(myTestDomain)) {
                    AuthenticationTest.this.tenantAdminService.createTenant(myTestDomain, TENANT_ADMIN_PW.toCharArray(), null);
                }
                return null;
            }
        }, (String)"");
        for (String enc : encs) {
            this.compositePasswordEncoder.setPreferredEncoding(enc);
            String hash = this.compositePasswordEncoder.encodePreferred(SOME_PASSWORD, null);
            this.assertCreateHashed(SOME_PASSWORD, hash, null, user1 + "@" + myTestDomain);
            this.assertCreateHashed(SOME_PASSWORD, null, SOME_PASSWORD.toCharArray(), user2 + "@" + myTestDomain);
        }
        this.compositePasswordEncoder.setPreferredEncoding(defaultencoding);
    }

    private void assertCreateHashed(String rawString, String hash, char[] rawPassword, String user) {
        this.dao.createUser(user, hash, rawPassword);
        UserDetails userDetails = this.dao.loadUserByUsername(user);
        AuthenticationTest.assertNotNull((Object)userDetails);
        AuthenticationTest.assertNotNull((Object)userDetails.getPassword());
        AuthenticationTest.assertTrue((boolean)this.compositePasswordEncoder.matches(this.compositePasswordEncoder.getPreferredEncoding(), rawString, userDetails.getPassword(), null));
        this.dao.deleteUser(user);
    }

    private RepositoryAuthenticationDao getRepositoryAuthenticationDao() {
        RepositoryAuthenticationDao dao = new RepositoryAuthenticationDao();
        dao.setTransactionService(this.transactionService);
        dao.setAuthorityService(this.authorityService);
        dao.setTenantService(this.tenantService);
        dao.setNodeService(this.nodeService);
        dao.setNamespaceService(this.getNamespacePrefixReolsver(""));
        dao.setCompositePasswordEncoder(this.compositePasswordEncoder);
        dao.setPolicyComponent(this.policyComponent);
        dao.setAuthenticationCache(this.authenticationCache);
        dao.setSingletonCache(this.immutableSingletonCache);
        return dao;
    }

    private String getUserName(Authentication authentication) {
        String username = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return username;
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("usr", "http://www.alfresco.org/model/user/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }

    public void testCreatingUserWithEmptyPassword() throws Exception {
        String previousAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String userName = GUID.generate();
        String rawPass = "";
        try {
            this.dao.createUser(userName, null, rawPass.toCharArray());
            NodeRef userNodeRed = this.getRepositoryAuthenticationDao().getUserOrNull(userName);
            AuthenticationTest.assertNotNull((Object)userNodeRed);
            Map properties = this.nodeService.getProperties(userNodeRed);
            AuthenticationTest.assertEquals(properties.get(ContentModel.PROP_ENABLED), (Object)false);
            properties.remove(ContentModel.PROP_ENABLED);
            properties.put(ContentModel.PROP_ENABLED, true);
            this.nodeService.setProperties(userNodeRed, properties);
            AuthenticationTest.assertEquals(properties.get(ContentModel.PROP_ENABLED), (Object)true);
            try {
                this.authenticationService.authenticate(userName, rawPass.toCharArray());
                AuthenticationTest.fail((String)"Authentication should have been rejected");
            }
            catch (IllegalArgumentException e) {
                AuthenticationTest.assertEquals((String)e.getMessage(), (String)"rawPassword is a mandatory parameter");
            }
            rawPass = "newPassword";
            this.dao.updateUser(userName, rawPass.toCharArray());
            try {
                this.authenticationService.authenticate(userName, rawPass.toCharArray());
            }
            catch (AuthenticationException authenticationException) {
                AuthenticationTest.fail((String)"Authentication should have passed.");
            }
            AuthenticationTest.assertEquals((String)this.authenticationService.getCurrentUserName(), (String)userName);
        }
        catch (Throwable throwable) {
            if (previousAuthenticatedUser != null) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)previousAuthenticatedUser);
            }
            try {
                this.dao.deleteUser(userName);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        if (previousAuthenticatedUser != null) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)previousAuthenticatedUser);
        }
        try {
            this.dao.deleteUser(userName);
        }
        catch (Exception exception) {}
    }
}

