/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.RedundantDbObject;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.extensions.surf.util.I18NUtil;

public class RedundantDbObjectTest {
    @Before
    public void setUp() {
        I18NUtil.registerResourceBundle((String)"alfresco.messages.system-messages");
    }

    @Test
    public void describe() {
        MyDbObject reference = new MyDbObject("reference");
        List<DbObject> matches = this.makeMatches(3);
        RedundantDbObject redundantDBO = new RedundantDbObject((DbObject)reference, matches);
        Assert.assertEquals((Object)"Redundancy: 3 items matching MyDbObject[name=reference], matches: MyDbObject[name=match1], MyDbObject[name=match2], MyDbObject[name=match3]", (Object)redundantDBO.describe());
    }

    @Test
    public void describeTooManyMatches() {
        MyDbObject reference = new MyDbObject("reference");
        List<DbObject> matches = this.makeMatches(4);
        RedundantDbObject redundantDBO = new RedundantDbObject((DbObject)reference, matches);
        Assert.assertEquals((Object)"4 redundant items? reference: MyDbObject[name=reference], matches: MyDbObject[name=match1], MyDbObject[name=match2], MyDbObject[name=match3] and 1 more...", (Object)redundantDBO.describe());
    }

    private List<DbObject> makeMatches(int numMatches) {
        ArrayList<DbObject> matches = new ArrayList<DbObject>();
        int i = 0;
        while (i < numMatches) {
            matches.add((DbObject)new MyDbObject("match" + (i + 1)));
            ++i;
        }
        return matches;
    }

    private static class MyDbObject
    extends AbstractDbObject {
        public MyDbObject(String name) {
            super(null, name);
        }

        public void accept(DbObjectVisitor visitor) {
        }
    }
}

